/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.feature.QuantileDiscretizer;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple1;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00112A!\u0001\u0002\u0001\u001b\tA\u0012+^1oi&dW\rR5tGJ,G/\u001b>feN+\u0018\u000e^3\u000b\u0005\r!\u0011a\u00024fCR,(/\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dIQ\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0005kRLGN\u0003\u0002\u0018\r\u0005)Q\u000e\u001c7jE&\u0011\u0011\u0004\u0006\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u!\tYR$D\u0001\u001d\u0015\t)B!\u0003\u0002\u001f9\t!B)\u001a4bk2$(+Z1e/JLG/\u001a+fgRDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u0002")
public class QuantileDiscretizerSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public QuantileDiscretizerSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("Test observed number of buckets and their sizes match expected values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkSession spark = this.$outer.spark();
                int datasetSize = 100000;
                int numBuckets = 5;
                SparkContext qual$1 = this.$outer.sc();
                NumericRange x$1 = (NumericRange)new RichDouble(Predef$.MODULE$.doubleWrapper(1.0)).to((Object)BoxesRunTime.boxToDouble((double)datasetSize)).by((Object)BoxesRunTime.boxToDouble((double)1.0));
                int x$2 = qual$1.parallelize$default$2();
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(QuantileDiscretizerSuite.class.getClassLoader());
                Dataset df = spark.implicits().rddToDatasetHolder(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple1<Object> apply(double _1) {
                        return new Tuple1.mcD.sp(_1);
                    }
                }, ClassTag$.MODULE$.apply(Tuple1.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple1"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                }))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input"}));
                QuantileDiscretizer discretizer = new QuantileDiscretizer().setInputCol("input").setOutputCol("result").setNumBuckets(numBuckets);
                Dataset result = discretizer.fit(df).transform(df);
                long observedNumBuckets = result.select("result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)observedNumBuckets));
                int $org_scalatest_assert_macro_right = numBuckets;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Observed number of buckets does not equal expected number of buckets.");
                double relativeError = discretizer.getRelativeError();
                UserDefinedFunction isGoodBucket = functions$.MODULE$.udf((Function1)new Serializable(this, datasetSize, numBuckets, relativeError){
                    public static final long serialVersionUID = 0L;
                    private final int datasetSize$1;
                    private final int numBuckets$1;
                    private final double relativeError$1;

                    public final boolean apply(int size) {
                        return this.apply$mcZI$sp(size);
                    }

                    public boolean apply$mcZI$sp(int size) {
                        return (double)scala.math.package$.MODULE$.abs(size - this.datasetSize$1 / this.numBuckets$1) <= this.relativeError$1 * (double)this.datasetSize$1;
                    }
                    {
                        this.datasetSize$1 = datasetSize$1;
                        this.numBuckets$1 = numBuckets$1;
                        this.relativeError$1 = relativeError$1;
                    }
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
                long numGoodBuckets = result.groupBy("result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().filter(isGoodBucket.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count"}))).$((Seq)Nil$.MODULE$)}))).count();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)numGoodBuckets));
                int $org_scalatest_assert_macro_right2 = numBuckets;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Bucket sizes are not within expected relative error tolerance.");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Test Bucketizer on duplicated splits", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                SparkSession spark = this.$outer.spark();
                int datasetSize = 12;
                int numBuckets = 5;
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$3 = Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 3.0, 2.0, 1.0, 1.0, 2.0, 3.0, 2.0, 2.0, 2.0, 1.0, 3.0});
                int x$4 = qual$2.parallelize$default$2();
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(QuantileDiscretizerSuite.class.getClassLoader());
                Dataset df = spark.implicits().rddToDatasetHolder(qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple1<Object> apply(double _1) {
                        return new Tuple1.mcD.sp(_1);
                    }
                }, ClassTag$.MODULE$.apply(Tuple1.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple1"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                }))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input"}));
                QuantileDiscretizer discretizer = new QuantileDiscretizer().setInputCol("input").setOutputCol("result").setNumBuckets(numBuckets);
                Dataset result = discretizer.fit(df).transform(df);
                long observedNumBuckets = result.select("result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
                int $org_scalatest_assert_macro_left = 2;
                long $org_scalatest_assert_macro_right = observedNumBuckets;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), (long)$org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right);
                if ($org_scalatest_assert_macro_left2.value()) {
                    long $org_scalatest_assert_macro_left3 = observedNumBuckets;
                    int $org_scalatest_assert_macro_right2 = numBuckets;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= (long)$org_scalatest_assert_macro_right2);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Observed number of buckets are not within expected range.");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Test transform method on unseen data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkSession spark = this.$outer.spark();
                SparkContext qual$3 = this.$outer.sc();
                NumericRange x$5 = (NumericRange)new RichDouble(Predef$.MODULE$.doubleWrapper(1.0)).to((Object)BoxesRunTime.boxToDouble((double)100.0)).by((Object)BoxesRunTime.boxToDouble((double)1.0));
                int x$6 = qual$3.parallelize$default$2();
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(QuantileDiscretizerSuite.class.getClassLoader());
                Dataset trainDF = spark.implicits().rddToDatasetHolder(qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple1<Object> apply(double _1) {
                        return new Tuple1.mcD.sp(_1);
                    }
                }, ClassTag$.MODULE$.apply(Tuple1.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple1"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                }))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input"}));
                SparkContext qual$4 = this.$outer.sc();
                NumericRange x$7 = (NumericRange)new RichDouble(Predef$.MODULE$.doubleWrapper(-10.0)).to((Object)BoxesRunTime.boxToDouble((double)110.0)).by((Object)BoxesRunTime.boxToDouble((double)1.0));
                int x$8 = qual$4.parallelize$default$2();
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(QuantileDiscretizerSuite.class.getClassLoader());
                Dataset testDF = spark.implicits().rddToDatasetHolder(qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple1<Object> apply(double _1) {
                        return new Tuple1.mcD.sp(_1);
                    }
                }, ClassTag$.MODULE$.apply(Tuple1.class)), spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple1"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                }))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input"}));
                QuantileDiscretizer discretizer = new QuantileDiscretizer().setInputCol("input").setOutputCol("result").setNumBuckets(5);
                Dataset result = discretizer.fit(trainDF).transform(testDF);
                long firstBucketSize = result.filter(result.apply("result").$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.0))).count();
                long lastBucketSize = result.filter(result.apply("result").$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)4.0))).count();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)firstBucketSize));
                long $org_scalatest_assert_macro_right = 30L;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size of first bucket ", " did not equal expected value of 30."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstBucketSize)})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)lastBucketSize));
                long $org_scalatest_assert_macro_right2 = 31L;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size of last bucket ", " did not equal expected value of 31."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastBucketSize)})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QuantileDiscretizer t = new QuantileDiscretizer().setInputCol("myInputCol").setOutputCol("myOutputCol").setNumBuckets(6);
                this.$outer.testDefaultReadWrite(t, this.$outer.testDefaultReadWrite$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Verify resulting model has parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkSession spark = this.$outer.spark();
                SparkContext qual$5 = this.$outer.sc();
                Range.Inclusive x$9 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100);
                int x$10 = qual$5.parallelize$default$2();
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(QuantileDiscretizerSuite.class.getClassLoader());
                Dataset df = spark.implicits().rddToDatasetHolder(qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple1<Object> apply(int _1) {
                        return new Tuple1.mcI.sp(_1);
                    }
                }, ClassTag$.MODULE$.apply(Tuple1.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple1"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                    }
                }))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input"}));
                QuantileDiscretizer discretizer = new QuantileDiscretizer().setInputCol("input").setOutputCol("result").setNumBuckets(5);
                Bucketizer model = discretizer.fit(df);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

