/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.ml.feature.VectorIndexerSuite$;
import org.apache.spark.ml.feature.VectorIndexerSuite$FeatureData$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import org.scalatest.exceptions.TestFailedException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001B\u0001\u0003\u00015\u0011!CV3di>\u0014\u0018J\u001c3fq\u0016\u00148+^5uK*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001q!CG\u0010\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\bCA\u000e\u001e\u001b\u0005a\"BA\u000b\u0005\u0013\tqBD\u0001\u000bEK\u001a\fW\u000f\u001c;SK\u0006$wK]5uKR+7\u000f\u001e\t\u0003A\rj\u0011!\t\u0006\u0003E\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003I\u0005\u0012q\u0001T8hO&tw\rC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\u0005!I1\u0006\u0001a\u0001\u0002\u0004%\t\u0001L\u0001\rI\u0016t7/\u001a)pS:$8/M\u000b\u0002[A\u0011aF\u0010\b\u0003_mr!\u0001M\u001d\u000f\u0005EBdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)D\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!A\u000f\u0004\u0002\u0007M\fH.\u0003\u0002={\u00059\u0001/Y2lC\u001e,'B\u0001\u001e\u0007\u0013\ty\u0004IA\u0005ECR\fgI]1nK*\u0011A(\u0010\u0005\n\u0005\u0002\u0001\r\u00111A\u0005\u0002\r\u000b\u0001\u0003Z3og\u0016\u0004v.\u001b8ugFzF%Z9\u0015\u0005\u0011S\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%\u0001B+oSRDqaS!\u0002\u0002\u0003\u0007Q&A\u0002yIEBa!\u0014\u0001!B\u0013i\u0013!\u00043f]N,\u0007k\\5oiN\f\u0004\u0005\u000b\u0002M\u001fB\u0011Q\tU\u0005\u0003#\u001a\u0013\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013M\u0003\u0001\u0019!a\u0001\n\u0003a\u0013!D:qCJ\u001cX\rU8j]R\u001c\u0018\u0007C\u0005V\u0001\u0001\u0007\t\u0019!C\u0001-\u0006\t2\u000f]1sg\u0016\u0004v.\u001b8ugFzF%Z9\u0015\u0005\u0011;\u0006bB&U\u0003\u0003\u0005\r!\f\u0005\u00073\u0002\u0001\u000b\u0015B\u0017\u0002\u001dM\u0004\u0018M]:f!>Lg\u000e^:2A!\u0012\u0001l\u0014\u0005\n9\u0002\u0001\r\u00111A\u0005\u0002u\u000b1\u0002]8j]R\fT.\u0019=fgV\ta\fE\u0002F?\u0006L!\u0001\u0019$\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0015\u0013\u0017BA2G\u0005\u0019!u.\u001e2mK\"IQ\r\u0001a\u0001\u0002\u0004%\tAZ\u0001\u0010a>Lg\u000e^\u0019nCb,7o\u0018\u0013fcR\u0011Ai\u001a\u0005\b\u0017\u0012\f\t\u00111\u0001_\u0011\u0019I\u0007\u0001)Q\u0005=\u0006a\u0001o\\5oiFj\u0017\r_3tA!\u0012\u0001n\u0014\u0005\nY\u0002\u0001\r\u00111A\u0005\u00021\nA\u0002Z3og\u0016\u0004v.\u001b8ugJB\u0011B\u001c\u0001A\u0002\u0003\u0007I\u0011A8\u0002!\u0011,gn]3Q_&tGo\u001d\u001a`I\u0015\fHC\u0001#q\u0011\u001dYU.!AA\u00025BaA\u001d\u0001!B\u0013i\u0013!\u00043f]N,\u0007k\\5oiN\u0014\u0004\u0005\u000b\u0002r\u001f\"IQ\u000f\u0001a\u0001\u0002\u0004%\t\u0001L\u0001\u000egB\f'o]3Q_&tGo\u001d\u001a\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0003A\u0018!E:qCJ\u001cX\rU8j]R\u001c(g\u0018\u0013fcR\u0011A)\u001f\u0005\b\u0017Z\f\t\u00111\u0001.\u0011\u0019Y\b\u0001)Q\u0005[\u0005q1\u000f]1sg\u0016\u0004v.\u001b8ugJ\u0002\u0003F\u0001>P\u0011%q\b\u00011AA\u0002\u0013\u0005A&A\u0005cC\u0012\u0004v.\u001b8ug\"Y\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0002\u00035\u0011\u0017\r\u001a)pS:$8o\u0018\u0013fcR\u0019A)!\u0002\t\u000f-{\u0018\u0011!a\u0001[!9\u0011\u0011\u0002\u0001!B\u0013i\u0013A\u00032bIB{\u0017N\u001c;tA!\u001a\u0011qA(\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002\t\"9\u0011Q\u0003\u0001\u0005\n\u0005]\u0011AC4fi&sG-\u001a=feV\u0011\u0011\u0011\u0004\t\u0004S\u0005m\u0011bAA\u000f\u0005\tia+Z2u_JLe\u000eZ3yKJ<\u0001\"!\t\u0003\u0011\u0003\u0011\u00111E\u0001\u0013-\u0016\u001cGo\u001c:J]\u0012,\u00070\u001a:Tk&$X\rE\u0002*\u0003K1q!\u0001\u0002\t\u0002\t\t9c\u0005\u0004\u0002&\u0005%\u0012q\u0006\t\u0004\u000b\u0006-\u0012bAA\u0017\r\n1\u0011I\\=SK\u001a\u00042!RA\u0019\u0013\r\t\u0019D\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\bM\u0005\u0015B\u0011AA\u001c)\t\t\u0019CB\u0004\u0002<\u0005\u0015\u0002)!\u0010\u0003\u0017\u0019+\u0017\r^;sK\u0012\u000bG/Y\n\t\u0003s\tI#a\u0010\u00020A\u0019Q)!\u0011\n\u0007\u0005\rcIA\u0004Qe>$Wo\u0019;\t\u0017\u0005\u001d\u0013\u0011\bBK\u0002\u0013\u0005\u0011\u0011J\u0001\tM\u0016\fG/\u001e:fgV\u0011\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\u0003\u0002\r1Lg.\u00197h\u0013\u0011\t)&a\u0014\u0003\rY+7\r^8s\u0011-\tI&!\u000f\u0003\u0012\u0003\u0006I!a\u0013\u0002\u0013\u0019,\u0017\r^;sKN\u0004\u0003\u0006BA,\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G2\u0015!\u00022fC:\u001c\u0018\u0002BA4\u0003C\u0012ABQ3b]B\u0013x\u000e]3sifD\u0001\"a\u001b\u0002:\u0011\u0005\u0011QN\u0001\fO\u0016$h)Z1ukJ,7\u000f\u0006\u0002\u0002L!9a%!\u000f\u0005\u0002\u0005ED\u0003BA:\u0003o\u0002B!!\u001e\u0002:5\u0011\u0011Q\u0005\u0005\t\u0003\u000f\ny\u00071\u0001\u0002L!Q\u00111PA\u001d\u0003\u0003%\t!! \u0002\t\r|\u0007/\u001f\u000b\u0005\u0003g\ny\b\u0003\u0006\u0002H\u0005e\u0004\u0013!a\u0001\u0003\u0017B!\"a!\u0002:E\u0005I\u0011AAC\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\"+\t\u0005-\u0013\u0011R\u0016\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0013$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0006=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011QTA\u001d\u0003\u0003%\t%a(\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u000b\u0005\u0003\u0002$\u00065VBAAS\u0015\u0011\t9+!+\u0002\t1\fgn\u001a\u0006\u0003\u0003W\u000bAA[1wC&!\u0011qVAS\u0005\u0019\u0019FO]5oO\"Q\u00111WA\u001d\u0003\u0003%\t!!.\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0006cA#\u0002:&\u0019\u00111\u0018$\u0003\u0007%sG\u000f\u0003\u0006\u0002@\u0006e\u0012\u0011!C\u0001\u0003\u0003\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002D\u0006%\u0007cA#\u0002F&\u0019\u0011q\u0019$\u0003\u0007\u0005s\u0017\u0010C\u0005L\u0003{\u000b\t\u00111\u0001\u00028\"Q\u0011QZA\u001d\u0003\u0003%\t%a4\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!5\u0011\r\u0005M\u0017\u0011\\Ab\u001b\t\t)NC\u0002\u0002X\u001a\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY.!6\u0003\u0011%#XM]1u_JD!\"a8\u0002:\u0005\u0005I\u0011AAq\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAr\u0003S\u00042!RAs\u0013\r\t9O\u0012\u0002\b\u0005>|G.Z1o\u0011%Y\u0015Q\\A\u0001\u0002\u0004\t\u0019\r\u0003\u0006\u0002n\u0006e\u0012\u0011!C!\u0003_\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003oC!\"a=\u0002:\u0005\u0005I\u0011IA{\u0003!!xn\u0015;sS:<GCAAQ\u0011)\tI0!\u000f\u0002\u0002\u0013\u0005\u00131`\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0018Q \u0005\n\u0017\u0006]\u0018\u0011!a\u0001\u0003\u0007<!B!\u0001\u0002&\u0005\u0005\t\u0012\u0001B\u0002\u0003-1U-\u0019;ve\u0016$\u0015\r^1\u0011\t\u0005U$Q\u0001\u0004\u000b\u0003w\t)#!A\t\u0002\t\u001d1C\u0002B\u0003\u0005\u0013\ty\u0003\u0005\u0005\u0003\f\tE\u00111JA:\u001b\t\u0011iAC\u0002\u0003\u0010\u0019\u000bqA];oi&lW-\u0003\u0003\u0003\u0014\t5!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9aE!\u0002\u0005\u0002\t]AC\u0001B\u0002\u0011)\t\u0019P!\u0002\u0002\u0002\u0013\u0015\u0013Q\u001f\u0005\u000b\u0005;\u0011)!!A\u0005\u0002\n}\u0011!B1qa2LH\u0003BA:\u0005CA\u0001\"a\u0012\u0003\u001c\u0001\u0007\u00111\n\u0015\u0005\u0005C\ti\u0006\u0003\u0006\u0003(\t\u0015\u0011\u0011!CA\u0005S\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003,\tE\u0002#B#\u0003.\u0005-\u0013b\u0001B\u0018\r\n1q\n\u001d;j_:D!Ba\r\u0003&\u0005\u0005\t\u0019AA:\u0003\rAH\u0005\r\u0005\u000b\u0005o\u0011)!!A\u0005\n\te\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u000f\u0011\t\u0005\r&QH\u0005\u0005\u0005\u007f\t)K\u0001\u0004PE*,7\r\u001e\u0005\u000b\u0005o\t)#!A\u0005\n\te\u0002")
public class VectorIndexerSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<Row> densePoints1;
    private transient Dataset<Row> sparsePoints1;
    private transient double[] point1maxes;
    private transient Dataset<Row> densePoints2;
    private transient Dataset<Row> sparsePoints2;
    private transient Dataset<Row> badPoints;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Dataset<Row> densePoints1() {
        return this.densePoints1;
    }

    public void densePoints1_$eq(Dataset<Row> x$1) {
        this.densePoints1 = x$1;
    }

    public Dataset<Row> sparsePoints1() {
        return this.sparsePoints1;
    }

    public void sparsePoints1_$eq(Dataset<Row> x$1) {
        this.sparsePoints1 = x$1;
    }

    public double[] point1maxes() {
        return this.point1maxes;
    }

    public void point1maxes_$eq(double[] x$1) {
        this.point1maxes = x$1;
    }

    public Dataset<Row> densePoints2() {
        return this.densePoints2;
    }

    public void densePoints2_$eq(Dataset<Row> x$1) {
        this.densePoints2 = x$1;
    }

    public Dataset<Row> sparsePoints2() {
        return this.sparsePoints2;
    }

    public void sparsePoints2_$eq(Dataset<Row> x$1) {
        this.sparsePoints2 = x$1;
    }

    public Dataset<Row> badPoints() {
        return this.badPoints;
    }

    public void badPoints_$eq(Dataset<Row> x$1) {
        this.badPoints = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        Seq densePoints1Seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -1.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0}))}));
        Seq sparsePoints1Seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, new int[]{0, 1}, new double[]{1.0, 2.0}), Vectors$.MODULE$.sparse(3, new int[]{1, 2}, new double[]{1.0, 2.0}), Vectors$.MODULE$.sparse(3, new int[]{2}, new double[]{-1.0}), Vectors$.MODULE$.sparse(3, new int[]{0, 1, 2}, new double[]{1.0, 3.0, 2.0})}));
        this.point1maxes_$eq(new double[]{1.0, 3.0, 2.0});
        Seq densePoints2Seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 1.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0, 1.0})), Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 0.0}))}));
        Seq sparsePoints2Seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(4, new int[]{0, 1, 3}, new double[]{1.0, 1.0, 1.0}), Vectors$.MODULE$.sparse(4, new int[]{1, 2, 3}, new double[]{1.0, 1.0, 1.0}), Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{-1.0, 1.0, 2.0})}));
        Seq badPointsSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(2, new int[]{0, 1}, new double[]{1.0, 1.0}), Vectors$.MODULE$.sparse(3, new int[]{2}, new double[]{-1.0})}));
        Vector $org_scalatest_assert_macro_left = (Vector)densePoints1Seq.head();
        int $org_scalatest_assert_macro_right = ((Vector)sparsePoints1Seq.head()).size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        Vector $org_scalatest_assert_macro_left2 = (Vector)densePoints2Seq.head();
        int $org_scalatest_assert_macro_right2 = ((Vector)sparsePoints2Seq.head()).size();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        int $org_scalatest_assert_macro_left3 = ((Vector)densePoints1Seq.head()).size();
        int $org_scalatest_assert_macro_right3 = ((Vector)densePoints2Seq.head()).size();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
        this.checkPair$1(densePoints1Seq, sparsePoints1Seq);
        this.checkPair$1(densePoints2Seq, sparsePoints2Seq);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator1$1(VectorIndexerSuite $outer) {
            }
        }
        this.densePoints1_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize(densePoints1Seq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator1$1(this))));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator2$1(VectorIndexerSuite $outer) {
            }
        }
        this.sparsePoints1_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize(sparsePoints1Seq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator2$1(this))));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator3$1(VectorIndexerSuite $outer) {
            }
        }
        this.densePoints2_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize(densePoints2Seq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator3$1(this))));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator4$1(VectorIndexerSuite $outer) {
            }
        }
        this.sparsePoints2_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize(sparsePoints2Seq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator4$1(this))));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator5$1(VectorIndexerSuite $outer) {
            }
        }
        this.badPoints_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize(badPointsSeq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator5$1(this))));
    }

    public VectorIndexer org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer() {
        return new VectorIndexer().setInputCol("features").setOutputCol("indexed");
    }

    private final void checkPair$1(Seq dvSeq, Seq svSeq) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)dvSeq.zip((GenIterable)svSeq, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final boolean apply(Tuple2<Vector, Vector> x0$1) {
                Tuple2<Vector, Vector> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector dv = (Vector)tuple2._1();
                    Vector sv = (Vector)tuple2._2();
                    boolean bl = this.$outer.convertToEqualizer(dv.toArray()).$eq$eq$eq((Object)sv.toArray(), Equality$.MODULE$.default());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), "dvSeq.zip[org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector, Seq[(org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector)]](svSeq)(collection.this.Seq.canBuildFrom[(org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector)]).forall(((x0$1: (org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector)) => x0$1 match {\n  case (_1: org.apache.spark.ml.linalg.Vector, _2: org.apache.spark.ml.linalg.Vector)(org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector)((dv @ _), (sv @ _)) => VectorIndexerSuite.this.convertToEqualizer[Array[Double]](dv.toArray).===(sv.toArray)(scalactic.this.Equality.default[Array[Double]])\n}))");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"typo in unit test");
    }

    public VectorIndexerSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new VectorIndexer());
                VectorIndexerModel model = new VectorIndexerModel("indexer", 1, Predef$.MODULE$.Map().empty());
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("Cannot fit an empty DataFrame", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
                Dataset rdd = this.$outer.spark().createDataFrame(this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Vector.class))), 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
                    }
                }));
                VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer();
                this.$outer.intercept((Function0)new Serializable(this, rdd, vectorIndexer){
                    public static final long serialVersionUID = 0L;
                    private final Dataset rdd$1;
                    private final VectorIndexer vectorIndexer$1;

                    public final VectorIndexerModel apply() {
                        return this.vectorIndexer$1.fit(this.rdd$1);
                    }
                    {
                        this.rdd$1 = rdd$1;
                        this.vectorIndexer$1 = vectorIndexer$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Throws error when given RDDs with different size vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer();
                VectorIndexerModel model = vectorIndexer.fit(this.$outer.densePoints1());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                model.transform(this.$outer.densePoints1());
                model.transform(this.$outer.sparsePoints1());
                this.$outer.intercept((Function0)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final VectorIndexerModel model$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.model$1.transform(this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().densePoints2()).collect();
                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Did not throw error when fit, transform were called on vectors of different lengths";
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$1 = model$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                this.$outer.intercept((Function0)new Serializable(this, vectorIndexer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final VectorIndexer vectorIndexer$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.vectorIndexer$2.fit(this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().badPoints());
                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Did not throw error when fitting vectors of different lengths in same RDD.";
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.vectorIndexer$2 = vectorIndexer$2;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }

            public /* synthetic */ VectorIndexerSuite org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Same result with dense and sparse vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.testDenseSparse$1(this.$outer.densePoints1(), this.$outer.sparsePoints1());
                this.testDenseSparse$1(this.$outer.densePoints2(), this.$outer.sparsePoints2());
            }

            private final void testDenseSparse$1(Dataset densePoints, Dataset sparsePoints) {
                VectorIndexer denseVectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(2);
                VectorIndexer sparseVectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(2);
                VectorIndexerModel denseModel = denseVectorIndexer.fit(densePoints);
                VectorIndexerModel sparseModel = sparseVectorIndexer.fit(sparsePoints);
                Map denseMap = denseModel.categoryMaps();
                Map sparseMap = sparseModel.categoryMaps();
                Set $org_scalatest_assert_macro_left = denseMap.keys().toSet();
                Set $org_scalatest_assert_macro_right = sparseMap.keys().toSet();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Categorical features chosen from dense vs. sparse vectors did not match.");
                Map $org_scalatest_assert_macro_left2 = denseMap;
                Map $org_scalatest_assert_macro_right2 = sparseMap;
                Map map = $org_scalatest_assert_macro_left2;
                Map map2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !map.equals(map2) : map2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Categorical feature value indexes chosen from dense vs. sparse vectors did not match.");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Builds valid categorical feature value index, transform correctly, check metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.checkCategoryMaps$1(this.$outer.densePoints1(), 2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})));
                this.checkCategoryMaps$1(this.$outer.densePoints1(), 3, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})));
                this.checkCategoryMaps$1(this.$outer.densePoints2(), 2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
            }

            public /* synthetic */ VectorIndexerSuite org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final void checkCategoryMaps$1(Dataset data, int maxCategories, Set categoricalFeatures) {
                Vector[] collectedData = (Vector[])Predef$.MODULE$.refArrayOps((Object[])data.collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Row x$1) {
                        return (Vector)x$1.getAs(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                String errMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkCategoryMaps failed for input with maxCategories=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxCategories)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" categoricalFeatures=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{categoricalFeatures.mkString(", ")}))).toString();
                try {
                    VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(maxCategories);
                    VectorIndexerModel model = vectorIndexer.fit(data);
                    Map categoryMaps = model.categoryMaps();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(categoryMaps.keys().toSet());
                    Set $org_scalatest_assert_macro_right = categoricalFeatures;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    Dataset transformed = model.transform(data).select("indexed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    RDD indexedRDD = transformed.rdd().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Vector apply(Row x$2) {
                            return (Vector)x$2.getAs(0);
                        }
                    }, ClassTag$.MODULE$.apply(Vector.class));
                    AttributeGroup featureAttrs = AttributeGroup$.MODULE$.fromStructField(transformed.schema().apply("indexed"));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(featureAttrs.name());
                    String $org_scalatest_assert_macro_right2 = "indexed";
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Attribute[])featureAttrs.attributes().get()).length));
                    int $org_scalatest_assert_macro_right3 = model.numFeatures();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    categoricalFeatures.foreach((Function1)new Serializable(this, collectedData, errMsg, categoryMaps, indexedRDD, featureAttrs){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;
                        private final Vector[] collectedData$1;
                        private final String errMsg$1;
                        private final Map categoryMaps$1;
                        private final RDD indexedRDD$1;
                        private final AttributeGroup featureAttrs$1;

                        public final void apply(int feature) {
                            this.apply$mcVI$sp(feature);
                        }

                        public void apply$mcVI$sp(int feature) {
                            Attribute featureAttr;
                            block6: {
                                block5: {
                                    Attribute attribute;
                                    Set origValueSet;
                                    block4: {
                                        origValueSet = Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])this.collectedData$1).map((Function1)new Serializable(this, feature){
                                            public static final long serialVersionUID = 0L;
                                            private final int feature$1;

                                            public final double apply(Vector x$3) {
                                                return x$3.apply(this.feature$1);
                                            }
                                            {
                                                this.feature$1 = feature$1;
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSet();
                                        Set targetValueIndexSet = scala.package$.MODULE$.Range().apply(0, origValueSet.size()).toSet();
                                        Map catMap = (Map)this.categoryMaps$1.apply((Object)BoxesRunTime.boxToInteger((int)feature));
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(catMap.keys().toSet());
                                        Set $org_scalatest_assert_macro_right = origValueSet;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(catMap.values().toSet());
                                        Set $org_scalatest_assert_macro_right2 = targetValueIndexSet;
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        if (origValueSet.contains((Object)BoxesRunTime.boxToDouble((double)0.0))) {
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(catMap.apply((Object)BoxesRunTime.boxToDouble((double)0.0)));
                                            int $org_scalatest_assert_macro_right3 = 0;
                                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                        }
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(Predef$.MODULE$.doubleArrayOps((double[])this.indexedRDD$1.map((Function1)new Serializable(this, feature){
                                            public static final long serialVersionUID = 0L;
                                            private final int feature$1;

                                            public final double apply(Vector x$4) {
                                                return x$4.apply(this.feature$1);
                                            }
                                            {
                                                this.feature$1 = feature$1;
                                            }
                                        }, ClassTag$.MODULE$.Double()).collect()).toSet());
                                        Set $org_scalatest_assert_macro_right4 = targetValueIndexSet;
                                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                                        featureAttr = this.featureAttrs$1.apply(feature);
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(featureAttr.index().get());
                                        int $org_scalatest_assert_macro_right5 = feature;
                                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                                        attribute = featureAttr;
                                        if (!(attribute instanceof BinaryAttribute)) break block4;
                                        BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(binaryAttribute.values().get());
                                        String[] $org_scalatest_assert_macro_right6 = (String[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])origValueSet.toArray(ClassTag$.MODULE$.Double())).sorted((Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(double x$5) {
                                                return ((Object)BoxesRunTime.boxToDouble((double)x$5)).toString();
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block5;
                                    }
                                    if (!(attribute instanceof NominalAttribute)) break block6;
                                    NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(nominalAttribute.values().get());
                                    String[] $org_scalatest_assert_macro_right = (String[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])origValueSet.toArray(ClassTag$.MODULE$.Double())).sorted((Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(double x$6) {
                                            return ((Object)BoxesRunTime.boxToDouble((double)x$6)).toString();
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(nominalAttribute.isOrdinal().get());
                                    boolean $org_scalatest_assert_macro_right7 = false;
                                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                return;
                            }
                            throw new RuntimeException(new StringBuilder().append((Object)this.errMsg$1).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Categorical feature ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)feature)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" metadata check. Found feature attribute: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureAttr}))).toString());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.collectedData$1 = collectedData$1;
                            this.errMsg$1 = errMsg$1;
                            this.categoryMaps$1 = categoryMaps$1;
                            this.indexedRDD$1 = indexedRDD$1;
                            this.featureAttrs$1 = featureAttrs$1;
                        }
                    });
                    ((IterableLike)scala.package$.MODULE$.Range().apply(0, model.numFeatures()).filter((Function1)new Serializable(this, categoricalFeatures){
                        public static final long serialVersionUID = 0L;
                        private final Set categoricalFeatures$1;

                        public final boolean apply(int feature) {
                            return this.apply$mcZI$sp(feature);
                        }

                        public boolean apply$mcZI$sp(int feature) {
                            return !this.categoricalFeatures$1.contains((Object)BoxesRunTime.boxToInteger((int)feature));
                        }
                        {
                            this.categoricalFeatures$1 = categoricalFeatures$1;
                        }
                    })).foreach((Function1)new Serializable(this, errMsg, featureAttrs){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;
                        private final String errMsg$1;
                        private final AttributeGroup featureAttrs$1;

                        public final void apply(int feature) {
                            this.apply$mcVI$sp(feature);
                        }

                        public void apply$mcVI$sp(int feature) {
                            Attribute featureAttr = this.featureAttrs$1.apply(feature);
                            Attribute attribute = featureAttr;
                            if (attribute instanceof NumericAttribute) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(featureAttr.index().get());
                                int $org_scalatest_assert_macro_right = feature;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new RuntimeException(new StringBuilder().append((Object)this.errMsg$1).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Numerical feature ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)feature)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" metadata check. Found feature attribute: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureAttr}))).toString());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.errMsg$1 = errMsg$1;
                            this.featureAttrs$1 = featureAttrs$1;
                        }
                    });
                    return;
                }
                catch (TestFailedException testFailedException) {
                    this.$outer.logError((Function0)new Serializable(this, errMsg){
                        public static final long serialVersionUID = 0L;
                        private final String errMsg$1;

                        public final String apply() {
                            return this.errMsg$1;
                        }
                        {
                            this.errMsg$1 = errMsg$1;
                        }
                    });
                    throw testFailedException;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Maintain sparsity for sparse vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.checkSparsity$1(this.$outer.sparsePoints1(), 2);
                this.checkSparsity$1(this.$outer.sparsePoints2(), 2);
            }

            public /* synthetic */ VectorIndexerSuite org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final void checkSparsity$1(Dataset data, int maxCategories) {
                Vector[] points = (Vector[])Predef$.MODULE$.refArrayOps((Object[])data.collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Row x$7) {
                        return (Vector)x$7.getAs(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(maxCategories);
                VectorIndexerModel model = vectorIndexer.fit(data);
                Vector[] indexedPoints = (Vector[])model.transform(data).select("indexed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Row x$8) {
                        return (Vector)x$8.getAs(0);
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).collect();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])points).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])indexedPoints), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Tuple2<Vector, Vector> x0$2) {
                        Tuple2<Vector, Vector> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Vector orig = (Vector)tuple2._1();
                            Vector indexed = (Vector)tuple2._2();
                            if (orig instanceof SparseVector) {
                                SparseVector sparseVector = (SparseVector)orig;
                                if (indexed instanceof SparseVector) {
                                    SparseVector sparseVector2 = (SparseVector)indexed;
                                    int[] $org_scalatest_assert_macro_left = sparseVector.indices();
                                    int $org_scalatest_assert_macro_right = sparseVector2.indices().length;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                                    this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new UnknownError("Unit test has a bug in it.");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Preserve metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Attribute[] featureAttributes = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(this.$outer.point1maxes()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NumericAttribute apply(Tuple2<Object, Object> x0$3) {
                        Tuple2<Object, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            double maxVal = tuple2._1$mcD$sp();
                            int i = tuple2._2$mcI$sp();
                            NumericAttribute numericAttribute = NumericAttribute$.MODULE$.defaultAttr().withName(((Object)BoxesRunTime.boxToInteger((int)i)).toString()).withMax(maxVal);
                            return numericAttribute;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
                AttributeGroup attrGroup = new AttributeGroup("features", featureAttributes);
                Dataset densePoints1WithMeta = this.$outer.densePoints1().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.densePoints1().apply("features").as("features", attrGroup.toMetadata())}));
                VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(2);
                VectorIndexerModel model = vectorIndexer.fit(densePoints1WithMeta);
                Dataset indexedPoints = model.transform(densePoints1WithMeta);
                Attribute[] transAttributes = (Attribute[])AttributeGroup$.MODULE$.fromStructField(indexedPoints.schema().apply("indexed")).attributes().get();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])featureAttributes).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])transAttributes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    /*
                     * Unable to fully structure code
                     */
                    public final void apply(Tuple2<Attribute, Attribute> x0$4) {
                        block4: {
                            var2_2 = x0$4;
                            if (var2_2 == null) break block4;
                            orig = (Attribute)var2_2._1();
                            trans = (Attribute)var2_2._2();
                            $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(orig.name());
                            $org_scalatest_assert_macro_right = trans.name();
                            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            var9_8 = new Tuple2((Object)orig, (Object)trans);
                            if (var9_8 == null) ** GOTO lbl-1000
                            orig = (Attribute)var9_8._1();
                            trans = (Attribute)var9_8._2();
                            if (!(orig instanceof NumericAttribute)) ** GOTO lbl-1000
                            var12_11 = (NumericAttribute)orig;
                            if (trans instanceof NumericAttribute) {
                                var13_12 = (NumericAttribute)trans;
                                $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(var12_11.max().nonEmpty(), "orig.max.nonEmpty");
                                if ($org_scalatest_assert_macro_left.value()) {
                                    $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(var12_11.max());
                                    $org_scalatest_assert_macro_right = var13_12.max();
                                    v0 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                } else {
                                    v0 = Bool$.MODULE$.simpleMacroBool(false, "");
                                }
                                $org_scalatest_assert_macro_right = v0;
                                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
                                this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                var14_18 = BoxedUnit.UNIT;
                            } else lbl-1000:
                            // 3 sources

                            {
                                var14_19 = BoxedUnit.UNIT;
                            }
                            var5_20 = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(var2_2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ VectorIndexerSuite org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("VectorIndexer read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VectorIndexer t = new VectorIndexer().setInputCol("myInputCol").setOutputCol("myOutputCol").setMaxCategories(30);
                this.$outer.testDefaultReadWrite(t, this.$outer.testDefaultReadWrite$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("VectorIndexerModel read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoryMaps = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToInteger((int)1))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)2.0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)3.0)), (Object)BoxesRunTime.boxToInteger((int)3))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)-1.0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)2.0)), (Object)BoxesRunTime.boxToInteger((int)2))})))}));
                VectorIndexerModel instance = new VectorIndexerModel("myVectorIndexerModel", 3, categoryMaps);
                VectorIndexerModel newInstance = this.$outer.testDefaultReadWrite(instance, this.$outer.testDefaultReadWrite$default$2());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)newInstance.numFeatures()));
                int $org_scalatest_assert_macro_right = instance.numFeatures();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(newInstance.categoryMaps());
                Map $org_scalatest_assert_macro_right2 = instance.categoryMaps();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static class FeatureData
    implements Product,
    Serializable {
        private final Vector features;

        public Vector features() {
            return this.features;
        }

        public Vector getFeatures() {
            return this.features();
        }

        public FeatureData copy(Vector features) {
            return new FeatureData(features);
        }

        public Vector copy$default$1() {
            return this.features();
        }

        public String productPrefix() {
            return "FeatureData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.features();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FeatureData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FeatureData)) return false;
            boolean bl = true;
            if (!bl) return false;
            FeatureData featureData = (FeatureData)x$1;
            Vector vector = this.features();
            Vector vector2 = featureData.features();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (!featureData.canEqual(this)) return false;
            return true;
        }

        public FeatureData(Vector features) {
            this.features = features;
            Product.class.$init$((Product)this);
        }
    }
}

