/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquares;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquaresModel;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquaresSuite$;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u001b\t1\u0013\n^3sCRLg/\u001a7z%\u0016<X-[4ii\u0016$G*Z1tiN\u000bX/\u0019:fgN+\u0018\u000e^3\u000b\u0005\r!\u0011!B8qi&l'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tA!\u001e;jY*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!I\u0001\u0005\u0001a\u0001\u0002\u0004%I!I\u0001\u000bS:\u001cH/\u00198dKN\fT#\u0001\u0012\u0011\u0007\r2\u0003&D\u0001%\u0015\t)c!A\u0002sI\u0012L!a\n\u0013\u0003\u0007I#E\t\u0005\u0002*Y5\t!F\u0003\u0002,\t\u00059a-Z1ukJ,\u0017BA\u0017+\u0005!Ien\u001d;b]\u000e,\u0007\"C\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u00031\u00039Ign\u001d;b]\u000e,7/M0%KF$\"!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\tUs\u0017\u000e\u001e\u0005\bq9\n\t\u00111\u0001#\u0003\rAH%\r\u0005\u0007u\u0001\u0001\u000b\u0015\u0002\u0012\u0002\u0017%t7\u000f^1oG\u0016\u001c\u0018\u0007\t\u0005\ny\u0001\u0001\r\u00111A\u0005\n\u0005\n!\"\u001b8ti\u0006t7-Z:3\u0011%q\u0004\u00011AA\u0002\u0013%q(\u0001\bj]N$\u0018M\\2fgJzF%Z9\u0015\u0005E\u0002\u0005b\u0002\u001d>\u0003\u0003\u0005\rA\t\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u0012\u0002\u0017%t7\u000f^1oG\u0016\u001c(\u0007\t\u0005\u0006\t\u0002!\t%R\u0001\nE\u00164wN]3BY2$\u0012!M\u0004\u0006\u000f\nA\t\u0001S\u0001'\u0013R,'/\u0019;jm\u0016d\u0017PU3xK&<\u0007\u000e^3e\u0019\u0016\f7\u000f^*rk\u0006\u0014Xm]*vSR,\u0007C\u0001\u0010J\r\u0015\t!\u0001#\u0001K'\rI5J\u0014\t\u0003e1K!!T\u001a\u0003\r\u0005s\u0017PU3g!\t\u0011t*\u0003\u0002Qg\ta1+\u001a:jC2L'0\u00192mK\")1$\u0013C\u0001%R\t\u0001\nC\u0003U\u0013\u0012\u0005Q+\u0001\u000bCS:|W.[1m%\u0016<X-[4ii\u001a+hn\u0019\u000b\u0004-rs\u0006\u0003\u0002\u001aX3fK!\u0001W\u001a\u0003\rQ+\b\u000f\\33!\t\u0011$,\u0003\u0002\\g\t1Ai\\;cY\u0016DQ!X*A\u0002!\n\u0001\"\u001b8ti\u0006t7-\u001a\u0005\u0006?N\u0003\r\u0001Y\u0001\u0006[>$W\r\u001c\t\u0003=\u0005L!A\u0019\u0002\u00033]+\u0017n\u001a5uK\u0012dU-Y:u'F,\u0018M]3t\u001b>$W\r\u001c\u0005\u0006I&#\t!Z\u0001\u0014!>L7o]8o%\u0016<X-[4ii\u001a+hn\u0019\u000b\u0004-\u001a<\u0007\"B/d\u0001\u0004A\u0003\"B0d\u0001\u0004\u0001\u0007\"B5J\t\u0003Q\u0017\u0001\u0007'2%\u0016<'/Z:tS>t'+Z<fS\u001eDGOR;oGR\u0019ak\u001b7\t\u000buC\u0007\u0019\u0001\u0015\t\u000b}C\u0007\u0019\u00011\t\u000f9L\u0015\u0011!C\u0005_\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003\u0011a\u0017M\\4\u000b\u0003U\fAA[1wC&\u0011qO\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class IterativelyReweightedLeastSquaresSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<Instance> org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances1;
    private RDD<Instance> org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Tuple2<Object, Object> L1RegressionReweightFunc(Instance instance, WeightedLeastSquaresModel weightedLeastSquaresModel) {
        return IterativelyReweightedLeastSquaresSuite$.MODULE$.L1RegressionReweightFunc(instance, weightedLeastSquaresModel);
    }

    public static Tuple2<Object, Object> PoissonReweightFunc(Instance instance, WeightedLeastSquaresModel weightedLeastSquaresModel) {
        return IterativelyReweightedLeastSquaresSuite$.MODULE$.PoissonReweightFunc(instance, weightedLeastSquaresModel);
    }

    public static Tuple2<Object, Object> BinomialReweightFunc(Instance instance, WeightedLeastSquaresModel weightedLeastSquaresModel) {
        return IterativelyReweightedLeastSquaresSuite$.MODULE$.BinomialReweightFunc(instance, weightedLeastSquaresModel);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public RDD<Instance> org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances1() {
        return this.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances1;
    }

    private void org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances1_$eq(RDD<Instance> x$1) {
        this.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances1 = x$1;
    }

    public RDD<Instance> org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2() {
        return this.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2;
    }

    private void org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2_$eq(RDD<Instance> x$1) {
        this.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2 = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances1_$eq((RDD<Instance>)this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(1.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), new Instance(0.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0})))})), 2, ClassTag$.MODULE$.apply(Instance.class)));
        this.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2_$eq((RDD<Instance>)this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(2.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), new Instance(8.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), new Instance(3.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), new Instance(9.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0})))})), 2, ClassTag$.MODULE$.apply(Instance.class)));
    }

    public IterativelyReweightedLeastSquaresSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("IRLS against GLM with Binomial errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IterativelyReweightedLeastSquaresSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.30216651, -0.04452045})), Vectors$.MODULE$.dense(3.5651651, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.2334085, -0.7348971}))}));
                IntRef idx2 = new IntRef(0);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1)new Serializable(this, expected, idx2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final Seq expected$1;
                    private final IntRef idx$1;

                    public final void apply(boolean fitIntercept) {
                        RDD newInstances = this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances1().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Instance apply(Instance instance) {
                                double mu = (instance.label() + 0.5) / 2.0;
                                double eta = package$.MODULE$.log(mu / (1.0 - mu));
                                return new Instance(eta, instance.weight(), instance.features());
                            }
                        }, ClassTag$.MODULE$.apply(Instance.class));
                        WeightedLeastSquaresModel initial = new WeightedLeastSquares(fitIntercept, 0.0, false, false).fit(newInstances);
                        IterativelyReweightedLeastSquaresModel irls = new IterativelyReweightedLeastSquares(initial, (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(Instance instance, WeightedLeastSquaresModel model) {
                                return IterativelyReweightedLeastSquaresSuite$.MODULE$.BinomialReweightFunc(instance, model);
                            }
                        }, fitIntercept, 0.0, 25, 1.0E-8).fit(this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances1());
                        Vector actual = Vectors$.MODULE$.dense(irls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{irls.coefficients().apply(0), irls.coefficients().apply(1)}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)this.expected$1.apply(this.idx$1.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))");
                        this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        ++this.idx$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$1 = expected$1;
                        this.idx$1 = idx$1;
                    }
                });
            }

            public /* synthetic */ IterativelyReweightedLeastSquaresSuite org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("IRLS against GLM with Poisson errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IterativelyReweightedLeastSquaresSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.09607792, 0.18375613})), Vectors$.MODULE$.dense(6.299947, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.324107, -1.081766}))}));
                IntRef idx2 = new IntRef(0);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1)new Serializable(this, expected, idx2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Seq expected$2;
                    private final IntRef idx$2;

                    public final void apply(boolean fitIntercept) {
                        double yMean = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Instance x$1) {
                                return x$1.label();
                            }
                        }, ClassTag$.MODULE$.Double())).mean();
                        RDD newInstances = this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2().map((Function1)new Serializable(this, yMean){
                            public static final long serialVersionUID = 0L;
                            private final double yMean$1;

                            public final Instance apply(Instance instance) {
                                double mu = (instance.label() + this.yMean$1) / 2.0;
                                double eta = package$.MODULE$.log(mu);
                                return new Instance(eta, instance.weight(), instance.features());
                            }
                            {
                                this.yMean$1 = yMean$1;
                            }
                        }, ClassTag$.MODULE$.apply(Instance.class));
                        WeightedLeastSquaresModel initial = new WeightedLeastSquares(fitIntercept, 0.0, false, false).fit(newInstances);
                        IterativelyReweightedLeastSquaresModel irls = new IterativelyReweightedLeastSquares(initial, (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(Instance instance, WeightedLeastSquaresModel model) {
                                return IterativelyReweightedLeastSquaresSuite$.MODULE$.PoissonReweightFunc(instance, model);
                            }
                        }, fitIntercept, 0.0, 25, 1.0E-8).fit(this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2());
                        Vector actual = Vectors$.MODULE$.dense(irls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{irls.coefficients().apply(0), irls.coefficients().apply(1)}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)this.expected$2.apply(this.idx$2.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))");
                        this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        ++this.idx$2.elem;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$2 = expected$2;
                        this.idx$2 = idx$2;
                    }
                });
            }

            public /* synthetic */ IterativelyReweightedLeastSquaresSuite org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("IRLS against L1Regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IterativelyReweightedLeastSquaresSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.266667, 0.4})), Vectors$.MODULE$.dense(29.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{17.0, -5.5}))}));
                IntRef idx2 = new IntRef(0);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1)new Serializable(this, expected, idx2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final Seq expected$3;
                    private final IntRef idx$3;

                    public final void apply(boolean fitIntercept) {
                        WeightedLeastSquaresModel initial = new WeightedLeastSquares(fitIntercept, 0.0, false, false).fit(this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2());
                        IterativelyReweightedLeastSquaresModel irls = new IterativelyReweightedLeastSquares(initial, (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(Instance instance, WeightedLeastSquaresModel model) {
                                return IterativelyReweightedLeastSquaresSuite$.MODULE$.L1RegressionReweightFunc(instance, model);
                            }
                        }, fitIntercept, 0.0, 200, 1.0E-7).fit(this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$instances2());
                        Vector actual = Vectors$.MODULE$.dense(irls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{irls.coefficients().apply(0), irls.coefficients().apply(1)}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)this.expected$3.apply(this.idx$3.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))");
                        this.$outer.org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        ++this.idx$3.elem;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$3 = expected$3;
                        this.idx$3 = idx$3;
                    }
                });
            }

            public /* synthetic */ IterativelyReweightedLeastSquaresSuite org$apache$spark$ml$optim$IterativelyReweightedLeastSquaresSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

