/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import java.util.Arrays;
import org.apache.spark.ml.param.JavaTestParams;
import org.apache.spark.ml.param.ParamValidators;
import org.junit.Assert;
import org.junit.Test;

public class JavaParamsSuite {
    @Test
    public void testParams() {
        JavaTestParams testParams = new JavaTestParams();
        Assert.assertEquals((long)testParams.getMyIntParam(), (long)1L);
        testParams.setMyIntParam(2).setMyDoubleParam(0.4).setMyStringParam("a");
        Assert.assertEquals((double)testParams.getMyDoubleParam(), (double)0.4, (double)0.0);
        Assert.assertEquals((Object)testParams.getMyStringParam(), (Object)"a");
        Assert.assertArrayEquals((double[])testParams.getMyDoubleArrayParam(), (double[])new double[]{1.0, 2.0}, (double)0.0);
    }

    @Test
    public void testParamValidate() {
        ParamValidators.gt((double)1.0);
        ParamValidators.gtEq((double)1.0);
        ParamValidators.lt((double)1.0);
        ParamValidators.ltEq((double)1.0);
        ParamValidators.inRange((double)0.0, (double)1.0, (boolean)true, (boolean)false);
        ParamValidators.inRange((double)0.0, (double)1.0);
        ParamValidators.inArray(Arrays.asList(0, 1, 3));
        ParamValidators.inArray(Arrays.asList("a", "b"));
    }
}

