/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALS$;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.ml.recommendation.ALSSuite$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u001b\ty\u0011\tT*DY\u0016\fg.\u001a:Tk&$XM\u0003\u0002\u0004\t\u0005q!/Z2p[6,g\u000eZ1uS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005\u0001")
public class ALSCleanerSuite
extends SparkFunSuite {
    public ALSCleanerSuite() {
        this.test("ALS shuffle cleanup standalone", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSCleanerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = new SparkConf();
                File localDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                File checkpointDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                try {
                    conf.set("spark.local.dir", localDir.getAbsolutePath());
                    SparkContext sc = new SparkContext("local[2]", "test", conf);
                    try {
                        sc.setCheckpointDir(checkpointDir.getAbsolutePath());
                        RDD input = sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000), sc.parallelize$default$2(), ClassTag$.MODULE$.Int());
                        RDD keyed = input.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(int x) {
                                return new Tuple2.mcII.sp(x % 20, 1);
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        RDD shuffled = RDD$.MODULE$.rddToPairRDDFunctions(keyed, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$27, int x$28) {
                                return this.apply$mcIII$sp(x$27, x$28);
                            }

                            public int apply$mcIII$sp(int x$27, int x$28) {
                                return x$27 + x$28;
                            }
                        });
                        RDD keysOnly = RDD$.MODULE$.rddToPairRDDFunctions(shuffled, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).keys();
                        Seq deps = keysOnly.dependencies();
                        keysOnly.count();
                        ALS$.MODULE$.cleanShuffleDependencies(sc, deps, true);
                        Set resultingFiles = this.getAllFiles$1(localDir);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(resultingFiles);
                        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        keysOnly.count();
                    }
                    catch (Throwable throwable) {
                        sc.stop();
                        throw throwable;
                    }
                    sc.stop();
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(localDir);
                    Utils$.MODULE$.deleteRecursively(checkpointDir);
                }
            }

            private final Set getAllFiles$1(File localDir$1) {
                return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)localDir$1, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSet();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ALS shuffle cleanup in algorithm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSCleanerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = new SparkConf();
                File localDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                File checkpointDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                try {
                    conf.set("spark.local.dir", localDir.getAbsolutePath());
                    SparkContext sc = new SparkContext("local[2]", "test", conf);
                    try {
                        sc.setCheckpointDir(checkpointDir.getAbsolutePath());
                        Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = ALSSuite$.MODULE$.genImplicitTestData(sc, 20, 5, 1, 0.2, 0L);
                        if (tuple2 != null) {
                            RDD training;
                            RDD rDD;
                            RDD training2 = rDD = (training = (RDD)tuple2._1());
                            SparkSession spark = SparkSession$.MODULE$.builder().master("local[2]").appName("ALSCleanerSuite").sparkContext(sc).getOrCreate();
                            ALS als = new ALS().setRank(1).setRegParam(1.0E-5).setSeed(0L).setCheckpointInterval(1).setMaxIter(7);
                            JavaUniverse $u = package$.MODULE$.universe();
                            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSCleanerSuite.class.getClassLoader());
                            ALSModel model = als.fit(spark.implicits().rddToDatasetHolder(training2, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                    Universe $u = $m$untyped.universe();
                                    Mirror<U> $m = $m$untyped;
                                    return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.ml")), $m.staticPackage("org.apache.spark.ml.recommendation")), $m.staticModule("org.apache.spark.ml.recommendation.ALS")), $m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                                }
                            }))).toDF());
                            Set resultingFiles = this.getAllFiles$2(localDir);
                            Regex pattern = new StringOps(Predef$.MODULE$.augmentString("shuffle_(\\d+)_.+\\.data")).r();
                            Set rddIds = (Set)resultingFiles.flatMap((Function1)new Serializable(this, pattern){
                                public static final long serialVersionUID = 0L;
                                private final Regex pattern$1;

                                public final Iterator<String> apply(File f) {
                                    return this.pattern$1.findAllIn((CharSequence)f.getName()).matchData().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Regex.Match x$29) {
                                            return x$29.group(1);
                                        }
                                    });
                                }
                                {
                                    this.pattern$1 = pattern$1;
                                }
                            }, Set$.MODULE$.canBuildFrom());
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)rddIds.size()));
                            int $org_scalatest_assert_macro_right = 4;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    finally {
                        sc.stop();
                    }
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(localDir);
                    Utils$.MODULE$.deleteRecursively(checkpointDir);
                }
            }

            private final Set getAllFiles$2(File localDir$2) {
                return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)localDir$2, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSet();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

