/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import com.github.fommil.netlib.BLAS;
import java.util.Random;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALSSuite$;
import org.apache.spark.ml.recommendation.ALSSuite$$anonfun$org$apache$spark$ml$recommendation$ALSSuite$;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ALSSuite$
implements Logging,
Serializable {
    public static final ALSSuite$ MODULE$;
    private final Map<String, Object> allModelParamSettings;
    private final Map<String, Object> allEstimatorParamSettings;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ALSSuite$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg2) {
        Logging.class.logInfo((Logging)this, msg2);
    }

    public void logDebug(Function0<String> msg2) {
        Logging.class.logDebug((Logging)this, msg2);
    }

    public void logTrace(Function0<String> msg2) {
        Logging.class.logTrace((Logging)this, msg2);
    }

    public void logWarning(Function0<String> msg2) {
        Logging.class.logWarning((Logging)this, msg2);
    }

    public void logError(Function0<String> msg2) {
        Logging.class.logError((Logging)this, msg2);
    }

    public void logInfo(Function0<String> msg2, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg2, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg2, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg2, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg2, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg2, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg2, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg2, (Throwable)throwable);
    }

    public void logError(Function0<String> msg2, Throwable throwable) {
        Logging.class.logError((Logging)this, msg2, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Map<String, Object> allModelParamSettings() {
        return this.allModelParamSettings;
    }

    public Map<String, Object> allEstimatorParamSettings() {
        return this.allEstimatorParamSettings;
    }

    public Seq<Tuple2<Object, float[]>> org$apache$spark$ml$recommendation$ALSSuite$$genFactors(int size, int rank, Random random, float a, float b) {
        Predef$.MODULE$.require(size > 0 && size < 0x2AAAAAAA);
        Predef$.MODULE$.require(b > a);
        Set ids = Set$.MODULE$.empty();
        while (ids.size() < size) {
            ids.$plus$eq((Object)BoxesRunTime.boxToInteger((int)random.nextInt()));
        }
        float width = b - a;
        return (Seq)((TraversableLike)ids.toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(rank, random, a, width){
            public static final long serialVersionUID = 0L;
            private final int rank$3;
            public final Random random$3;
            public final float a$1;
            public final float width$1;

            public final Tuple2<Object, float[]> apply(int id) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), Array$.MODULE$.fill(this.rank$3, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$ml$recommendation$ALSSuite$$genFactors$1 $outer;

                    public final float apply() {
                        return this.apply$mcF$sp();
                    }

                    public float apply$mcF$sp() {
                        return this.$outer.a$1 + this.$outer.random$3.nextFloat() * this.$outer.width$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Float()));
            }
            {
                this.rank$3 = rank$3;
                this.random$3 = random$3;
                this.a$1 = a$1;
                this.width$1 = width$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private float genFactors$default$4() {
        return -1.0f;
    }

    private float genFactors$default$5() {
        return 1.0f;
    }

    public Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> genImplicitTestData(SparkContext sc, int numUsers, int numItems, int rank, double noiseStd, long seed) {
        double positiveFraction = 0.8;
        double negativeFraction = 1.0 - positiveFraction;
        double trainingFraction = 0.6;
        double testFraction = 0.3;
        double totalFraction = trainingFraction + testFraction;
        Random random = new Random(seed);
        Seq<Tuple2<Object, float[]>> userFactors = this.org$apache$spark$ml$recommendation$ALSSuite$$genFactors(numUsers, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        Seq<Tuple2<Object, float[]>> itemFactors = this.org$apache$spark$ml$recommendation$ALSSuite$$genFactors(numItems, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        ArrayBuffer training = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer test = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        userFactors.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, float[]> check$ifrefutable$5) {
                Tuple2<Object, float[]> tuple2 = check$ifrefutable$5;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(rank, noiseStd, positiveFraction, negativeFraction, trainingFraction, totalFraction, random, itemFactors, training, test){
            public static final long serialVersionUID = 0L;
            public final int rank$2;
            public final double noiseStd$2;
            public final double positiveFraction$1;
            public final double negativeFraction$1;
            public final double trainingFraction$2;
            public final double totalFraction$2;
            public final Random random$4;
            private final Seq itemFactors$2;
            public final ArrayBuffer training$3;
            public final ArrayBuffer test$3;

            public final void apply(Tuple2<Object, float[]> x$31) {
                Tuple2<Object, float[]> tuple2 = x$31;
                if (tuple2 != null) {
                    int userId = tuple2._1$mcI$sp();
                    float[] userFactor = (float[])tuple2._2();
                    this.itemFactors$2.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, float[]> check$ifrefutable$6) {
                            Tuple2<Object, float[]> tuple2 = check$ifrefutable$6;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, userId, userFactor){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.genImplicitTestData.2 $outer;
                        private final int userId$2;
                        private final float[] userFactor$2;

                        public final Object apply(Tuple2<Object, float[]> x$30) {
                            Tuple2<Object, float[]> tuple2 = x$30;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                boolean observed;
                                int itemId = tuple2._1$mcI$sp();
                                float[] itemFactor = (float[])tuple2._2();
                                float rating = BLAS.getInstance().sdot(this.$outer.rank$2, this.userFactor$2, 1, itemFactor, 1);
                                double threshold = rating > 0.0f ? this.$outer.positiveFraction$1 : this.$outer.negativeFraction$1;
                                boolean bl = observed = this.$outer.random$4.nextDouble() < threshold;
                                if (observed) {
                                    double x = this.$outer.random$4.nextDouble();
                                    if (x < this.$outer.totalFraction$2) {
                                        if (x < this.$outer.trainingFraction$2) {
                                            double noise = this.$outer.noiseStd$2 * this.$outer.random$4.nextGaussian();
                                            boxedUnit = this.$outer.training$3.$plus$eq((Object)new ALS.Rating$mcI$sp(this.userId$2, itemId, rating + (float)noise));
                                        } else {
                                            boxedUnit = this.$outer.test$3.$plus$eq((Object)new ALS.Rating$mcI$sp(this.userId$2, itemId, rating));
                                        }
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return boxedUnit2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.userId$2 = userId$2;
                            this.userFactor$2 = userFactor$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.rank$2 = rank$2;
                this.noiseStd$2 = noiseStd$2;
                this.positiveFraction$1 = positiveFraction$1;
                this.negativeFraction$1 = negativeFraction$1;
                this.trainingFraction$2 = trainingFraction$2;
                this.totalFraction$2 = totalFraction$2;
                this.random$4 = random$4;
                this.itemFactors$2 = itemFactors$2;
                this.training$3 = training$3;
                this.test$3 = test$3;
            }
        });
        this.logInfo((Function0<String>)new Serializable(training, test){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer training$3;
            private final ArrayBuffer test$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated an implicit feedback dataset with ", " ratings for training "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.training$3.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and ", " for test."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.test$3.size())}))).toString();
            }
            {
                this.training$3 = training$3;
                this.test$3 = test$3;
            }
        });
        return new Tuple2((Object)sc.parallelize((Seq)training, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)), (Object)sc.parallelize((Seq)test, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)));
    }

    public double genImplicitTestData$default$5() {
        return 0.0;
    }

    public long genImplicitTestData$default$6() {
        return 11L;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ALSSuite$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.allModelParamSettings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"predictionCol"), (Object)"myPredictionCol")}));
        this.allEstimatorParamSettings = this.allModelParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rank"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"regParam"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"numUserBlocks"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"numItemBlocks"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"implicitPrefs"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"alpha"), (Object)BoxesRunTime.boxToDouble((double)0.9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"nonnegative"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"checkpointInterval"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"intermediateStorageLevel"), (Object)"MEMORY_ONLY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"finalStorageLevel"), (Object)"MEMORY_AND_DISK_SER")})));
    }
}

