/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import com.github.fommil.netlib.BLAS;
import java.io.File;
import java.util.Random;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALS$;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.ml.recommendation.ALSSuite$;
import org.apache.spark.ml.recommendation.ALSSuite$$anonfun$1$;
import org.apache.spark.ml.recommendation.ALSSuite$$anonfun$21$$anonfun$apply$mcV$sp$12$;
import org.apache.spark.ml.recommendation.ALSSuite$$anonfun$24$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.storage.StorageLevel;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple7;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0001\u0003\u00015\u0011\u0001\"\u0011'T'VLG/\u001a\u0006\u0003\u0007\u0011\taB]3d_6lWM\u001c3bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%iy\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0005kRLGN\u0003\u0002\u0018\r\u0005)Q\u000e\u001c7jE&\u0011\u0011\u0004\u0006\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u!\tYR$D\u0001\u001d\u0015\t)B!\u0003\u0002\u001f9\t!B)\u001a4bk2$(+Z1e/JLG/\u001a+fgR\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001J\u0011\u0003\u000f1{wmZ5oO\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011A\u0001\u0005\u0006W\u0001!\t\u0005L\u0001\nE\u00164wN]3BY2$\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0005+:LG\u000fC\u00035\u0001\u0011\u0005C&\u0001\u0005bMR,'/\u00117m\u0011\u00151\u0004\u0001\"\u00018\u0003M9WM\\#ya2L7-\u001b;UKN$H)\u0019;b)\u0019A\u0004L\u0017/_GB!a&O\u001e<\u0013\tQtF\u0001\u0004UkBdWM\r\t\u0004y}\nU\"A\u001f\u000b\u0005y2\u0011a\u0001:eI&\u0011\u0001)\u0010\u0002\u0004%\u0012#\u0005c\u0001\"S+:\u00111\t\u0015\b\u0003\t>s!!\u0012(\u000f\u0005\u0019keBA$M\u001d\tA5*D\u0001J\u0015\tQE\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011BA)\u0003\u0003\r\tEjU\u0005\u0003'R\u0013aAU1uS:<'BA)\u0003!\tqc+\u0003\u0002X_\t\u0019\u0011J\u001c;\t\u000be+\u0004\u0019A+\u0002\u00119,X.V:feNDQaW\u001bA\u0002U\u000b\u0001B\\;n\u0013R,Wn\u001d\u0005\u0006;V\u0002\r!V\u0001\u0005e\u0006t7\u000eC\u0004`kA\u0005\t\u0019\u00011\u0002\u00119|\u0017n]3Ti\u0012\u0004\"AL1\n\u0005\t|#A\u0002#pk\ndW\rC\u0004ekA\u0005\t\u0019A3\u0002\tM,W\r\u001a\t\u0003]\u0019L!aZ\u0018\u0003\t1{gn\u001a\u0005\u0006S\u0002!\tA[\u0001\u0014O\u0016t\u0017*\u001c9mS\u000eLG\u000fV3ti\u0012\u000bG/\u0019\u000b\u0007q-dWN\\8\t\u000beC\u0007\u0019A+\t\u000bmC\u0007\u0019A+\t\u000buC\u0007\u0019A+\t\u000f}C\u0007\u0013!a\u0001A\"9A\r\u001bI\u0001\u0002\u0004)\u0007\"B9\u0001\t\u0013\u0011\u0018AC4f]\u001a\u000b7\r^8sgRY1/a\u0002\u0002\f\u00055\u0011qDA\u0012!\r!\u0018\u0010 \b\u0003k^t!\u0001\u0013<\n\u0003AJ!\u0001_\u0018\u0002\u000fA\f7m[1hK&\u0011!p\u001f\u0002\u0004'\u0016\f(B\u0001=0!\u0011q\u0013(V?\u0011\t9r\u0018\u0011A\u0005\u0003\u007f>\u0012Q!\u0011:sCf\u00042ALA\u0002\u0013\r\t)a\f\u0002\u0006\r2|\u0017\r\u001e\u0005\u0007\u0003\u0013\u0001\b\u0019A+\u0002\tML'0\u001a\u0005\u0006;B\u0004\r!\u0016\u0005\b\u0003\u001f\u0001\b\u0019AA\t\u0003\u0019\u0011\u0018M\u001c3p[B!\u00111CA\u000e\u001b\t\t)BC\u0002\u0016\u0003/Q!!!\u0007\u0002\t)\fg/Y\u0005\u0005\u0003;\t)B\u0001\u0004SC:$w.\u001c\u0005\n\u0003C\u0001\b\u0013!a\u0001\u0003\u0003\t\u0011!\u0019\u0005\n\u0003K\u0001\b\u0013!a\u0001\u0003\u0003\t\u0011A\u0019\u0005\b\u0003S\u0001A\u0011AA\u0016\u0003\u001d!Xm\u001d;B\u0019N#2#LA\u0017\u0003c\t)$a\u000e\u0002<\u0005}\u0012\u0011JA'\u0003#Bq!a\f\u0002(\u0001\u00071(\u0001\u0005ue\u0006Lg.\u001b8h\u0011\u001d\t\u0019$a\nA\u0002m\nA\u0001^3ti\"1Q,a\nA\u0002UCq!!\u000f\u0002(\u0001\u0007Q+A\u0004nCbLE/\u001a:\t\u000f\u0005u\u0012q\u0005a\u0001A\u0006A!/Z4QCJ\fW\u000e\u0003\u0006\u0002B\u0005\u001d\u0002\u0013!a\u0001\u0003\u0007\nQ\"[7qY&\u001c\u0017\u000e\u001e)sK\u001a\u001c\bc\u0001\u0018\u0002F%\u0019\u0011qI\u0018\u0003\u000f\t{w\u000e\\3b]\"I\u00111JA\u0014!\u0003\u0005\r!V\u0001\u000e]VlWk]3s\u00052|7m[:\t\u0013\u0005=\u0013q\u0005I\u0001\u0002\u0004)\u0016!\u00048v[&#X-\u001c\"m_\u000e\\7\u000fC\u0005\u0002T\u0005\u001d\u0002\u0013!a\u0001A\u0006QA/\u0019:hKR\u0014VjU#\t\u0013\u0005]\u0003!%A\u0005\u0002\u0005e\u0013!H4f]\u0016C\b\u000f\\5dSR$Vm\u001d;ECR\fG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005m#f\u00011\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GMC\u0002\u0002j=\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002r\u0001\t\n\u0011\"\u0001\u0002t\u0005ir-\u001a8FqBd\u0017nY5u)\u0016\u001cH\u000fR1uC\u0012\"WMZ1vYR$S'\u0006\u0002\u0002v)\u001aQ-!\u0018\t\u0013\u0005e\u0004!%A\u0005\n\u0005m\u0014\u0001F4f]\u001a\u000b7\r^8sg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002~)\"\u0011\u0011AA/\u0011%\t\t\tAI\u0001\n\u0013\tY(\u0001\u000bhK:4\u0015m\u0019;peN$C-\u001a4bk2$H%\u000e\u0005\n\u0003\u000b\u0003\u0011\u0013!C\u0001\u00033\nQdZ3o\u00136\u0004H.[2jiR+7\u000f\u001e#bi\u0006$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0003\u0013\u0003\u0011\u0013!C\u0001\u0003g\nQdZ3o\u00136\u0004H.[2jiR+7\u000f\u001e#bi\u0006$C-\u001a4bk2$H%\u000e\u0005\n\u0003\u001b\u0003\u0011\u0013!C\u0001\u0003\u001f\u000b\u0011\u0003^3ti\u0006c5\u000b\n3fM\u0006,H\u000e\u001e\u00137+\t\t\tJ\u000b\u0003\u0002D\u0005u\u0003\"CAK\u0001E\u0005I\u0011AAL\u0003E!Xm\u001d;B\u0019N#C-\u001a4bk2$HeN\u000b\u0003\u00033S3!VA/\u0011%\ti\nAI\u0001\n\u0003\t9*A\tuKN$\u0018\tT*%I\u00164\u0017-\u001e7uIaB\u0011\"!)\u0001#\u0003%\t!!\u0017\u0002#Q,7\u000f^!M'\u0012\"WMZ1vYR$\u0013hB\u0004\u0002&\nA\t!a*\u0002\u0011\u0005c5kU;ji\u0016\u00042!KAU\r\u0019\t!\u0001#\u0001\u0002,N9\u0011\u0011VAW?\u0005M\u0006c\u0001\u0018\u00020&\u0019\u0011\u0011W\u0018\u0003\r\u0005s\u0017PU3g!\rq\u0013QW\u0005\u0004\u0003o{#\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002\u0014\u0002*\u0012\u0005\u00111\u0018\u000b\u0003\u0003OC!\"a0\u0002*\n\u0007I\u0011AAa\u0003U\tG\u000e\\'pI\u0016d\u0007+\u0019:b[N+G\u000f^5oON,\"!a1\u0011\u0011\u0005\u0015\u00171ZAi\u0003/t1ALAd\u0013\r\tImL\u0001\u0007!J,G-\u001a4\n\t\u00055\u0017q\u001a\u0002\u0004\u001b\u0006\u0004(bAAe_A!\u0011QYAj\u0013\u0011\t).a4\u0003\rM#(/\u001b8h!\rq\u0013\u0011\\\u0005\u0004\u00037|#aA!os\"I\u0011q\\AUA\u0003%\u00111Y\u0001\u0017C2dWj\u001c3fYB\u000b'/Y7TKR$\u0018N\\4tA!Q\u00111]AU\u0005\u0004%\t!!1\u00023\u0005dG.R:uS6\fGo\u001c:QCJ\fWnU3ui&twm\u001d\u0005\n\u0003O\fI\u000b)A\u0005\u0003\u0007\f!$\u00197m\u000bN$\u0018.\\1u_J\u0004\u0016M]1n'\u0016$H/\u001b8hg\u0002Bq!]AU\t\u0013\tY\u000fF\u0006t\u0003[\fy/!=\u0002t\u0006U\bbBA\u0005\u0003S\u0004\r!\u0016\u0005\u0007;\u0006%\b\u0019A+\t\u0011\u0005=\u0011\u0011\u001ea\u0001\u0003#A!\"!\t\u0002jB\u0005\t\u0019AA\u0001\u0011)\t)#!;\u0011\u0002\u0003\u0007\u0011\u0011\u0001\u0005\bS\u0006%F\u0011AA})5A\u00141 B\u0003\u0005\u000f\u0011IAa\u0003\u0003\u000e!A\u0011Q`A|\u0001\u0004\ty0\u0001\u0002tGB\u0019qB!\u0001\n\u0007\t\raA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0004Z\u0003o\u0004\r!\u0016\u0005\u00077\u0006]\b\u0019A+\t\ru\u000b9\u00101\u0001V\u0011!y\u0016q\u001fI\u0001\u0002\u0004\u0001\u0007\u0002\u00033\u0002xB\u0005\t\u0019A3\t\u0015\u0005%\u0015\u0011VI\u0001\n\u0003\tI\u0006\u0003\u0006\u0003\u0014\u0005%\u0016\u0013!C\u0001\u0003g\nQdZ3o\u00136\u0004H.[2jiR+7\u000f\u001e#bi\u0006$C-\u001a4bk2$HE\u000e\u0005\u000b\u0003s\nI+%A\u0005\n\u0005m\u0004BCAA\u0003S\u000b\n\u0011\"\u0003\u0002|!Q!1DAU\u0003\u0003%IA!\b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005?\u0001BA!\t\u0003(5\u0011!1\u0005\u0006\u0005\u0005K\t9\"\u0001\u0003mC:<\u0017\u0002\u0002B\u0015\u0005G\u0011aa\u00142kK\u000e$\b")
public class ALSSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static long genImplicitTestData$default$6() {
        return ALSSuite$.MODULE$.genImplicitTestData$default$6();
    }

    public static Map<String, Object> allEstimatorParamSettings() {
        return ALSSuite$.MODULE$.allEstimatorParamSettings();
    }

    public static Map<String, Object> allModelParamSettings() {
        return ALSSuite$.MODULE$.allModelParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.sc().setCheckpointDir(this.tempDir().getAbsolutePath());
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> genExplicitTestData(int numUsers, int numItems, int rank, double noiseStd, long seed) {
        double trainingFraction = 0.6;
        double testFraction = 0.3;
        double totalFraction = trainingFraction + testFraction;
        Random random = new Random(seed);
        Seq<Tuple2<Object, float[]>> userFactors = this.genFactors(numUsers, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        Seq<Tuple2<Object, float[]>> itemFactors = this.genFactors(numItems, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        ArrayBuffer training = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer test = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        userFactors.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, float[]> check$ifrefutable$1) {
                Tuple2<Object, float[]> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, rank, noiseStd, trainingFraction, totalFraction, random, itemFactors, training, test){
            public static final long serialVersionUID = 0L;
            public final int rank$1;
            public final double noiseStd$1;
            public final double trainingFraction$1;
            public final double totalFraction$1;
            public final Random random$2;
            private final Seq itemFactors$1;
            public final ArrayBuffer training$1;
            public final ArrayBuffer test$1;

            public final void apply(Tuple2<Object, float[]> x$8) {
                Tuple2<Object, float[]> tuple2 = x$8;
                if (tuple2 != null) {
                    int userId = tuple2._1$mcI$sp();
                    float[] userFactor = (float[])tuple2._2();
                    this.itemFactors$1.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, float[]> check$ifrefutable$2) {
                            Tuple2<Object, float[]> tuple2 = check$ifrefutable$2;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, userId, userFactor){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$genExplicitTestData$2 $outer;
                        private final int userId$1;
                        private final float[] userFactor$1;

                        public final Object apply(Tuple2<Object, float[]> x$7) {
                            Tuple2<Object, float[]> tuple2 = x$7;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                int itemId = tuple2._1$mcI$sp();
                                float[] itemFactor = (float[])tuple2._2();
                                double x = this.$outer.random$2.nextDouble();
                                if (x < this.$outer.totalFraction$1) {
                                    float rating = BLAS.getInstance().sdot(this.$outer.rank$1, this.userFactor$1, 1, itemFactor, 1);
                                    if (x < this.$outer.trainingFraction$1) {
                                        double noise = this.$outer.noiseStd$1 * this.$outer.random$2.nextGaussian();
                                        boxedUnit = this.$outer.training$1.$plus$eq((Object)new ALS.Rating$mcI$sp(this.userId$1, itemId, rating + (float)noise));
                                    } else {
                                        boxedUnit = this.$outer.test$1.$plus$eq((Object)new ALS.Rating$mcI$sp(this.userId$1, itemId, rating));
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return boxedUnit2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.userId$1 = userId$1;
                            this.userFactor$1 = userFactor$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.rank$1 = rank$1;
                this.noiseStd$1 = noiseStd$1;
                this.trainingFraction$1 = trainingFraction$1;
                this.totalFraction$1 = totalFraction$1;
                this.random$2 = random$2;
                this.itemFactors$1 = itemFactors$1;
                this.training$1 = training$1;
                this.test$1 = test$1;
            }
        });
        this.logInfo((Function0)new Serializable(this, training, test){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer training$1;
            private final ArrayBuffer test$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated an explicit feedback dataset with ", " ratings for training "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.training$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and ", " for test."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.test$1.size())}))).toString();
            }
            {
                this.training$1 = training$1;
                this.test$1 = test$1;
            }
        });
        return new Tuple2((Object)this.sc().parallelize((Seq)training, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)), (Object)this.sc().parallelize((Seq)test, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)));
    }

    public double genExplicitTestData$default$4() {
        return 0.0;
    }

    public long genExplicitTestData$default$5() {
        return 11L;
    }

    public Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> genImplicitTestData(int numUsers, int numItems, int rank, double noiseStd, long seed) {
        return ALSSuite$.MODULE$.genImplicitTestData(this.sc(), numUsers, numItems, rank, noiseStd, seed);
    }

    public double genImplicitTestData$default$4() {
        return 0.0;
    }

    public long genImplicitTestData$default$5() {
        return 11L;
    }

    private Seq<Tuple2<Object, float[]>> genFactors(int size, int rank, Random random, float a, float b) {
        return ALSSuite$.MODULE$.org$apache$spark$ml$recommendation$ALSSuite$$genFactors(size, rank, random, a, b);
    }

    private float genFactors$default$4() {
        return -1.0f;
    }

    private float genFactors$default$5() {
        return 1.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testALS(RDD<ALS.Rating<Object>> training, RDD<ALS.Rating<Object>> test, int rank, int maxIter, double regParam, boolean implicitPrefs, int numUserBlocks, int numItemBlocks, double targetRMSE) {
        double d;
        SparkSession spark = this.spark();
        ALS als = new ALS().setRank(rank).setRegParam(regParam).setImplicitPrefs(implicitPrefs).setNumUserBlocks(numUserBlocks).setNumItemBlocks(numItemBlocks).setSeed(0L);
        double alpha = als.getAlpha();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.ml")), $m.staticPackage("org.apache.spark.ml.recommendation")), $m.staticModule("org.apache.spark.ml.recommendation.ALS")), $m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_recommendation_ALSSuite$$typecreator1$1(ALSSuite $outer) {
            }
        }
        ALSModel model = als.fit(spark.implicits().rddToDatasetHolder(training, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSSuite$$typecreator1$1(this)))).toDF());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.ml")), $m.staticPackage("org.apache.spark.ml.recommendation")), $m.staticModule("org.apache.spark.ml.recommendation.ALS")), $m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_recommendation_ALSSuite$$typecreator2$1(ALSSuite $outer) {
            }
        }
        RDD predictions = model.transform(spark.implicits().rddToDatasetHolder(test, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSSuite$$typecreator2$1(this)))).toDF()).select("rating", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row x0$2) {
                Row row = x0$2;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object rating = ((SeqLike)some.get()).apply(0);
                    Object prediction = ((SeqLike)some.get()).apply(1);
                    if (rating instanceof Float) {
                        float f = BoxesRunTime.unboxToFloat((Object)rating);
                        if (prediction instanceof Float) {
                            float f2 = BoxesRunTime.unboxToFloat((Object)prediction);
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp((double)f, (double)f2);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        if (implicitPrefs) {
            Tuple2.mcDD.sp sp2;
            Tuple2 tuple2 = (Tuple2)predictions.map((Function1)new $anonfun$37(this, alpha), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2)new $anonfun$38(this));
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            double totalWeight = tuple2._1$mcD$sp();
            double weightedSumSq = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(totalWeight, weightedSumSq);
            double totalWeight2 = sp3._1$mcD$sp();
            double weightedSumSq2 = sp3._2$mcD$sp();
            d = scala.math.package$.MODULE$.sqrt(weightedSumSq2 / totalWeight2);
        } else {
            double mse = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(predictions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x0$5) {
                    Tuple2<Object, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        double rating = tuple2._1$mcD$sp();
                        double prediction = tuple2._2$mcD$sp();
                        double err = rating - prediction;
                        double d = err * err;
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.Double())).mean();
            d = scala.math.package$.MODULE$.sqrt(mse);
        }
        double rmse = d;
        this.logInfo((Function0)new Serializable(this, rmse){
            public static final long serialVersionUID = 0L;
            private final double rmse$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test RMSE is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.rmse$1)}));
            }
            {
                this.rmse$1 = rmse$1;
            }
        });
        double $org_scalatest_assert_macro_left = rmse;
        double $org_scalatest_assert_macro_right = targetRMSE;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
    }

    public boolean testALS$default$6() {
        return false;
    }

    public int testALS$default$7() {
        return 2;
    }

    public int testALS$default$8() {
        return 3;
    }

    public double testALS$default$9() {
        return 0.05;
    }

    public ALSSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("LocalIndexEncoder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random random = new Random();
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 5, 10, 20, 50, 100}))).foreach((Function1)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final Random random$1;

                    public final void apply(int numBlocks) {
                        this.apply$mcVI$sp(numBlocks);
                    }

                    public void apply$mcVI$sp(int numBlocks) {
                        ALS.LocalIndexEncoder encoder = new ALS.LocalIndexEncoder(numBlocks);
                        int maxLocalIndex = Integer.MAX_VALUE / numBlocks;
                        Seq tests = (Seq)((TraversableLike)Seq$.MODULE$.fill(5, (Function0)new Serializable(this, maxLocalIndex, numBlocks){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final int maxLocalIndex$1;
                            private final int numBlocks$1;

                            public final Tuple2<Object, Object> apply() {
                                return new Tuple2.mcII.sp(this.$outer.random$1.nextInt(this.numBlocks$1), this.$outer.random$1.nextInt(this.maxLocalIndex$1));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.maxLocalIndex$1 = maxLocalIndex$1;
                                this.numBlocks$1 = numBlocks$1;
                            }
                        })).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(0, 0), new Tuple2.mcII.sp(numBlocks - 1, maxLocalIndex)})), Seq$.MODULE$.canBuildFrom());
                        tests.foreach((Function1)new Serializable(this, encoder, numBlocks){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final ALS.LocalIndexEncoder encoder$1;
                            private final int numBlocks$1;

                            public final void apply(Tuple2<Object, Object> x0$1) {
                                Tuple2<Object, Object> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    int blockId = tuple2._1$mcI$sp();
                                    int localIndex = tuple2._2$mcI$sp();
                                    String err = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed with numBlocks=", ", blockId=", ", and localIndex=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numBlocks$1), BoxesRunTime.boxToInteger((int)blockId), BoxesRunTime.boxToInteger((int)localIndex)}));
                                    int encoded = this.encoder$1.encode(blockId, localIndex);
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.encoder$1.blockId(encoded)));
                                    int $org_scalatest_assert_macro_right = blockId;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)err);
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.encoder$1.localIndex(encoded)));
                                    int $org_scalatest_assert_macro_right2 = localIndex;
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)err);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.encoder$1 = encoder$1;
                                this.numBlocks$1 = numBlocks$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                    }
                });
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("normal equation construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = 2;
                ALS.NormalEquation qual$1 = new ALS.NormalEquation(k);
                float[] x$32 = new float[]{1.0f, 2.0f};
                double x$33 = 3.0;
                double x$34 = qual$1.add$default$3();
                ALS.NormalEquation ne0 = qual$1.add(x$32, x$33, x$34).add(new float[]{4.0f, 5.0f}, 6.0, 2.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ne0.k()));
                int $org_scalatest_assert_macro_right = k;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ne0.triK()));
                int $org_scalatest_assert_macro_right2 = k * (k + 1) / 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(ne0.ata())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(33.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{42.0, 54.0}))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(ne0.ata)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(33.0, 42.0, 54.0)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(ne0.atb())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(51.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{66.0}))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(ne0.atb)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(51.0, 66.0)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ALS.NormalEquation qual$2 = new ALS.NormalEquation(2);
                float[] x$35 = new float[]{7.0f, 8.0f};
                double x$36 = 9.0;
                double x$37 = qual$2.add$default$3();
                ALS.NormalEquation ne1 = qual$2.add(x$35, x$36, x$37);
                ne0.merge(ne1);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(ne0.ata())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(82.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{98.0, 118.0}))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(ne0.ata)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(82.0, 98.0, 118.0)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(ne0.atb())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(114.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{138.0}))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(ne0.atb)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(114.0, 138.0)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, ne0){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne0$1;

                    public final ALS.NormalEquation apply() {
                        return this.ne0$1.add(new float[]{1.0f}, 2.0, this.ne0$1.add$default$3());
                    }
                    {
                        this.ne0$1 = ne0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, ne0){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne0$1;

                    public final ALS.NormalEquation apply() {
                        return this.ne0$1.add(new float[]{1.0f, 2.0f, 3.0f}, 4.0, this.ne0$1.add$default$3());
                    }
                    {
                        this.ne0$1 = ne0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, ne0){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne0$1;

                    public final ALS.NormalEquation apply() {
                        return this.ne0$1.add(new float[]{1.0f, 2.0f}, 0.0, -1.0);
                    }
                    {
                        this.ne0$1 = ne0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, ne0){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne0$1;

                    public final ALS.NormalEquation apply() {
                        ALS.NormalEquation ne2 = new ALS.NormalEquation(3);
                        return this.ne0$1.merge(ne2);
                    }
                    {
                        this.ne0$1 = ne0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                ne0.reset();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(ne0.ata()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$1) {
                        return this.apply$mcZD$sp(x$1);
                    }

                    public boolean apply$mcZD$sp(double x$1) {
                        return x$1 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(ne0.ata).forall(((x$1: Double) => x$1.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(ne0.atb()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$2) {
                        return this.apply$mcZD$sp(x$2);
                    }

                    public boolean apply$mcZD$sp(double x$2) {
                        return x$2 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(ne0.atb).forall(((x$2: Double) => x$2.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CholeskySolver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = 2;
                ALS.NormalEquation qual$3 = new ALS.NormalEquation(k);
                float[] x$38 = new float[]{1.0f, 2.0f};
                double x$39 = 4.0;
                double x$40 = qual$3.add$default$3();
                ALS.NormalEquation qual$4 = qual$3.add(x$38, x$39, x$40);
                float[] x$41 = new float[]{1.0f, 3.0f};
                double x$42 = 9.0;
                double x$43 = qual$4.add$default$3();
                ALS.NormalEquation qual$5 = qual$4.add(x$41, x$42, x$43);
                float[] x$44 = new float[]{1.0f, 4.0f};
                double x$45 = 16.0;
                double x$46 = qual$5.add$default$3();
                ALS.NormalEquation ne0 = qual$5.add(x$44, x$45, x$46);
                ALS.NormalEquation ne1 = new ALS.NormalEquation(k).merge(ne0);
                ALS.CholeskySolver chol = new ALS.CholeskySolver();
                double[] x0 = (double[])Predef$.MODULE$.floatArrayOps(chol.solve(ne0, 0.0)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(float x$3) {
                        return this.apply$mcDF$sp(x$3);
                    }

                    public double apply$mcDF$sp(float x$3) {
                        return x$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(x0)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-8.333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.0}))).relTol(1.0E-6)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(x0)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(-8.333333, 6.0)).relTol(1.0E-6))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(ne0.ata()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$4) {
                        return this.apply$mcZD$sp(x$4);
                    }

                    public boolean apply$mcZD$sp(double x$4) {
                        return x$4 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(ne0.ata).forall(((x$4: Double) => x$4.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(ne0.atb()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$5) {
                        return this.apply$mcZD$sp(x$5);
                    }

                    public boolean apply$mcZD$sp(double x$5) {
                        return x$5 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(ne0.atb).forall(((x$5: Double) => x$5.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                double[] x1 = (double[])Predef$.MODULE$.floatArrayOps(chol.solve(ne1, 1.5)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(float x$6) {
                        return this.apply$mcDF$sp(x$6);
                    }

                    public double apply$mcDF$sp(float x$6) {
                        return x$6;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.1155556, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.28}))).relTol(1.0E-6)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(x1)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(-0.1155556, 3.28)).relTol(1.0E-6))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("RatingBlockBuilder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ALS.RatingBlockBuilder$mcI$sp emptyBuilder = new ALS.RatingBlockBuilder$mcI$sp(ClassTag$.MODULE$.Int());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyBuilder.size()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ALS.RatingBlock emptyBlock = emptyBuilder.build$mcI$sp();
                ArrayOps $org_scalatest_assert_macro_left2 = Predef$.MODULE$.intArrayOps(emptyBlock.srcIds$mcI$sp());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ArrayOps $org_scalatest_assert_macro_left3 = Predef$.MODULE$.intArrayOps(emptyBlock.dstIds$mcI$sp());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ArrayOps $org_scalatest_assert_macro_left4 = Predef$.MODULE$.floatArrayOps(emptyBlock.ratings());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ALS.RatingBlockBuilder builder0 = new ALS.RatingBlockBuilder$mcI$sp(ClassTag$.MODULE$.Int()).add$mcI$sp((ALS.Rating)new ALS.Rating$mcI$sp(0, 1, 2.0f)).add$mcI$sp((ALS.Rating)new ALS.Rating$mcI$sp(3, 4, 5.0f));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)builder0.size()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                ALS.RatingBlockBuilder builder1 = new ALS.RatingBlockBuilder$mcI$sp(ClassTag$.MODULE$.Int()).add$mcI$sp((ALS.Rating)new ALS.Rating$mcI$sp(6, 7, 8.0f)).merge$mcI$sp(builder0.build$mcI$sp());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)builder1.size()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                ALS.RatingBlock block = builder1.build$mcI$sp();
                Set ratings = ((TraversableOnce)Seq$.MODULE$.tabulate(block.size(), (Function1)new Serializable(this, block){
                    public static final long serialVersionUID = 0L;
                    private final ALS.RatingBlock block$1;

                    public final Tuple3<Object, Object, Object> apply(int i) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.block$1.srcIds$mcI$sp()[i]), (Object)BoxesRunTime.boxToInteger((int)this.block$1.dstIds$mcI$sp()[i]), (Object)BoxesRunTime.boxToFloat((float)this.block$1.ratings()[i]));
                    }
                    {
                        this.block$1 = block$1;
                    }
                })).toSet();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(ratings);
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToFloat((float)2.0f)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToFloat((float)5.0f)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToFloat((float)8.0f))}));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("UncompressedInBlock", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ALS.LocalIndexEncoder encoder = new ALS.LocalIndexEncoder(10);
                ALS.UncompressedInBlock uncompressed = new ALS.UncompressedInBlockBuilder$mcI$sp(encoder, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).add$mcI$sp(0, new int[]{1, 0, 2}, new int[]{0, 1, 4}, new float[]{1.0f, 2.0f, 3.0f}).add$mcI$sp(1, new int[]{3, 0}, new int[]{2, 5}, new float[]{4.0f, 5.0f}).build$mcI$sp();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)uncompressed.length()));
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Set records = ((TraversableOnce)Seq$.MODULE$.tabulate(uncompressed.length(), (Function1)new Serializable(this, encoder, uncompressed){
                    public static final long serialVersionUID = 0L;
                    private final ALS.LocalIndexEncoder encoder$2;
                    private final ALS.UncompressedInBlock uncompressed$1;

                    public final Tuple4<Object, Object, Object, Object> apply(int i) {
                        int dstEncodedIndex = this.uncompressed$1.dstEncodedIndices()[i];
                        int dstBlockId = this.encoder$2.blockId(dstEncodedIndex);
                        int dstLocalIndex = this.encoder$2.localIndex(dstEncodedIndex);
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)this.uncompressed$1.srcIds$mcI$sp()[i]), (Object)BoxesRunTime.boxToInteger((int)dstBlockId), (Object)BoxesRunTime.boxToInteger((int)dstLocalIndex), (Object)BoxesRunTime.boxToFloat((float)this.uncompressed$1.ratings()[i]));
                    }
                    {
                        this.encoder$2 = encoder$2;
                        this.uncompressed$1 = uncompressed$1;
                    }
                })).toSet();
                Set expected = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToFloat((float)1.0f)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToFloat((float)2.0f)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToFloat((float)3.0f)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToFloat((float)4.0f)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToFloat((float)5.0f))}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(records);
                Set $org_scalatest_assert_macro_right2 = expected;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ALS.InBlock compressed = uncompressed.compress$mcI$sp();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)compressed.size()));
                int $org_scalatest_assert_macro_right3 = 5;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(compressed.srcIds$mcI$sp()).toSeq());
                Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(compressed.dstPtrs()).toSeq());
                Seq $org_scalatest_assert_macro_right5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5}));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                ArrayBuffer decompressed = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                for (int i = 0; i < compressed.srcIds$mcI$sp().length; ++i) {
                    for (int j = compressed.dstPtrs()[i]; j < compressed.dstPtrs()[i + 1]; ++j) {
                        int dstEncodedIndex = compressed.dstEncodedIndices()[j];
                        int dstBlockId = encoder.blockId(dstEncodedIndex);
                        int dstLocalIndex = encoder.localIndex(dstEncodedIndex);
                        decompressed.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)compressed.srcIds$mcI$sp()[i]), (Object)BoxesRunTime.boxToInteger((int)dstBlockId), (Object)BoxesRunTime.boxToInteger((int)dstLocalIndex), (Object)BoxesRunTime.boxToFloat((float)compressed.ratings()[j])));
                    }
                }
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(decompressed.toSet());
                Set $org_scalatest_assert_macro_right6 = expected;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("exact rank-1 matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(20, 40, 1, this.$outer.genExplicitTestData$default$4(), this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$47 = training2;
                    RDD x$48 = test2;
                    int x$49 = 1;
                    int x$50 = 1;
                    double x$51 = 1.0E-5;
                    double x$52 = 0.001;
                    boolean x$53 = this.$outer.testALS$default$6();
                    int x$54 = this.$outer.testALS$default$7();
                    int x$55 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$47, (RDD<ALS.Rating<Object>>)x$48, x$50, x$49, x$51, x$53, x$54, x$55, x$52);
                    RDD x$56 = training2;
                    RDD x$57 = test2;
                    int x$58 = 1;
                    int x$59 = 2;
                    double x$60 = 1.0E-5;
                    double x$61 = 0.001;
                    boolean x$62 = this.$outer.testALS$default$6();
                    int x$63 = this.$outer.testALS$default$7();
                    int x$64 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$56, (RDD<ALS.Rating<Object>>)x$57, x$59, x$58, x$60, x$62, x$63, x$64, x$61);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("approximate rank-1 matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(20, 40, 1, 0.01, this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$65 = training2;
                    RDD x$66 = test2;
                    int x$67 = 2;
                    int x$68 = 1;
                    double x$69 = 0.01;
                    double x$70 = 0.02;
                    boolean x$71 = this.$outer.testALS$default$6();
                    int x$72 = this.$outer.testALS$default$7();
                    int x$73 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$65, (RDD<ALS.Rating<Object>>)x$66, x$68, x$67, x$69, x$71, x$72, x$73, x$70);
                    RDD x$74 = training2;
                    RDD x$75 = test2;
                    int x$76 = 2;
                    int x$77 = 2;
                    double x$78 = 0.01;
                    double x$79 = 0.02;
                    boolean x$80 = this.$outer.testALS$default$6();
                    int x$81 = this.$outer.testALS$default$7();
                    int x$82 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$74, (RDD<ALS.Rating<Object>>)x$75, x$77, x$76, x$78, x$80, x$81, x$82, x$79);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("approximate rank-2 matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(20, 40, 2, 0.01, this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$83 = training2;
                    RDD x$84 = test2;
                    int x$85 = 4;
                    int x$86 = 2;
                    double x$87 = 0.01;
                    double x$88 = 0.03;
                    boolean x$89 = this.$outer.testALS$default$6();
                    int x$90 = this.$outer.testALS$default$7();
                    int x$91 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$83, (RDD<ALS.Rating<Object>>)x$84, x$86, x$85, x$87, x$89, x$90, x$91, x$88);
                    RDD x$92 = training2;
                    RDD x$93 = test2;
                    int x$94 = 4;
                    int x$95 = 3;
                    double x$96 = 0.01;
                    double x$97 = 0.03;
                    boolean x$98 = this.$outer.testALS$default$6();
                    int x$99 = this.$outer.testALS$default$7();
                    int x$100 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$92, (RDD<ALS.Rating<Object>>)x$93, x$95, x$94, x$96, x$98, x$99, x$100, x$97);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("different block settings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(20, 40, 2, 0.01, this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2)}))).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, Object> check$ifrefutable$3) {
                            Tuple2<Object, Object> tuple2 = check$ifrefutable$3;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, training2, test2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$15 $outer;
                        private final RDD training$2;
                        private final RDD test$2;

                        public final void apply(Tuple2<Object, Object> x$14) {
                            Tuple2<Object, Object> tuple2 = x$14;
                            if (tuple2 != null) {
                                int numUserBlocks = tuple2._1$mcI$sp();
                                int numItemBlocks = tuple2._2$mcI$sp();
                                RDD x$101 = this.training$2;
                                RDD x$102 = this.test$2;
                                int x$103 = 4;
                                int x$104 = 3;
                                double x$105 = 0.01;
                                double x$106 = 0.03;
                                int x$107 = numUserBlocks;
                                int x$108 = numItemBlocks;
                                boolean x$109 = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().testALS$default$6();
                                this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().testALS((RDD<ALS.Rating<Object>>)x$101, (RDD<ALS.Rating<Object>>)x$102, x$104, x$103, x$105, x$109, x$107, x$108, x$106);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.training$2 = training$2;
                            this.test$2 = test$2;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("more blocks than ratings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(4, 4, 1, this.$outer.genExplicitTestData$default$4(), this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$110 = training2;
                    RDD x$111 = test2;
                    int x$112 = 2;
                    int x$113 = 1;
                    double x$114 = 1.0E-4;
                    double x$115 = 0.002;
                    int x$116 = 5;
                    int x$117 = 5;
                    boolean x$118 = this.$outer.testALS$default$6();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$110, (RDD<ALS.Rating<Object>>)x$111, x$113, x$112, x$114, x$118, x$117, x$116, x$115);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("implicit feedback", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genImplicitTestData(20, 40, 2, 0.01, this.$outer.genImplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$119 = training2;
                    RDD x$120 = test2;
                    int x$121 = 4;
                    int x$122 = 2;
                    double x$123 = 0.01;
                    boolean x$124 = true;
                    double x$125 = 0.3;
                    int x$126 = this.$outer.testALS$default$7();
                    int x$127 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$119, (RDD<ALS.Rating<Object>>)x$120, x$122, x$121, x$123, x$124, x$126, x$127, x$125);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("using generic ID types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genImplicitTestData(20, 40, 2, 0.01, this.$outer.genImplicitTestData$default$5());
                if (tuple2 != null) {
                    int x$140;
                    StorageLevel x$139;
                    StorageLevel x$138;
                    boolean x$137;
                    double x$136;
                    boolean x$135;
                    double x$134;
                    int x$133;
                    RDD longRatings;
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2 = rDD = (ratings = (RDD)tuple2._1());
                    RDD x$128 = longRatings = ratings2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ALS.Rating<Object> apply(ALS.Rating<Object> r) {
                            return new ALS.Rating$mcJ$sp((long)r.user$mcI$sp(), (long)r.item$mcI$sp(), r.rating());
                        }
                    }, ClassTag$.MODULE$.apply(ALS.Rating.class));
                    int x$129 = 2;
                    int x$130 = 4;
                    long x$131 = 0L;
                    int x$132 = ALS$.MODULE$.train$default$3();
                    Tuple2 tuple22 = ALS$.MODULE$.train(x$128, x$129, x$132, x$133 = ALS$.MODULE$.train$default$4(), x$130, x$134 = ALS$.MODULE$.train$default$6(), x$135 = ALS$.MODULE$.train$default$7(), x$136 = ALS$.MODULE$.train$default$8(), x$137 = ALS$.MODULE$.train$default$9(), x$138 = ALS$.MODULE$.train$default$10(), x$139 = ALS$.MODULE$.train$default$11(), x$140 = ALS$.MODULE$.train$default$12(), x$131, ClassTag$.MODULE$.Long(), (Ordering)Ordering.Long$.MODULE$);
                    if (tuple22 != null) {
                        RDD strRatings;
                        RDD longUserFactors;
                        RDD rDD2;
                        RDD longUserFactors2 = rDD2 = (longUserFactors = (RDD)tuple22._1());
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ScalaRunTime$.MODULE$.anyValClass((Object)BoxesRunTime.boxToLong((long)((Tuple2)longUserFactors2.first())._1$mcJ$sp()), ClassTag$.MODULE$.Long()));
                        Class<Long> $org_scalatest_assert_macro_right = Long.TYPE;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        RDD x$141 = strRatings = ratings2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ALS.Rating<String> apply(ALS.Rating<Object> r) {
                                return new ALS.Rating((Object)((Object)BoxesRunTime.boxToInteger((int)r.user$mcI$sp())).toString(), (Object)((Object)BoxesRunTime.boxToInteger((int)r.item$mcI$sp())).toString(), r.rating());
                            }
                        }, ClassTag$.MODULE$.apply(ALS.Rating.class));
                        int x$142 = 2;
                        int x$143 = 4;
                        long x$144 = 0L;
                        int x$145 = ALS$.MODULE$.train$default$3();
                        int x$146 = ALS$.MODULE$.train$default$4();
                        double x$147 = ALS$.MODULE$.train$default$6();
                        boolean x$148 = ALS$.MODULE$.train$default$7();
                        double x$149 = ALS$.MODULE$.train$default$8();
                        boolean x$150 = ALS$.MODULE$.train$default$9();
                        StorageLevel x$151 = ALS$.MODULE$.train$default$10();
                        StorageLevel x$152 = ALS$.MODULE$.train$default$11();
                        int x$153 = ALS$.MODULE$.train$default$12();
                        Tuple2 tuple23 = ALS$.MODULE$.train(x$141, x$142, x$145, x$146, x$143, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$144, ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.String$.MODULE$);
                        if (tuple23 != null) {
                            RDD strUserFactors;
                            RDD rDD3;
                            RDD strUserFactors2 = rDD3 = (strUserFactors = (RDD)tuple23._1());
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((Tuple2)strUserFactors2.first())._1().getClass());
                            Class<String> $org_scalatest_assert_macro_right2 = String.class;
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            return;
                        }
                        throw new MatchError((Object)tuple23);
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("nonnegative constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genImplicitTestData(20, 40, 2, 0.01, this.$outer.genImplicitTestData$default$5());
                if (tuple2 != null) {
                    int x$166;
                    StorageLevel x$165;
                    StorageLevel x$164;
                    double x$163;
                    boolean x$162;
                    double x$161;
                    int x$160;
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2;
                    RDD x$154 = ratings2 = (rDD = (ratings = (RDD)tuple2._1()));
                    int x$155 = 2;
                    int x$156 = 4;
                    boolean x$157 = true;
                    long x$158 = 0L;
                    int x$159 = ALS$.MODULE$.train$default$3();
                    Tuple2 tuple22 = ALS$.MODULE$.train(x$154, x$155, x$159, x$160 = ALS$.MODULE$.train$default$4(), x$156, x$161 = ALS$.MODULE$.train$default$6(), x$162 = ALS$.MODULE$.train$default$7(), x$163 = ALS$.MODULE$.train$default$8(), x$157, x$164 = ALS$.MODULE$.train$default$10(), x$165 = ALS$.MODULE$.train$default$11(), x$166 = ALS$.MODULE$.train$default$12(), x$158, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        RDD userFactors = (RDD)tuple22._1();
                        RDD itemFactors = (RDD)tuple22._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)userFactors, (Object)itemFactors);
                        RDD userFactors2 = (RDD)tuple24._1();
                        RDD itemFactors2 = (RDD)tuple24._2();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isNonnegative$1(userFactors2), "isNonnegative(userFactors)");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.isNonnegative$1(itemFactors2), "isNonnegative(itemFactors)");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }

            private final boolean isNonnegative$1(RDD factors) {
                return BoxesRunTime.unboxToBoolean((Object)RDD$.MODULE$.rddToPairRDDFunctions(factors, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(float[] x$18) {
                        return Predef$.MODULE$.floatArrayOps(x$18).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(float x$19) {
                                return this.apply$mcZF$sp(x$19);
                            }

                            public boolean apply$mcZF$sp(float x$19) {
                                return (double)x$19 >= 0.0;
                            }
                        });
                    }
                }, ClassTag$.MODULE$.Boolean()).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(boolean x$20, boolean x$21) {
                        return x$20 && x$21;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("als partitioner is a projection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 10, 100, 1000}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final void apply(int p) {
                        this.apply$mcVI$sp(p);
                    }

                    public void apply$mcVI$sp(int p) {
                        HashPartitioner part = new HashPartitioner(p);
                        for (int k = 0; k < p; ++k) {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)k));
                            int $org_scalatest_assert_macro_right = part.getPartition((Object)BoxesRunTime.boxToInteger((int)k));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)k));
                            int $org_scalatest_assert_macro_right2 = part.getPartition((Object)BoxesRunTime.boxToLong((long)k));
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("partitioner in returned factors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genImplicitTestData(20, 40, 2, 0.01, this.$outer.genImplicitTestData$default$5());
                if (tuple2 != null) {
                    int x$179;
                    StorageLevel x$178;
                    StorageLevel x$177;
                    boolean x$176;
                    double x$175;
                    boolean x$174;
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2;
                    RDD x$167 = ratings2 = (rDD = (ratings = (RDD)tuple2._1()));
                    int x$168 = 2;
                    int x$169 = 4;
                    int x$170 = 3;
                    int x$171 = 4;
                    long x$172 = 0L;
                    double x$173 = ALS$.MODULE$.train$default$6();
                    Tuple2 tuple22 = ALS$.MODULE$.train(x$167, x$168, x$170, x$171, x$169, x$173, x$174 = ALS$.MODULE$.train$default$7(), x$175 = ALS$.MODULE$.train$default$8(), x$176 = ALS$.MODULE$.train$default$9(), x$177 = ALS$.MODULE$.train$default$10(), x$178 = ALS$.MODULE$.train$default$11(), x$179 = ALS$.MODULE$.train$default$12(), x$172, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        RDD userFactors = (RDD)tuple22._1();
                        RDD itemFactors = (RDD)tuple22._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)userFactors, (Object)itemFactors);
                        RDD userFactors2 = (RDD)tuple24._1();
                        RDD itemFactors2 = (RDD)tuple24._2();
                        ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"User", (Object)userFactors2), new Tuple2((Object)"Item", (Object)itemFactors2)}))).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, RDD<Tuple2<Object, float[]>>> check$ifrefutable$4) {
                                Tuple2<String, RDD<Tuple2<Object, float[]>>> tuple2 = check$ifrefutable$4;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this, userFactors2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$21 $outer;
                            private final RDD userFactors$1;

                            public final long apply(Tuple2<String, RDD<Tuple2<Object, float[]>>> x$23) {
                                Tuple2<String, RDD<Tuple2<Object, float[]>>> tuple2 = x$23;
                                if (tuple2 != null) {
                                    String tpe = (String)tuple2._1();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.userFactors$1.partitioner().isDefined(), "userFactors.partitioner.isDefined");
                                    this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factors should have partitioner."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tpe})));
                                    Partitioner part = (Partitioner)this.userFactors$1.partitioner().get();
                                    long l = this.userFactors$1.mapPartitionsWithIndex((Function2)new Serializable(this, tpe, part){
                                        public static final long serialVersionUID = 0L;
                                        public final String tpe$1;
                                        public final Partitioner part$1;

                                        public final Iterator<Nothing$> apply(int idx2, Iterator<Tuple2<Object, float[]>> items) {
                                            items.foreach((Function1)new Serializable(this, idx2){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ $anonfun$21$$anonfun$apply$mcV$sp$12$$anonfun$apply$5 $outer;
                                                private final int idx$1;

                                                public final void apply(Tuple2<Object, float[]> x0$6) {
                                                    Tuple2<Object, float[]> tuple2 = x0$6;
                                                    if (tuple2 != null) {
                                                        int id = tuple2._1$mcI$sp();
                                                        if (this.$outer.part$1.getPartition((Object)BoxesRunTime.boxToInteger((int)id)) != this.idx$1) {
                                                            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ID ", " should not be in partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tpe$1, BoxesRunTime.boxToInteger((int)id), BoxesRunTime.boxToInteger((int)this.idx$1)})));
                                                        }
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        return;
                                                    }
                                                    throw new MatchError(tuple2);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.idx$1 = idx$1;
                                                }
                                            });
                                            return scala.package$.MODULE$.Iterator().empty();
                                        }
                                        {
                                            this.tpe$1 = tpe$1;
                                            this.part$1 = part$1;
                                        }
                                    }, this.userFactors$1.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Nothing()).count();
                                    return l;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.userFactors$1 = userFactors$1;
                            }
                        });
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("als with large number of iterations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(4, 4, 1, this.$outer.genExplicitTestData$default$4(), this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2;
                    RDD x$180 = ratings2 = (rDD = (ratings = (RDD)tuple2._1()));
                    int x$181 = 1;
                    int x$182 = 50;
                    int x$183 = 2;
                    int x$184 = 2;
                    long x$185 = 0L;
                    double x$186 = ALS$.MODULE$.train$default$6();
                    boolean x$187 = ALS$.MODULE$.train$default$7();
                    double x$188 = ALS$.MODULE$.train$default$8();
                    boolean x$189 = ALS$.MODULE$.train$default$9();
                    StorageLevel x$190 = ALS$.MODULE$.train$default$10();
                    StorageLevel x$191 = ALS$.MODULE$.train$default$11();
                    int x$192 = ALS$.MODULE$.train$default$12();
                    ALS$.MODULE$.train(x$180, x$181, x$183, x$184, x$182, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$185, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                    RDD x$193 = ratings2;
                    int x$194 = 1;
                    int x$195 = 50;
                    int x$196 = 2;
                    int x$197 = 2;
                    boolean x$198 = true;
                    long x$199 = 0L;
                    double x$200 = ALS$.MODULE$.train$default$6();
                    double x$201 = ALS$.MODULE$.train$default$8();
                    boolean x$202 = ALS$.MODULE$.train$default$9();
                    StorageLevel x$203 = ALS$.MODULE$.train$default$10();
                    StorageLevel x$204 = ALS$.MODULE$.train$default$11();
                    int x$205 = ALS$.MODULE$.train$default$12();
                    ALS$.MODULE$.train(x$193, x$194, x$196, x$197, x$195, x$200, x$198, x$201, x$202, x$203, x$204, x$205, x$199, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(4, 4, 1, this.$outer.genExplicitTestData$default$4(), this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2 = rDD = (ratings = (RDD)tuple2._1());
                    ALS als = new ALS();
                    ALSSuite$.MODULE$.allEstimatorParamSettings().foreach((Function1)new Serializable(this, als){
                        public static final long serialVersionUID = 0L;
                        private final ALS als$1;

                        public final ALS apply(Tuple2<String, Object> x0$7) {
                            Tuple2<String, Object> tuple2 = x0$7;
                            if (tuple2 != null) {
                                String p = (String)tuple2._1();
                                Object v = tuple2._2();
                                ALS aLS = (ALS)this.als$1.set(this.als$1.getParam(p), v);
                                return aLS;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.als$1 = als$1;
                        }
                    });
                    SparkSession spark = this.$outer.spark();
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSSuite.class.getClassLoader());
                    ALSModel model = als.fit(spark.implicits().rddToDatasetHolder(ratings2, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.ml")), $m.staticPackage("org.apache.spark.ml.recommendation")), $m.staticModule("org.apache.spark.ml.recommendation.ALS")), $m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                        }
                    }))).toDF());
                    ALS als2 = this.$outer.testDefaultReadWrite(als, this.$outer.testDefaultReadWrite$default$2());
                    ALSSuite$.MODULE$.allEstimatorParamSettings().foreach((Function1)new Serializable(this, als, als2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$23 $outer;
                        private final ALS als$1;
                        private final ALS als2$1;

                        public final void apply(Tuple2<String, Object> x0$8) {
                            Tuple2<String, Object> tuple2 = x0$8;
                            if (tuple2 != null) {
                                String p = (String)tuple2._1();
                                Param param = this.als$1.getParam(p);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(this.als$1.get(param).get());
                                Object $org_scalatest_assert_macro_right = this.als2$1.get(param).get();
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.als$1 = als$1;
                            this.als2$1 = als2$1;
                        }
                    });
                    ALSModel model2 = this.$outer.testDefaultReadWrite(model, this.$outer.testDefaultReadWrite$default$2());
                    ALSSuite$.MODULE$.allModelParamSettings().foreach((Function1)new Serializable(this, model, model2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$23 $outer;
                        private final ALSModel model$1;
                        private final ALSModel model2$1;

                        public final void apply(Tuple2<String, Object> x0$9) {
                            Tuple2<String, Object> tuple2 = x0$9;
                            if (tuple2 != null) {
                                String p = (String)tuple2._1();
                                Param param = this.model$1.getParam(p);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(this.model$1.get(param).get());
                                Object $org_scalatest_assert_macro_right = this.model2$1.get(param).get();
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.model$1 = model$1;
                            this.model2$1 = model2$1;
                        }
                    });
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.rank()));
                    int $org_scalatest_assert_macro_right = model2.rank();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.getFactors$1(model.userFactors()));
                    Set $org_scalatest_assert_macro_right2 = this.getFactors$1(model2.userFactors());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.getFactors$1(model.itemFactors()));
                    Set $org_scalatest_assert_macro_right3 = this.getFactors$1(model2.itemFactors());
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final Set getFactors$1(Dataset df) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"})).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, float[]> apply(Row x0$10) {
                        Row row = x0$10;
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)row.getInt(0)), row.getAs(1));
                        return tuple2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("input type validation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkSession spark = this.$outer.spark();
                ALS als = new ALS().setMaxIter(1).setRank(1);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"user", (Object)IntegerType$.MODULE$), new Tuple2((Object)"item", (Object)IntegerType$.MODULE$), new Tuple2((Object)"rating", (Object)FloatType$.MODULE$)}))).foreach((Function1)new Serializable(this, spark, als){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;
                    private final SparkSession spark$1;
                    private final ALS als$2;

                    public final void apply(Tuple2<String, NumericType> x0$11) {
                        Tuple2<String, NumericType> tuple2 = x0$11;
                        if (tuple2 != null) {
                            String colName = (String)tuple2._1();
                            NumericType sqlType = (NumericType)tuple2._2();
                            MLTestingUtils$.MODULE$.checkNumericTypesALS(this.als$2, this.spark$1, colName, sqlType, (Function2<ALSModel, ALSModel, BoxedUnit>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$16 $outer;

                                public final void apply(ALSModel ex, ALSModel act) {
                                    this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(((Row)ex.userFactors().first()).getSeq(1)).$eq$eq$eq((Object)((Row)act.userFactors().first()).getSeq(1), Equality$.MODULE$.default());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, (Function3<ALSModel, ALSModel, Dataset<Row>, BoxedUnit>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(ALSModel ex, ALSModel act, Dataset<Row> x$24) {
                                    new Serializable(this, ex, act){
                                        public static final long serialVersionUID = 0L;
                                        private final ALSModel ex$1;
                                        private final ALSModel act$1;

                                        public final boolean apply(Dataset<Row> x$25, Dataset<Row> x$26) {
                                            return TestingUtils$.MODULE$.DoubleWithAlmostEquals((double)((Row)this.ex$1.transform(x$25).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getFloat(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals((double)((Row)this.act$1.transform(x$26).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getFloat(0)).absTol(1.0E-6));
                                        }
                                        {
                                            this.ex$1 = ex$1;
                                            this.act$1 = act$1;
                                        }
                                    };
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anonfun$24 org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.spark$1 = spark$1;
                        this.als$2 = als$2;
                    }
                });
                long big = (long)Integer.MAX_VALUE + 1L;
                double small = (double)Integer.MIN_VALUE - 1.0;
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSSuite.class.getClassLoader());
                Dataset df = spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple7((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)big), (Object)BoxesRunTime.boxToDouble((double)small), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)big), (Object)BoxesRunTime.boxToDouble((double)small), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple7((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)5.0))})), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple7"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Long")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Long")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                }))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user", "user_big", "user_small", "item", "item_big", "item_small", "rating"}));
                this.$outer.withClue("fit should fail when ids exceed integer range. ", (Function0)new Serializable(this, als, df){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;
                    public final ALS als$2;
                    public final Dataset df$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        String $org_scalatest_assert_macro_left = ((Throwable)this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$3 $outer;

                            public final ALSModel apply() {
                                return this.$outer.als$2.fit(this.$outer.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.df$1.apply("user_big").as("user"), this.$outer.df$1.apply("item"), this.$outer.df$1.apply("rating")})));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class))).getCause().getMessage();
                        String $org_scalatest_assert_macro_right = "was out of Integer range";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        String $org_scalatest_assert_macro_left2 = ((Throwable)this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$3 $outer;

                            public final ALSModel apply() {
                                return this.$outer.als$2.fit(this.$outer.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.df$1.apply("user_small").as("user"), this.$outer.df$1.apply("item"), this.$outer.df$1.apply("rating")})));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class))).getCause().getMessage();
                        String $org_scalatest_assert_macro_right2 = "was out of Integer range";
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                        this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        String $org_scalatest_assert_macro_left3 = ((Throwable)this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$3 $outer;

                            public final ALSModel apply() {
                                return this.$outer.als$2.fit(this.$outer.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.df$1.apply("item_big").as("item"), this.$outer.df$1.apply("user"), this.$outer.df$1.apply("rating")})));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class))).getCause().getMessage();
                        String $org_scalatest_assert_macro_right3 = "was out of Integer range";
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3));
                        this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        String $org_scalatest_assert_macro_left4 = ((Throwable)this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$3 $outer;

                            public final ALSModel apply() {
                                return this.$outer.als$2.fit(this.$outer.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.df$1.apply("item_small").as("item"), this.$outer.df$1.apply("user"), this.$outer.df$1.apply("rating")})));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class))).getCause().getMessage();
                        String $org_scalatest_assert_macro_right4 = "was out of Integer range";
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4));
                        this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.als$2 = als$2;
                        this.df$1 = df$1;
                    }
                });
                this.$outer.withClue("transform should fail when ids exceed integer range. ", (Function0)new Serializable(this, als, df){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;
                    private final ALS als$2;
                    public final Dataset df$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ALSModel model = this.als$2.fit(this.df$1);
                        String $org_scalatest_assert_macro_left = ((Throwable)this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, model){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$4 $outer;
                            private final ALSModel model$2;

                            public final Row apply() {
                                return (Row)this.model$2.transform(this.$outer.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.df$1.apply("user_big").as("user"), this.$outer.df$1.apply("item")}))).first();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model$2 = model$2;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class))).getMessage();
                        String $org_scalatest_assert_macro_right = "was out of Integer range";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        String $org_scalatest_assert_macro_left2 = ((Throwable)this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, model){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$4 $outer;
                            private final ALSModel model$2;

                            public final Row apply() {
                                return (Row)this.model$2.transform(this.$outer.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.df$1.apply("user_small").as("user"), this.$outer.df$1.apply("item")}))).first();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model$2 = model$2;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class))).getMessage();
                        String $org_scalatest_assert_macro_right2 = "was out of Integer range";
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                        this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        String $org_scalatest_assert_macro_left3 = ((Throwable)this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, model){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$4 $outer;
                            private final ALSModel model$2;

                            public final Row apply() {
                                return (Row)this.model$2.transform(this.$outer.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.df$1.apply("item_big").as("item"), this.$outer.df$1.apply("user")}))).first();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model$2 = model$2;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class))).getMessage();
                        String $org_scalatest_assert_macro_right3 = "was out of Integer range";
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3));
                        this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        String $org_scalatest_assert_macro_left4 = ((Throwable)this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, model){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$24$$anonfun$apply$mcV$sp$4 $outer;
                            private final ALSModel model$2;

                            public final Row apply() {
                                return (Row)this.model$2.transform(this.$outer.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.df$1.apply("item_small").as("item"), this.$outer.df$1.apply("user")}))).first();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model$2 = model$2;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class))).getMessage();
                        String $org_scalatest_assert_macro_right4 = "was out of Integer range";
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4));
                        this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.als$2 = als$2;
                        this.df$1 = df$1;
                    }
                });
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

