/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.regression.AFTPoint;
import org.apache.spark.ml.regression.AFTSurvivalRegression;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.ml.regression.AFTSurvivalRegressionSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.random.ExponentialGenerator;
import org.apache.spark.mllib.random.WeibullGenerator;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u00015\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|gnU;ji\u0016T!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%i\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003vi&d'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005miR\"\u0001\u000f\u000b\u0005U!\u0011B\u0001\u0010\u001d\u0005Q!UMZ1vYR\u0014V-\u00193Xe&$X\rV3ti\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\nK\u0001\u0001\r\u00111A\u0005\u0002\u0019\n\u0011\u0003Z1uCN,G/\u00168jm\u0006\u0014\u0018.\u0019;f+\u00059\u0003C\u0001\u00159\u001d\tISG\u0004\u0002+g9\u00111F\r\b\u0003YEr!!\f\u0019\u000e\u00039R!a\f\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u00025\r\u0005\u00191/\u001d7\n\u0005Y:\u0014a\u00029bG.\fw-\u001a\u0006\u0003i\u0019I!!\u000f\u001e\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001\u001c8\u0011%a\u0004\u00011AA\u0002\u0013\u0005Q(A\u000beCR\f7/\u001a;V]&4\u0018M]5bi\u0016|F%Z9\u0015\u0005y\"\u0005CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%\u0001B+oSRDq!R\u001e\u0002\u0002\u0003\u0007q%A\u0002yIEBaa\u0012\u0001!B\u00139\u0013A\u00053bi\u0006\u001cX\r^+oSZ\f'/[1uK\u0002B#AR%\u0011\u0005}R\u0015BA&A\u0005%!(/\u00198tS\u0016tG\u000fC\u0005N\u0001\u0001\u0007\t\u0019!C\u0001M\u0005\u0019B-\u0019;bg\u0016$X*\u001e7uSZ\f'/[1uK\"Iq\n\u0001a\u0001\u0002\u0004%\t\u0001U\u0001\u0018I\u0006$\u0018m]3u\u001bVdG/\u001b<be&\fG/Z0%KF$\"AP)\t\u000f\u0015s\u0015\u0011!a\u0001O!11\u000b\u0001Q!\n\u001d\nA\u0003Z1uCN,G/T;mi&4\u0018M]5bi\u0016\u0004\u0003F\u0001*J\u0011%1\u0006\u00011AA\u0002\u0013\u0005a%A\feCR\f7/\u001a;V]&4\u0018M]5bi\u0016\u001c6-\u00197fI\"I\u0001\f\u0001a\u0001\u0002\u0004%\t!W\u0001\u001cI\u0006$\u0018m]3u+:Lg/\u0019:jCR,7kY1mK\u0012|F%Z9\u0015\u0005yR\u0006bB#X\u0003\u0003\u0005\ra\n\u0005\u00079\u0002\u0001\u000b\u0015B\u0014\u00021\u0011\fG/Y:fiVs\u0017N^1sS\u0006$XmU2bY\u0016$\u0007\u0005\u000b\u0002\\\u0013\")q\f\u0001C!A\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002}!)!\r\u0001C\u0001G\u0006\u0001r-\u001a8fe\u0006$X-\u0011$U\u0013:\u0004X\u000f\u001e\u000b\u000eI>$HP`A\u0001\u0003\u000b\tI!!\u0004\u0011\u0007\u0015LGN\u0004\u0002gQ:\u0011QfZ\u0005\u0002\u0003&\u0011a\u0007Q\u0005\u0003U.\u00141aU3r\u0015\t1\u0004\t\u0005\u0002$[&\u0011aN\u0001\u0002\t\u0003\u001a#\u0006k\\5oi\")\u0001/\u0019a\u0001c\u0006Ya.^7GK\u0006$XO]3t!\ty$/\u0003\u0002t\u0001\n\u0019\u0011J\u001c;\t\u000bU\f\u0007\u0019\u0001<\u0002\u000balU-\u00198\u0011\u0007}:\u00180\u0003\u0002y\u0001\n)\u0011I\u001d:bsB\u0011qH_\u0005\u0003w\u0002\u0013a\u0001R8vE2,\u0007\"B?b\u0001\u00041\u0018!\u0003=WCJL\u0017M\\2f\u0011\u0015y\u0018\r1\u0001r\u0003\u001dq\u0007k\\5oiNDa!a\u0001b\u0001\u0004\t\u0018\u0001B:fK\u0012Da!a\u0002b\u0001\u0004I\u0018\u0001D<fS\n,H\u000e\\*iCB,\u0007BBA\u0006C\u0002\u0007\u00110\u0001\u0007xK&\u0014W\u000f\u001c7TG\u0006dW\r\u0003\u0004\u0002\u0010\u0005\u0004\r!_\u0001\u0010Kb\u0004xN\\3oi&\fG.T3b]\u001e9\u00111\u0003\u0002\t\u0002\u0005U\u0011AG!G)N+(O^5wC2\u0014Vm\u001a:fgNLwN\\*vSR,\u0007cA\u0012\u0002\u0018\u00191\u0011A\u0001E\u0001\u00033\u0019b!a\u0006\u0002\u001c\u0005\u0005\u0002cA \u0002\u001e%\u0019\u0011q\u0004!\u0003\r\u0005s\u0017PU3g!\ry\u00141E\u0005\u0004\u0003K\u0001%\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002\u0011\u0002\u0018\u0011\u0005\u0011\u0011\u0006\u000b\u0003\u0003+A!\"!\f\u0002\u0018\t\u0007I\u0011AA\u0018\u0003A\tG\u000e\u001c)be\u0006l7+\u001a;uS:<7/\u0006\u0002\u00022AA\u00111GA\u001d\u0003\u007f\t)ED\u0002@\u0003kI1!a\u000eA\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\ri\u0015\r\u001d\u0006\u0004\u0003o\u0001\u0005\u0003BA\u001a\u0003\u0003JA!a\u0011\u0002>\t11\u000b\u001e:j]\u001e\u00042aPA$\u0013\r\tI\u0005\u0011\u0002\u0004\u0003:L\b\"CA'\u0003/\u0001\u000b\u0011BA\u0019\u0003E\tG\u000e\u001c)be\u0006l7+\u001a;uS:<7\u000f\t\u0005\u000b\u0003#\n9\"!A\u0005\n\u0005M\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u0016\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u0005!A.\u00198h\u0015\t\ty&\u0001\u0003kCZ\f\u0017\u0002BA2\u00033\u0012aa\u00142kK\u000e$\b")
public class AFTSurvivalRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<Row> datasetUnivariate;
    private transient Dataset<Row> datasetMultivariate;
    private transient Dataset<Row> datasetUnivariateScaled;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Map<String, Object> allParamSettings() {
        return AFTSurvivalRegressionSuite$.MODULE$.allParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Dataset<Row> datasetUnivariate() {
        return this.datasetUnivariate;
    }

    public void datasetUnivariate_$eq(Dataset<Row> x$1) {
        this.datasetUnivariate = x$1;
    }

    public Dataset<Row> datasetMultivariate() {
        return this.datasetMultivariate;
    }

    public void datasetMultivariate_$eq(Dataset<Row> x$1) {
        this.datasetMultivariate = x$1;
    }

    public Dataset<Row> datasetUnivariateScaled() {
        return this.datasetUnivariateScaled;
    }

    public void datasetUnivariateScaled_$eq(Dataset<Row> x$1) {
        this.datasetUnivariateScaled = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        Seq<AFTPoint> x$1 = this.generateAFTInput(1, new double[]{5.5}, new double[]{0.8}, 1000, 42, 1.0, 2.0, 2.0);
        int x$2 = qual$1.parallelize$default$2();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator1$1(AFTSurvivalRegressionSuite $outer) {
            }
        }
        this.datasetUnivariate_$eq((Dataset<Row>)this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(AFTPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator1$1(this))));
        SparkContext qual$2 = this.sc();
        Seq<AFTPoint> x$3 = this.generateAFTInput(2, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 1000, 42, 1.5, 2.5, 2.0);
        int x$4 = qual$2.parallelize$default$2();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator2$1(AFTSurvivalRegressionSuite $outer) {
            }
        }
        this.datasetMultivariate_$eq((Dataset<Row>)this.spark().createDataFrame(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(AFTPoint.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator2$1(this))));
        SparkContext qual$3 = this.sc();
        Seq<AFTPoint> x$5 = this.generateAFTInput(1, new double[]{5.5}, new double[]{0.8}, 1000, 42, 1.0, 2.0, 2.0);
        int x$6 = qual$3.parallelize$default$2();
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator3$1(AFTSurvivalRegressionSuite $outer) {
            }
        }
        this.datasetUnivariateScaled_$eq((Dataset<Row>)this.spark().createDataFrame(qual$3.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(AFTPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AFTPoint apply(AFTPoint x) {
                return new AFTPoint(Vectors$.MODULE$.dense(x.features().apply(0) * 1000.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), x.label(), x.censor());
            }
        }, ClassTag$.MODULE$.apply(AFTPoint.class)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator3$1(this))));
    }

    public Seq<AFTPoint> generateAFTInput(int numFeatures, double[] xMean, double[] xVariance, int nPoints, int seed, double weibullShape, double weibullScale, double exponentialMean) {
        WeibullGenerator weibull = new WeibullGenerator(weibullShape, weibullScale);
        weibull.setSeed((long)seed);
        ExponentialGenerator exponential = new ExponentialGenerator(exponentialMean);
        exponential.setSeed((long)seed);
        Random rnd = new Random(seed);
        double[][] x = (double[][])Array$.MODULE$.fill(nPoints, (Function0)new Serializable(this, numFeatures, rnd){
            public static final long serialVersionUID = 0L;
            private final int numFeatures$1;
            public final Random rnd$1;

            public final double[] apply() {
                return (double[])Array$.MODULE$.fill(this.numFeatures$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.rnd$1.nextDouble();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double());
            }
            {
                this.numFeatures$1 = numFeatures$1;
                this.rnd$1 = rnd$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Predef$.MODULE$.refArrayOps((Object[])x).foreach((Function1)new Serializable(this, xMean, xVariance){
            public static final long serialVersionUID = 0L;
            private final double[] xMean$1;
            private final double[] xVariance$1;

            public final void apply(double[] v) {
                int len = v.length;
                for (int i = 0; i < len; ++i) {
                    v[i] = (v[i] - 0.5) * scala.math.package$.MODULE$.sqrt(12.0 * this.xVariance$1[i]) + this.xMean$1[i];
                }
            }
            {
                this.xMean$1 = xMean$1;
                this.xVariance$1 = xVariance$1;
            }
        });
        IndexedSeq y = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nPoints).map((Function1)new Serializable(this, weibull, exponential){
            public static final long serialVersionUID = 0L;
            private final WeibullGenerator weibull$1;
            private final ExponentialGenerator exponential$1;

            public final Tuple2<Object, Object> apply(int i) {
                return new Tuple2.mcDD.sp(this.weibull$1.nextValue(), this.exponential$1.nextValue());
            }
            {
                this.weibull$1 = weibull$1;
                this.exponential$1 = exponential$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)y.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])x), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final AFTPoint apply(Tuple2<Tuple2<Object, Object>, double[]> p) {
                return new AFTPoint(Vectors$.MODULE$.dense((double[])p._2()), ((Tuple2)p._1())._1$mcD$sp(), this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$censor$1(((Tuple2)p._1())._1$mcD$sp(), ((Tuple2)p._1())._2$mcD$sp()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public final double org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$censor$1(double x, double y) {
        return x <= y ? 1.0 : 0.0;
    }

    public AFTSurvivalRegressionSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.ignore("export test data into CSV format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.datasetUnivariate().rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object label = ((SeqLike)some.get()).apply(1);
                            Object censor = ((SeqLike)some.get()).apply(2);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (label instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)label);
                                    if (censor instanceof Double) {
                                        double d2 = BoxesRunTime.unboxToDouble((Object)censor);
                                        String string = new StringBuilder().append((Object)Predef$.MODULE$.doubleArrayOps(vector.toArray()).mkString(",")).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)d2)).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)d)).toString();
                                        return string;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(String.class)).repartition(1, (Ordering)Ordering.String$.MODULE$).saveAsTextFile("target/tmp/AFTSurvivalRegressionSuite/datasetUnivariate");
                this.$outer.datasetMultivariate().rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object label = ((SeqLike)some.get()).apply(1);
                            Object censor = ((SeqLike)some.get()).apply(2);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (label instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)label);
                                    if (censor instanceof Double) {
                                        double d2 = BoxesRunTime.unboxToDouble((Object)censor);
                                        String string = new StringBuilder().append((Object)Predef$.MODULE$.doubleArrayOps(vector.toArray()).mkString(",")).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)d2)).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)d)).toString();
                                        return string;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(String.class)).repartition(1, (Ordering)Ordering.String$.MODULE$).saveAsTextFile("target/tmp/AFTSurvivalRegressionSuite/datasetMultivariate");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new AFTSurvivalRegression());
                AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel("aftSurvReg", Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 0.0, 0.0);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("aft survival regression: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AFTSurvivalRegression aftr = new AFTSurvivalRegression();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(aftr.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(aftr.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "features";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(aftr.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(aftr.getCensorCol());
                String $org_scalatest_assert_macro_right4 = "censor";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(aftr.getFitIntercept(), "aftr.getFitIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)aftr.getMaxIter()));
                int $org_scalatest_assert_macro_right5 = 100;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)aftr.getTol()));
                double $org_scalatest_assert_macro_right6 = 1.0E-6;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                AFTSurvivalRegressionModel model = aftr.setQuantileProbabilities(new double[]{0.1, 0.8}).setQuantilesCol("quantiles").fit(this.$outer.datasetUnivariate());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                model.transform(this.$outer.datasetUnivariate()).select("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "quantiles"})).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(model.getFeaturesCol());
                String $org_scalatest_assert_macro_right7 = "features";
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(model.getPredictionCol());
                String $org_scalatest_assert_macro_right8 = "prediction";
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(model.getQuantileProbabilities());
                double[] $org_scalatest_assert_macro_right9 = new double[]{0.1, 0.8};
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(model.getQuantilesCol());
                String $org_scalatest_assert_macro_right10 = "quantiles";
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right11 = 0.0;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aft survival regression with univariate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] quantileProbabilities = new double[]{0.1, 0.5, 0.9};
                AFTSurvivalRegression trainer = new AFTSurvivalRegression().setQuantileProbabilities(quantileProbabilities).setQuantilesCol("quantiles");
                AFTSurvivalRegressionModel model = trainer.fit(this.$outer.datasetUnivariate());
                Vector coefficientsR = Vectors$.MODULE$.dense(-0.039, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                double interceptR = 1.759;
                double scaleR = 1.41;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.scale()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scaleR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.scale).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scaleR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector features = Vectors$.MODULE$.dense(6.559282795753792, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                double responsePredictR = 4.494763;
                Vector quantilePredictR = Vectors$.MODULE$.dense(0.1879174, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.6801195, 14.5779394}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.predict(features)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(responsePredictR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(responsePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.predictQuantiles(features)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(quantilePredictR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(quantilePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])model.transform(this.$outer.datasetUnivariate()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "quantiles"})).collect()).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final AFTSurvivalRegressionModel model$1;

                    public final void apply(Row x0$3) {
                        Row row = x0$3;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object prediction = ((SeqLike)some.get()).apply(1);
                            Object quantiles = ((SeqLike)some.get()).apply(2);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    if (quantiles instanceof Vector) {
                                        Vector vector2 = (Vector)quantiles;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.model$1.predict(vector)).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.model$1.predictQuantiles(vector)).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(quantiles).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$1 = model$1;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aft survival regression with multivariate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] quantileProbabilities = new double[]{0.1, 0.5, 0.9};
                AFTSurvivalRegression trainer = new AFTSurvivalRegression().setQuantileProbabilities(quantileProbabilities).setQuantilesCol("quantiles");
                AFTSurvivalRegressionModel model = trainer.fit(this.$outer.datasetMultivariate());
                Vector coefficientsR = Vectors$.MODULE$.dense(-0.0844, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0677}));
                double interceptR = 1.9206;
                double scaleR = 0.977;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.scale()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scaleR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.scale).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scaleR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector features = Vectors$.MODULE$.dense(2.233396950271428, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.5321374085997683}));
                double responsePredictR = 4.761219;
                Vector quantilePredictR = Vectors$.MODULE$.dense(0.5287044, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.3285858, 10.7517072}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.predict(features)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(responsePredictR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(responsePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.predictQuantiles(features)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(quantilePredictR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(quantilePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])model.transform(this.$outer.datasetMultivariate()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "quantiles"})).collect()).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final AFTSurvivalRegressionModel model$2;

                    public final void apply(Row x0$4) {
                        Row row = x0$4;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object prediction = ((SeqLike)some.get()).apply(1);
                            Object quantiles = ((SeqLike)some.get()).apply(2);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    if (quantiles instanceof Vector) {
                                        Vector vector2 = (Vector)quantiles;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.model$2.predict(vector)).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.model$2.predictQuantiles(vector)).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(quantiles).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$2 = model$2;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aft survival regression w/o intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] quantileProbabilities = new double[]{0.1, 0.5, 0.9};
                AFTSurvivalRegression trainer = new AFTSurvivalRegression().setQuantileProbabilities(quantileProbabilities).setQuantilesCol("quantiles").setFitIntercept(false);
                AFTSurvivalRegressionModel model = trainer.fit(this.$outer.datasetMultivariate());
                Vector coefficientsR = Vectors$.MODULE$.dense(0.896, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.709}));
                double interceptR = 0.0;
                double scaleR = 1.52;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = interceptR;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.scale()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scaleR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.scale).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scaleR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector features = Vectors$.MODULE$.dense(2.233396950271428, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.5321374085997683}));
                double responsePredictR = 44.54465;
                Vector quantilePredictR = Vectors$.MODULE$.dense(1.452103, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{25.506077, 158.4286}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.predict(features)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(responsePredictR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(responsePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.predictQuantiles(features)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(quantilePredictR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(quantilePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])model.transform(this.$outer.datasetMultivariate()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "quantiles"})).collect()).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final AFTSurvivalRegressionModel model$3;

                    public final void apply(Row x0$5) {
                        Row row = x0$5;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object prediction = ((SeqLike)some.get()).apply(1);
                            Object quantiles = ((SeqLike)some.get()).apply(2);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    if (quantiles instanceof Vector) {
                                        Vector vector2 = (Vector)quantiles;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.model$3.predict(vector)).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.model$3.predictQuantiles(vector)).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(quantiles).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$3 = model$3;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aft survival regression w/o quantiles column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AFTSurvivalRegression trainer = new AFTSurvivalRegression();
                AFTSurvivalRegressionModel model = trainer.fit(this.$outer.datasetUnivariate());
                Dataset outputDf = model.transform(this.$outer.datasetUnivariate());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.refArrayOps((Object[])outputDf.schema().fieldNames()).contains((Object)"quantiles")));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])outputDf.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final AFTSurvivalRegressionModel model$4;

                    public final void apply(Row x0$6) {
                        Row row = x0$6;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object prediction = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.model$4.predict(vector)).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).relTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$4 = model$4;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AFTSurvivalRegression aft = new AFTSurvivalRegression().setMaxIter(1);
                MLTestingUtils$.MODULE$.checkNumericTypes(aft, this.$outer.spark(), false, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(AFTSurvivalRegressionModel expected, AFTSurvivalRegressionModel actual) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)expected.intercept()));
                        double $org_scalatest_assert_macro_right = actual.intercept();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().convertToEqualizer(expected.coefficients());
                        Vector $org_scalatest_assert_macro_right2 = actual.coefficients();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("numerical stability of standardization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AFTSurvivalRegression trainer = new AFTSurvivalRegression();
                AFTSurvivalRegressionModel model1 = trainer.fit(this.$outer.datasetUnivariate());
                AFTSurvivalRegressionModel model2 = trainer.fit(this.$outer.datasetUnivariateScaled());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.coefficients().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.coefficients().apply(0) * 1000.0).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.coefficients.apply(0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.coefficients.apply(0).*(1000.0)).absTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).absTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.scale()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.scale()).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.scale).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.scale).absTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AFTSurvivalRegression aft = new AFTSurvivalRegression();
                this.$outer.testEstimatorAndModelReadWrite(aft, this.$outer.datasetMultivariate(), AFTSurvivalRegressionSuite$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply(AFTSurvivalRegressionModel model, AFTSurvivalRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$checkModelData$1(AFTSurvivalRegressionModel model, AFTSurvivalRegressionModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = model2.intercept();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.coefficients());
                Vector $org_scalatest_assert_macro_right2 = model2.coefficients();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.scale()));
                double $org_scalatest_assert_macro_right3 = model2.scale();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-15892: Incorrectly merged AFTAggregator with zero total count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionSuite.class.getClassLoader());
                Dataset dataset = this.$outer.spark().createDataFrame(this.$outer.sc().parallelize(this.$outer.generateAFTInput(1, new double[]{5.5}, new double[]{0.8}, 2, 42, 1.0, 2.0, 2.0), 3, ClassTag$.MODULE$.apply(AFTPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTPoint")).asType()).toTypeConstructor();
                    }
                }));
                AFTSurvivalRegression trainer = new AFTSurvivalRegression();
                trainer.fit(dataset);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

