/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor;
import org.apache.spark.ml.regression.DecisionTreeRegressorSuite$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u001b\tQB)Z2jg&|g\u000e\u0016:fKJ+wM]3tg>\u00148+^5uK*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00135A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B;uS2T!a\u0006\u0004\u0002\u000b5dG.\u001b2\n\u0005e!\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\t\u00037ui\u0011\u0001\b\u0006\u0003+\u0011I!A\b\u000f\u0003)\u0011+g-Y;miJ+\u0017\rZ,sSR,G+Z:u\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001C\u0005&\u0001\u0001\u0007\t\u0019!C\u0005M\u0005A2-\u0019;fO>\u0014\u0018nY1m\t\u0006$\u0018\rU8j]R\u001c(\u000b\u0012#\u0016\u0003\u001d\u00022\u0001K\u0016.\u001b\u0005I#B\u0001\u0016\u0007\u0003\r\u0011H\rZ\u0005\u0003Y%\u00121A\u0015#E!\tq\u0013'D\u00010\u0015\t\u0001D!A\u0004gK\u0006$XO]3\n\u0005Iz#\u0001\u0004'bE\u0016dW\r\u001a)pS:$\b\"\u0003\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u00036\u0003q\u0019\u0017\r^3h_JL7-\u00197ECR\f\u0007k\\5oiN\u0014F\tR0%KF$\"A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b{M\n\t\u00111\u0001(\u0003\rAH%\r\u0005\u0007\u007f\u0001\u0001\u000b\u0015B\u0014\u00023\r\fG/Z4pe&\u001c\u0017\r\u001c#bi\u0006\u0004v.\u001b8ugJ#E\t\t\u0005\u0006\u0003\u0002!\tEQ\u0001\nE\u00164wN]3BY2$\u0012AN\u0004\u0007\t\nA\t\u0001B#\u00025\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:peN+\u0018\u000e^3\u0011\u0005\r2eAB\u0001\u0003\u0011\u0003!qi\u0005\u0002G\u001d!)\u0001E\u0012C\u0001\u0013R\tQ\tC\u0003L\r\u0012\u0005A*A\u0006d_6\u0004\u0018M]3B!&\u001bH\u0003\u0002\u001cN\u001fRCQA\u0014&A\u0002\u001d\nA\u0001Z1uC\")\u0001K\u0013a\u0001#\u0006\u0011A\r\u001e\t\u0003GIK!a\u0015\u0002\u0003+\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:pe\")QK\u0013a\u0001-\u0006\u00192-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fgB!qKW/^\u001d\t9\u0004,\u0003\u0002Zq\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\u00075\u000b\u0007O\u0003\u0002ZqA\u0011qGX\u0005\u0003?b\u00121!\u00138u\u0011\u001d\tg)!A\u0005\n\t\f1B]3bIJ+7o\u001c7wKR\t1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006!A.\u00198h\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[3\u0003\r=\u0013'.Z2u\u0001")
public class DecisionTreeRegressorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private RDD<LabeledPoint> org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void compareAPIs(RDD<LabeledPoint> rDD, DecisionTreeRegressor decisionTreeRegressor, Map<Object, Object> map) {
        DecisionTreeRegressorSuite$.MODULE$.compareAPIs(rDD, decisionTreeRegressor, map);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public RDD<LabeledPoint> org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD() {
        return this.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD;
    }

    private void org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        Seq x$3 = (Seq)Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                return x$1.asML();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        int x$4 = qual$1.parallelize$default$2();
        this.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD_$eq((RDD<LabeledPoint>)qual$1.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public DecisionTreeRegressorSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("Regression stump with 3-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeRegressor dt = new DecisionTreeRegressor().setImpurity("variance").setMaxDepth(2).setMaxBins(100).setSeed(1L);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                DecisionTreeRegressorSuite$.MODULE$.compareAPIs(this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD(), dt, (Map<Object, Object>)categoricalFeatures);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression stump with binary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeRegressor dt = new DecisionTreeRegressor().setImpurity("variance").setMaxDepth(2).setMaxBins(100);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                DecisionTreeRegressorSuite$.MODULE$.compareAPIs(this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD(), dt, (Map<Object, Object>)categoricalFeatures);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("copied model must have the same parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD(), (Map<Object, Object>)categoricalFeatures, 0);
                DecisionTreeRegressionModel model = (DecisionTreeRegressionModel)new DecisionTreeRegressor().setImpurity("variance").setMaxDepth(2).setMaxBins(8).fit(df);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("predictVariance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeRegressor dt = ((DecisionTreeRegressor)new DecisionTreeRegressor().setImpurity("variance").setMaxDepth(2).setMaxBins(100).setPredictionCol("")).setVarianceCol("variance");
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$categoricalDataPointsRDD(), (Map<Object, Object>)categoricalFeatures, 0);
                DecisionTreeRegressionModel model = (DecisionTreeRegressionModel)dt.fit(df);
                Row[] predictions = (Row[])model.transform(df).select(model.getFeaturesCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{model.getVarianceCol()})).collect();
                Predef$.MODULE$.refArrayOps((Object[])predictions).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final DecisionTreeRegressionModel model$1;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object variance = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (variance instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)variance);
                                    double expectedVariance = this.model$1.rootNode().predictImpl(vector).impurityStats().calculate();
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)d));
                                    double $org_scalatest_assert_macro_right = expectedVariance;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected variance ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)expectedVariance), BoxesRunTime.boxToDouble((double)d)})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$1 = model$1;
                    }
                });
            }

            public /* synthetic */ DecisionTreeRegressorSuite org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Feature importance with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeRegressor dt = new DecisionTreeRegressor().setImpurity("variance").setMaxDepth(3).setSeed(123L);
                RDD<LabeledPoint> data = TreeTests$.MODULE$.featureImportanceData(this.$outer.sc());
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(data, (Map<Object, Object>)categoricalFeatures, 0);
                DecisionTreeRegressionModel model = (DecisionTreeRegressionModel)dt.fit(df);
                Vector importances = model.featureImportances();
                int mostImportantFeature = importances.argmax();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mostImportantFeature));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(importances.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(importances.toArray()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$2) {
                        return this.apply$mcZD$sp(x$2);
                    }

                    public boolean apply$mcZD$sp(double x$2) {
                        return x$2 >= 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(importances.toArray).forall(((x$2: Double) => x$2.>=(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeRegressor dt = new DecisionTreeRegressor().setMaxDepth(1);
                MLTestingUtils$.MODULE$.checkNumericTypes(dt, this.$outer.spark(), false, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(DecisionTreeRegressionModel expected, DecisionTreeRegressionModel actual) {
                        TreeTests$.MODULE$.checkEqual((DecisionTreeModel)expected, (DecisionTreeModel)actual);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeRegressor dt = new DecisionTreeRegressor();
                RDD<LabeledPoint> rdd = TreeTests$.MODULE$.getTreeReadWriteData(this.$outer.sc());
                Dataset<Row> categoricalData = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}))), 0);
                this.$outer.testEstimatorAndModelReadWrite(dt, categoricalData, TreeTests$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(DecisionTreeRegressionModel model, DecisionTreeRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Dataset<Row> continuousData = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), 0);
                this.$outer.testEstimatorAndModelReadWrite(dt, continuousData, TreeTests$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(DecisionTreeRegressionModel model, DecisionTreeRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.testEstimatorAndModelReadWrite(dt, continuousData, (Map<String, Object>)TreeTests$.MODULE$.allParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxDepth"), (Object)BoxesRunTime.boxToInteger((int)0))}))), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(DecisionTreeRegressionModel model, DecisionTreeRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$regression$DecisionTreeRegressorSuite$$anonfun$$checkModelData$1(DecisionTreeRegressionModel model, DecisionTreeRegressionModel model2) {
                TreeTests$.MODULE$.checkEqual((DecisionTreeModel)model, (DecisionTreeModel)model2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right = model2.numFeatures();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

