/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.regression.GBTRegressor;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GBTRegressorSuite$
extends SparkFunSuite {
    public static final GBTRegressorSuite$ MODULE$;

    static {
        new GBTRegressorSuite$();
    }

    public void compareAPIs(RDD<org.apache.spark.ml.feature.LabeledPoint> data, Option<RDD<org.apache.spark.ml.feature.LabeledPoint>> validationData, GBTRegressor gbt, Map<Object, Object> categoricalFeatures) {
        int numFeatures = ((org.apache.spark.ml.feature.LabeledPoint)data.first()).features().size();
        BoostingStrategy oldBoostingStrategy = gbt.getOldBoostingStrategy(categoricalFeatures, Algo$.MODULE$.Regression());
        GradientBoostedTrees oldGBT = new GradientBoostedTrees(oldBoostingStrategy, (int)gbt.getSeed());
        GradientBoostedTreesModel oldModel = oldGBT.run(data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.ml.feature.LabeledPoint point) {
                return LabeledPoint$.MODULE$.fromML(point);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        Dataset<Row> newData = TreeTests$.MODULE$.setMetadata(data, categoricalFeatures, 0);
        GBTRegressionModel newModel = (GBTRegressionModel)gbt.fit(newData);
        GBTRegressionModel oldModelAsNew = GBTRegressionModel$.MODULE$.fromOld(oldModel, (GBTRegressor)newModel.parent(), categoricalFeatures, numFeatures);
        TreeTests$.MODULE$.checkEqual(oldModelAsNew, newModel);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.numFeatures()));
        int $org_scalatest_assert_macro_right = numFeatures;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)oldModelAsNew.numFeatures()));
        int $org_scalatest_assert_macro_right2 = numFeatures;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GBTRegressorSuite$() {
        MODULE$ = this;
    }
}

