/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressor;
import org.apache.spark.ml.regression.GBTRegressor$;
import org.apache.spark.ml.regression.GBTRegressorSuite$;
import org.apache.spark.ml.regression.GBTRegressorSuite$$anonfun$1$;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u00015\u0011\u0011c\u0012\"U%\u0016<'/Z:t_J\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\n\u001b!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tA!\u001e;jY*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002\u001c;5\tAD\u0003\u0002\u0016\t%\u0011a\u0004\b\u0002\u0015\t\u00164\u0017-\u001e7u%\u0016\fGm\u0016:ji\u0016$Vm\u001d;\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001bB\u0013\u0001\u0005\u0004%IAJ\u0001\u0011i\u0016\u001cHoQ8nE&t\u0017\r^5p]N,\u0012a\n\t\u0004Q-jS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u000b!r\u0003gM\u001a\n\u0005=J#A\u0002+va2,7\u0007\u0005\u0002)c%\u0011!'\u000b\u0002\u0004\u0013:$\bC\u0001\u00155\u0013\t)\u0014F\u0001\u0004E_V\u0014G.\u001a\u0005\u0007o\u0001\u0001\u000b\u0011B\u0014\u0002#Q,7\u000f^\"p[\nLg.\u0019;j_:\u001c\b\u0005C\u0005:\u0001\u0001\u0007\t\u0019!C\u0005u\u0005!A-\u0019;b+\u0005Y\u0004c\u0001\u001f@\u00036\tQH\u0003\u0002?\r\u0005\u0019!\u000f\u001a3\n\u0005\u0001k$a\u0001*E\tB\u0011!)R\u0007\u0002\u0007*\u0011A\tB\u0001\bM\u0016\fG/\u001e:f\u0013\t15I\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u0005I\u0001\u0001\u0007\t\u0019!C\u0005\u0013\u0006AA-\u0019;b?\u0012*\u0017\u000f\u0006\u0002K\u001bB\u0011\u0001fS\u0005\u0003\u0019&\u0012A!\u00168ji\"9ajRA\u0001\u0002\u0004Y\u0014a\u0001=%c!1\u0001\u000b\u0001Q!\nm\nQ\u0001Z1uC\u0002B\u0011B\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\u0002\u0013Q\u0014\u0018-\u001b8ECR\f\u0007\"\u0003+\u0001\u0001\u0004\u0005\r\u0011\"\u0003V\u00035!(/Y5o\t\u0006$\u0018m\u0018\u0013fcR\u0011!J\u0016\u0005\b\u001dN\u000b\t\u00111\u0001<\u0011\u0019A\u0006\u0001)Q\u0005w\u0005QAO]1j]\u0012\u000bG/\u0019\u0011\t\u0013i\u0003\u0001\u0019!a\u0001\n\u0013Q\u0014A\u0004<bY&$\u0017\r^5p]\u0012\u000bG/\u0019\u0005\n9\u0002\u0001\r\u00111A\u0005\nu\u000b!C^1mS\u0012\fG/[8o\t\u0006$\u0018m\u0018\u0013fcR\u0011!J\u0018\u0005\b\u001dn\u000b\t\u00111\u0001<\u0011\u0019\u0001\u0007\u0001)Q\u0005w\u0005ya/\u00197jI\u0006$\u0018n\u001c8ECR\f\u0007\u0005C\u0003c\u0001\u0011\u00053-A\u0005cK\u001a|'/Z!mYR\t!jB\u0003f\u0005!%a-A\tH\u0005R\u0013Vm\u001a:fgN|'oU;ji\u0016\u0004\"aI4\u0007\u000b\u0005\u0011\u0001\u0012\u00025\u0014\u0005\u001dt\u0001\"\u0002\u0011h\t\u0003QG#\u00014\t\u000b1<G\u0011A7\u0002\u0017\r|W\u000e]1sK\u0006\u0003\u0016j\u001d\u000b\u0006\u0015:|7\u000f\u001f\u0005\u0006s-\u0004\ra\u000f\u0005\u00065.\u0004\r\u0001\u001d\t\u0004QE\\\u0014B\u0001:*\u0005\u0019y\u0005\u000f^5p]\")Ao\u001ba\u0001k\u0006\u0019qM\u0019;\u0011\u0005\r2\u0018BA<\u0003\u000519%\t\u0016*fOJ,7o]8s\u0011\u0015I8\u000e1\u0001{\u0003M\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t!\u0011Yh\u0010\r\u0019\u000f\u0005!b\u0018BA?*\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\u00075\u000b\u0007O\u0003\u0002~S!I\u0011QA4\u0002\u0002\u0013%\u0011qA\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00027b]\u001eT!!a\u0005\u0002\t)\fg/Y\u0005\u0005\u0003/\tiA\u0001\u0004PE*,7\r\u001e")
public class GBTRegressorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private final Tuple3<Object, Object, Object>[] org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations;
    private RDD<LabeledPoint> org$apache$spark$ml$regression$GBTRegressorSuite$$data;
    private RDD<LabeledPoint> trainData;
    private RDD<LabeledPoint> validationData;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void compareAPIs(RDD<LabeledPoint> rDD, Option<RDD<LabeledPoint>> option, GBTRegressor gBTRegressor, Map<Object, Object> map) {
        GBTRegressorSuite$.MODULE$.compareAPIs(rDD, option, gBTRegressor, map);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Tuple3<Object, Object, Object>[] org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations() {
        return this.org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$regression$GBTRegressorSuite$$data() {
        return this.org$apache$spark$ml$regression$GBTRegressorSuite$$data;
    }

    private void org$apache$spark$ml$regression$GBTRegressorSuite$$data_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$regression$GBTRegressorSuite$$data = x$1;
    }

    private RDD<LabeledPoint> trainData() {
        return this.trainData;
    }

    private void trainData_$eq(RDD<LabeledPoint> x$1) {
        this.trainData = x$1;
    }

    private RDD<LabeledPoint> validationData() {
        return this.validationData;
    }

    private void validationData_$eq(RDD<LabeledPoint> x$1) {
        this.validationData = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.org$apache$spark$ml$regression$GBTRegressorSuite$$data_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(10, 100)), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                return x$1.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        this.trainData_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(20, 120)), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$2) {
                return x$2.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        this.validationData_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(20, 80)), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$3) {
                return x$3.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public GBTRegressorSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)0.75)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)0.75))});
        this.test("Regression with continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Predef$.MODULE$.refArrayOps((Object[])GBTRegressor$.MODULE$.supportedLossTypes()).foreach((Function1)new Serializable(this, categoricalFeatures){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final Map categoricalFeatures$1;

                    public final void apply(String loss) {
                        Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$$outer().org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations()).foreach((Function1)new Serializable(this, loss){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final String loss$1;

                            public final void apply(Tuple3<Object, Object, Object> x0$1) {
                                Tuple3<Object, Object, Object> tuple3 = x0$1;
                                if (tuple3 != null) {
                                    int maxIter = BoxesRunTime.unboxToInt((Object)tuple3._1());
                                    double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                                    double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                                    GBTRegressor gbt = new GBTRegressor().setMaxDepth(2).setSubsamplingRate(subsamplingRate).setLossType(this.loss$1).setMaxIter(maxIter).setStepSize(learningRate).setSeed(123L);
                                    GBTRegressorSuite$.MODULE$.compareAPIs(this.$outer.org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$$outer().org$apache$spark$ml$regression$GBTRegressorSuite$$data(), (Option<RDD<LabeledPoint>>)None$.MODULE$, gbt, (Map<Object, Object>)this.$outer.categoricalFeatures$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple3);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.loss$1 = loss$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.categoricalFeatures$1 = categoricalFeatures$1;
                    }
                });
            }

            public /* synthetic */ GBTRegressorSuite org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("GBTRegressor behaves reasonably on toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressorSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(10.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}))), new LabeledPoint(-5.0, Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0, 1.0}))), new LabeledPoint(11.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}))), new LabeledPoint(-6.0, Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 2.0, 1.0}))), new LabeledPoint(9.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0, 4.0}))), new LabeledPoint(-4.0, Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0, 2.0})))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                GBTRegressor gbt = new GBTRegressor().setMaxDepth(2).setMaxIter(2);
                GBTRegressionModel model = (GBTRegressionModel)gbt.fit(df);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                Dataset preds = model.transform(df);
                RDD predictions = preds.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Row x$4) {
                        return x$4.getDouble(0);
                    }
                }, ClassTag$.MODULE$.Double());
                double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)predictions.max((Ordering)Ordering.Double$.MODULE$));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (double)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToDouble((Object)predictions.min((Ordering)Ordering.Double$.MODULE$));
                int $org_scalatest_assert_macro_right2 = -1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < (double)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                this.$outer.sc().setCheckpointDir(path);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressorSuite.class.getClassLoader());
                Dataset df = this.$outer.spark().createDataFrame(this.$outer.org$apache$spark$ml$regression$GBTRegressorSuite$$data(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                GBTRegressor gbt = new GBTRegressor().setMaxDepth(2).setMaxIter(5).setStepSize(0.1).setCheckpointInterval(2).setSeed(123L);
                GBTRegressionModel model = (GBTRegressionModel)gbt.fit(df);
                this.$outer.sc().checkpointDir_$eq((Option)None$.MODULE$);
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GBTRegressor gbt = new GBTRegressor().setMaxDepth(1);
                MLTestingUtils$.MODULE$.checkNumericTypes(gbt, this.$outer.spark(), false, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(GBTRegressionModel expected, GBTRegressionModel actual) {
                        TreeTests$.MODULE$.checkEqual(expected, actual);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Feature importance with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GBTRegressor gbt = new GBTRegressor().setMaxDepth(3).setMaxIter(5).setSubsamplingRate(1.0).setStepSize(0.5).setSeed(123L);
                RDD<LabeledPoint> data = TreeTests$.MODULE$.featureImportanceData(this.$outer.sc());
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(data, (Map<Object, Object>)categoricalFeatures, 0);
                Vector importances = ((GBTRegressionModel)gbt.fit(df)).featureImportances();
                int mostImportantFeature = importances.argmax();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mostImportantFeature));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(importances.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(importances.toArray()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$5) {
                        return this.apply$mcZD$sp(x$5);
                    }

                    public boolean apply$mcZD$sp(double x$5) {
                        return x$5 >= 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(importances.toArray).forall(((x$5: Double) => x$5.>=(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GBTRegressor gbt = new GBTRegressor();
                RDD<LabeledPoint> rdd = TreeTests$.MODULE$.getTreeReadWriteData(this.$outer.sc());
                Map allParamSettings = TreeTests$.MODULE$.allParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lossType"), (Object)"squared")})));
                Dataset<Row> continuousData = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), 0);
                this.$outer.testEstimatorAndModelReadWrite(gbt, continuousData, (Map<String, Object>)allParamSettings, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(GBTRegressionModel model, GBTRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$checkModelData$1(GBTRegressionModel model, GBTRegressionModel model2) {
                TreeTests$.MODULE$.checkEqual(model, model2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right = model2.numFeatures();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

