/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSuite$;
import org.apache.spark.mllib.random.GammaGenerator;
import org.apache.spark.mllib.random.PoissonGenerator;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.StandardNormalGenerator;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class GeneralizedLinearRegressionSuite$
implements Serializable {
    public static final GeneralizedLinearRegressionSuite$ MODULE$;
    private final Map<String, Object> allParamSettings;

    static {
        new GeneralizedLinearRegressionSuite$();
    }

    public Map<String, Object> allParamSettings() {
        return this.allParamSettings;
    }

    public Seq<LabeledPoint> generateGeneralizedLinearRegressionInput(double intercept, double[] coefficients, double[] xMean, double[] xVariance, int nPoints, int seed, double noiseLevel, String family, String link) {
        String string;
        block7: {
            Tuple2 tuple2;
            Random rnd;
            block5: {
                block6: {
                    block4: {
                        rnd = new Random(seed);
                        String string2 = string = family;
                        if ("gaussian" != null ? !"gaussian".equals(string2) : string2 != null) break block4;
                        tuple2 = new Tuple2((Object)new StandardNormalGenerator(), (Object)BoxesRunTime.boxToDouble((double)0.0));
                        break block5;
                    }
                    String string3 = string;
                    if ("poisson" != null ? !"poisson".equals(string3) : string3 != null) break block6;
                    tuple2 = new Tuple2((Object)new PoissonGenerator(1.0), (Object)BoxesRunTime.boxToDouble((double)1.0));
                    break block5;
                }
                String string4 = string;
                if ("gamma" != null ? !"gamma".equals(string4) : string4 != null) break block7;
                tuple2 = new Tuple2((Object)new GammaGenerator(1.0, 1.0), (Object)BoxesRunTime.boxToDouble((double)1.0));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                RandomDataGenerator generator = (RandomDataGenerator)tuple22._1();
                double mean = tuple22._2$mcD$sp();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)generator, (Object)BoxesRunTime.boxToDouble((double)mean));
                RandomDataGenerator generator2 = (RandomDataGenerator)tuple24._1();
                double mean2 = tuple24._2$mcD$sp();
                generator2.setSeed((long)seed);
                return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)new Serializable(intercept, coefficients, xMean, xVariance, noiseLevel, link, rnd, generator2, mean2){
                    public static final long serialVersionUID = 0L;
                    private final double intercept$1;
                    private final double[] coefficients$1;
                    public final double[] xMean$1;
                    public final double[] xVariance$1;
                    private final double noiseLevel$1;
                    private final String link$1;
                    public final Random rnd$1;
                    private final RandomDataGenerator generator$1;
                    private final double mean$1;

                    public final LabeledPoint apply(int x$22) {
                        String string;
                        block6: {
                            double d;
                            Vector features;
                            block3: {
                                double eta;
                                block5: {
                                    block4: {
                                        block2: {
                                            features = Vectors$.MODULE$.dense((double[])((TraversableOnce)Predef$.MODULE$.doubleArrayOps(this.coefficients$1).indices().map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun.generateGeneralizedLinearRegressionInput.1 $outer;

                                                public final double apply(int i) {
                                                    return this.apply$mcDI$sp(i);
                                                }

                                                public double apply$mcDI$sp(int i) {
                                                    return GeneralizedLinearRegressionSuite$.MODULE$.org$apache$spark$ml$regression$GeneralizedLinearRegressionSuite$$rndElement$1(i, this.$outer.xMean$1, this.$outer.xVariance$1, this.$outer.rnd$1);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
                                            eta = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(this.coefficients$1), features) + this.intercept$1;
                                            String string2 = string = this.link$1;
                                            if ("identity" != null ? !"identity".equals(string2) : string2 != null) break block2;
                                            d = eta;
                                            break block3;
                                        }
                                        String string3 = string;
                                        if ("log" != null ? !"log".equals(string3) : string3 != null) break block4;
                                        d = package$.MODULE$.exp(eta);
                                        break block3;
                                    }
                                    String string4 = string;
                                    if ("sqrt" != null ? !"sqrt".equals(string4) : string4 != null) break block5;
                                    d = package$.MODULE$.pow(eta, 2.0);
                                    break block3;
                                }
                                String string5 = string;
                                if ("inverse" != null ? !"inverse".equals(string5) : string5 != null) break block6;
                                d = 1.0 / eta;
                            }
                            double mu = d;
                            double label = mu + this.noiseLevel$1 * (BoxesRunTime.unboxToDouble((Object)this.generator$1.nextValue()) - this.mean$1);
                            return new LabeledPoint(label, features);
                        }
                        throw new MatchError((Object)string);
                    }
                    {
                        this.intercept$1 = intercept$1;
                        this.coefficients$1 = coefficients$1;
                        this.xMean$1 = xMean$1;
                        this.xVariance$1 = xVariance$1;
                        this.noiseLevel$1 = noiseLevel$1;
                        this.link$1 = link$1;
                        this.rnd$1 = rnd$1;
                        this.generator$1 = generator$1;
                        this.mean$1 = mean$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)string);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final double org$apache$spark$ml$regression$GeneralizedLinearRegressionSuite$$rndElement$1(int i, double[] xMean$1, double[] xVariance$1, Random rnd$1) {
        return (rnd$1.nextDouble() - 0.5) * package$.MODULE$.sqrt(12.0 * xVariance$1[i]) + xMean$1[i];
    }

    private GeneralizedLinearRegressionSuite$() {
        MODULE$ = this;
        this.allParamSettings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"family"), (Object)"poisson"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"link"), (Object)"log"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fitIntercept"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"tol"), (Object)BoxesRunTime.boxToDouble((double)0.8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"regParam"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"predictionCol"), (Object)"myPrediction")}));
    }
}

