/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionSuite$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$10$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$11$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$12$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$13$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$13$$anonfun$apply$mcV$sp$13$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$14$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$15$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$4$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$6$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$7$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$8$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$9$;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u00015\u0011Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk&$XM\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019\u0011\"\u0004\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\tU$\u0018\u000e\u001c\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yiB\u00111$H\u0007\u00029)\u0011Q\u0003B\u0005\u0003=q\u0011A\u0003R3gCVdGOU3bI^\u0013\u0018\u000e^3UKN$\b\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0003\u0011\u001d)\u0003A1A\u0005\n\u0019\nAa]3fIV\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0002J]RDaA\f\u0001!\u0002\u00139\u0013!B:fK\u0012\u0004\u0003\"\u0003\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00012\u0003]!\u0017\r^1tKR<\u0016\u000e\u001e5EK:\u001cXMR3biV\u0014X-F\u00013!\t\u00194I\u0004\u00025\u0001:\u0011QG\u0010\b\u0003mur!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005ib\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qHB\u0001\u0004gFd\u0017BA!C\u0003\u001d\u0001\u0018mY6bO\u0016T!a\u0010\u0004\n\u0005\u0011+%!\u0003#bi\u00064%/Y7f\u0015\t\t%\tC\u0005H\u0001\u0001\u0007\t\u0019!C\u0001\u0011\u0006YB-\u0019;bg\u0016$x+\u001b;i\t\u0016t7/\u001a$fCR,(/Z0%KF$\"!\u0013'\u0011\u0005!R\u0015BA&*\u0005\u0011)f.\u001b;\t\u000f53\u0015\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\t\r=\u0003\u0001\u0015)\u00033\u0003a!\u0017\r^1tKR<\u0016\u000e\u001e5EK:\u001cXMR3biV\u0014X\r\t\u0015\u0003\u001dF\u0003\"\u0001\u000b*\n\u0005MK#!\u0003;sC:\u001c\u0018.\u001a8u\u0011%)\u0006\u00011AA\u0002\u0013\u0005\u0011'A\u0014eCR\f7/\u001a;XSRDG)\u001a8tK\u001a+\u0017\r^;sK^KG\u000f[8vi&sG/\u001a:dKB$\b\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0001Y\u0003-\"\u0017\r^1tKR<\u0016\u000e\u001e5EK:\u001cXMR3biV\u0014XmV5uQ>,H/\u00138uKJ\u001cW\r\u001d;`I\u0015\fHCA%Z\u0011\u001die+!AA\u0002IBaa\u0017\u0001!B\u0013\u0011\u0014\u0001\u000b3bi\u0006\u001cX\r^,ji\"$UM\\:f\r\u0016\fG/\u001e:f/&$\bn\\;u\u0013:$XM]2faR\u0004\u0003F\u0001.R\u0011%q\u0006\u00011AA\u0002\u0013\u0005\u0011'\u0001\reCR\f7/\u001a;XSRD7\u000b]1sg\u00164U-\u0019;ve\u0016D\u0011\u0002\u0019\u0001A\u0002\u0003\u0007I\u0011A1\u00029\u0011\fG/Y:fi^KG\u000f[*qCJ\u001cXMR3biV\u0014Xm\u0018\u0013fcR\u0011\u0011J\u0019\u0005\b\u001b~\u000b\t\u00111\u00013\u0011\u0019!\u0007\u0001)Q\u0005e\u0005IB-\u0019;bg\u0016$x+\u001b;i'B\f'o]3GK\u0006$XO]3!Q\t\u0019\u0017\u000bC\u0005h\u0001\u0001\u0007\t\u0019!C\u0001c\u0005\tB-\u0019;bg\u0016$x+\u001b;i/\u0016Lw\r\u001b;\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0003Q\u0017!\u00063bi\u0006\u001cX\r^,ji\"<V-[4ii~#S-\u001d\u000b\u0003\u0013.Dq!\u00145\u0002\u0002\u0003\u0007!\u0007\u0003\u0004n\u0001\u0001\u0006KAM\u0001\u0013I\u0006$\u0018m]3u/&$\bnV3jO\"$\b\u0005\u000b\u0002m#\"I\u0001\u000f\u0001a\u0001\u0002\u0004%\t!M\u0001\u001fI\u0006$\u0018m]3u/&$\bnV3jO\"$8i\u001c8ti\u0006tG\u000fT1cK2D\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011A:\u0002E\u0011\fG/Y:fi^KG\u000f[,fS\u001eDGoQ8ogR\fg\u000e\u001e'bE\u0016dw\fJ3r)\tIE\u000fC\u0004Nc\u0006\u0005\t\u0019\u0001\u001a\t\rY\u0004\u0001\u0015)\u00033\u0003}!\u0017\r^1tKR<\u0016\u000e\u001e5XK&<\u0007\u000e^\"p]N$\u0018M\u001c;MC\n,G\u000e\t\u0015\u0003kFC\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011A\u0019\u00025\u0011\fG/Y:fi^KG\u000f[,fS\u001eDGOW3s_2\u000b'-\u001a7\t\u0013m\u0004\u0001\u0019!a\u0001\n\u0003a\u0018A\b3bi\u0006\u001cX\r^,ji\"<V-[4iij+'o\u001c'bE\u0016dw\fJ3r)\tIU\u0010C\u0004Nu\u0006\u0005\t\u0019\u0001\u001a\t\r}\u0004\u0001\u0015)\u00033\u0003m!\u0017\r^1tKR<\u0016\u000e\u001e5XK&<\u0007\u000e\u001e.fe>d\u0015MY3mA!\u0012a0\u0015\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001J\u000f\u001d\tYA\u0001E\u0001\u0003\u001b\tQ\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk&$X\rE\u0002$\u0003\u001f1a!\u0001\u0002\t\u0002\u0005E1CBA\b\u0003'\tI\u0002E\u0002)\u0003+I1!a\u0006*\u0005\u0019\te.\u001f*fMB\u0019\u0001&a\u0007\n\u0007\u0005u\u0011F\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004!\u0003\u001f!\t!!\t\u0015\u0005\u00055\u0001BCA\u0013\u0003\u001f\u0011\r\u0011\"\u0001\u0002(\u0005\u0001\u0012\r\u001c7QCJ\fWnU3ui&twm]\u000b\u0003\u0003S\u0001\u0002\"a\u000b\u00022\u0005]\u0012Q\b\b\u0004Q\u00055\u0012bAA\u0018S\u00051\u0001K]3eK\u001aLA!a\r\u00026\t\u0019Q*\u00199\u000b\u0007\u0005=\u0012\u0006\u0005\u0003\u0002,\u0005e\u0012\u0002BA\u001e\u0003k\u0011aa\u0015;sS:<\u0007c\u0001\u0015\u0002@%\u0019\u0011\u0011I\u0015\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002F\u0005=\u0001\u0015!\u0003\u0002*\u0005\t\u0012\r\u001c7QCJ\fWnU3ui&twm\u001d\u0011\t\u0015\u0005%\u0013qBA\u0001\n\u0013\tY%A\u0006sK\u0006$'+Z:pYZ,GCAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\nA\u0001\\1oO*\u0011\u0011qK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\\\u0005E#AB(cU\u0016\u001cG\u000f")
public class LinearRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private final int seed;
    private transient Dataset<Row> datasetWithDenseFeature;
    private transient Dataset<Row> datasetWithDenseFeatureWithoutIntercept;
    private transient Dataset<Row> datasetWithSparseFeature;
    private transient Dataset<Row> datasetWithWeight;
    private transient Dataset<Row> datasetWithWeightConstantLabel;
    private transient Dataset<Row> datasetWithWeightZeroLabel;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Map<String, Object> allParamSettings() {
        return LinearRegressionSuite$.MODULE$.allParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    private int seed() {
        return this.seed;
    }

    public Dataset<Row> datasetWithDenseFeature() {
        return this.datasetWithDenseFeature;
    }

    public void datasetWithDenseFeature_$eq(Dataset<Row> x$1) {
        this.datasetWithDenseFeature = x$1;
    }

    public Dataset<Row> datasetWithDenseFeatureWithoutIntercept() {
        return this.datasetWithDenseFeatureWithoutIntercept;
    }

    public void datasetWithDenseFeatureWithoutIntercept_$eq(Dataset<Row> x$1) {
        this.datasetWithDenseFeatureWithoutIntercept = x$1;
    }

    public Dataset<Row> datasetWithSparseFeature() {
        return this.datasetWithSparseFeature;
    }

    public void datasetWithSparseFeature_$eq(Dataset<Row> x$1) {
        this.datasetWithSparseFeature = x$1;
    }

    public Dataset<Row> datasetWithWeight() {
        return this.datasetWithWeight;
    }

    public void datasetWithWeight_$eq(Dataset<Row> x$1) {
        this.datasetWithWeight = x$1;
    }

    public Dataset<Row> datasetWithWeightConstantLabel() {
        return this.datasetWithWeightConstantLabel;
    }

    public void datasetWithWeightConstantLabel_$eq(Dataset<Row> x$1) {
        this.datasetWithWeightConstantLabel = x$1;
    }

    public Dataset<Row> datasetWithWeightZeroLabel() {
        return this.datasetWithWeightZeroLabel;
    }

    public void datasetWithWeightZeroLabel_$eq(Dataset<Row> x$1) {
        this.datasetWithWeightZeroLabel = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator1$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithDenseFeature_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 10000, this.seed(), 0.1), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                return x$1.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator1$1(this))));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator2$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithDenseFeatureWithoutIntercept_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 10000, this.seed(), 0.1), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$2) {
                return x$2.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator2$1(this))));
        Random r = new Random(this.seed());
        int featureSize = 4100;
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator3$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithSparseFeature_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(0.0, (double[])((TraversableOnce)Seq$.MODULE$.fill(featureSize, (Function0)new Serializable(this, r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.r$1.nextDouble();
            }
            {
                this.r$1 = r$1;
            }
        })).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)Seq$.MODULE$.fill(featureSize, (Function0)new Serializable(this, r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.r$1.nextDouble();
            }
            {
                this.r$1 = r$1;
            }
        })).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)Seq$.MODULE$.fill(featureSize, (Function0)new Serializable(this, r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.r$1.nextDouble();
            }
            {
                this.r$1 = r$1;
            }
        })).toArray(ClassTag$.MODULE$.Double()), 200, this.seed(), 0.1, 0.7), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$3) {
                return x$3.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator3$1(this))));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.Instance")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator4$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithWeight_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(17.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), new Instance(19.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), new Instance(23.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), new Instance(29.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0})))})), 2, ClassTag$.MODULE$.apply(Instance.class)), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator4$1(this))));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.Instance")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator5$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithWeightConstantLabel_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(17.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), new Instance(17.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), new Instance(17.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), new Instance(17.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0})))})), 2, ClassTag$.MODULE$.apply(Instance.class)), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator5$1(this))));
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.Instance")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator6$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithWeightZeroLabel_$eq((Dataset<Row>)this.spark().createDataFrame(this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(0.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), new Instance(0.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), new Instance(0.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), new Instance(0.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0})))})), 2, ClassTag$.MODULE$.apply(Instance.class)), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator6$1(this))));
    }

    public LinearRegressionSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.seed = 42;
        this.ignore("export test data into CSV format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.datasetWithDenseFeature().rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object label = ((SeqLike)some.get()).apply(0);
                            Object features = ((SeqLike)some.get()).apply(1);
                            if (label instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)label);
                                if (features instanceof Vector) {
                                    Vector vector = (Vector)features;
                                    String string = new StringBuilder().append(d).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps(vector.toArray()).mkString(",")).toString();
                                    return string;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(String.class)).repartition(1, (Ordering)Ordering.String$.MODULE$).saveAsTextFile("target/tmp/LinearRegressionSuite/datasetWithDenseFeature");
                this.$outer.datasetWithDenseFeatureWithoutIntercept().rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object label = ((SeqLike)some.get()).apply(0);
                            Object features = ((SeqLike)some.get()).apply(1);
                            if (label instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)label);
                                if (features instanceof Vector) {
                                    Vector vector = (Vector)features;
                                    String string = new StringBuilder().append(d).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps(vector.toArray()).mkString(",")).toString();
                                    return string;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(String.class)).repartition(1, (Ordering)Ordering.String$.MODULE$).saveAsTextFile("target/tmp/LinearRegressionSuite/datasetWithDenseFeatureWithoutIntercept");
                this.$outer.datasetWithSparseFeature().rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x0$3) {
                        Row row = x0$3;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object label = ((SeqLike)some.get()).apply(0);
                            Object features = ((SeqLike)some.get()).apply(1);
                            if (label instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)label);
                                if (features instanceof Vector) {
                                    Vector vector = (Vector)features;
                                    String string = new StringBuilder().append(d).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps(vector.toArray()).mkString(",")).toString();
                                    return string;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(String.class)).repartition(1, (Ordering)Ordering.String$.MODULE$).saveAsTextFile("target/tmp/LinearRegressionSuite/datasetWithSparseFeature");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new LinearRegression());
                LinearRegressionModel model = new LinearRegressionModel("linearReg", Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 0.0);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("linear regression: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegression lir = new LinearRegression();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(lir.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(lir.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "features";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(lir.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lir.getRegParam()));
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lir.getElasticNetParam()));
                double $org_scalatest_assert_macro_right5 = 0.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(lir.getFitIntercept(), "lir.getFitIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(lir.getStandardization(), "lir.getStandardization");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                String $org_scalatest_assert_macro_left6 = lir.getSolver();
                String $org_scalatest_assert_macro_right6 = "auto";
                String string = $org_scalatest_assert_macro_left6;
                String string2 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                LinearRegressionModel model = (LinearRegressionModel)lir.fit(this.$outer.datasetWithDenseFeature());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                model.transform(this.$outer.datasetWithDenseFeature()).select("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(model.getFeaturesCol());
                String $org_scalatest_assert_macro_right7 = "features";
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(model.getPredictionCol());
                String $org_scalatest_assert_macro_right8 = "prediction";
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right9 = 0.0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                int numFeatures = ((Vector)((Row)this.$outer.datasetWithDenseFeature().select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getAs(0)).size();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right10 = numFeatures;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with intercept without regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer1 = new LinearRegression().setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setStandardization(false).setSolver(solver);
                        LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        double interceptR = 6.298698;
                        Vector coefficientsR = Vectors$.MODULE$.dense(4.700706, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.199082}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4 $outer;
                            private final LinearRegressionModel model1$1;

                            public final void apply(Row x0$4) {
                                Row row = x0$4;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Object features = ((SeqLike)some.get()).apply(0);
                                    Object prediction1 = ((SeqLike)some.get()).apply(1);
                                    if (features instanceof DenseVector) {
                                        DenseVector denseVector = (DenseVector)features;
                                        if (prediction1 instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                            double prediction2 = denseVector.apply(0) * this.model1$1.coefficients().apply(0) + denseVector.apply(1) * this.model1$1.coefficients().apply(1) + this.model1$1.intercept();
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model1$1 = model1$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$4 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept without regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer1 = new LinearRegression().setFitIntercept(false).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setFitIntercept(false).setStandardization(false).setSolver(solver);
                        LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel modelWithoutIntercept1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeatureWithoutIntercept());
                        LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel modelWithoutIntercept2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeatureWithoutIntercept());
                        Vector coefficientsR = Vectors$.MODULE$.dense(6.973403, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.28437}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Vector coefficientsWithourInterceptR = Vectors$.MODULE$.dense(4.70011, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.19943}));
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelWithoutIntercept1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(modelWithoutIntercept1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(modelWithoutIntercept1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsWithourInterceptR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(modelWithoutIntercept1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsWithourInterceptR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelWithoutIntercept2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(modelWithoutIntercept2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(modelWithoutIntercept2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsWithourInterceptR).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(modelWithoutIntercept2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsWithourInterceptR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with intercept with L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Object apply(String solver) {
                        Object object;
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(1.0).setRegParam(0.57).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(1.0).setRegParam(0.57).setSolver(solver).setStandardization(false);
                        String string = solver;
                        String string2 = "normal";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, trainer1, trainer2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$6 $outer;
                                private final LinearRegression trainer1$1;
                                private final LinearRegression trainer2$1;

                                public final LinearRegressionModel apply() {
                                    this.trainer1$1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                    return (LinearRegressionModel)this.trainer2$1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.trainer1$1 = trainer1$1;
                                    this.trainer2$1 = trainer2$1;
                                }
                            }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        } else {
                            LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            double interceptR1 = 6.242284;
                            Vector coefficientsR1 = Vectors$.MODULE$.dense(4.019605, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.679538}));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double interceptR2 = 6.416948;
                            Vector coefficientsR2 = Vectors$.MODULE$.dense(3.893869, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.724286}));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$6 $outer;
                                private final LinearRegressionModel model1$2;

                                public final void apply(Row x0$5) {
                                    Row row = x0$5;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object features = ((SeqLike)some.get()).apply(0);
                                        Object prediction1 = ((SeqLike)some.get()).apply(1);
                                        if (features instanceof DenseVector) {
                                            DenseVector denseVector = (DenseVector)features;
                                            if (prediction1 instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                                double prediction2 = denseVector.apply(0) * this.model1$2.coefficients().apply(0) + denseVector.apply(1) * this.model1$2.coefficients().apply(1) + this.model1$2.intercept();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.model1$2 = model1$2;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ $anonfun$6 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept with L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final Object apply(String solver) {
                        Object object;
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(1.0).setRegParam(0.57).setFitIntercept(false).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(1.0).setRegParam(0.57).setFitIntercept(false).setStandardization(false).setSolver(solver);
                        String string = solver;
                        String string2 = "normal";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, trainer1, trainer2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$7$$anonfun$apply$mcV$sp$7 $outer;
                                private final LinearRegression trainer1$2;
                                private final LinearRegression trainer2$2;

                                public final LinearRegressionModel apply() {
                                    this.trainer1$2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                    return (LinearRegressionModel)this.trainer2$2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.trainer1$2 = trainer1$2;
                                    this.trainer2$2 = trainer2$2;
                                }
                            }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        } else {
                            LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            double interceptR1 = 0.0;
                            Vector coefficientsR1 = Vectors$.MODULE$.dense(6.272927, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.782604}));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).absTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double interceptR2 = 0.0;
                            Vector coefficientsR2 = Vectors$.MODULE$.dense(6.207817, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.77578}));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$7$$anonfun$apply$mcV$sp$7 $outer;
                                private final LinearRegressionModel model1$3;

                                public final void apply(Row x0$6) {
                                    Row row = x0$6;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object features = ((SeqLike)some.get()).apply(0);
                                        Object prediction1 = ((SeqLike)some.get()).apply(1);
                                        if (features instanceof DenseVector) {
                                            DenseVector denseVector = (DenseVector)features;
                                            if (prediction1 instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                                double prediction2 = denseVector.apply(0) * this.model1$3.coefficients().apply(0) + denseVector.apply(1) * this.model1$3.coefficients().apply(1) + this.model1$3.intercept();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.model1$3 = model1$3;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ $anonfun$7 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with intercept with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(0.0).setRegParam(2.3).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(0.0).setRegParam(2.3).setStandardization(false).setSolver(solver);
                        LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        double interceptR1 = 5.260103;
                        Vector coefficientsR1 = Vectors$.MODULE$.dense(3.725522, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.711203}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double interceptR2 = 5.790885;
                        Vector coefficientsR2 = Vectors$.MODULE$.dense(3.432373, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.919196}));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$8 $outer;
                            private final LinearRegressionModel model1$4;

                            public final void apply(Row x0$7) {
                                Row row = x0$7;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Object features = ((SeqLike)some.get()).apply(0);
                                    Object prediction1 = ((SeqLike)some.get()).apply(1);
                                    if (features instanceof DenseVector) {
                                        DenseVector denseVector = (DenseVector)features;
                                        if (prediction1 instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                            double prediction2 = denseVector.apply(0) * this.model1$4.coefficients().apply(0) + denseVector.apply(1) * this.model1$4.coefficients().apply(1) + this.model1$4.intercept();
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model1$4 = model1$4;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$8 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(0.0).setRegParam(2.3).setFitIntercept(false).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(0.0).setRegParam(2.3).setFitIntercept(false).setStandardization(false).setSolver(solver);
                        LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        double interceptR1 = 0.0;
                        Vector coefficientsR1 = Vectors$.MODULE$.dense(5.49343, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.223082}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).absTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double interceptR2 = 0.0;
                        Vector coefficientsR2 = Vectors$.MODULE$.dense(5.244324, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.203106}));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.01))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$9 $outer;
                            private final LinearRegressionModel model1$5;

                            public final void apply(Row x0$8) {
                                Row row = x0$8;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Object features = ((SeqLike)some.get()).apply(0);
                                    Object prediction1 = ((SeqLike)some.get()).apply(1);
                                    if (features instanceof DenseVector) {
                                        DenseVector denseVector = (DenseVector)features;
                                        if (prediction1 instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                            double prediction2 = denseVector.apply(0) * this.model1$5.coefficients().apply(0) + denseVector.apply(1) * this.model1$5.coefficients().apply(1) + this.model1$5.intercept();
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model1$5 = model1$5;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$9 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with intercept with ElasticNet regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final Object apply(String solver) {
                        Object object;
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(0.3).setRegParam(1.6).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(0.3).setRegParam(1.6).setStandardization(false).setSolver(solver);
                        String string = solver;
                        String string2 = "normal";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, trainer1, trainer2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$10 $outer;
                                private final LinearRegression trainer1$3;
                                private final LinearRegression trainer2$3;

                                public final LinearRegressionModel apply() {
                                    this.trainer1$3.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                    return (LinearRegressionModel)this.trainer2$3.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.trainer1$3 = trainer1$3;
                                    this.trainer2$3 = trainer2$3;
                                }
                            }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        } else {
                            LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            double interceptR1 = 5.689855;
                            Vector coefficientsR1 = Vectors$.MODULE$.dense(3.661181, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.000274}));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double interceptR2 = 6.11389;
                            Vector coefficientsR2 = Vectors$.MODULE$.dense(3.407021, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.152512}));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$10 $outer;
                                private final LinearRegressionModel model1$6;

                                public final void apply(Row x0$9) {
                                    Row row = x0$9;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object features = ((SeqLike)some.get()).apply(0);
                                        Object prediction1 = ((SeqLike)some.get()).apply(1);
                                        if (features instanceof DenseVector) {
                                            DenseVector denseVector = (DenseVector)features;
                                            if (prediction1 instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                                double prediction2 = denseVector.apply(0) * this.model1$6.coefficients().apply(0) + denseVector.apply(1) * this.model1$6.coefficients().apply(1) + this.model1$6.intercept();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.model1$6 = model1$6;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ $anonfun$10 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept with ElasticNet regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final Object apply(String solver) {
                        Object object;
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(0.3).setRegParam(1.6).setFitIntercept(false).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(0.3).setRegParam(1.6).setFitIntercept(false).setStandardization(false).setSolver(solver);
                        String string = solver;
                        String string2 = "normal";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, trainer1, trainer2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$11 $outer;
                                private final LinearRegression trainer1$4;
                                private final LinearRegression trainer2$4;

                                public final LinearRegressionModel apply() {
                                    this.trainer1$4.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                    return (LinearRegressionModel)this.trainer2$4.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.trainer1$4 = trainer1$4;
                                    this.trainer2$4 = trainer2$4;
                                }
                            }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        } else {
                            LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            double interceptR1 = 0.0;
                            Vector coefficientsR1 = Vectors$.MODULE$.dense(5.643748, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.331519}));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).absTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double interceptR2 = 0.0;
                            Vector coefficientsR2 = Vectors$.MODULE$.dense(5.455902, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.312266}));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.01))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$11 $outer;
                                private final LinearRegressionModel model1$7;

                                public final void apply(Row x0$10) {
                                    Row row = x0$10;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object features = ((SeqLike)some.get()).apply(0);
                                        Object prediction1 = ((SeqLike)some.get()).apply(1);
                                        if (features instanceof DenseVector) {
                                            DenseVector denseVector = (DenseVector)features;
                                            if (prediction1 instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                                double prediction2 = denseVector.apply(0) * this.model1$7.coefficients().apply(0) + denseVector.apply(1) * this.model1$7.coefficients().apply(1) + this.model1$7.intercept();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.model1$7 = model1$7;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ $anonfun$11 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression model with constant label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-9.221298, 3.394343})), Vectors$.MODULE$.dense(17.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))}));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;
                    public final Seq expected$1;

                    public final void apply(String solver) {
                        IntRef idx2 = new IntRef(0);
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1)new Serializable(this, solver, idx2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$12$$anonfun$apply$mcV$sp$12 $outer;
                            private final String solver$1;
                            private final IntRef idx$1;

                            public final void apply(boolean fitIntercept) {
                                LinearRegressionModel model1 = (LinearRegressionModel)((LinearRegression)new LinearRegression().setFitIntercept(fitIntercept).setWeightCol("weight").setPredictionCol("myPrediction")).setSolver(this.solver$1).fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithWeightConstantLabel());
                                Vector actual1 = Vectors$.MODULE$.dense(model1.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{model1.coefficients().apply(0), model1.coefficients().apply(1)}));
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)this.$outer.expected$1.apply(this.idx$1.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual1).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))");
                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithWeightConstantLabel().schema().fieldNames()).toSet().$plus((Object)model1.getPredictionCol()).subsetOf((GenSet)Predef$.MODULE$.refArrayOps((Object[])model1.summary().predictions().schema().fieldNames()).toSet()), "scala.this.Predef.refArrayOps[String](LinearRegressionSuite.this.datasetWithWeightConstantLabel.schema.fieldNames).toSet[String].+(model1.getPredictionCol).subsetOf(scala.this.Predef.refArrayOps[String](model1.summary.predictions.schema.fieldNames).toSet[String])");
                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                LinearRegressionModel model2 = (LinearRegressionModel)((LinearRegression)new LinearRegression().setFitIntercept(fitIntercept).setWeightCol("weight").setPredictionCol("myPrediction")).setSolver(this.solver$1).fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithWeightZeroLabel());
                                Vector actual2 = Vectors$.MODULE$.dense(model2.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{model2.coefficients().apply(0), model2.coefficients().apply(1)}));
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual2).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-4))");
                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithWeightZeroLabel().schema().fieldNames()).toSet().$plus((Object)model2.getPredictionCol()).subsetOf((GenSet)Predef$.MODULE$.refArrayOps((Object[])model2.summary().predictions().schema().fieldNames()).toSet()), "scala.this.Predef.refArrayOps[String](LinearRegressionSuite.this.datasetWithWeightZeroLabel.schema.fieldNames).toSet[String].+(model2.getPredictionCol).subsetOf(scala.this.Predef.refArrayOps[String](model2.summary.predictions.schema.fieldNames).toSet[String])");
                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                                ++this.idx$1.elem;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.solver$1 = solver$1;
                                this.idx$1 = idx$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$12 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$1 = expected$1;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("regularized linear regression through origin with constant label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final void apply(String solver) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1)new Serializable(this, solver){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$13$$anonfun$apply$mcV$sp$13 $outer;
                            private final String solver$2;

                            public final IllegalArgumentException apply(boolean standardization) {
                                LinearRegression model = new LinearRegression().setFitIntercept(false).setRegParam(0.1).setStandardization(standardization).setSolver(this.solver$2);
                                return (IllegalArgumentException)this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, model){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$13$$anonfun$apply$mcV$sp$13$$anonfun$apply$15 $outer;
                                    private final LinearRegression model$1;

                                    public final LinearRegressionModel apply() {
                                        return (LinearRegressionModel)this.model$1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithWeightConstantLabel());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.model$1 = model$1;
                                    }
                                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                            }

                            public /* synthetic */ $anonfun$13$$anonfun$apply$mcV$sp$13 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.solver$2 = solver$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$13 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with l-bfgs when training is not needed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$14 $outer;

                    public final void apply(boolean fitIntercept) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1)new Serializable(this, fitIntercept){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$14$$anonfun$apply$mcV$sp$14 $outer;
                            private final boolean fitIntercept$1;

                            public final void apply(boolean standardization) {
                                LinearRegressionModel model1 = (LinearRegressionModel)new LinearRegression().setFitIntercept(this.fitIntercept$1).setStandardization(standardization).setWeightCol("weight").setSolver("l-bfgs").fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithWeightConstantLabel());
                                if (this.fitIntercept$1) {
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.summary().objectiveHistory()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.summary.objectiveHistory.apply(0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-4))");
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                LinearRegressionModel model2 = (LinearRegressionModel)new LinearRegression().setFitIntercept(this.fitIntercept$1).setWeightCol("weight").setSolver("l-bfgs").fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithWeightZeroLabel());
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.summary().objectiveHistory()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.summary.objectiveHistory.apply(0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-4))");
                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.fitIntercept$1 = fitIntercept$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$14 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression model training summary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer = (LinearRegression)new LinearRegression().setSolver(solver).setPredictionCol("myPrediction");
                        LinearRegressionModel model = (LinearRegressionModel)trainer.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegression trainerNoPredictionCol = (LinearRegression)trainer.setPredictionCol("");
                        LinearRegressionModel modelNoPredictionCol = (LinearRegressionModel)trainerNoPredictionCol.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasSummary(), "model.hasSummary");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(modelNoPredictionCol.hasSummary(), "modelNoPredictionCol.hasSummary");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature().schema().fieldNames()).toSet().$plus((Object)model.getPredictionCol()).subsetOf((GenSet)Predef$.MODULE$.refArrayOps((Object[])model.summary().predictions().schema().fieldNames()).toSet()), "scala.this.Predef.refArrayOps[String](LinearRegressionSuite.this.datasetWithDenseFeature.schema.fieldNames).toSet[String].+(model.getPredictionCol).subsetOf(scala.this.Predef.refArrayOps[String](model.summary.predictions.schema.fieldNames).toSet[String])");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        String[] modelNoPredictionColFieldNames = modelNoPredictionCol.summary().predictions().schema().fieldNames();
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature().schema().fieldNames()).toSet().subsetOf((GenSet)Predef$.MODULE$.refArrayOps((Object[])modelNoPredictionColFieldNames).toSet()), "scala.this.Predef.refArrayOps[String](LinearRegressionSuite.this.datasetWithDenseFeature.schema.fieldNames).toSet[String].subsetOf(scala.this.Predef.refArrayOps[String](modelNoPredictionColFieldNames).toSet[String])");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])modelNoPredictionColFieldNames).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String s) {
                                return s.startsWith("prediction_");
                            }
                        }), "scala.this.Predef.refArrayOps[String](modelNoPredictionColFieldNames).exists(((s: String) => s.startsWith(\"prediction_\")))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature().select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).rdd().map((Function1)new Serializable(this, model){
                            public static final long serialVersionUID = 0L;
                            private final LinearRegressionModel model$2;

                            public final double apply(Row x0$11) {
                                Row row = x0$11;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Object features = ((SeqLike)some.get()).apply(0);
                                    Object label = ((SeqLike)some.get()).apply(1);
                                    if (features instanceof DenseVector) {
                                        DenseVector denseVector = (DenseVector)features;
                                        if (label instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)label);
                                            double prediction = denseVector.apply(0) * this.model$2.coefficients().apply(0) + denseVector.apply(1) * this.model$2.coefficients().apply(1) + this.model$2.intercept();
                                            double d2 = d - prediction;
                                            return d2;
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                            {
                                this.model$2 = model$2;
                            }
                        }, ClassTag$.MODULE$.Double()).zip(model.summary().residuals().rdd().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Row x$4) {
                                return x$4.getDouble(0);
                            }
                        }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double()).collect()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$15 $outer;

                            public final void apply(Tuple2<Object, Object> x0$12) {
                                Tuple2<Object, Object> tuple2 = x0$12;
                                if (tuple2 != null) {
                                    double manualResidual = tuple2._1$mcD$sp();
                                    double resultResidual = tuple2._2$mcD$sp();
                                    double d = manualResidual;
                                    double d2 = resultResidual;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d2).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(manualResidual).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(resultResidual).relTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        BoxedUnit expectedResiduals = BoxedUnit.UNIT;
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.00985449).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.summary.meanSquaredError).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.00985449).relTol(1.0E-4))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.07961668).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.summary.meanAbsoluteError).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.07961668).relTol(1.0E-4))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.9998737).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.summary.r2).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.9998737).relTol(1.0E-4))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                        String string = solver;
                        String string2 = "l-bfgs";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(model.summary().objectiveHistory()).sliding(2).forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(double[] x) {
                                    return x[0] >= x[1];
                                }
                            }), "scala.this.Predef.doubleArrayOps(model.summary.objectiveHistory).sliding(2).forall(((x: Array[Double]) => x.apply(0).>=(x.apply(1))))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                        } else {
                            double[] $org_scalatest_assert_macro_left = model.summary().objectiveHistory();
                            int $org_scalatest_assert_macro_right = 1;
                            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                            double $org_scalatest_assert_macro_left2 = model.summary().objectiveHistory()[0];
                            double $org_scalatest_assert_macro_right2 = 0.0;
                            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                            double[] devianceResidualsR = new double[]{-0.47082, 0.34635};
                            double[] seCoefR = new double[]{0.0011805, 9.044E-4, 0.00186};
                            int[] tValsR = new int[]{3980, 7961, 3388};
                            int[] pValsR = new int[]{0, 0, 0};
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().devianceResiduals()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(devianceResidualsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$15 $outer;

                                public final void apply(Tuple2<Object, Object> x) {
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(1.0E-4))");
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().coefficientStandardErrors()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(seCoefR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$15 $outer;

                                public final void apply(Tuple2<Object, Object> x) {
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(1.0E-4))");
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.doubleArrayOps(model.summary().tValues()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(double x$5) {
                                    return this.apply$mcJD$sp(x$5);
                                }

                                public long apply$mcJD$sp(double x$5) {
                                    return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(x$5));
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).zip((GenIterable)Predef$.MODULE$.wrapIntArray(tValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$15 $outer;

                                public final void apply(Tuple2<Object, Object> x) {
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)x._1$mcJ$sp()));
                                    int $org_scalatest_assert_macro_right = x._2$mcI$sp();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.doubleArrayOps(model.summary().pValues()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(double x$6) {
                                    return this.apply$mcJD$sp(x$6);
                                }

                                public long apply$mcJD$sp(double x$6) {
                                    return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(x$6));
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).zip((GenIterable)Predef$.MODULE$.wrapIntArray(pValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$15 $outer;

                                public final void apply(Tuple2<Object, Object> x) {
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)x._1$mcJ$sp()));
                                    int $org_scalatest_assert_macro_right = x._2$mcI$sp();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                    }

                    public /* synthetic */ $anonfun$15 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression model testset evaluation summary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final boolean apply(String solver) {
                        LinearRegression trainer = new LinearRegression().setSolver(solver);
                        LinearRegressionModel model = (LinearRegressionModel)trainer.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionSummary testSummary = model.evaluate(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(testSummary.meanSquaredError()).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.summary.meanSquaredError).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(testSummary.meanSquaredError).relTol(1.0E-5))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(testSummary.r2()).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.summary.r2).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(testSummary.r2).relTol(1.0E-5))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.summary().residuals().select("residuals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])testSummary.residuals().select("residuals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Row, Row> x0$13) {
                                Tuple2<Row, Row> tuple2 = x0$13;
                                if (tuple2 != null) {
                                    Object r1;
                                    Row row = (Row)tuple2._1();
                                    Row row2 = (Row)tuple2._2();
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (r1 = ((SeqLike)some.get()).apply(0)) instanceof Double) {
                                        Object r2;
                                        double d = BoxesRunTime.unboxToDouble((Object)r1);
                                        Some some2 = Row$.MODULE$.unapplySeq(row2);
                                        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (r2 = ((SeqLike)some2.get()).apply(0)) instanceof Double) {
                                            double d2 = BoxesRunTime.unboxToDouble((Object)r2);
                                            boolean bl = TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d2).relTol(1.0E-5));
                                            return bl;
                                        }
                                    }
                                }
                                throw new MatchError(tuple2);
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with weighted samples", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$17 $outer;

                    public final void apply(String solver) {
                        Seq activeData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 500, 1, 0.1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$7) {
                                return x$7.asML();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Random rnd = new Random(8392);
                        Seq signedData = (Seq)activeData.map((Function1)new Serializable(this, rnd){
                            public static final long serialVersionUID = 0L;
                            private final Random rnd$1;

                            public final Tuple2<Object, LabeledPoint> apply(LabeledPoint x0$14) {
                                LabeledPoint labeledPoint = x0$14;
                                if (labeledPoint != null) {
                                    LabeledPoint labeledPoint2 = labeledPoint;
                                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((this.rnd$1.nextGaussian() > 0.0 ? 1 : 0) != 0), (Object)labeledPoint2);
                                    return tuple2;
                                }
                                throw new MatchError((Object)labeledPoint);
                            }
                            {
                                this.rnd$1 = rnd$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq data1 = (Seq)signedData.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterator<LabeledPoint> apply(Tuple2<Object, LabeledPoint> x0$15) {
                                Tuple2<Object, LabeledPoint> tuple2;
                                block4: {
                                    Iterator iterator;
                                    block3: {
                                        block2: {
                                            tuple2 = x0$15;
                                            if (tuple2 == null) break block2;
                                            boolean bl = tuple2._1$mcZ$sp();
                                            LabeledPoint p = (LabeledPoint)tuple2._2();
                                            if (!bl) break block2;
                                            iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{p, p}));
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        boolean bl = tuple2._1$mcZ$sp();
                                        LabeledPoint p = (LabeledPoint)tuple2._2();
                                        if (bl) break block4;
                                        iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{p}));
                                    }
                                    return iterator;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq weightedSignedData = (Seq)signedData.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterator<Instance> apply(Tuple2<Object, LabeledPoint> x0$16) {
                                Tuple2<Object, LabeledPoint> tuple2;
                                block4: {
                                    Iterator iterator;
                                    block3: {
                                        block2: {
                                            tuple2 = x0$16;
                                            if (tuple2 == null) break block2;
                                            boolean bl = tuple2._1$mcZ$sp();
                                            LabeledPoint labeledPoint = (LabeledPoint)tuple2._2();
                                            if (!bl || labeledPoint == null) break block2;
                                            double label = labeledPoint.label();
                                            Vector features = labeledPoint.features();
                                            iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(label, 1.2, features), new Instance(label, 0.8, features)}));
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        boolean bl = tuple2._1$mcZ$sp();
                                        LabeledPoint labeledPoint = (LabeledPoint)tuple2._2();
                                        if (bl || labeledPoint == null) break block4;
                                        double label = labeledPoint.label();
                                        Vector features = labeledPoint.features();
                                        iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(label, 0.3, features), new Instance(label, 0.1, features), new Instance(label, 0.6, features)}));
                                    }
                                    return iterator;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq noiseData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(2.0, new double[]{1.0, 3.0}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 500, 1, 0.1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$8) {
                                return x$8.asML();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq weightedNoiseData = (Seq)noiseData.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Instance apply(LabeledPoint x0$17) {
                                LabeledPoint labeledPoint = x0$17;
                                if (labeledPoint != null) {
                                    double label = labeledPoint.label();
                                    Vector features = labeledPoint.features();
                                    Instance instance = new Instance(label, 0.0, features);
                                    return instance;
                                }
                                throw new MatchError((Object)labeledPoint);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq data2 = (Seq)weightedSignedData.$plus$plus((GenTraversableOnce)weightedNoiseData, Seq$.MODULE$.canBuildFrom());
                        JavaUniverse $u = package$.MODULE$.universe();
                        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
                        JavaUniverse $u2 = package$.MODULE$.universe();
                        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
                        Tuple2 tuple2 = new Tuple2((Object)this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().spark().createDataFrame(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().sc().parallelize(data1, 4, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                            }
                        })), (Object)this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().spark().createDataFrame(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().sc().parallelize(data2, 4, ClassTag$.MODULE$.apply(Instance.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.Instance")).asType()).toTypeConstructor();
                            }
                        })));
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            Dataset data = (Dataset)tuple2._1();
                            Dataset weightedData = (Dataset)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)data, (Object)weightedData);
                            Dataset data3 = (Dataset)tuple23._1();
                            Dataset weightedData2 = (Dataset)tuple23._2();
                            LinearRegression trainer1a = new LinearRegression().setFitIntercept(true).setElasticNetParam(0.0).setRegParam(0.21).setStandardization(true).setSolver(solver);
                            LinearRegression trainer1b = new LinearRegression().setFitIntercept(true).setWeightCol("weight").setElasticNetParam(0.0).setRegParam(0.21).setStandardization(true).setSolver(solver);
                            LinearRegressionModel model1a0 = (LinearRegressionModel)trainer1a.fit(data3);
                            LinearRegressionModel model1a1 = (LinearRegressionModel)trainer1a.fit(weightedData2);
                            LinearRegressionModel model1b = (LinearRegressionModel)trainer1b.fit(weightedData2);
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a1.coefficients()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1a0.coefficients).!~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1a1.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a0.intercept()).$bang$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a1.intercept()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1a0.intercept).!~=(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1a1.intercept).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1b.coefficients()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1a0.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1b.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a0.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1b.intercept()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1a0.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1b.intercept).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            LinearRegression trainer2a = new LinearRegression().setFitIntercept(true).setElasticNetParam(0.0).setRegParam(0.21).setStandardization(false).setSolver(solver);
                            LinearRegression trainer2b = new LinearRegression().setFitIntercept(true).setWeightCol("weight").setElasticNetParam(0.0).setRegParam(0.21).setStandardization(false).setSolver(solver);
                            LinearRegressionModel model2a0 = (LinearRegressionModel)trainer2a.fit(data3);
                            LinearRegressionModel model2a1 = (LinearRegressionModel)trainer2a.fit(weightedData2);
                            LinearRegressionModel model2b = (LinearRegressionModel)trainer2b.fit(weightedData2);
                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2a1.coefficients()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2a0.coefficients).!~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2a1.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2a0.intercept()).$bang$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2a1.intercept()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2a0.intercept).!~=(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2a1.intercept).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2b.coefficients()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2a0.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2b.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2a0.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2b.intercept()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2a0.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2b.intercept).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                            LinearRegression trainer3a = new LinearRegression().setFitIntercept(false).setElasticNetParam(0.0).setRegParam(0.21).setStandardization(true).setSolver(solver);
                            LinearRegression trainer3b = new LinearRegression().setFitIntercept(false).setWeightCol("weight").setElasticNetParam(0.0).setRegParam(0.21).setStandardization(true).setSolver(solver);
                            LinearRegressionModel model3a0 = (LinearRegressionModel)trainer3a.fit(data3);
                            LinearRegressionModel model3a1 = (LinearRegressionModel)trainer3a.fit(weightedData2);
                            LinearRegressionModel model3b = (LinearRegressionModel)trainer3b.fit(weightedData2);
                            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model3a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model3a1.coefficients()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model3a0.coefficients).!~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model3a1.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model3a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model3b.coefficients()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model3a0.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model3b.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                            LinearRegression trainer4a = new LinearRegression().setFitIntercept(false).setElasticNetParam(0.0).setRegParam(0.21).setStandardization(false).setSolver(solver);
                            LinearRegression trainer4b = new LinearRegression().setFitIntercept(false).setWeightCol("weight").setElasticNetParam(0.0).setRegParam(0.21).setStandardization(false).setSolver(solver);
                            LinearRegressionModel model4a0 = (LinearRegressionModel)trainer4a.fit(data3);
                            LinearRegressionModel model4a1 = (LinearRegressionModel)trainer4a.fit(weightedData2);
                            LinearRegressionModel model4b = (LinearRegressionModel)trainer4b.fit(weightedData2);
                            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model4a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model4a1.coefficients()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model4a0.coefficients).!~=(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model4a1.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model4a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model4b.coefficients()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model4a0.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model4b.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression model with l-bfgs with big feature datasets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegression trainer = new LinearRegression().setSolver("auto");
                LinearRegressionModel model = (LinearRegressionModel)trainer.fit(this.$outer.datasetWithSparseFeature());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasSummary(), "model.hasSummary");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(model.summary().objectiveHistory()).sliding(2).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double[] x) {
                        return x[0] >= x[1];
                    }
                }), "scala.this.Predef.doubleArrayOps(model.summary.objectiveHistory).sliding(2).forall(((x: Array[Double]) => x.apply(0).>=(x.apply(1))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression summary with weighted samples and intercept by normal solver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegressionModel model = (LinearRegressionModel)new LinearRegression().setWeightCol("weight").setSolver("normal").fit(this.$outer.datasetWithWeight());
                Vector coefficientsR = Vectors$.MODULE$.dense(new double[]{6.08, -0.6});
                double interceptR = 18.08;
                double[] devianceResidualsR = new double[]{-1.358, 1.92};
                double[] seCoefR = new double[]{5.556, 1.96, 9.608};
                double[] tValsR = new double[]{1.094, -0.306, 1.882};
                double[] pValsR = new double[]{0.471, 0.811, 0.311};
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(interceptR).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().devianceResiduals()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(devianceResidualsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().coefficientStandardErrors()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(seCoefR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().tValues()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(tValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().pValues()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(pValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression summary with weighted samples and w/o intercept by normal solver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegressionModel model = (LinearRegressionModel)new LinearRegression().setWeightCol("weight").setSolver("normal").setFitIntercept(false).fit(this.$outer.datasetWithWeight());
                Vector coefficientsR = Vectors$.MODULE$.dense(new double[]{-3.7271, 3.01});
                double interceptR = 0.0;
                double[] devianceResidualsR = new double[]{-4.6, 2.344};
                double[] seCoefR = new double[]{2.9032, 0.6022};
                double[] tValsR = new double[]{-1.284, 4.998};
                double[] pValsR = new double[]{0.3279, 0.0378};
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = interceptR;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().devianceResiduals()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(devianceResidualsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().coefficientStandardErrors()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(seCoefR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().tValues()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(tValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().pValues()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(pValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegression lr = new LinearRegression();
                this.$outer.testEstimatorAndModelReadWrite(lr, this.$outer.datasetWithWeight(), LinearRegressionSuite$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;

                    public final void apply(LinearRegressionModel model, LinearRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$checkModelData$1(LinearRegressionModel model, LinearRegressionModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = model2.intercept();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.coefficients());
                Vector $org_scalatest_assert_macro_right2 = model2.coefficients();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegression lr = new LinearRegression().setMaxIter(1);
                MLTestingUtils$.MODULE$.checkNumericTypes(lr, this.$outer.spark(), false, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$22 $outer;

                    public final void apply(LinearRegressionModel expected, LinearRegressionModel actual) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)expected.intercept()));
                        double $org_scalatest_assert_macro_right = actual.intercept();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().convertToEqualizer(expected.coefficients());
                        Vector $org_scalatest_assert_macro_right2 = actual.coefficients();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

