/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressor;
import org.apache.spark.ml.regression.RandomForestRegressorSuite$;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001b\tQ\"+\u00198e_64uN]3tiJ+wM]3tg>\u00148+^5uK*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00135A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B;uS2T!a\u0006\u0004\u0002\u000b5dG.\u001b2\n\u0005e!\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\t\u00037ui\u0011\u0001\b\u0006\u0003+\u0011I!A\b\u000f\u0003)\u0011+g-Y;miJ+\u0017\rZ,sSR,G+Z:u\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001C\u0005&\u0001\u0001\u0007\t\u0019!C\u0005M\u0005YrN\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN,\u0004gX\u00191aA*\u0012a\n\t\u0004Q-jS\"A\u0015\u000b\u0005)2\u0011a\u0001:eI&\u0011A&\u000b\u0002\u0004%\u0012#\u0005C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0005\u0003\u001d1W-\u0019;ve\u0016L!AM\u0018\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0013)\u0014aH8sI\u0016\u0014X\r\u001a'bE\u0016dW\r\u001a)pS:$8/\u000e\u0019`cA\u0002\u0004g\u0018\u0013fcR\u0011a\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0005+:LG\u000fC\u0004>g\u0005\u0005\t\u0019A\u0014\u0002\u0007a$\u0013\u0007\u0003\u0004@\u0001\u0001\u0006KaJ\u0001\u001d_J$WM]3e\u0019\u0006\u0014W\r\\3e!>Lg\u000e^:6a}\u000b\u0004\u0007\r\u0019!\u0011\u0015\t\u0005\u0001\"\u0011C\u0003%\u0011WMZ8sK\u0006cG\u000eF\u00017\u0011\u0015!\u0005\u0001\"\u0001F\u0003\u0011\u0012Xm\u001a:fgNLwN\u001c+fgR<\u0016\u000e\u001e5D_:$\u0018N\\;pkN4U-\u0019;ve\u0016\u001cHC\u0001\u001cG\u0011\u001595\t1\u0001I\u0003\t\u0011h\r\u0005\u0002$\u0013&\u0011!J\u0001\u0002\u0016%\u0006tGm\\7G_J,7\u000f\u001e*fOJ,7o]8s\u000f\u0015a%\u0001#\u0003N\u0003i\u0011\u0016M\u001c3p[\u001a{'/Z:u%\u0016<'/Z:t_J\u001cV/\u001b;f!\t\u0019cJB\u0003\u0002\u0005!%qj\u0005\u0002O\u001d!)\u0001E\u0014C\u0001#R\tQ\nC\u0003T\u001d\u0012\u0005A+A\u0006d_6\u0004\u0018M]3B!&\u001bH\u0003\u0002\u001cV/bCQA\u0016*A\u0002\u001d\nA\u0001Z1uC\")qI\u0015a\u0001\u0011\")\u0011L\u0015a\u00015\u0006\u00192-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fgB!1LX1b\u001d\t9D,\u0003\u0002^q\u00051\u0001K]3eK\u001aL!a\u00181\u0003\u00075\u000b\u0007O\u0003\u0002^qA\u0011qGY\u0005\u0003Gb\u00121!\u00138u\u0011\u001d)g*!A\u0005\n\u0019\f1B]3bIJ+7o\u001c7wKR\tq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006!A.\u00198h\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\r=\u0013'.Z2u\u0001")
public class RandomForestRegressorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private RDD<LabeledPoint> orderedLabeledPoints50_1000;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void compareAPIs(RDD<LabeledPoint> rDD, RandomForestRegressor randomForestRegressor, Map<Object, Object> map) {
        RandomForestRegressorSuite$.MODULE$.compareAPIs(rDD, randomForestRegressor, map);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    private RDD<LabeledPoint> orderedLabeledPoints50_1000() {
        return this.orderedLabeledPoints50_1000;
    }

    private void orderedLabeledPoints50_1000_$eq(RDD<LabeledPoint> x$1) {
        this.orderedLabeledPoints50_1000 = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        Seq x$3 = (Seq)Predef$.MODULE$.refArrayOps((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                return x$1.asML();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        int x$4 = qual$1.parallelize$default$2();
        this.orderedLabeledPoints50_1000_$eq((RDD<LabeledPoint>)qual$1.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public void regressionTestWithContinuousFeatures(RandomForestRegressor rf) {
        Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
        RandomForestRegressor newRF = rf.setImpurity("variance").setMaxDepth(2).setMaxBins(10).setNumTrees(1).setFeatureSubsetStrategy("auto").setSeed(123L);
        RandomForestRegressorSuite$.MODULE$.compareAPIs(this.orderedLabeledPoints50_1000(), newRF, (Map<Object, Object>)categoricalFeaturesInfo);
    }

    public RandomForestRegressorSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("Regression with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestRegressor rf = new RandomForestRegressor();
                this.$outer.regressionTestWithContinuousFeatures(rf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression with continuous features and node Id cache : comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestRegressor rf = new RandomForestRegressor().setCacheNodeIds(true);
                this.$outer.regressionTestWithContinuousFeatures(rf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Feature importance with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestRegressor rf = new RandomForestRegressor().setImpurity("variance").setMaxDepth(3).setNumTrees(3).setFeatureSubsetStrategy("all").setSubsamplingRate(1.0).setSeed(123L);
                RDD<LabeledPoint> data = TreeTests$.MODULE$.featureImportanceData(this.$outer.sc());
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Dataset<Row> df = TreeTests$.MODULE$.setMetadata(data, (Map<Object, Object>)categoricalFeatures, 0);
                RandomForestRegressionModel model = (RandomForestRegressionModel)rf.fit(df);
                Vector importances = model.featureImportances();
                int mostImportantFeature = importances.argmax();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mostImportantFeature));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(importances.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(importances.toArray()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$2) {
                        return this.apply$mcZD$sp(x$2);
                    }

                    public boolean apply$mcZD$sp(double x$2) {
                        return x$2 >= 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(importances.toArray).forall(((x$2: Double) => x$2.>=(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestRegressor rf = new RandomForestRegressor().setMaxDepth(1);
                MLTestingUtils$.MODULE$.checkNumericTypes(rf, this.$outer.spark(), false, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(RandomForestRegressionModel expected, RandomForestRegressionModel actual) {
                        TreeTests$.MODULE$.checkEqual(expected, actual);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestRegressor rf = new RandomForestRegressor().setNumTrees(2);
                RDD<LabeledPoint> rdd = TreeTests$.MODULE$.getTreeReadWriteData(this.$outer.sc());
                Map allParamSettings = TreeTests$.MODULE$.allParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"impurity"), (Object)"variance")})));
                Dataset<Row> continuousData = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), 0);
                this.$outer.testEstimatorAndModelReadWrite(rf, continuousData, (Map<String, Object>)allParamSettings, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(RandomForestRegressionModel model, RandomForestRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$RandomForestRegressorSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$regression$RandomForestRegressorSuite$$anonfun$$checkModelData$1(RandomForestRegressionModel model, RandomForestRegressionModel model2) {
                TreeTests$.MODULE$.checkEqual(model, model2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right = model2.numFeatures();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

