/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.source.libsvm.LibSVMRelationSuite$;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001\u001f\t\u0019B*\u001b2T-6\u0013V\r\\1uS>t7+^5uK*\u00111\u0001B\u0001\u0007Y&\u00147O^7\u000b\u0005\u00151\u0011AB:pkJ\u001cWM\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011)A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012\u0001B;uS2T!!\u0007\u0005\u0002\u000b5dG.\u001b2\n\u0005m1\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tA\u0011B\t\u0001A\u0002\u0003\u0007I\u0011A\u0012\u0002\tA\fG\u000f[\u000b\u0002IA\u0011Qe\u000b\b\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!fJ\u0001\u0007!J,G-\u001a4\n\u00051j#AB*ue&twM\u0003\u0002+O!Iq\u0006\u0001a\u0001\u0002\u0004%\t\u0001M\u0001\ta\u0006$\bn\u0018\u0013fcR\u0011\u0011\u0007\u000e\t\u0003MIJ!aM\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bk9\n\t\u00111\u0001%\u0003\rAH%\r\u0005\u0007o\u0001\u0001\u000b\u0015\u0002\u0013\u0002\u000bA\fG\u000f\u001b\u0011\t\u000be\u0002A\u0011\t\u001e\u0002\u0013\t,gm\u001c:f\u00032dG#A\u0019\t\u000bq\u0002A\u0011\t\u001e\u0002\u0011\u00054G/\u001a:BY2\u0004")
public class LibSVMRelationSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private String path;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public String path() {
        return this.path;
    }

    public void path_$eq(String x$1) {
        this.path = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        String lines = new StringOps(Predef$.MODULE$.augmentString("\n        |1 1:1.0 3:2.0 5:3.0\n        |0\n        |0 2:4.0 4:5.0 6:6.0\n      ")).stripMargin();
        File dir = Utils$.MODULE$.createDirectory(this.tempDir().getCanonicalPath(), "data");
        File file = new File(dir, "part-00000");
        Files.write((CharSequence)lines, (File)file, (Charset)StandardCharsets.UTF_8);
        this.path_$eq(dir.toURI().toString());
    }

    @Override
    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(new File(this.path()));
            return;
        }
        finally {
            MLlibTestSparkContext$class.afterAll(this);
        }
    }

    public LibSVMRelationSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("select as sparse vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector v;
                Dataset df = this.$outer.spark().read().format("libsvm").load(this.$outer.path());
                String $org_scalatest_assert_macro_left = df.columns()[0];
                String $org_scalatest_assert_macro_right = "label";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = df.columns()[1];
                String $org_scalatest_assert_macro_right2 = "features";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Row row1 = (Row)df.first();
                double $org_scalatest_assert_macro_left3 = row1.getDouble(0);
                double $org_scalatest_assert_macro_right3 = 1.0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                SparseVector $org_scalatest_assert_macro_left4 = v = (SparseVector)row1.getAs(1);
                Vector $org_scalatest_assert_macro_right4 = Vectors$.MODULE$.sparse(6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0), new Tuple2.mcID.sp(4, 3.0)})));
                SparseVector sparseVector = $org_scalatest_assert_macro_left4;
                Vector vector = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("select as dense vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector v;
                Dataset df = this.$outer.spark().read().format("libsvm").options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"vectorType"), (Object)"dense")}))).load(this.$outer.path());
                String $org_scalatest_assert_macro_left = df.columns()[0];
                String $org_scalatest_assert_macro_right = "label";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = df.columns()[1];
                String $org_scalatest_assert_macro_right2 = "features";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                long $org_scalatest_assert_macro_left3 = df.count();
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Row row1 = (Row)df.first();
                double $org_scalatest_assert_macro_left4 = row1.getDouble(0);
                double $org_scalatest_assert_macro_right4 = 1.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                DenseVector $org_scalatest_assert_macro_left5 = v = (DenseVector)row1.getAs(1);
                Vector $org_scalatest_assert_macro_right5 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 0.0, 3.0, 0.0}));
                DenseVector denseVector = $org_scalatest_assert_macro_left5;
                Vector vector = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(denseVector != null ? !denseVector.equals(vector) : vector != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("select a vector with specifying the longer dimension", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector v;
                Dataset df = this.$outer.spark().read().option("numFeatures", "100").format("libsvm").load(this.$outer.path());
                Row row1 = (Row)df.first();
                SparseVector $org_scalatest_assert_macro_left = v = (SparseVector)row1.getAs(1);
                Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(100, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0), new Tuple2.mcID.sp(4, 3.0)})));
                SparseVector sparseVector = $org_scalatest_assert_macro_left;
                Vector vector = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("write libsvm data and read it again", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector v;
                Dataset df = this.$outer.spark().read().format("libsvm").load(this.$outer.path());
                File tempDir2 = new File(this.$outer.tempDir(), "read_write_test");
                String writepath = tempDir2.toURI().toString();
                df.coalesce(1).write().format("libsvm").mode(SaveMode.Overwrite).save(writepath);
                Dataset df2 = this.$outer.spark().read().format("libsvm").load(writepath);
                Row row1 = (Row)df2.first();
                SparseVector $org_scalatest_assert_macro_left = v = (SparseVector)row1.getAs(1);
                Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0), new Tuple2.mcID.sp(4, 3.0)})));
                SparseVector sparseVector = $org_scalatest_assert_macro_left;
                Vector vector = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("write libsvm data failed due to invalid schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = this.$outer.spark().read().format("text").load(this.$outer.path());
                this.$outer.intercept((Function0)new Serializable(this, df){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final Dataset df$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.df$1.write().format("libsvm").save(new StringBuilder().append((Object)this.$outer.org$apache$spark$ml$source$libsvm$LibSVMRelationSuite$$anonfun$$$outer().path()).append((Object)"_2").toString());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.df$1 = df$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }

            public /* synthetic */ LibSVMRelationSuite org$apache$spark$ml$source$libsvm$LibSVMRelationSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("select features from libsvm relation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = this.$outer.spark().read().format("libsvm").load(this.$outer.path());
                df.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Row x0$1) {
                        Object d;
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (d = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                            Vector vector;
                            Vector vector2 = vector = (Vector)d;
                            return vector2;
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).first();
                df.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

