/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.tree.impl.BaggedPoint;
import org.apache.spark.ml.tree.impl.BaggedPoint$;
import org.apache.spark.ml.tree.impl.BaggedPointSuite$;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00052A!\u0001\u0002\u0001\u001f\t\u0001\")Y4hK\u0012\u0004v.\u001b8u'VLG/\u001a\u0006\u0003\u0007\u0011\tA![7qY*\u0011QAB\u0001\u0005iJ,WM\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011)A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012\u0001B;uS2T!!\u0007\u0005\u0002\u000b5dG.\u001b2\n\u0005m1\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\t\u0001")
public class BaggedPointSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public BaggedPointSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("BaggedPoint RDD: without subsampling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaggedPointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000);
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$9 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$10 = qual$1.parallelize$default$2();
                RDD rdd = qual$1.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(rdd, 1.0, 1, false, 42L);
                Predef$.MODULE$.refArrayOps((Object[])baggedRDD.collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(BaggedPoint<LabeledPoint> baggedPoint) {
                        Bool bool;
                        ArrayOps $org_scalatest_assert_macro_left = Predef$.MODULE$.doubleArrayOps(baggedPoint.subsampleWeights());
                        int $org_scalatest_assert_macro_right = 1;
                        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                        if ($org_scalatest_assert_macro_left2.value()) {
                            double $org_scalatest_assert_macro_left3 = baggedPoint.subsampleWeights()[0];
                            int $org_scalatest_assert_macro_right2 = 1;
                            bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == (double)$org_scalatest_assert_macro_right2);
                        } else {
                            bool = Bool$.MODULE$.simpleMacroBool(false, "");
                        }
                        Bool $org_scalatest_assert_macro_right3 = bool;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                        this.$outer.org$apache$spark$ml$tree$impl$BaggedPointSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ BaggedPointSuite org$apache$spark$ml$tree$impl$BaggedPointSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("BaggedPoint RDD: with subsampling with replacement (fraction = 1.0)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaggedPointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numSubsamples = 100;
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(1.0, 1.0);
                if (sp2 != null) {
                    Tuple2.mcDD.sp sp3;
                    double expectedMean = sp2._1$mcD$sp();
                    double expectedStddev = sp2._2$mcD$sp();
                    Tuple2.mcDD.sp sp4 = sp3 = new Tuple2.mcDD.sp(expectedMean, expectedStddev);
                    double expectedMean2 = sp4._1$mcD$sp();
                    double expectedStddev2 = sp4._2$mcD$sp();
                    int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
                    LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000);
                    SparkContext qual$2 = this.$outer.sc();
                    WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                    int x$12 = qual$2.parallelize$default$2();
                    RDD rdd = qual$2.parallelize((Seq)x$11, x$12, ClassTag$.MODULE$.apply(LabeledPoint.class));
                    Predef$.MODULE$.intArrayOps(seeds).foreach((Function1)new Serializable(this, numSubsamples, expectedMean2, expectedStddev2, rdd){
                        public static final long serialVersionUID = 0L;
                        private final int numSubsamples$1;
                        private final double expectedMean$1;
                        private final double expectedStddev$1;
                        private final RDD rdd$1;

                        public final void apply(int seed) {
                            this.apply$mcVI$sp(seed);
                        }

                        public void apply$mcVI$sp(int seed) {
                            RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(this.rdd$1, 1.0, this.numSubsamples$1, true, (long)seed);
                            double[][] subsampleCounts = (double[][])baggedRDD.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double[] apply(BaggedPoint<LabeledPoint> x$2) {
                                    return x$2.subsampleWeights();
                                }
                            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).collect();
                            EnsembleTestHelper$.MODULE$.testRandomArrays(subsampleCounts, this.numSubsamples$1, this.expectedMean$1, this.expectedStddev$1, 0.01);
                        }
                        {
                            this.numSubsamples$1 = numSubsamples$1;
                            this.expectedMean$1 = expectedMean$1;
                            this.expectedStddev$1 = expectedStddev$1;
                            this.rdd$1 = rdd$1;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)sp2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("BaggedPoint RDD: with subsampling with replacement (fraction = 0.5)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaggedPointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numSubsamples = 100;
                double subsample = 0.5;
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(subsample, package$.MODULE$.sqrt(subsample));
                if (sp2 != null) {
                    Tuple2.mcDD.sp sp3;
                    double expectedMean = sp2._1$mcD$sp();
                    double expectedStddev = sp2._2$mcD$sp();
                    Tuple2.mcDD.sp sp4 = sp3 = new Tuple2.mcDD.sp(expectedMean, expectedStddev);
                    double expectedMean2 = sp4._1$mcD$sp();
                    double expectedStddev2 = sp4._2$mcD$sp();
                    int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
                    LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000);
                    SparkContext qual$3 = this.$outer.sc();
                    WrappedArray x$13 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                    int x$14 = qual$3.parallelize$default$2();
                    RDD rdd = qual$3.parallelize((Seq)x$13, x$14, ClassTag$.MODULE$.apply(LabeledPoint.class));
                    Predef$.MODULE$.intArrayOps(seeds).foreach((Function1)new Serializable(this, numSubsamples, subsample, expectedMean2, expectedStddev2, rdd){
                        public static final long serialVersionUID = 0L;
                        private final int numSubsamples$2;
                        private final double subsample$1;
                        private final double expectedMean$2;
                        private final double expectedStddev$2;
                        private final RDD rdd$2;

                        public final void apply(int seed) {
                            this.apply$mcVI$sp(seed);
                        }

                        public void apply$mcVI$sp(int seed) {
                            RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(this.rdd$2, this.subsample$1, this.numSubsamples$2, true, (long)seed);
                            double[][] subsampleCounts = (double[][])baggedRDD.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double[] apply(BaggedPoint<LabeledPoint> x$4) {
                                    return x$4.subsampleWeights();
                                }
                            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).collect();
                            EnsembleTestHelper$.MODULE$.testRandomArrays(subsampleCounts, this.numSubsamples$2, this.expectedMean$2, this.expectedStddev$2, 0.01);
                        }
                        {
                            this.numSubsamples$2 = numSubsamples$2;
                            this.subsample$1 = subsample$1;
                            this.expectedMean$2 = expectedMean$2;
                            this.expectedStddev$2 = expectedStddev$2;
                            this.rdd$2 = rdd$2;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)sp2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("BaggedPoint RDD: with subsampling without replacement (fraction = 1.0)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaggedPointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numSubsamples = 100;
                Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(1.0, 0);
                if (sp2 != null) {
                    Tuple2.mcDI.sp sp3;
                    double expectedMean = sp2._1$mcD$sp();
                    int expectedStddev = sp2._2$mcI$sp();
                    Tuple2.mcDI.sp sp4 = sp3 = new Tuple2.mcDI.sp(expectedMean, expectedStddev);
                    double expectedMean2 = sp4._1$mcD$sp();
                    int expectedStddev2 = sp4._2$mcI$sp();
                    int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
                    LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000);
                    SparkContext qual$4 = this.$outer.sc();
                    WrappedArray x$15 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                    int x$16 = qual$4.parallelize$default$2();
                    RDD rdd = qual$4.parallelize((Seq)x$15, x$16, ClassTag$.MODULE$.apply(LabeledPoint.class));
                    Predef$.MODULE$.intArrayOps(seeds).foreach((Function1)new Serializable(this, numSubsamples, expectedMean2, expectedStddev2, rdd){
                        public static final long serialVersionUID = 0L;
                        private final int numSubsamples$3;
                        private final double expectedMean$3;
                        private final int expectedStddev$3;
                        private final RDD rdd$3;

                        public final void apply(int seed) {
                            this.apply$mcVI$sp(seed);
                        }

                        public void apply$mcVI$sp(int seed) {
                            RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(this.rdd$3, 1.0, this.numSubsamples$3, false, (long)seed);
                            double[][] subsampleCounts = (double[][])baggedRDD.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double[] apply(BaggedPoint<LabeledPoint> x$6) {
                                    return x$6.subsampleWeights();
                                }
                            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).collect();
                            EnsembleTestHelper$.MODULE$.testRandomArrays(subsampleCounts, this.numSubsamples$3, this.expectedMean$3, this.expectedStddev$3, 0.01);
                        }
                        {
                            this.numSubsamples$3 = numSubsamples$3;
                            this.expectedMean$3 = expectedMean$3;
                            this.expectedStddev$3 = expectedStddev$3;
                            this.rdd$3 = rdd$3;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)sp2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("BaggedPoint RDD: with subsampling without replacement (fraction = 0.5)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaggedPointSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numSubsamples = 100;
                double subsample = 0.5;
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(subsample, package$.MODULE$.sqrt(subsample * (1.0 - subsample)));
                if (sp2 != null) {
                    Tuple2.mcDD.sp sp3;
                    double expectedMean = sp2._1$mcD$sp();
                    double expectedStddev = sp2._2$mcD$sp();
                    Tuple2.mcDD.sp sp4 = sp3 = new Tuple2.mcDD.sp(expectedMean, expectedStddev);
                    double expectedMean2 = sp4._1$mcD$sp();
                    double expectedStddev2 = sp4._2$mcD$sp();
                    int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
                    LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(1, 1000);
                    SparkContext qual$5 = this.$outer.sc();
                    WrappedArray x$17 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                    int x$18 = qual$5.parallelize$default$2();
                    RDD rdd = qual$5.parallelize((Seq)x$17, x$18, ClassTag$.MODULE$.apply(LabeledPoint.class));
                    Predef$.MODULE$.intArrayOps(seeds).foreach((Function1)new Serializable(this, numSubsamples, subsample, expectedMean2, expectedStddev2, rdd){
                        public static final long serialVersionUID = 0L;
                        private final int numSubsamples$4;
                        private final double subsample$2;
                        private final double expectedMean$4;
                        private final double expectedStddev$4;
                        private final RDD rdd$4;

                        public final void apply(int seed) {
                            this.apply$mcVI$sp(seed);
                        }

                        public void apply$mcVI$sp(int seed) {
                            RDD baggedRDD = BaggedPoint$.MODULE$.convertToBaggedRDD(this.rdd$4, this.subsample$2, this.numSubsamples$4, false, (long)seed);
                            double[][] subsampleCounts = (double[][])baggedRDD.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double[] apply(BaggedPoint<LabeledPoint> x$8) {
                                    return x$8.subsampleWeights();
                                }
                            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).collect();
                            EnsembleTestHelper$.MODULE$.testRandomArrays(subsampleCounts, this.numSubsamples$4, this.expectedMean$4, this.expectedStddev$4, 0.01);
                        }
                        {
                            this.numSubsamples$4 = numSubsamples$4;
                            this.subsample$2 = subsample$2;
                            this.expectedMean$4 = expectedMean$4;
                            this.expectedStddev$4 = expectedStddev$4;
                            this.rdd$4 = rdd$4;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)sp2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

