/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.LearningNode;
import org.apache.spark.ml.tree.LearningNode$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.impl.BaggedPoint$;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.tree.impl.RandomForest;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.tree.impl.RandomForestSuite$;
import org.apache.spark.ml.tree.impl.RandomForestSuite$$anonfun$org$apache$spark$ml$tree$impl$RandomForestSuite$;
import org.apache.spark.ml.tree.impl.RandomForestSuite$$anonfun$org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1$1$;
import org.apache.spark.ml.tree.impl.TreePoint$;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.GiniCalculator;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.collection.OpenHashMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001f\t\t\"+\u00198e_64uN]3tiN+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001B5na2T!!\u0002\u0004\u0002\tQ\u0014X-\u001a\u0006\u0003\u000f!\t!!\u001c7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Q\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0003vi&d'BA\r\t\u0003\u0015iG\u000e\\5c\u0013\tYbCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012\u0001\t\u0003\u0019\u0013a\u00112j]\u0006\u0014\u0018p\u00117bgNLg-[2bi&|g\u000eV3ti^KG\u000f[\"p]RLg.^8vg\u001a+\u0017\r^;sKN\fe\u000eZ*vEN\fW\u000e\u001d7fI\u001a+\u0017\r^;sKN$\"\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006W\u0005\u0002\r\u0001L\u0001\tgR\u0014\u0018\r^3hsB\u0011Q&M\u0007\u0002])\u0011q\u0006M\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005\u0015A\u0012B\u0001\u001a/\u0005!\u0019FO]1uK\u001eLx!\u0002\u001b\u0003\u0011\u0013)\u0014!\u0005*b]\u0012|WNR8sKN$8+^5uKB\u0011\u0001E\u000e\u0004\u0006\u0003\tAIaN\n\u0004maZ\u0004CA\u0013:\u0013\tQdE\u0001\u0004B]f\u0014VM\u001a\t\u0003KqJ!!\u0010\u0014\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bu1D\u0011A \u0015\u0003UBQ!\u0011\u001c\u0005\u0002\t\u000b\u0001\"\\1q)>4Vm\u0019\u000b\u0003\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0004\u0002\r1Lg.\u00197h\u0013\tAUI\u0001\u0004WK\u000e$xN\u001d\u0005\u0006\u0015\u0002\u0003\raS\u0001\u0004[\u0006\u0004\b\u0003\u0002'P%Vs!!J'\n\u000593\u0013A\u0002)sK\u0012,g-\u0003\u0002Q#\n\u0019Q*\u00199\u000b\u000593\u0003CA\u0013T\u0013\t!fEA\u0002J]R\u0004\"!\n,\n\u0005]3#A\u0002#pk\ndW\rC\u0004Zm\u0005\u0005I\u0011\u0002.\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u00027B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0005Y\u0006twMC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\tl&AB(cU\u0016\u001cG\u000f")
public class RandomForestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Vector mapToVec(Map<Object, Object> map) {
        return RandomForestSuite$.MODULE$.mapToVec(map);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public void binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(Strategy strategy) {
        int numFeatures = 50;
        org.apache.spark.mllib.regression.LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(numFeatures, 1000);
        SparkContext qual$10 = this.sc();
        WrappedArray x$154 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$155 = qual$10.parallelize$default$2();
        RDD rdd = qual$10.parallelize((Seq)x$154, x$155, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$10) {
                return x$10.asML();
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(1, "auto", numFeatures, strategy, numFeatures, rdd);
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(1, "all", numFeatures, strategy, numFeatures, rdd);
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(1, "sqrt", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), strategy, numFeatures, rdd);
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(1, "log2", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))), strategy, numFeatures, rdd);
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(1, "onethird", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0)), strategy, numFeatures, rdd);
        String[] realStrategies = (String[])((Object[])new String[]{".1", ".10", "0.10", "0.1", "0.9", "1.0"});
        Predef$.MODULE$.refArrayOps((Object[])realStrategies).foreach((Function1)new Serializable(this, strategy, numFeatures, rdd){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;
            private final Strategy strategy$1;
            private final int numFeatures$1;
            private final RDD rdd$1;

            public final void apply(String strategy) {
                int expected = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(strategy)).toDouble() * (double)this.numFeatures$1));
                this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(1, strategy, expected, this.strategy$1, this.numFeatures$1, this.rdd$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.strategy$1 = strategy$1;
                this.numFeatures$1 = numFeatures$1;
                this.rdd$1 = rdd$1;
            }
        });
        String[] integerStrategies = (String[])((Object[])new String[]{"1", "10", "100", "1000", "10000"});
        Predef$.MODULE$.refArrayOps((Object[])integerStrategies).foreach((Function1)new Serializable(this, strategy, numFeatures, rdd){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;
            private final Strategy strategy$1;
            private final int numFeatures$1;
            private final RDD rdd$1;

            public final void apply(String strategy) {
                int expected = new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() < this.numFeatures$1 ? new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() : this.numFeatures$1;
                this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(1, strategy, expected, this.strategy$1, this.numFeatures$1, this.rdd$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.strategy$1 = strategy$1;
                this.numFeatures$1 = numFeatures$1;
                this.rdd$1 = rdd$1;
            }
        });
        String[] invalidStrategies = (String[])((Object[])new String[]{"-.1", "-.10", "-0.10", ".0", "0.0", "1.1", "0"});
        Predef$.MODULE$.refArrayOps((Object[])invalidStrategies).foreach((Function1)new Serializable(this, strategy, rdd){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;
            public final Strategy strategy$1;
            public final RDD rdd$1;

            public final IllegalArgumentException apply(String invalidStrategy) {
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this, invalidStrategy){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$3 $outer;
                    private final String invalidStrategy$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        DecisionTreeMetadata decisionTreeMetadata = DecisionTreeMetadata$.MODULE$.buildMetadata(this.$outer.rdd$1, this.$outer.strategy$1, 1, this.invalidStrategy$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.invalidStrategy$1 = invalidStrategy$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.strategy$1 = strategy$1;
                this.rdd$1 = rdd$1;
            }
        });
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(2, "all", numFeatures, strategy, numFeatures, rdd);
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(2, "auto", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), strategy, numFeatures, rdd);
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(2, "sqrt", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), strategy, numFeatures, rdd);
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(2, "log2", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))), strategy, numFeatures, rdd);
        this.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(2, "onethird", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0)), strategy, numFeatures, rdd);
        Predef$.MODULE$.refArrayOps((Object[])realStrategies).foreach((Function1)new Serializable(this, strategy, numFeatures, rdd){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;
            private final Strategy strategy$1;
            private final int numFeatures$1;
            private final RDD rdd$1;

            public final void apply(String strategy) {
                int expected = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(strategy)).toDouble() * (double)this.numFeatures$1));
                this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(2, strategy, expected, this.strategy$1, this.numFeatures$1, this.rdd$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.strategy$1 = strategy$1;
                this.numFeatures$1 = numFeatures$1;
                this.rdd$1 = rdd$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])integerStrategies).foreach((Function1)new Serializable(this, strategy, numFeatures, rdd){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;
            private final Strategy strategy$1;
            private final int numFeatures$1;
            private final RDD rdd$1;

            public final void apply(String strategy) {
                int expected = new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() < this.numFeatures$1 ? new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() : this.numFeatures$1;
                this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(2, strategy, expected, this.strategy$1, this.numFeatures$1, this.rdd$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.strategy$1 = strategy$1;
                this.numFeatures$1 = numFeatures$1;
                this.rdd$1 = rdd$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])invalidStrategies).foreach((Function1)new Serializable(this, strategy, rdd){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;
            public final Strategy strategy$1;
            public final RDD rdd$1;

            public final IllegalArgumentException apply(String invalidStrategy) {
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this, invalidStrategy){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$6 $outer;
                    private final String invalidStrategy$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        DecisionTreeMetadata decisionTreeMetadata = DecisionTreeMetadata$.MODULE$.buildMetadata(this.$outer.rdd$1, this.$outer.strategy$1, 2, this.invalidStrategy$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.invalidStrategy$2 = invalidStrategy$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.strategy$1 = strategy$1;
                this.rdd$1 = rdd$1;
            }
        });
    }

    public final void org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1(int numTrees, String featureSubsetStrategy, int numFeaturesPerNode, Strategy strategy$1, int numFeatures$1, RDD rdd$1) {
        int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
        long maxMemoryUsage = 0x8000000L;
        DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd$1, strategy$1, numTrees, featureSubsetStrategy);
        Predef$.MODULE$.intArrayOps(seeds).foreach((Function1)new Serializable(this, numFeatures$1, numTrees, featureSubsetStrategy, numFeaturesPerNode, maxMemoryUsage, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;
            private final int numFeatures$1;
            private final int numTrees$1;
            private final String featureSubsetStrategy$1;
            public final int numFeaturesPerNode$1;
            private final long maxMemoryUsage$1;
            private final DecisionTreeMetadata metadata$1;

            public final void apply(int seed) {
                this.apply$mcVI$sp(seed);
            }

            public void apply$mcVI$sp(int seed) {
                String failString = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed on test with:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numTrees=", ", featureSubsetStrategy=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees$1), this.featureSubsetStrategy$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numFeaturesPerNode=", ", seed=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numFeaturesPerNode$1), BoxesRunTime.boxToInteger((int)seed)}))).toString();
                Queue nodeQueue = new Queue();
                LearningNode[] topNodes = new LearningNode[this.numTrees$1];
                scala.package$.MODULE$.Range().apply(0, this.numTrees$1).foreach$mVc$sp((Function1)new Serializable(this, nodeQueue, topNodes){
                    public static final long serialVersionUID = 0L;
                    private final Queue nodeQueue$1;
                    private final LearningNode[] topNodes$1;

                    public final void apply(int treeIndex) {
                        this.apply$mcVI$sp(treeIndex);
                    }

                    public void apply$mcVI$sp(int treeIndex) {
                        this.topNodes$1[treeIndex] = LearningNode$.MODULE$.emptyNode(1);
                        this.nodeQueue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)this.topNodes$1[treeIndex])}));
                    }
                    {
                        this.nodeQueue$1 = nodeQueue$1;
                        this.topNodes$1 = topNodes$1;
                    }
                });
                Random rng = new Random(seed);
                Tuple2 tuple2 = RandomForest$.MODULE$.selectNodesToSplit(nodeQueue, this.maxMemoryUsage$1, this.metadata$1, rng);
                if (tuple2 != null) {
                    Map nodesForGroup = (Map)tuple2._1();
                    Map treeToNodeToIndexInfo = (Map)tuple2._2();
                    if (nodesForGroup != null) {
                        Map map = nodesForGroup;
                        if (treeToNodeToIndexInfo != null) {
                            Tuple2 tuple22;
                            Map map2 = treeToNodeToIndexInfo;
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)map, (Object)map2);
                            Map nodesForGroup2 = (Map)tuple23._1();
                            Map treeToNodeToIndexInfo2 = (Map)tuple23._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)nodesForGroup2.size()));
                            int $org_scalatest_assert_macro_right = this.numTrees$1;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)failString);
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(nodesForGroup2.values().forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(LearningNode[] x$12) {
                                    return x$12.length == 1;
                                }
                            }), "nodesForGroup.values.forall(((x$12: Array[org.apache.spark.ml.tree.LearningNode]) => x$12.length.==(1)))");
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)failString);
                            if (this.numFeaturesPerNode$1 == this.numFeatures$1) {
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(treeToNodeToIndexInfo2.values().forall((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Map<Object, RandomForest.NodeIndexInfo> x$13) {
                                        return x$13.values().forall((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(RandomForest.NodeIndexInfo x$14) {
                                                return x$14.featureSubset().isEmpty();
                                            }
                                        });
                                    }
                                }), "treeToNodeToIndexInfo.values.forall(((x$13: Map[Int,org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo]) => x$13.values.forall(((x$14: org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo) => x$14.featureSubset.isEmpty))))");
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)failString);
                            } else {
                                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(treeToNodeToIndexInfo2.values().forall((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1$1 $outer;

                                    public final boolean apply(Map<Object, RandomForest.NodeIndexInfo> x$15) {
                                        return x$15.values().forall((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1$1$$anonfun$29 $outer;

                                            public final boolean apply(RandomForest.NodeIndexInfo x$16) {
                                                return this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)((int[])x$16.featureSubset().get()).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$anonfun$$$outer().numFeaturesPerNode$1), Equality$.MODULE$.default());
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }

                                    public /* synthetic */ $anonfun$org$apache$spark$ml$tree$impl$RandomForestSuite$$checkFeatureSubsetStrategy$1$1 org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }), "treeToNodeToIndexInfo.values.forall(((x$15: Map[Int,org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo]) => x$15.values.forall(((x$16: org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo) => RandomForestSuite.this.convertToEqualizer[Int](x$16.featureSubset.get.length).===(numFeaturesPerNode)(scalactic.this.Equality.default[Int])))))");
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)failString);
                            }
                            return;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ RandomForestSuite org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numFeatures$1 = numFeatures$1;
                this.numTrees$1 = numTrees$1;
                this.featureSubsetStrategy$1 = featureSubsetStrategy$1;
                this.numFeaturesPerNode$1 = numFeaturesPerNode$1;
                this.maxMemoryUsage$1 = maxMemoryUsage$1;
                this.metadata$1 = metadata$1;
            }
        });
    }

    public RandomForestSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Binary classification with continuous features: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                        return x$1.asML();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$19 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$20 = qual$1.parallelize$default$2();
                RDD rdd = qual$1.parallelize((Seq)x$19, x$20, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
                int $org_scalatest_assert_macro_right3 = 99;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with binary (ordered) categorical features: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$2) {
                        return x$2.asML();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$21 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$22 = qual$2.parallelize$default$2();
                RDD rdd = qual$2.parallelize((Seq)x$21, x$22, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$23 = Algo$.MODULE$.Classification();
                Gini$ x$24 = Gini$.MODULE$;
                int x$25 = 2;
                int x$26 = 2;
                int x$27 = 100;
                Map x$28 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                Enumeration.Value x$29 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$30 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$31 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$32 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$33 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$34 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$35 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$23, (Impurity)x$24, x$25, x$26, x$27, x$29, x$28, x$30, x$31, x$32, x$33, x$34, x$35);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with 3-ary (ordered) categorical features, with no samples for one category: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$3) {
                        return x$3.asML();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$36 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$37 = qual$3.parallelize$default$2();
                RDD rdd = qual$3.parallelize((Seq)x$36, x$37, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$38 = Algo$.MODULE$.Classification();
                Gini$ x$39 = Gini$.MODULE$;
                int x$40 = 2;
                int x$41 = 2;
                int x$42 = 100;
                Map x$43 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$44 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$45 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$46 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$47 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$48 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$49 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$50 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$38, (Impurity)x$39, x$40, x$41, x$42, x$44, x$43, x$45, x$46, x$47, x$48, x$49, x$50);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("find splits for a continuous feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeMetadata fakeMetadata = new DecisionTreeMetadata(1, 0L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{6}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
                double[] featureSamples = (double[])Array$.MODULE$.fill(200000, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return package$.MODULE$.random();
                    }
                }, ClassTag$.MODULE$.Double());
                double[] splits = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples), fakeMetadata, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)fakeMetadata.numSplits(0)));
                int $org_scalatest_assert_macro_right2 = 5;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)fakeMetadata.numBins()[0]));
                int $org_scalatest_assert_macro_right3 = 6;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((double[])Predef$.MODULE$.doubleArrayOps(splits).distinct()).length));
                int $org_scalatest_assert_macro_right4 = splits.length;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                DecisionTreeMetadata fakeMetadata2 = new DecisionTreeMetadata(1, 0L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{5}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
                double[] featureSamples2 = (double[])Predef$.MODULE$.intArrayOps(new int[]{1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$4) {
                        return this.apply$mcDI$sp(x$4);
                    }

                    public double apply$mcDI$sp(int x$4) {
                        return x$4;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[] splits2 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples2), fakeMetadata2, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((double[])Predef$.MODULE$.doubleArrayOps(splits2).distinct()).length));
                int $org_scalatest_assert_macro_right6 = splits2.length;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                DecisionTreeMetadata fakeMetadata3 = new DecisionTreeMetadata(1, 0L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
                double[] featureSamples3 = (double[])Predef$.MODULE$.intArrayOps(new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 5}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$5) {
                        return this.apply$mcDI$sp(x$5);
                    }

                    public double apply$mcDI$sp(int x$5) {
                        return x$5;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[] splits3 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples3), fakeMetadata3, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits3.length));
                int $org_scalatest_assert_macro_right7 = 2;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits3[0]));
                double $org_scalatest_assert_macro_right8 = 2.0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits3[1]));
                double $org_scalatest_assert_macro_right9 = 3.0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                DecisionTreeMetadata fakeMetadata4 = new DecisionTreeMetadata(1, 0L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
                double[] featureSamples4 = (double[])Predef$.MODULE$.intArrayOps(new int[]{0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$6) {
                        return this.apply$mcDI$sp(x$6);
                    }

                    public double apply$mcDI$sp(int x$6) {
                        return x$6;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[] splits4 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples4), fakeMetadata4, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits4.length));
                int $org_scalatest_assert_macro_right10 = 1;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits4[0]));
                double $org_scalatest_assert_macro_right11 = 1.0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification with unordered categorical features: split calculations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$7) {
                        return x$7.asML();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$51 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$52 = qual$4.parallelize$default$2();
                RDD rdd = qual$4.parallelize((Seq)x$51, x$52, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$53 = Algo$.MODULE$.Classification();
                Gini$ x$54 = Gini$.MODULE$;
                int x$55 = 2;
                int x$56 = 100;
                int x$57 = 100;
                Map x$58 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$59 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$60 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$61 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$62 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$63 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$64 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$65 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$53, (Impurity)x$54, x$55, x$56, x$57, x$59, x$58, x$60, x$61, x$62, x$63, x$64, x$65);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numSplits(0)));
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numBins()[0]));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numSplits(1)));
                int $org_scalatest_assert_macro_right6 = 3;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numBins()[1]));
                int $org_scalatest_assert_macro_right7 = 3;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                this.checkCategoricalSplit$1(splits[0][0], 0, new double[]{0.0});
                this.checkCategoricalSplit$1(splits[0][1], 0, new double[]{1.0});
                this.checkCategoricalSplit$1(splits[0][2], 0, new double[]{0.0, 1.0});
                this.checkCategoricalSplit$1(splits[1][0], 1, new double[]{0.0});
                this.checkCategoricalSplit$1(splits[1][1], 1, new double[]{1.0});
                this.checkCategoricalSplit$1(splits[1][2], 1, new double[]{0.0, 1.0});
            }

            private final void checkCategoricalSplit$1(Split s, int featureIndex, double[] leftCategories) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)s.featureIndex()));
                int $org_scalatest_assert_macro_right = featureIndex;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Split $org_scalatest_assert_macro_left2 = s;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.tree.CategoricalSplit", $org_scalatest_assert_macro_left2 instanceof CategoricalSplit);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                CategoricalSplit s0 = (CategoricalSplit)s;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(s0.leftCategories());
                double[] $org_scalatest_assert_macro_right2 = leftCategories;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)s0.numCategories()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification with ordered categorical features: split calculations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$8) {
                        return x$8.asML();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 3000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$5 = this.$outer.sc();
                WrappedArray x$66 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$67 = qual$5.parallelize$default$2();
                RDD rdd = qual$5.parallelize((Seq)x$66, x$67, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$68 = Algo$.MODULE$.Classification();
                Gini$ x$69 = Gini$.MODULE$;
                int x$70 = 2;
                int x$71 = 100;
                int x$72 = 100;
                Map x$73 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
                Enumeration.Value x$74 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$75 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$76 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$77 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$78 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$79 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$80 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$68, (Impurity)x$69, x$70, x$71, x$72, x$74, x$73, x$75, x$76, x$77, x$78, x$79, x$80);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("extract categories from a number for multiclass classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List l = RandomForest$.MODULE$.extractMultiClassCategories(13, 10);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)l.length()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0, 0.0})));
                List $org_scalatest_assert_macro_right2 = l;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Avoid aggregation on the last level", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0})))});
                SparkContext qual$6 = this.$outer.sc();
                WrappedArray x$81 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$82 = qual$6.parallelize$default$2();
                RDD input = qual$6.parallelize((Seq)x$81, x$82, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$83 = Algo$.MODULE$.Classification();
                Gini$ x$84 = Gini$.MODULE$;
                int x$85 = 1;
                int x$86 = 2;
                Map x$87 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$88 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$89 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$90 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$91 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$92 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$93 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$94 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$95 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$83, (Impurity)x$84, x$85, x$86, x$88, x$89, x$87, x$90, x$91, x$92, x$93, x$94, x$95);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(input, strategy);
                Split[][] splits = RandomForest$.MODULE$.findSplits(input, metadata, 42L);
                RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(input, splits, metadata);
                RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5());
                LearningNode topNode = LearningNode$.MODULE$.emptyNode(1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)topNode.isLeaf()));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(topNode.stats());
                Null$ $org_scalatest_assert_macro_right2 = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new LearningNode[]{topNode})}));
                Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)topNode.id()), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
                Queue nodeQueue = new Queue();
                RandomForest$.MODULE$.findBestSplits(baggedInput, metadata, (LearningNode[])((Object[])new LearningNode[]{topNode}), nodesForGroup, treeToNodeToIndexInfo, splits, nodeQueue, RandomForest$.MODULE$.findBestSplits$default$8(), RandomForest$.MODULE$.findBestSplits$default$9());
                Queue $org_scalatest_assert_macro_left3 = nodeQueue;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(topNode.stats());
                Null$ $org_scalatest_assert_macro_right3 = null;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!==", null, $org_scalatest_assert_macro_left4.$bang$eq$eq($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                double $org_scalatest_assert_macro_left5 = topNode.stats().impurity();
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).toNode().prediction()));
                double $org_scalatest_assert_macro_right5 = 0.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).toNode().prediction()));
                double $org_scalatest_assert_macro_right6 = 1.0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).stats().impurity()));
                double $org_scalatest_assert_macro_right7 = 0.0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).stats().impurity()));
                double $org_scalatest_assert_macro_right8 = 0.0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Avoid aggregation if impurity is 0.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0})))});
                SparkContext qual$7 = this.$outer.sc();
                WrappedArray x$96 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$97 = qual$7.parallelize$default$2();
                RDD input = qual$7.parallelize((Seq)x$96, x$97, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$98 = Algo$.MODULE$.Classification();
                Gini$ x$99 = Gini$.MODULE$;
                int x$100 = 5;
                int x$101 = 2;
                Map x$102 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$103 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$104 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$105 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$106 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$107 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$108 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$109 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$110 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$98, (Impurity)x$99, x$100, x$101, x$103, x$104, x$102, x$105, x$106, x$107, x$108, x$109, x$110);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(input, strategy);
                Split[][] splits = RandomForest$.MODULE$.findSplits(input, metadata, 42L);
                RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(input, splits, metadata);
                RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5());
                LearningNode topNode = LearningNode$.MODULE$.emptyNode(1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)topNode.isLeaf()));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(topNode.stats());
                Null$ $org_scalatest_assert_macro_right2 = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new LearningNode[]{topNode})}));
                Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)topNode.id()), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
                Queue nodeQueue = new Queue();
                RandomForest$.MODULE$.findBestSplits(baggedInput, metadata, (LearningNode[])((Object[])new LearningNode[]{topNode}), nodesForGroup, treeToNodeToIndexInfo, splits, nodeQueue, RandomForest$.MODULE$.findBestSplits$default$8(), RandomForest$.MODULE$.findBestSplits$default$9());
                Queue $org_scalatest_assert_macro_left3 = nodeQueue;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(topNode.stats());
                Null$ $org_scalatest_assert_macro_right3 = null;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!==", null, $org_scalatest_assert_macro_left4.$bang$eq$eq($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                double $org_scalatest_assert_macro_left5 = topNode.stats().impurity();
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).toNode().prediction()));
                double $org_scalatest_assert_macro_right5 = 0.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).toNode().prediction()));
                double $org_scalatest_assert_macro_right6 = 1.0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).stats().impurity()));
                double $org_scalatest_assert_macro_right7 = 0.0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).stats().impurity()));
                double $org_scalatest_assert_macro_right8 = 0.0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Use soft prediction for binary classification with ordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$125;
                boolean x$124;
                double x$123;
                int x$122;
                double x$121;
                int x$120;
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
                SparkContext qual$8 = this.$outer.sc();
                WrappedArray x$111 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$112 = qual$8.parallelize$default$2();
                RDD input = qual$8.parallelize((Seq)x$111, x$112, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$113 = Algo$.MODULE$.Classification();
                Gini$ x$114 = Gini$.MODULE$;
                int x$115 = 1;
                int x$116 = 2;
                Map x$117 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$118 = 3;
                Enumeration.Value x$119 = Strategy$.MODULE$.$lessinit$greater$default$6();
                Strategy strategy = new Strategy(x$113, (Impurity)x$114, x$115, x$116, x$118, x$119, x$117, x$120 = Strategy$.MODULE$.$lessinit$greater$default$8(), x$121 = Strategy$.MODULE$.$lessinit$greater$default$9(), x$122 = Strategy$.MODULE$.$lessinit$greater$default$10(), x$123 = Strategy$.MODULE$.$lessinit$greater$default$11(), x$124 = Strategy$.MODULE$.$lessinit$greater$default$12(), x$125 = Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeModel model = (DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(input, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7())).head();
                Node node = model.rootNode();
                if (node instanceof InternalNode) {
                    InternalNode internalNode = (InternalNode)node;
                    Split split = internalNode.split();
                    if (split instanceof CategoricalSplit) {
                        CategoricalSplit categoricalSplit = (CategoricalSplit)split;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(categoricalSplit.leftCategories());
                        double[] $org_scalatest_assert_macro_right = new double[]{1.0};
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return;
                    }
                    throw new AssertionError((Object)"model.rootNode.split was not a CategoricalSplit");
                }
                throw new AssertionError((Object)"model.rootNode was not an InternalNode");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Second level node building with vs. without groups", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateOrderedLabeledPoints()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$9) {
                        return x$9.asML();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$9 = this.$outer.sc();
                WrappedArray x$126 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$127 = qual$9.parallelize$default$2();
                RDD rdd = qual$9.parallelize((Seq)x$126, x$127, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$128 = Algo$.MODULE$.Classification();
                Entropy$ x$129 = Entropy$.MODULE$;
                int x$130 = 3;
                int x$131 = 2;
                int x$132 = 100;
                int x$133 = 1000;
                Enumeration.Value x$134 = Strategy$.MODULE$.$lessinit$greater$default$6();
                Map x$135 = Strategy$.MODULE$.$lessinit$greater$default$7();
                int x$136 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$137 = Strategy$.MODULE$.$lessinit$greater$default$9();
                double x$138 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$139 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$140 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy1 = new Strategy(x$128, (Impurity)x$129, x$130, x$131, x$132, x$134, x$135, x$136, x$137, x$133, x$138, x$139, x$140);
                Enumeration.Value x$141 = Algo$.MODULE$.Classification();
                Entropy$ x$142 = Entropy$.MODULE$;
                int x$143 = 3;
                int x$144 = 2;
                int x$145 = 100;
                int x$146 = 0;
                Enumeration.Value x$147 = Strategy$.MODULE$.$lessinit$greater$default$6();
                Map x$148 = Strategy$.MODULE$.$lessinit$greater$default$7();
                int x$149 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$150 = Strategy$.MODULE$.$lessinit$greater$default$9();
                double x$151 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$152 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$153 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy2 = new Strategy(x$141, (Impurity)x$142, x$143, x$144, x$145, x$147, x$148, x$149, x$150, x$146, x$151, x$152, x$153);
                DecisionTreeModel tree1 = (DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy1, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7())).head();
                DecisionTreeModel tree2 = (DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy2, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7())).head();
                InternalNode[] children1 = this.getChildren$1(tree1.rootNode());
                InternalNode[] children2 = this.getChildren$1(tree2.rootNode());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, children1, children2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    private final InternalNode[] children1$1;
                    private final InternalNode[] children2$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        double $org_scalatest_assert_macro_left = this.children1$1[i].gain();
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (double)$org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        double $org_scalatest_assert_macro_left2 = this.children2$1[i].gain();
                        int $org_scalatest_assert_macro_right2 = 0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (double)$org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().convertToEqualizer(this.children1$1[i].split());
                        Split $org_scalatest_assert_macro_right3 = this.children2$1[i].split();
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)this.children1$1[i].impurity()));
                        double $org_scalatest_assert_macro_right4 = this.children2$1[i].impurity();
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().convertToEqualizer(this.children1$1[i].impurityStats().stats());
                        double[] $org_scalatest_assert_macro_right5 = this.children2$1[i].impurityStats().stats();
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)this.children1$1[i].leftChild().impurity()));
                        double $org_scalatest_assert_macro_right6 = this.children2$1[i].leftChild().impurity();
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)this.children1$1[i].rightChild().impurity()));
                        double $org_scalatest_assert_macro_right7 = this.children2$1[i].rightChild().impurity();
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)this.children1$1[i].prediction()));
                        double $org_scalatest_assert_macro_right8 = this.children2$1[i].prediction();
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.children1$1 = children1$1;
                        this.children2$1 = children2$1;
                    }
                });
            }

            public /* synthetic */ RandomForestSuite org$apache$spark$ml$tree$impl$RandomForestSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final InternalNode[] getChildren$1(Node rootNode) {
                Node node = rootNode;
                if (node instanceof InternalNode) {
                    InternalNode internalNode = (InternalNode)node;
                    Node $org_scalatest_assert_macro_left = internalNode.leftChild();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.ml.tree.InternalNode", $org_scalatest_assert_macro_left instanceof InternalNode);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    Node $org_scalatest_assert_macro_left2 = internalNode.rightChild();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.tree.InternalNode", $org_scalatest_assert_macro_left2 instanceof InternalNode);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    InternalNode[] internalNodeArray = (InternalNode[])((Object[])new InternalNode[]{(InternalNode)internalNode.leftChild(), (InternalNode)internalNode.rightChild()});
                    return internalNodeArray;
                }
                throw new AssertionError((Object)"rootNode was not an InternalNode");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features: subsampling features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$156 = Algo$.MODULE$.Classification();
                Gini$ x$157 = Gini$.MODULE$;
                int x$158 = 2;
                int x$159 = 2;
                Map x$160 = categoricalFeaturesInfo;
                int x$161 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$162 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$163 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$164 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$165 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$166 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$167 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$168 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$156, (Impurity)x$157, x$158, x$159, x$161, x$162, x$160, x$163, x$164, x$165, x$166, x$167, x$168);
                this.$outer.binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features and node Id cache: subsampling features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$169 = Algo$.MODULE$.Classification();
                Gini$ x$170 = Gini$.MODULE$;
                int x$171 = 2;
                int x$172 = 2;
                Map x$173 = categoricalFeaturesInfo;
                boolean x$174 = true;
                int x$175 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$176 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$177 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$178 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$179 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$180 = Strategy$.MODULE$.$lessinit$greater$default$11();
                int x$181 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$169, (Impurity)x$170, x$171, x$172, x$175, x$176, x$173, x$177, x$178, x$179, x$180, x$174, x$181);
                this.$outer.binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("computeFeatureImportance, featureImportances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GiniCalculator leftImp = new GiniCalculator(new double[]{3.0, 2.0, 1.0});
                LeafNode left = new LeafNode(0.0, leftImp.calculate(), (ImpurityCalculator)leftImp);
                GiniCalculator rightImp = new GiniCalculator(new double[]{1.0, 2.0, 5.0});
                LeafNode right = new LeafNode(2.0, rightImp.calculate(), (ImpurityCalculator)rightImp);
                Node parent = TreeTests$.MODULE$.buildParentNode((Node)left, (Node)right, (Split)new ContinuousSplit(0, 0.5));
                ImpurityCalculator parentImp = parent.impurityStats();
                GiniCalculator left2Imp = new GiniCalculator(new double[]{1.0, 6.0, 1.0});
                LeafNode left2 = new LeafNode(0.0, left2Imp.calculate(), (ImpurityCalculator)left2Imp);
                Node grandParent = TreeTests$.MODULE$.buildParentNode((Node)left2, parent, (Split)new ContinuousSplit(1, 1.0));
                ImpurityCalculator grandImp = grandParent.impurityStats();
                this.testNode$1((Node)left, Predef$.MODULE$.Map().empty());
                double feature0importance = parentImp.calculate() * (double)parentImp.count() - (leftImp.calculate() * (double)leftImp.count() + rightImp.calculate() * (double)rightImp.count());
                this.testNode$1(parent, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)feature0importance))})));
                double feature1importance = grandImp.calculate() * (double)grandImp.count() - (left2Imp.calculate() * (double)left2Imp.count() + parentImp.calculate() * (double)parentImp.count());
                this.testNode$1(grandParent, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)feature0importance)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)feature1importance))})));
                DecisionTreeModel[] trees = (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])new Node[]{parent, grandParent}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DecisionTreeModel apply(Node root) {
                        return new DecisionTreeClassificationModel(root, 2, 3);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
                Vector importances = TreeEnsembleModel$.MODULE$.featureImportances(trees, 2);
                double tree2norm = feature0importance + feature1importance;
                Vector expected = Vectors$.MODULE$.dense((1.0 + feature0importance / tree2norm) / 2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{feature1importance / tree2norm / 2.0}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(importances).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(importances).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            private final void testNode$1(Node node, Map expected) {
                OpenHashMap.mcD.sp map = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
                TreeEnsembleModel$.MODULE$.computeFeatureImportance(node, (OpenHashMap)map);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)map.toMap(Predef$.MODULE$.conforms()))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)expected)).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(map.toMap[Int, Double](scala.this.Predef.conforms[(Int, Double)]))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(expected)).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("normalizeMapValues", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OpenHashMap.mcD.sp map = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
                map.update$mcD$sp((Object)BoxesRunTime.boxToInteger((int)0), 1.0);
                map.update$mcD$sp((Object)BoxesRunTime.boxToInteger((int)2), 2.0);
                TreeEnsembleModel$.MODULE$.normalizeMapValues((OpenHashMap)map);
                Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)0.6666666666666666))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)map.toMap(Predef$.MODULE$.conforms()))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)expected)).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(map.toMap[Int, Double](scala.this.Predef.conforms[(Int, Double)]))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(expected)).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

