/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tuning;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionSuite$;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.HashingTF;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.tuning.CrossValidator;
import org.apache.spark.ml.tuning.CrossValidatorModel;
import org.apache.spark.ml.tuning.CrossValidatorSuite$;
import org.apache.spark.ml.tuning.CrossValidatorSuite$$anonfun$6$;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u00015\u00111c\u0011:pgN4\u0016\r\\5eCR|'oU;ji\u0016T!a\u0001\u0003\u0002\rQ,h.\u001b8h\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001q!C\u0007\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011)H/\u001b7\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004\"aG\u000f\u000e\u0003qQ!!\u0006\u0003\n\u0005ya\"\u0001\u0006#fM\u0006,H\u000e\u001e*fC\u0012<&/\u001b;f)\u0016\u001cH\u000fC\u0003!\u0001\u0011\u0005\u0011%\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\u0005!IQ\u0005\u0001a\u0001\u0002\u0004%\tAJ\u0001\bI\u0006$\u0018m]3u+\u00059\u0003G\u0001\u00151!\rICFL\u0007\u0002U)\u00111FB\u0001\u0004gFd\u0017BA\u0017+\u0005\u001d!\u0015\r^1tKR\u0004\"a\f\u0019\r\u0001\u0011I\u0011GMA\u0001\u0002\u0003\u0015\t\u0001\u000f\u0002\u0004?\u0012\n\u0004BB\u001a\u0001A\u0003&A'\u0001\u0005eCR\f7/\u001a;!a\t)t\u0007E\u0002*YY\u0002\"aL\u001c\u0005\u0013E\u0012\u0014\u0011!A\u0001\u0006\u0003A\u0014CA\u001d@!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u000f!\n\u0005\u0005[$aA!os\"\u0012!g\u0011\t\u0003u\u0011K!!R\u001e\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"C$\u0001\u0001\u0004\u0005\r\u0011\"\u0001I\u0003-!\u0017\r^1tKR|F%Z9\u0015\u0005%c\u0005C\u0001\u001eK\u0013\tY5H\u0001\u0003V]&$\bbB'G\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\n\u0004GA(R!\rIC\u0006\u0015\t\u0003_E#\u0011\"\r\u001a\u0002\u0002\u0003\u0005)\u0011\u0001\u001d\t\u000bM\u0003A\u0011\t+\u0002\u0013\t,gm\u001c:f\u00032dG#A%\b\u000bY\u0013\u0001\u0012A,\u0002'\r\u0013xn]:WC2LG-\u0019;peN+\u0018\u000e^3\u0011\u0005\rBf!B\u0001\u0003\u0011\u0003I6C\u0001-\u000f\u0011\u0015\u0001\u0003\f\"\u0001\\)\u00059\u0006\"B/Y\t\u0003q\u0016\u0001E2p[B\f'/\u001a)be\u0006lW*\u00199t)\rIuL\u001b\u0005\u0006Ar\u0003\r!Y\u0001\u0006a6\u000b\u0007o\u001d\t\u0004u\t$\u0017BA2<\u0005\u0015\t%O]1z!\t)\u0007.D\u0001g\u0015\t9G!A\u0003qCJ\fW.\u0003\u0002jM\nA\u0001+\u0019:b[6\u000b\u0007\u000fC\u0003l9\u0002\u0007\u0011-\u0001\u0004q\u001b\u0006\u00048O\r\u0004\u0006[b\u000b\tA\u001c\u0002\b\u001bflu\u000eZ3m'\taw\u000eE\u0002qcNl\u0011\u0001B\u0005\u0003e\u0012\u0011Q!T8eK2\u0004\"\u0001\u001e7\u000e\u0003aCQ\u0001\t7\u0005\u0002Y$\u0012a\u001d\u0004\u0005qb\u0003\u0011PA\u0006Ns\u0016\u001bH/[7bi>\u00148cA<{{B\u0019\u0001o_:\n\u0005q$!!C#ti&l\u0017\r^8s!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u00014\u0002\rMD\u0017M]3e\u0013\r\t)a \u0002\f\u0011\u0006\u001c\u0018J\u001c9vi\u000e{G\u000e\u0003\u0006\u0002\n]\u0014)\u0019!C!\u0003\u0017\t1!^5e+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005Uab\u0001\u001e\u0002\u0012%\u0019\u00111C\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\t9\"!\u0007\u0003\rM#(/\u001b8h\u0015\r\t\u0019b\u000f\u0005\u000b\u0003;9(\u0011!Q\u0001\n\u00055\u0011\u0001B;jI\u0002Ba\u0001I<\u0005\u0002\u0005\u0005B\u0003BA\u0012\u0003K\u0001\"\u0001^<\t\u0011\u0005%\u0011q\u0004a\u0001\u0003\u001bAq!!\u000bx\t\u0003\nY#A\u0002gSR$2a]A\u0017\u0011\u001d)\u0013q\u0005a\u0001\u0003_\u0001D!!\r\u00026A!\u0011\u0006LA\u001a!\ry\u0013Q\u0007\u0003\f\u0003o\ti#!A\u0001\u0002\u000b\u0005\u0001HA\u0002`IIBq!a\u000fx\t\u0003\ni$A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\ty$a\u0013\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012+\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI%a\u0011\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005\u0002N\u0005e\u0002\u0019AA \u0003\u0019\u00198\r[3nC\"9\u0011\u0011K<\u0005B\u0005M\u0013\u0001B2paf$B!a\t\u0002V!9\u0011qKA(\u0001\u0004!\u0017!B3yiJ\fgABA.1\u0002\tiFA\u0006Ns\u00163\u0018\r\\;bi>\u00148\u0003BA-\u0003?\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K\"\u0011AC3wC2,\u0018\r^5p]&!\u0011\u0011NA2\u0005%)e/\u00197vCR|'\u000fC\u0004!\u00033\"\t!!\u001c\u0015\u0005\u0005=\u0004c\u0001;\u0002Z!A\u00111OA-\t\u0003\n)(\u0001\u0005fm\u0006dW/\u0019;f)\u0011\t9(! \u0011\u0007i\nI(C\u0002\u0002|m\u0012a\u0001R8vE2,\u0007bB\u0013\u0002r\u0001\u0007\u0011q\u0010\u0019\u0005\u0003\u0003\u000b)\t\u0005\u0003*Y\u0005\r\u0005cA\u0018\u0002\u0006\u0012Y\u0011qQA?\u0003\u0003\u0005\tQ!\u00019\u0005\ryFe\r\u0005\t\u0003\u0017\u000bI\u0006\"\u0011\u0002\u000e\u0006q\u0011n\u001d'be\u001e,'OQ3ui\u0016\u0014XCAAH!\rQ\u0014\u0011S\u0005\u0004\u0003'[$a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003\u0013\tIF1A\u0005B\u0005-\u0001\"CA\u000f\u00033\u0002\u000b\u0011BA\u0007\u0011!\t\t&!\u0017\u0005B\u0005mE\u0003BA8\u0003;Cq!a\u0016\u0002\u001a\u0002\u0007A\rC\u0005\u0002\"b\u000b\t\u0011\"\u0003\u0002$\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\t1\fgn\u001a\u0006\u0003\u0003_\u000bAA[1wC&!\u00111WAU\u0005\u0019y%M[3di\u0002")
public class CrossValidatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<?> dataset;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void compareParamMaps(ParamMap[] paramMapArray, ParamMap[] paramMapArray2) {
        CrossValidatorSuite$.MODULE$.compareParamMaps(paramMapArray, paramMapArray2);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Dataset<?> dataset() {
        return this.dataset;
    }

    public void dataset_$eq(Dataset<?> x$1) {
        this.dataset = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CrossValidatorSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_tuning_CrossValidatorSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_tuning_CrossValidatorSuite$$typecreator1$1(CrossValidatorSuite $outer) {
            }
        }
        this.dataset_$eq(this.spark().createDataFrame(this.sc().parallelize(LogisticRegressionSuite$.MODULE$.generateLogisticInput(1.0, 1.0, 100, 42), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tuning_CrossValidatorSuite$$typecreator1$1(this))));
    }

    public CrossValidatorSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("cross validation with logistic regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression();
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.001, 1000.0}).addGrid(lr.maxIter(), new int[]{0, 10}).build();
                BinaryClassificationEvaluator eval = new BinaryClassificationEvaluator();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)lr).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setNumFolds(3);
                CrossValidatorModel cvModel = cv.fit(this.$outer.dataset());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)cvModel);
                LogisticRegression parent = (LogisticRegression)cvModel.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right = 0.001;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right2 = 10;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel.avgMetrics().length));
                int $org_scalatest_assert_macro_right3 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("cross validation with linear regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CrossValidatorSuite.class.getClassLoader());
                Dataset dataset = this.$outer.spark().createDataFrame(this.$outer.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 100, 42, 0.1), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                        return x$1.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                LinearRegression trainer = new LinearRegression().setSolver("l-bfgs");
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(trainer.regParam(), new double[]{1000.0, 0.001}).addGrid(trainer.maxIter(), new int[]{0, 10}).build();
                RegressionEvaluator eval = new RegressionEvaluator();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)trainer).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setNumFolds(3);
                CrossValidatorModel cvModel = cv.fit(dataset);
                LinearRegression parent = (LinearRegression)cvModel.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right = 0.001;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right2 = 10;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel.avgMetrics().length));
                int $org_scalatest_assert_macro_right3 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                eval.setMetricName("r2");
                CrossValidatorModel cvModel2 = cv.fit(dataset);
                LinearRegression parent2 = (LinearRegression)cvModel2.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent2.getRegParam()));
                double $org_scalatest_assert_macro_right4 = 0.001;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent2.getMaxIter()));
                int $org_scalatest_assert_macro_right5 = 10;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel2.avgMetrics().length));
                int $org_scalatest_assert_macro_right6 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("transformSchema should check estimatorParamMaps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyEstimator est = new MyEstimator("est");
                MyEvaluator eval = new MyEvaluator();
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(est.inputCol(), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input1", "input2"})).build();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)est).setEstimatorParamMaps(paramMaps).setEvaluator((Evaluator)eval);
                cv.transformSchema(new StructType());
                ParamMap[] invalidParamMaps = (ParamMap[])Predef$.MODULE$.refArrayOps((Object[])paramMaps).$colon$plus((Object)ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{est.inputCol().$minus$greater((Object)"")})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParamMap.class)));
                cv.setEstimatorParamMaps(invalidParamMaps);
                this.$outer.intercept((Function0)new Serializable(this, cv){
                    public static final long serialVersionUID = 0L;
                    private final CrossValidator cv$1;

                    public final StructType apply() {
                        return this.cv$1.transformSchema(new StructType());
                    }
                    {
                        this.cv$1 = cv$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: CrossValidator with simple estimator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(3);
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator().setMetricName("areaUnderPR");
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).build();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)lr).setEvaluator((Evaluator)evaluator).setNumFolds(20).setEstimatorParamMaps(paramMaps);
                CrossValidator cv2 = this.$outer.testDefaultReadWrite(cv, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(cv.uid());
                String $org_scalatest_assert_macro_right = cv2.uid();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cv.getNumFolds()));
                int $org_scalatest_assert_macro_right2 = cv2.getNumFolds();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)cv.getSeed()));
                long $org_scalatest_assert_macro_right3 = cv2.getSeed();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Evaluator $org_scalatest_assert_macro_left4 = cv2.getEvaluator();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.ml.evaluation.BinaryClassificationEvaluator", $org_scalatest_assert_macro_left4 instanceof BinaryClassificationEvaluator);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                BinaryClassificationEvaluator evaluator2 = (BinaryClassificationEvaluator)cv2.getEvaluator();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(evaluator.uid());
                String $org_scalatest_assert_macro_right4 = evaluator2.uid();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(evaluator.getMetricName());
                String $org_scalatest_assert_macro_right5 = evaluator2.getMetricName();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Estimator estimator = cv2.getEstimator();
                if (estimator instanceof LogisticRegression) {
                    LogisticRegression logisticRegression = (LogisticRegression)estimator;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(lr.uid());
                    String $org_scalatest_assert_macro_right6 = logisticRegression.uid();
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)lr.getMaxIter()));
                    int $org_scalatest_assert_macro_right7 = logisticRegression.getMaxIter();
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    CrossValidatorSuite$.MODULE$.compareParamMaps(cv.getEstimatorParamMaps(), cv2.getEstimatorParamMaps());
                    return;
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded CrossValidator expected estimator of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegression but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimator.getClass().getName()}))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: CrossValidator with complex estimator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BinaryClassificationEvaluator lrEvaluator = new BinaryClassificationEvaluator().setMetricName("areaUnderPR");
                LogisticRegression lr = new LogisticRegression().setMaxIter(3);
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).build();
                CrossValidator lrcv = new CrossValidator().setEstimator((Estimator)lr).setEvaluator((Evaluator)lrEvaluator).setEstimatorParamMaps(lrParamMaps);
                HashingTF hashingTF = new HashingTF();
                Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{hashingTF, lrcv}));
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(hashingTF.numFeatures(), new int[]{10, 20}).addGrid(lr.elasticNetParam(), new double[]{0.0, 1.0}).build();
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)pipeline).setEvaluator((Evaluator)evaluator).setNumFolds(20).setEstimatorParamMaps(paramMaps);
                CrossValidator cv2 = this.$outer.testDefaultReadWrite(cv, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(cv.uid());
                String $org_scalatest_assert_macro_right = cv2.uid();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cv.getNumFolds()));
                int $org_scalatest_assert_macro_right2 = cv2.getNumFolds();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)cv.getSeed()));
                long $org_scalatest_assert_macro_right3 = cv2.getSeed();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Evaluator $org_scalatest_assert_macro_left4 = cv2.getEvaluator();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.ml.evaluation.BinaryClassificationEvaluator", $org_scalatest_assert_macro_left4 instanceof BinaryClassificationEvaluator);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(cv.getEvaluator().uid());
                String $org_scalatest_assert_macro_right4 = cv2.getEvaluator().uid();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                CrossValidatorSuite$.MODULE$.compareParamMaps(cv.getEstimatorParamMaps(), cv2.getEstimatorParamMaps());
                Estimator estimator = cv2.getEstimator();
                if (estimator instanceof Pipeline) {
                    Pipeline pipeline2 = (Pipeline)estimator;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(pipeline.uid());
                    String $org_scalatest_assert_macro_right5 = pipeline2.uid();
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    PipelineStage[] pipelineStageArray = pipeline2.getStages();
                    Option option = Array$.MODULE$.unapplySeq((Object)pipelineStageArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        PipelineStage hashingTF2 = (PipelineStage)((SeqLike)option.get()).apply(0);
                        PipelineStage lrcv2 = (PipelineStage)((SeqLike)option.get()).apply(1);
                        if (hashingTF2 instanceof HashingTF) {
                            HashingTF hashingTF3 = (HashingTF)hashingTF2;
                            if (lrcv2 instanceof CrossValidator) {
                                CrossValidator crossValidator = (CrossValidator)lrcv2;
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(hashingTF.uid());
                                String $org_scalatest_assert_macro_right6 = hashingTF3.uid();
                                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                                Estimator estimator2 = crossValidator.getEstimator();
                                if (estimator2 instanceof LogisticRegression) {
                                    LogisticRegression logisticRegression = (LogisticRegression)estimator2;
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(lr.uid());
                                    String $org_scalatest_assert_macro_right7 = logisticRegression.uid();
                                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)lr.getMaxIter()));
                                    int $org_scalatest_assert_macro_right8 = logisticRegression.getMaxIter();
                                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(lrcv.uid());
                                    String $org_scalatest_assert_macro_right9 = crossValidator.uid();
                                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                                    Evaluator $org_scalatest_assert_macro_left11 = crossValidator.getEvaluator();
                                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.ml.evaluation.BinaryClassificationEvaluator", $org_scalatest_assert_macro_left11 instanceof BinaryClassificationEvaluator);
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(lrEvaluator.uid());
                                    String $org_scalatest_assert_macro_right10 = crossValidator.getEvaluator().uid();
                                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                                    CrossValidatorSuite$.MODULE$.compareParamMaps(lrParamMaps, crossValidator.getEstimatorParamMaps());
                                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded internal CrossValidator expected to be"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegression but found type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimator2.getClass().getName()}))).toString());
                            }
                        }
                    }
                    throw new AssertionError((Object)new StringBuilder().append((Object)"Loaded Pipeline expected stages (HashingTF, CrossValidator) but found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pipelineStageArray).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(PipelineStage x$2) {
                            return x$2.getClass().getName();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ")).toString());
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded CrossValidator expected estimator of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" CrossValidator but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimator.getClass().getName()}))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: CrossValidator fails for extraneous Param", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression();
                LogisticRegression lr2 = new LogisticRegression();
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator();
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).addGrid(lr2.regParam(), new double[]{0.1, 0.2}).build();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)lr).setEvaluator((Evaluator)evaluator).setEstimatorParamMaps(paramMaps);
                this.$outer.withClue("CrossValidator.write failed to catch extraneous Param error", (Function0)new Serializable(this, cv){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final CrossValidator cv$2;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$ml$tuning$CrossValidatorSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$3 $outer;

                            public final MLWriter apply() {
                                return this.$outer.cv$2.write();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cv$2 = cv$2;
                    }
                });
            }

            public /* synthetic */ CrossValidatorSuite org$apache$spark$ml$tuning$CrossValidatorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: CrossValidatorModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setThreshold(0.6);
                LogisticRegressionModel lrModel = new LogisticRegressionModel(lr.uid(), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), 1.2).setThreshold(0.6);
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator().setMetricName("areaUnderPR");
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).build();
                CrossValidatorModel cv = new CrossValidatorModel("cvUid", (Model)lrModel, new double[]{0.3, 0.6});
                cv.set(cv.estimator(), (Object)lr).set(cv.evaluator(), (Object)evaluator).set((Param)cv.numFolds(), (Object)BoxesRunTime.boxToInteger((int)20)).set(cv.estimatorParamMaps(), (Object)paramMaps);
                CrossValidatorModel cv2 = this.$outer.testDefaultReadWrite(cv, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(cv.uid());
                String $org_scalatest_assert_macro_right = cv2.uid();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cv.getNumFolds()));
                int $org_scalatest_assert_macro_right2 = cv2.getNumFolds();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)cv.getSeed()));
                long $org_scalatest_assert_macro_right3 = cv2.getSeed();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Evaluator $org_scalatest_assert_macro_left4 = cv2.getEvaluator();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.ml.evaluation.BinaryClassificationEvaluator", $org_scalatest_assert_macro_left4 instanceof BinaryClassificationEvaluator);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                BinaryClassificationEvaluator evaluator2 = (BinaryClassificationEvaluator)cv2.getEvaluator();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(evaluator.uid());
                String $org_scalatest_assert_macro_right4 = evaluator2.uid();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(evaluator.getMetricName());
                String $org_scalatest_assert_macro_right5 = evaluator2.getMetricName();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Estimator estimator = cv2.getEstimator();
                if (estimator instanceof LogisticRegression) {
                    LogisticRegression logisticRegression = (LogisticRegression)estimator;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(lr.uid());
                    String $org_scalatest_assert_macro_right6 = logisticRegression.uid();
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lr.getThreshold()));
                    double $org_scalatest_assert_macro_right7 = logisticRegression.getThreshold();
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    CrossValidatorSuite$.MODULE$.compareParamMaps(cv.getEstimatorParamMaps(), cv2.getEstimatorParamMaps());
                    Model model = cv2.bestModel();
                    if (model instanceof LogisticRegressionModel) {
                        LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)model;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(lrModel.uid());
                        String $org_scalatest_assert_macro_right8 = logisticRegressionModel.uid();
                        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lrModel.getThreshold()));
                        double $org_scalatest_assert_macro_right9 = logisticRegressionModel.getThreshold();
                        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(lrModel.coefficients());
                        Vector $org_scalatest_assert_macro_right10 = logisticRegressionModel.coefficients();
                        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lrModel.intercept()));
                        double $org_scalatest_assert_macro_right11 = logisticRegressionModel.intercept();
                        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(cv.avgMetrics());
                        double[] $org_scalatest_assert_macro_right12 = cv2.avgMetrics();
                        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                        return;
                    }
                    throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded CrossValidator expected bestModel of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegressionModel but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{model.getClass().getName()}))).toString());
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded CrossValidator expected estimator of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegression but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimator.getClass().getName()}))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static abstract class MyModel
    extends Model<MyModel> {
    }

    public static class MyEstimator
    extends Estimator<MyModel>
    implements HasInputCol {
        private final String uid;
        private final Param<String> inputCol;

        public final Param<String> inputCol() {
            return this.inputCol;
        }

        public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
            this.inputCol = x$1;
        }

        public final String getInputCol() {
            return HasInputCol.class.getInputCol((HasInputCol)this);
        }

        public String uid() {
            return this.uid;
        }

        public MyModel fit(Dataset<?> dataset) {
            throw new UnsupportedOperationException();
        }

        public StructType transformSchema(StructType schema) {
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString((String)this.$(this.inputCol()))).nonEmpty());
            return schema;
        }

        public MyEstimator copy(ParamMap extra) {
            return (MyEstimator)this.defaultCopy(extra);
        }

        public MyEstimator(String uid) {
            this.uid = uid;
            HasInputCol.class.$init$((HasInputCol)this);
        }
    }

    public static class MyEvaluator
    extends Evaluator {
        private final String uid;

        public double evaluate(Dataset<?> dataset) {
            throw new UnsupportedOperationException();
        }

        public boolean isLargerBetter() {
            return true;
        }

        public String uid() {
            return this.uid;
        }

        public MyEvaluator copy(ParamMap extra) {
            return (MyEvaluator)this.defaultCopy(extra);
        }

        public MyEvaluator() {
            this.uid = "eval";
        }
    }
}

