/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tuning;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionSuite$;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.tuning.TrainValidationSplit;
import org.apache.spark.ml.tuning.TrainValidationSplitModel;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u00015\u0011\u0011\u0004\u0016:bS:4\u0016\r\\5eCRLwN\\*qY&$8+^5uK*\u00111\u0001B\u0001\u0007iVt\u0017N\\4\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019\u0011\"\u0004\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\tU$\u0018\u000e\u001c\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yiB\u00111$H\u0007\u00029)\u0011Q\u0003B\u0005\u0003=q\u0011A\u0003R3gCVdGOU3bI^\u0013\u0018\u000e^3UKN$\b\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0003\u000f\u0015)#\u0001#\u0001'\u0003e!&/Y5o-\u0006d\u0017\u000eZ1uS>t7\u000b\u001d7jiN+\u0018\u000e^3\u0011\u0005\r:c!B\u0001\u0003\u0011\u0003A3cA\u0014*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u0004\"A\u000b\u0019\n\u0005EZ#\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u0011(\t\u0003\u0019D#\u0001\u0014\u0007\u000bU:\u0013\u0011\u0001\u001c\u0003\u000f5KXj\u001c3fYN\u0011Ag\u000e\t\u0004qeZT\"\u0001\u0003\n\u0005i\"!!B'pI\u0016d\u0007C\u0001\u001f5\u001b\u00059\u0003\"\u0002\u00115\t\u0003qD#A\u001e\u0007\t\u0001;\u0003!\u0011\u0002\f\u001bf,5\u000f^5nCR|'oE\u0002@\u0005\u0016\u00032\u0001O\"<\u0013\t!EAA\u0005FgRLW.\u0019;peB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0007g\"\f'/\u001a3\u000b\u0005)#\u0011!\u00029be\u0006l\u0017B\u0001'H\u0005-A\u0015m]%oaV$8i\u001c7\t\u00119{$Q1A\u0005B=\u000b1!^5e+\u0005\u0001\u0006CA)U\u001d\tQ#+\u0003\u0002TW\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u00196\u0006\u0003\u0005Y\u007f\t\u0005\t\u0015!\u0003Q\u0003\u0011)\u0018\u000e\u001a\u0011\t\u000b\u0001zD\u0011\u0001.\u0015\u0005mc\u0006C\u0001\u001f@\u0011\u0015q\u0015\f1\u0001Q\u0011\u0015qv\b\"\u0011`\u0003\r1\u0017\u000e\u001e\u000b\u0003w\u0001DQ!Y/A\u0002\t\fq\u0001Z1uCN,G\u000f\r\u0002dWB\u0019AmZ5\u000e\u0003\u0015T!A\u001a\u0004\u0002\u0007M\fH.\u0003\u0002iK\n9A)\u0019;bg\u0016$\bC\u00016l\u0019\u0001!\u0011\u0002\u001c1\u0002\u0002\u0003\u0005)\u0011A7\u0003\u0007}#\u0013'\u0005\u0002ocB\u0011!f\\\u0005\u0003a.\u0012qAT8uQ&tw\r\u0005\u0002+e&\u00111o\u000b\u0002\u0004\u0003:L\b\"B;@\t\u00032\u0018a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\u0005]l\bC\u0001=|\u001b\u0005I(B\u0001>f\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0018P\u0001\u0006TiJ,8\r\u001e+za\u0016DQA ;A\u0002]\faa]2iK6\f\u0007bBA\u0001\u007f\u0011\u0005\u00131A\u0001\u0005G>\u0004\u0018\u0010F\u0002\\\u0003\u000bAq!a\u0002\u0000\u0001\u0004\tI!A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\f\u00055Q\"A%\n\u0007\u0005=\u0011J\u0001\u0005QCJ\fW.T1q\r\u0019\t\u0019b\n\u0001\u0002\u0016\tYQ*_#wC2,\u0018\r^8s'\u0011\t\t\"a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b\u0005\u0003))g/\u00197vCRLwN\\\u0005\u0005\u0003C\tYBA\u0005Fm\u0006dW/\u0019;pe\"9\u0001%!\u0005\u0005\u0002\u0005\u0015BCAA\u0014!\ra\u0014\u0011\u0003\u0005\t\u0003W\t\t\u0002\"\u0011\u0002.\u0005AQM^1mk\u0006$X\r\u0006\u0003\u00020\u0005U\u0002c\u0001\u0016\u00022%\u0019\u00111G\u0016\u0003\r\u0011{WO\u00197f\u0011\u001d\t\u0017\u0011\u0006a\u0001\u0003o\u0001D!!\u000f\u0002>A!AmZA\u001e!\rQ\u0017Q\b\u0003\f\u0003\u007f\t)$!A\u0001\u0002\u000b\u0005QNA\u0002`IIB\u0001\"a\u0011\u0002\u0012\u0011\u0005\u0013QI\u0001\u000fSNd\u0015M]4fe\n+G\u000f^3s+\t\t9\u0005E\u0002+\u0003\u0013J1!a\u0013,\u0005\u001d\u0011un\u001c7fC:D\u0001BTA\t\u0005\u0004%\te\u0014\u0005\b1\u0006E\u0001\u0015!\u0003Q\u0011!\t\t!!\u0005\u0005B\u0005MC\u0003BA\u0014\u0003+B\u0001\"a\u0002\u0002R\u0001\u0007\u0011\u0011\u0002\u0005\n\u00033:\u0013\u0011!C\u0005\u00037\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\f\t\u0005\u0003?\nI'\u0004\u0002\u0002b)!\u00111MA3\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0014\u0001\u00026bm\u0006LA!a\u001b\u0002b\t1qJ\u00196fGR\u0004")
public class TrainValidationSplitSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData2) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData2);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public TrainValidationSplitSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("train validation with logistic regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrainValidationSplitSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TrainValidationSplitSuite.class.getClassLoader());
                Dataset dataset = this.$outer.spark().createDataFrame(this.$outer.sc().parallelize(LogisticRegressionSuite$.MODULE$.generateLogisticInput(1.0, 1.0, 100, 42), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                LogisticRegression lr = new LogisticRegression();
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.001, 1000.0}).addGrid(lr.maxIter(), new int[]{0, 10}).build();
                BinaryClassificationEvaluator eval = new BinaryClassificationEvaluator();
                TrainValidationSplit cv = new TrainValidationSplit().setEstimator((Estimator)lr).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setTrainRatio(0.5).setSeed(42L);
                TrainValidationSplitModel cvModel = cv.fit(dataset);
                LogisticRegression parent = (LogisticRegression)cvModel.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)cv.getTrainRatio()));
                double $org_scalatest_assert_macro_right = 0.5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right2 = 0.001;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right3 = 10;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel.validationMetrics().length));
                int $org_scalatest_assert_macro_right4 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("train validation with linear regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrainValidationSplitSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TrainValidationSplitSuite.class.getClassLoader());
                Dataset dataset = this.$outer.spark().createDataFrame(this.$outer.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 100, 42, 0.1), 2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                        return x$1.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                LinearRegression trainer = new LinearRegression().setSolver("l-bfgs");
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(trainer.regParam(), new double[]{1000.0, 0.001}).addGrid(trainer.maxIter(), new int[]{0, 10}).build();
                RegressionEvaluator eval = new RegressionEvaluator();
                TrainValidationSplit cv = new TrainValidationSplit().setEstimator((Estimator)trainer).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setTrainRatio(0.5).setSeed(42L);
                TrainValidationSplitModel cvModel = cv.fit(dataset);
                LinearRegression parent = (LinearRegression)cvModel.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right = 0.001;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right2 = 10;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel.validationMetrics().length));
                int $org_scalatest_assert_macro_right3 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                eval.setMetricName("r2");
                TrainValidationSplitModel cvModel2 = cv.fit(dataset);
                LinearRegression parent2 = (LinearRegression)cvModel2.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent2.getRegParam()));
                double $org_scalatest_assert_macro_right4 = 0.001;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent2.getMaxIter()));
                int $org_scalatest_assert_macro_right5 = 10;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel2.validationMetrics().length));
                int $org_scalatest_assert_macro_right6 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("transformSchema should check estimatorParamMaps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrainValidationSplitSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyEstimator est = new MyEstimator("est");
                MyEvaluator eval = new MyEvaluator();
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(est.inputCol(), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input1", "input2"})).build();
                TrainValidationSplit cv = new TrainValidationSplit().setEstimator((Estimator)est).setEstimatorParamMaps(paramMaps).setEvaluator((Evaluator)eval).setTrainRatio(0.5);
                cv.transformSchema(new StructType());
                ParamMap[] invalidParamMaps = (ParamMap[])Predef$.MODULE$.refArrayOps((Object[])paramMaps).$colon$plus((Object)ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{est.inputCol().$minus$greater((Object)"")})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParamMap.class)));
                cv.setEstimatorParamMaps(invalidParamMaps);
                this.$outer.intercept((Function0)new Serializable(this, cv){
                    public static final long serialVersionUID = 0L;
                    private final TrainValidationSplit cv$1;

                    public final StructType apply() {
                        return this.cv$1.transformSchema(new StructType());
                    }
                    {
                        this.cv$1 = cv$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: TrainValidationSplit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrainValidationSplitSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(3);
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator();
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).build();
                TrainValidationSplit tvs = new TrainValidationSplit().setEstimator((Estimator)lr).setEvaluator((Evaluator)evaluator).setTrainRatio(0.5).setEstimatorParamMaps(paramMaps).setSeed(42L);
                TrainValidationSplit tvs2 = this.$outer.testDefaultReadWrite(tvs, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)tvs.getTrainRatio()));
                double $org_scalatest_assert_macro_right = tvs2.getTrainRatio();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tvs.getSeed()));
                long $org_scalatest_assert_macro_right2 = tvs2.getSeed();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: TrainValidationSplitModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrainValidationSplitSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setThreshold(0.6);
                LogisticRegressionModel lrModel = new LogisticRegressionModel(lr.uid(), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), 1.2).setThreshold(0.6);
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator();
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).build();
                TrainValidationSplitModel tvs = new TrainValidationSplitModel("cvUid", (Model)lrModel, new double[]{0.3, 0.6});
                tvs.set(tvs.estimator(), (Object)lr).set(tvs.evaluator(), (Object)evaluator).set((Param)tvs.trainRatio(), (Object)BoxesRunTime.boxToDouble((double)0.5)).set(tvs.estimatorParamMaps(), (Object)paramMaps).set((Param)tvs.seed(), (Object)BoxesRunTime.boxToLong((long)42L));
                TrainValidationSplitModel tvs2 = this.$outer.testDefaultReadWrite(tvs, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)tvs.getTrainRatio()));
                double $org_scalatest_assert_macro_right = tvs2.getTrainRatio();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(tvs.validationMetrics());
                double[] $org_scalatest_assert_macro_right2 = tvs2.validationMetrics();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tvs.getSeed()));
                long $org_scalatest_assert_macro_right3 = tvs2.getSeed();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static abstract class MyModel
    extends Model<MyModel> {
    }

    public static class MyEstimator
    extends Estimator<MyModel>
    implements HasInputCol {
        private final String uid;
        private final Param<String> inputCol;

        public final Param<String> inputCol() {
            return this.inputCol;
        }

        public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
            this.inputCol = x$1;
        }

        public final String getInputCol() {
            return HasInputCol.class.getInputCol((HasInputCol)this);
        }

        public String uid() {
            return this.uid;
        }

        public MyModel fit(Dataset<?> dataset) {
            throw new UnsupportedOperationException();
        }

        public StructType transformSchema(StructType schema) {
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString((String)this.$(this.inputCol()))).nonEmpty());
            return schema;
        }

        public MyEstimator copy(ParamMap extra) {
            return (MyEstimator)this.defaultCopy(extra);
        }

        public MyEstimator(String uid) {
            this.uid = uid;
            HasInputCol.class.$init$((HasInputCol)this);
        }
    }

    public static class MyEvaluator
    extends Evaluator {
        private final String uid;

        public double evaluate(Dataset<?> dataset) {
            throw new UnsupportedOperationException();
        }

        public boolean isLargerBetter() {
            return true;
        }

        public String uid() {
            return this.uid;
        }

        public MyEvaluator copy(ParamMap extra) {
            return (MyEvaluator)this.defaultCopy(extra);
        }

        public MyEvaluator() {
            this.uid = "eval";
        }
    }
}

