/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MLTestingUtils$
extends SparkFunSuite {
    public static final MLTestingUtils$ MODULE$;

    static {
        new MLTestingUtils$();
    }

    public void checkCopy(Model<?> model) {
        Model copied = model.copy(ParamMap$.MODULE$.empty());
        String $org_scalatest_assert_macro_left = copied.parent().uid();
        String $org_scalatest_assert_macro_right = model.parent().uid();
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        Estimator $org_scalatest_assert_macro_left2 = copied.parent();
        Estimator $org_scalatest_assert_macro_right2 = model.parent();
        Estimator estimator = $org_scalatest_assert_macro_left2;
        Estimator estimator2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(estimator != null ? !estimator.equals(estimator2) : estimator2 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    public <M extends Model<M>, T extends Estimator<M>> void checkNumericTypes(T estimator, SparkSession spark, boolean isClassification, Function2<M, M, BoxedUnit> check) {
        Map<NumericType, Dataset<Row>> dfs = isClassification ? this.genClassifDFWithNumericLabelCol(spark, this.genClassifDFWithNumericLabelCol$default$2(), this.genClassifDFWithNumericLabelCol$default$3()) : this.genRegressionDFWithNumericLabelCol(spark, this.genRegressionDFWithNumericLabelCol$default$2(), this.genRegressionDFWithNumericLabelCol$default$3(), this.genRegressionDFWithNumericLabelCol$default$4());
        Model expected = estimator.fit((Dataset)dfs.apply((Object)DoubleType$.MODULE$));
        Iterable actuals = (Iterable)((TraversableLike)dfs.keys().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(NumericType x$1) {
                NumericType numericType = x$1;
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                return numericType != null ? !numericType.equals(doubleType$) : doubleType$ != null;
            }
        })).map((Function1)new Serializable(estimator, dfs){
            public static final long serialVersionUID = 0L;
            private final Estimator estimator$1;
            private final Map dfs$1;

            public final M apply(NumericType t) {
                return (M)this.estimator$1.fit((Dataset)this.dfs$1.apply((Object)t));
            }
            {
                this.estimator$1 = estimator$1;
                this.dfs$1 = dfs$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        actuals.foreach((Function1)new Serializable(check, expected){
            public static final long serialVersionUID = 0L;
            private final Function2 check$1;
            private final Model expected$1;

            public final void apply(M actual) {
                this.check$1.apply((Object)this.expected$1, actual);
            }
            {
                this.check$1 = check$1;
                this.expected$1 = expected$1;
            }
        });
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(((Object)((Object)this)).getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$1() {
            }
        }
        Dataset dfWithStringLabels = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"0", (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), (Object)BoxesRunTime.boxToDouble((double)0.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features", "censor"}));
        IllegalArgumentException thrown = (IllegalArgumentException)this.intercept((Function0)new Serializable(estimator, dfWithStringLabels){
            public static final long serialVersionUID = 0L;
            private final Estimator estimator$1;
            private final Dataset dfWithStringLabels$1;

            public final M apply() {
                return (M)this.estimator$1.fit(this.dfWithStringLabels$1);
            }
            {
                this.estimator$1 = estimator$1;
                this.dfWithStringLabels$1 = dfWithStringLabels$1;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        String $org_scalatest_assert_macro_left = thrown.getMessage();
        String $org_scalatest_assert_macro_right = "Column label must be of type NumericType but was actually of type StringType";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public void checkNumericTypesALS(ALS estimator, SparkSession spark, String column, NumericType baseType, Function2<ALSModel, ALSModel, BoxedUnit> check, Function3<ALSModel, ALSModel, Dataset<Row>, BoxedUnit> check2) {
        Map<NumericType, Dataset<Row>> dfs = this.genRatingsDFWithNumericCols(spark, column);
        ALSModel expected = estimator.fit((Dataset)dfs.apply((Object)baseType));
        Iterable actuals = (Iterable)((TraversableLike)dfs.keys().filter((Function1)new Serializable(baseType){
            public static final long serialVersionUID = 0L;
            private final NumericType baseType$1;

            public final boolean apply(NumericType x$2) {
                NumericType numericType = x$2;
                NumericType numericType2 = this.baseType$1;
                return numericType != null ? !numericType.equals(numericType2) : numericType2 != null;
            }
            {
                this.baseType$1 = baseType$1;
            }
        })).map((Function1)new Serializable(estimator, dfs){
            public static final long serialVersionUID = 0L;
            private final ALS estimator$2;
            private final Map dfs$2;

            public final Tuple2<NumericType, ALSModel> apply(NumericType t) {
                return new Tuple2((Object)t, (Object)this.estimator$2.fit((Dataset)this.dfs$2.apply((Object)t)));
            }
            {
                this.estimator$2 = estimator$2;
                this.dfs$2 = dfs$2;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        actuals.foreach((Function1)new Serializable(check, expected){
            public static final long serialVersionUID = 0L;
            private final Function2 check$2;
            private final ALSModel expected$2;

            public final void apply(Tuple2<NumericType, ALSModel> x0$1) {
                Tuple2<NumericType, ALSModel> tuple2 = x0$1;
                if (tuple2 != null) {
                    ALSModel actual = (ALSModel)tuple2._2();
                    BoxedUnit boxedUnit = (BoxedUnit)this.check$2.apply((Object)this.expected$2, (Object)actual);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.check$2 = check$2;
                this.expected$2 = expected$2;
            }
        });
        actuals.foreach((Function1)new Serializable(check2, dfs, expected){
            public static final long serialVersionUID = 0L;
            private final Function3 check2$1;
            private final Map dfs$2;
            private final ALSModel expected$2;

            public final void apply(Tuple2<NumericType, ALSModel> x0$2) {
                Tuple2<NumericType, ALSModel> tuple2 = x0$2;
                if (tuple2 != null) {
                    NumericType t = (NumericType)tuple2._1();
                    ALSModel actual = (ALSModel)tuple2._2();
                    BoxedUnit boxedUnit = (BoxedUnit)this.check2$1.apply((Object)this.expected$2, (Object)actual, this.dfs$2.apply((Object)t));
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.check2$1 = check2$1;
                this.dfs$2 = dfs$2;
                this.expected$2 = expected$2;
            }
        });
        Dataset baseDF = (Dataset)dfs.apply((Object)baseType);
        Seq others = (Seq)((TraversableLike)Predef$.MODULE$.refArrayOps((Object[])baseDF.columns()).toSeq().diff((GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{column})))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String x$3) {
                return functions$.MODULE$.col(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq cols = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(column).cast((DataType)StringType$.MODULE$)}))).$plus$plus((GenTraversableOnce)others, Seq$.MODULE$.canBuildFrom());
        Dataset strDF = baseDF.select(cols);
        IllegalArgumentException thrown = (IllegalArgumentException)this.intercept((Function0)new Serializable(estimator, strDF){
            public static final long serialVersionUID = 0L;
            private final ALS estimator$2;
            private final Dataset strDF$1;

            public final ALSModel apply() {
                return this.estimator$2.fit(this.strDF$1);
            }
            {
                this.estimator$2 = estimator$2;
                this.strDF$1 = strDF$1;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        String $org_scalatest_assert_macro_left = thrown.getMessage();
        String $org_scalatest_assert_macro_right = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " must be of type NumericType but was actually of type StringType"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public <T extends Evaluator> void checkNumericTypes(T evaluator, SparkSession spark) {
        Map<NumericType, Dataset<Row>> dfs = this.genEvaluatorDFWithNumericLabelCol(spark, "label", "prediction");
        double expected = evaluator.evaluate((Dataset)dfs.apply((Object)DoubleType$.MODULE$));
        Iterable actuals = (Iterable)((TraversableLike)dfs.keys().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(NumericType x$4) {
                NumericType numericType = x$4;
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                return numericType != null ? !numericType.equals(doubleType$) : doubleType$ != null;
            }
        })).map((Function1)new Serializable(evaluator, dfs){
            public static final long serialVersionUID = 0L;
            private final Evaluator evaluator$1;
            private final Map dfs$3;

            public final double apply(NumericType t) {
                return this.evaluator$1.evaluate((Dataset)this.dfs$3.apply((Object)t));
            }
            {
                this.evaluator$1 = evaluator$1;
                this.dfs$3 = dfs$3;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        actuals.foreach((Function1)new Serializable(expected){
            public static final long serialVersionUID = 0L;
            private final double expected$3;

            public final void apply(double actual) {
                this.apply$mcVD$sp(actual);
            }

            public void apply$mcVD$sp(double actual) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = MLTestingUtils$.MODULE$.convertToEqualizer(BoxesRunTime.boxToDouble((double)this.expected$3));
                double $org_scalatest_assert_macro_right = actual;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                MLTestingUtils$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                this.expected$3 = expected$3;
            }
        });
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(((Object)((Object)this)).getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$1() {
            }
        }
        Dataset dfWithStringLabels = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)BoxesRunTime.boxToDouble((double)0.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "prediction"}));
        IllegalArgumentException thrown = (IllegalArgumentException)this.intercept((Function0)new Serializable(evaluator, dfWithStringLabels){
            public static final long serialVersionUID = 0L;
            private final Evaluator evaluator$1;
            private final Dataset dfWithStringLabels$2;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.evaluator$1.evaluate(this.dfWithStringLabels$2);
            }
            {
                this.evaluator$1 = evaluator$1;
                this.dfWithStringLabels$2 = dfWithStringLabels$2;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        String $org_scalatest_assert_macro_left = thrown.getMessage();
        String $org_scalatest_assert_macro_right = "Column label must be of type NumericType but was actually of type StringType";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public <M extends Model<M>, T extends Estimator<M>> boolean checkNumericTypes$default$3() {
        return true;
    }

    public Map<NumericType, Dataset<Row>> genClassifDFWithNumericLabelCol(SparkSession spark, String labelColName, String featuresColName) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(((Object)((Object)this)).getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator3$1() {
            }
        }
        Dataset df = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 1.0}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 2.0}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 9.0}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator3$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{labelColName, featuresColName}));
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ShortType$.MODULE$, LongType$.MODULE$, IntegerType$.MODULE$, FloatType$.MODULE$, ByteType$.MODULE$, DoubleType$.MODULE$, new DecimalType(10, 0)}));
        return ((TraversableOnce)types.map((Function1)new Serializable(labelColName, featuresColName, df){
            public static final long serialVersionUID = 0L;
            private final String labelColName$2;
            private final String featuresColName$2;
            private final Dataset df$1;

            public final Tuple2<NumericType, Dataset<Row>> apply(NumericType t) {
                Dataset castDF = this.df$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.labelColName$2).cast((DataType)t), functions$.MODULE$.col(this.featuresColName$2)}));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)t), TreeTests$.MODULE$.setMetadata((Dataset<Row>)castDF, 2, this.labelColName$2, this.featuresColName$2));
            }
            {
                this.labelColName$2 = labelColName$2;
                this.featuresColName$2 = featuresColName$2;
                this.df$1 = df$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public String genClassifDFWithNumericLabelCol$default$2() {
        return "label";
    }

    public String genClassifDFWithNumericLabelCol$default$3() {
        return "features";
    }

    public Map<NumericType, Dataset<Row>> genRegressionDFWithNumericLabelCol(SparkSession spark, String labelColName, String featuresColName, String censorColName) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(((Object)((Object)this)).getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$1() {
            }
        }
        Dataset df = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{labelColName, featuresColName}));
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ShortType$.MODULE$, LongType$.MODULE$, IntegerType$.MODULE$, FloatType$.MODULE$, ByteType$.MODULE$, DoubleType$.MODULE$, new DecimalType(10, 0)}));
        return ((TraversableOnce)types.map((Function1)new Serializable(labelColName, featuresColName, censorColName, df){
            public static final long serialVersionUID = 0L;
            private final String labelColName$1;
            private final String featuresColName$1;
            private final String censorColName$1;
            private final Dataset df$2;

            public final Tuple2<NumericType, Dataset<Row>> apply(NumericType t) {
                Dataset castDF = this.df$2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.labelColName$1).cast((DataType)t), functions$.MODULE$.col(this.featuresColName$1)}));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)t), (Object)TreeTests$.MODULE$.setMetadata((Dataset<Row>)castDF, 0, this.labelColName$1, this.featuresColName$1).withColumn(this.censorColName$1, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0))));
            }
            {
                this.labelColName$1 = labelColName$1;
                this.featuresColName$1 = featuresColName$1;
                this.censorColName$1 = censorColName$1;
                this.df$2 = df$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public String genRegressionDFWithNumericLabelCol$default$2() {
        return "label";
    }

    public String genRegressionDFWithNumericLabelCol$default$3() {
        return "features";
    }

    public String genRegressionDFWithNumericLabelCol$default$4() {
        return "censor";
    }

    public Map<NumericType, Dataset<Row>> genRatingsDFWithNumericCols(SparkSession spark, String column) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(((Object)((Object)this)).getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$1() {
            }
        }
        Dataset df = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)40), (Object)BoxesRunTime.boxToDouble((double)4.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)50), (Object)BoxesRunTime.boxToDouble((double)5.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user", "item", "rating"}));
        Seq others = (Seq)((TraversableLike)Predef$.MODULE$.refArrayOps((Object[])df.columns()).toSeq().diff((GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{column})))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String x$5) {
                return functions$.MODULE$.col(x$5);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ShortType$.MODULE$, LongType$.MODULE$, IntegerType$.MODULE$, FloatType$.MODULE$, ByteType$.MODULE$, DoubleType$.MODULE$, new DecimalType(10, 0)}));
        return ((TraversableOnce)types.map((Function1)new Serializable(column, df, others){
            public static final long serialVersionUID = 0L;
            private final String column$1;
            private final Dataset df$3;
            private final Seq others$1;

            public final Tuple2<NumericType, Dataset<Row>> apply(NumericType t) {
                Seq cols = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.column$1).cast((DataType)t)}))).$plus$plus((GenTraversableOnce)this.others$1, Seq$.MODULE$.canBuildFrom());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)t), (Object)this.df$3.select(cols));
            }
            {
                this.column$1 = column$1;
                this.df$3 = df$3;
                this.others$1 = others$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Map<NumericType, Dataset<Row>> genEvaluatorDFWithNumericLabelCol(SparkSession spark, String labelColName, String predictionColName) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(((Object)((Object)this)).getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator6$1() {
            }
        }
        Dataset df = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0), new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(2, 2.0), new Tuple2.mcID.sp(3, 3.0), new Tuple2.mcID.sp(4, 4.0)})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator6$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{labelColName, predictionColName}));
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ShortType$.MODULE$, LongType$.MODULE$, IntegerType$.MODULE$, FloatType$.MODULE$, ByteType$.MODULE$, DoubleType$.MODULE$, new DecimalType(10, 0)}));
        return ((TraversableOnce)types.map((Function1)new Serializable(labelColName, predictionColName, df){
            public static final long serialVersionUID = 0L;
            private final String labelColName$3;
            private final String predictionColName$1;
            private final Dataset df$4;

            public final Tuple2<NumericType, Dataset<Row>> apply(NumericType t) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)t), (Object)this.df$4.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.labelColName$3).cast((DataType)t), functions$.MODULE$.col(this.predictionColName$1)})));
            }
            {
                this.labelColName$3 = labelColName$3;
                this.predictionColName$1 = predictionColName$1;
                this.df$4 = df$4;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public String genEvaluatorDFWithNumericLabelCol$default$2() {
        return "label";
    }

    public String genEvaluatorDFWithNumericLabelCol$default$3() {
        return "prediction";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MLTestingUtils$() {
        MODULE$ = this;
    }
}

