/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.File;
import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMModel$;
import org.apache.spark.mllib.classification.SVMSuite$;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.classification.SVMWithSGD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001u<Q!\u0001\u0002\t\u00025\t\u0001b\u0015,N'VLG/\u001a\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u0003\u0011M3VjU;ji\u0016\u001c2a\u0004\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u00111#G\u0005\u00035Q\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001H\b\u0005\u0002u\ta\u0001P5oSRtD#A\u0007\t\u000b}yA\u0011\u0001\u0011\u0002-\u001d,g.\u001a:bi\u0016\u001cf+T%oaV$\u0018i\u001d'jgR$R!I\u00185sy\u00022AI\u0014*\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011)H/\u001b7\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002+[5\t1F\u0003\u0002-\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\n\u00059Z#\u0001\u0004'bE\u0016dW\r\u001a)pS:$\b\"\u0002\u0019\u001f\u0001\u0004\t\u0014!C5oi\u0016\u00148-\u001a9u!\t\u0019\"'\u0003\u00024)\t1Ai\\;cY\u0016DQ!\u000e\u0010A\u0002Y\nqa^3jO\"$8\u000fE\u0002\u0014oEJ!\u0001\u000f\u000b\u0003\u000b\u0005\u0013(/Y=\t\u000bir\u0002\u0019A\u001e\u0002\u000f9\u0004v.\u001b8ugB\u00111\u0003P\u0005\u0003{Q\u00111!\u00138u\u0011\u0015yd\u00041\u0001<\u0003\u0011\u0019X-\u001a3\t\u000b\u0005{A\u0011\u0001\"\u0002!\u001d,g.\u001a:bi\u0016\u001cf+T%oaV$H#B\"P!F\u0013\u0006c\u0001#MS9\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u00112\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005-#\u0012a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tYE\u0003C\u00031\u0001\u0002\u0007\u0011\u0007C\u00036\u0001\u0002\u0007a\u0007C\u0003;\u0001\u0002\u00071\bC\u0003@\u0001\u0002\u00071\bC\u0004U\u001f\t\u0007I\u0011B+\u0002\u0017\tLg.\u0019:z\u001b>$W\r\\\u000b\u0002-B\u0011abV\u0005\u00031\n\u0011\u0001b\u0015,N\u001b>$W\r\u001c\u0005\u00075>\u0001\u000b\u0011\u0002,\u0002\u0019\tLg.\u0019:z\u001b>$W\r\u001c\u0011\t\u000fq{\u0011\u0011!C\u0005;\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005q\u0006CA0c\u001b\u0005\u0001'BA1&\u0003\u0011a\u0017M\\4\n\u0005\r\u0004'AB(cU\u0016\u001cGO\u0002\u0003\u0011\u0005\u0001)7c\u00013gUB\u0011q\r[\u0007\u0002\r%\u0011\u0011N\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005-lW\"\u00017\u000b\u0005\u0011\"\u0011B\u00018m\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqRDQ\u0001\b3\u0005\u0002A$\u0012!\u001d\t\u0003\u001d\u0011DQa\u001d3\u0005\u0002Q\f!C^1mS\u0012\fG/\u001a)sK\u0012L7\r^5p]R\u0019Q\u000f_>\u0011\u0005M1\u0018BA<\u0015\u0005\u0011)f.\u001b;\t\u000be\u0014\b\u0019\u0001>\u0002\u0017A\u0014X\rZ5di&|gn\u001d\t\u0004\t2\u000b\u0004\"\u0002?s\u0001\u0004\u0019\u0015!B5oaV$\b")
public class SVMSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Seq<LabeledPoint> generateSVMInput(double d, double[] dArray, int n, int n2) {
        return SVMSuite$.MODULE$.generateSVMInput(d, dArray, n, n2);
    }

    public static List<LabeledPoint> generateSVMInputAsList(double d, double[] dArray, int n, int n2) {
        return SVMSuite$.MODULE$.generateSVMInputAsList(d, dArray, n, n2);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOffPredictions;
        int $org_scalatest_assert_macro_left = numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, LabeledPoint> x0$1) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$1;
                if (tuple2 != null) {
                    LabeledPoint expected;
                    double prediction = tuple2._1$mcD$sp();
                    boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public SVMSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("SVM with threshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SVMSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 0.01;
                double B = -1.5;
                double C = 1.0;
                Seq<LabeledPoint> testData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42);
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                SVMWithSGD svm = (SVMWithSGD)new SVMWithSGD().setIntercept(true);
                svm.optimizer().setStepSize(1.0).setRegParam(1.0).setNumIterations(100);
                SVMModel model = (SVMModel)svm.run(testRDD);
                Seq<LabeledPoint> validationData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                double[] predictions = (double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$1) {
                        return x$1.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect();
                int $org_scalatest_assert_macro_left = Predef$.MODULE$.doubleArrayOps(predictions).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$2) {
                        return this.apply$mcZD$sp(x$2);
                    }

                    public boolean apply$mcZD$sp(double x$2) {
                        return x$2 == 0.0;
                    }
                });
                int $org_scalatest_assert_macro_right = predictions.length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                model.setThreshold(10000.0);
                predictions = (double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$3) {
                        return x$3.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect();
                int $org_scalatest_assert_macro_left2 = Predef$.MODULE$.doubleArrayOps(predictions).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$4) {
                        return this.apply$mcZD$sp(x$4);
                    }

                    public boolean apply$mcZD$sp(double x$4) {
                        return x$4 == 0.0;
                    }
                });
                int $org_scalatest_assert_macro_right2 = predictions.length;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                model.setThreshold(-10000.0);
                predictions = (double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$5) {
                        return x$5.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect();
                int $org_scalatest_assert_macro_left3 = Predef$.MODULE$.doubleArrayOps(predictions).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$6) {
                        return this.apply$mcZD$sp(x$6);
                    }

                    public boolean apply$mcZD$sp(double x$6) {
                        return x$6 == 1.0;
                    }
                });
                int $org_scalatest_assert_macro_right3 = predictions.length;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SVM using local random SGD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SVMSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 0.01;
                double B = -1.5;
                double C = 1.0;
                Seq<LabeledPoint> testData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42);
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                SVMWithSGD svm = (SVMWithSGD)new SVMWithSGD().setIntercept(true);
                svm.optimizer().setStepSize(1.0).setRegParam(1.0).setNumIterations(100);
                SVMModel model = (SVMModel)svm.run(testRDD);
                Seq<LabeledPoint> validationData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$7) {
                        return x$7.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final SVMModel model$1;

                    public final double apply(LabeledPoint row) {
                        return this.model$1.predict(row.features());
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SVM local random SGD with initial weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SVMSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 0.01;
                double B = -1.5;
                double C = 1.0;
                Seq<LabeledPoint> testData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42);
                double initialB = -1.0;
                double initialC = -1.0;
                Vector initialWeights = Vectors$.MODULE$.dense(initialB, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{initialC}));
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                SVMWithSGD svm = (SVMWithSGD)new SVMWithSGD().setIntercept(true);
                svm.optimizer().setStepSize(1.0).setRegParam(1.0).setNumIterations(100);
                SVMModel model = (SVMModel)svm.run(testRDD, initialWeights);
                Seq<LabeledPoint> validationData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$8) {
                        return x$8.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final SVMModel model$2;

                    public final double apply(LabeledPoint row) {
                        return this.model$2.predict(row.features());
                    }
                    {
                        this.model$2 = model$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SVM with invalid labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SVMSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 0.01;
                double B = -1.5;
                double C = 1.0;
                Seq<LabeledPoint> testData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42);
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD testRDDInvalid = testRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint lp) {
                        return lp.label() == 0.0 ? new LabeledPoint(-1.0, lp.features()) : lp;
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.intercept((Function0)new Serializable(this, testRDDInvalid){
                    public static final long serialVersionUID = 0L;
                    private final RDD testRDDInvalid$1;

                    public final SVMModel apply() {
                        return SVMWithSGD$.MODULE$.train(this.testRDDInvalid$1, 100);
                    }
                    {
                        this.testRDDInvalid$1 = testRDDInvalid$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                new SVMWithSGD().setValidateData(false).run(testRDDInvalid);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SVMSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                SVMModel model = SVMSuite$.MODULE$.org$apache$spark$mllib$classification$SVMSuite$$binaryModel();
                model.clearThreshold();
                Option $org_scalatest_assert_macro_left = model.getThreshold();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    SVMModel sameModel = SVMModel$.MODULE$.load(this.$outer.sc(), path);
                    Vector $org_scalatest_assert_macro_left2 = model.weights();
                    Vector $org_scalatest_assert_macro_right = sameModel.weights();
                    Vector vector = $org_scalatest_assert_macro_left2;
                    Vector vector2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(vector != null ? !vector.equals(vector2) : vector2 != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    double $org_scalatest_assert_macro_left3 = model.intercept();
                    double $org_scalatest_assert_macro_right2 = sameModel.intercept();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right2);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    Option $org_scalatest_assert_macro_left4 = sameModel.getThreshold();
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    try {
                        model.setThreshold(0.7);
                        model.save(this.$outer.sc(), path);
                        SVMModel sameModel2 = SVMModel$.MODULE$.load(this.$outer.sc(), path);
                        double $org_scalatest_assert_macro_left5 = BoxesRunTime.unboxToDouble((Object)model.getThreshold().get());
                        double $org_scalatest_assert_macro_right3 = BoxesRunTime.unboxToDouble((Object)sameModel2.getThreshold().get());
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right3);
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        return;
                    }
                    finally {
                        Utils$.MODULE$.deleteRecursively(tempDir);
                    }
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

