/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.classification.StreamingLogisticRegressionSuite$$anonfun$2$;
import org.apache.spark.mllib.classification.StreamingLogisticRegressionWithSGD;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u001b\t\u00013\u000b\u001e:fC6Lgn\u001a'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u001cV/\u001b;f\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003/Q\u0011Q\u0002V3tiN+\u0018\u000e^3CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0011 \u0003Ei\u0017\r_,bSR$\u0016.\\3NS2d\u0017n]\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t\u0019\u0011J\u001c;\t\u0013\u001d\u0002\u0001\u0019!a\u0001\n\u0003A\u0013aA:tGV\t\u0011\u0006\u0005\u0002\u0014U%\u00111\u0006\u0006\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqRD\u0011\"\f\u0001A\u0002\u0003\u0007I\u0011\u0001\u0018\u0002\u000fM\u001c8m\u0018\u0013fcR\u0011qF\r\t\u0003CAJ!!\r\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bg1\n\t\u00111\u0001*\u0003\rAH%\r\u0005\u0007k\u0001\u0001\u000b\u0015B\u0015\u0002\tM\u001c8\r\t\u0005\u0006o\u0001!\t\u0005O\u0001\u000eC\u001a$XM\u001d$v]\u000e$\u0018n\u001c8\u0015\u0003=\u0002")
public class StreamingLogisticRegressionSuite
extends SparkFunSuite
implements TestSuiteBase {
    private StreamingContext ssc;
    private final String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    private String checkpointDir$lzycompute() {
        StreamingLogisticRegressionSuite streamingLogisticRegressionSuite = this;
        synchronized (streamingLogisticRegressionSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.class.checkpointDir((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
            return this.checkpointDir;
        }
    }

    public String checkpointDir() {
        return this.bitmap$0 ? this.checkpointDir : this.checkpointDir$lzycompute();
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public String framework() {
        return TestSuiteBase.class.framework((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.class.master((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.class.batchDuration((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.class.numInputPartitions((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.class.useManualClock((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.class.actuallyWait((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.class.beforeFunction((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.class.withStreamingContext((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.class.withTestServer((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.class.setupStreams((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.class.setupStreams((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag<V> evidence$9) {
        return TestSuiteBase.class.runStreams((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, evidence$9);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag<V> evidence$10) {
        return TestSuiteBase.class.runStreamsWithPartitions((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, evidence$10);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.class.verifyOutput((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.class.testOperation$default$4((TestSuiteBase)this);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.class.setupStreams$default$3((TestSuiteBase)this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public int maxWaitTimeMillis() {
        return 30000;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    public void afterFunction() {
        TestSuiteBase.class.afterFunction((TestSuiteBase)this);
        if (this.ssc() != null) {
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
        }
    }

    public StreamingLogisticRegressionSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        TestSuiteBase.class.$init$((TestSuiteBase)this);
        this.test("parameter accuracy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 100;
                double B = 1.5;
                StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
                int numBatches = 20;
                IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this, nPoints, B){
                    public static final long serialVersionUID = 0L;
                    private final int nPoints$1;
                    private final double B$1;

                    public final Seq<LabeledPoint> apply(int i) {
                        return LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, this.B$1, this.nPoints$1, 42 * (i + 1));
                    }
                    {
                        this.nPoints$1 = nPoints$1;
                        this.B$1 = B$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.$outer.ssc_$eq(this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLogisticRegressionWithSGD model$1;

                    public final DStream<Object> apply(DStream<LabeledPoint> inputDStream) {
                        this.model$1.trainOn(inputDStream);
                        return inputDStream.count();
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.Long()));
                this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((LogisticRegressionModel)model.latestModel()).weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.latestModel().weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.1))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parameter convergence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double B = 1.5;
                int nPoints = 100;
                StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
                int numBatches = 20;
                IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this, B, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final double B$2;
                    private final int nPoints$2;

                    public final Seq<LabeledPoint> apply(int i) {
                        return LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, this.B$2, this.nPoints$2, 42 * (i + 1));
                    }
                    {
                        this.B$2 = B$2;
                        this.nPoints$2 = nPoints$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                ArrayBuffer history = new ArrayBuffer(numBatches);
                this.$outer.ssc_$eq(this.$outer.setupStreams(input, new Serializable(this, B, model, history){
                    public static final long serialVersionUID = 0L;
                    public final double B$2;
                    public final StreamingLogisticRegressionWithSGD model$2;
                    public final ArrayBuffer history$1;

                    public final DStream<Object> apply(DStream<LabeledPoint> inputDStream) {
                        this.model$2.trainOn(inputDStream);
                        inputDStream.foreachRDD((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$2 $outer;

                            public final void apply(RDD<LabeledPoint> x) {
                                this.$outer.history$1.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{package$.MODULE$.abs(((LogisticRegressionModel)this.$outer.model$2.latestModel()).weights().apply(0) - this.$outer.B$2)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        return inputDStream.count();
                    }
                    {
                        this.B$2 = B$2;
                        this.model$2 = model$2;
                        this.history$1 = history$1;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.Long()));
                this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                ArrayBuffer deltas = (ArrayBuffer)((IndexedSeqOptimized)history.drop(1)).zip((GenIterable)history.dropRight(1), ArrayBuffer$.MODULE$.canBuildFrom());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(deltas.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> x) {
                        return x._1$mcD$sp() - x._2$mcD$sp() <= 0.1;
                    }
                }), "deltas.forall(((x: (Double, Double)) => x._1.-(x._2).<=(0.1)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)((TraversableOnce)deltas.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x) {
                        return x._1$mcD$sp() - x._2$mcD$sp() < 0.0 ? 1 : 0;
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("predictions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double B = 1.5;
                int nPoints = 100;
                StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
                int numBatches = 10;
                IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this, B, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final double B$3;
                    private final int nPoints$3;

                    public final Seq<LabeledPoint> apply(int i) {
                        return LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, this.B$3, this.nPoints$3, 42 * (i + 1));
                    }
                    {
                        this.B$3 = B$3;
                        this.nPoints$3 = nPoints$3;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.$outer.ssc_$eq(this.$outer.setupStreams(testInput, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLogisticRegressionWithSGD model$3;

                    public final DStream<Tuple2<Object, Object>> apply(DStream<LabeledPoint> inputDStream) {
                        return this.model$3.predictOnValues(inputDStream.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Vector> apply(LabeledPoint x) {
                                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features());
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                    }
                    {
                        this.model$3 = model$3;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
                Seq<Seq<V>> output = this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                Seq errors = (Seq)output.map((Function1)new Serializable(this, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final int nPoints$3;

                    public final double apply(Seq<Tuple2<Object, Object>> batch) {
                        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object> p) {
                                return package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp());
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.nPoints$3;
                    }
                    {
                        this.nPoints$3 = nPoints$3;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(errors.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x) {
                        return this.apply$mcZD$sp(x);
                    }

                    public boolean apply$mcZD$sp(double x) {
                        return x <= 0.4;
                    }
                }), "errors.forall(((x: Double) => x.<=(0.4)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("training and prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.01).setNumIterations(10);
                int numBatches = 10;
                int nPoints = 100;
                IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final int nPoints$4;

                    public final Seq<LabeledPoint> apply(int i) {
                        return LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, 5.0, this.nPoints$4, 42 * (i + 1));
                    }
                    {
                        this.nPoints$4 = nPoints$4;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.$outer.ssc_$eq(this.$outer.setupStreams(testInput, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLogisticRegressionWithSGD model$4;

                    public final DStream<Tuple2<Object, Object>> apply(DStream<LabeledPoint> inputDStream) {
                        this.model$4.trainOn(inputDStream);
                        return this.model$4.predictOnValues(inputDStream.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Vector> apply(LabeledPoint x) {
                                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features());
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                    }
                    {
                        this.model$4 = model$4;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
                Seq<Seq<V>> output = this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                List error = ((TraversableOnce)output.map((Function1)new Serializable(this, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final int nPoints$4;

                    public final double apply(Seq<Tuple2<Object, Object>> batch) {
                        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object> p) {
                                return package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp());
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.nPoints$4;
                    }
                    {
                        this.nPoints$4 = nPoints$4;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toList();
                double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)error.head());
                double $org_scalatest_assert_macro_right = 0.8;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                if ($org_scalatest_assert_macro_left2.value()) {
                    double $org_scalatest_assert_macro_left3 = BoxesRunTime.unboxToDouble((Object)error.last());
                    double $org_scalatest_assert_macro_right2 = 0.2;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right2);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("handling empty RDDs in a stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.01).setNumIterations(10);
                int numBatches = 10;
                Seq emptyInput = (Seq)Seq$.MODULE$.empty();
                this.$outer.ssc_$eq(this.$outer.setupStreams(emptyInput, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLogisticRegressionWithSGD model$5;

                    public final DStream<Tuple2<Object, Object>> apply(DStream<LabeledPoint> inputDStream) {
                        this.model$5.trainOn(inputDStream);
                        return this.model$5.predictOnValues(inputDStream.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Vector> apply(LabeledPoint x) {
                                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features());
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                    }
                    {
                        this.model$5 = model$5;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
                Seq<Seq<V>> output = this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

