/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.clustering.GaussianMixture;
import org.apache.spark.mllib.clustering.GaussianMixture$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$;
import org.apache.spark.mllib.clustering.GaussianMixtureSuite$;
import org.apache.spark.mllib.clustering.GaussianMixtureSuite$GaussianTestData$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001b\t!r)Y;tg&\fg.T5yiV\u0014XmU;ji\u0016T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003/Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005\u001d)a\u0004\u0001E\u0001?\u0005\u0001r)Y;tg&\fg\u000eV3ti\u0012\u000bG/\u0019\t\u0003A\u0005j\u0011\u0001\u0001\u0004\u0006E\u0001A\ta\t\u0002\u0011\u000f\u0006,8o]5b]R+7\u000f\u001e#bi\u0006\u001c\"!\t\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0011\u0015I\u0012\u0005\"\u0001,)\u0005y\u0002bB\u0017\"\u0005\u0004%\tAL\u0001\u0005I\u0006$\u0018-F\u00010!\r)\u0003GM\u0005\u0003c\u0019\u0012Q!\u0011:sCf\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0003\u0002\r1Lg.\u00197h\u0013\t9DG\u0001\u0004WK\u000e$xN\u001d\u0005\u0007s\u0005\u0002\u000b\u0011B\u0018\u0002\u000b\u0011\fG/\u0019\u0011\t\u000fm\n#\u0019!C\u0001]\u0005)A-\u0019;be!1Q(\tQ\u0001\n=\na\u0001Z1uCJ\u0002\u0003")
public class GaussianMixtureSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private volatile GaussianMixtureSuite$GaussianTestData$ GaussianTestData$module;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GaussianMixtureSuite$GaussianTestData$ GaussianTestData$lzycompute() {
        GaussianMixtureSuite gaussianMixtureSuite = this;
        synchronized (gaussianMixtureSuite) {
            if (this.GaussianTestData$module != null) return this.GaussianTestData$module;
            this.GaussianTestData$module = new GaussianMixtureSuite$GaussianTestData$(this);
            return this.GaussianTestData$module;
        }
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public GaussianMixtureSuite$GaussianTestData$ GaussianTestData() {
        return this.GaussianTestData$module == null ? this.GaussianTestData$lzycompute() : this.GaussianTestData$module;
    }

    public GaussianMixtureSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("single cluster", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$2 = Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{9.0})), Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0})), Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))});
                int x$3 = qual$1.parallelize$default$2();
                RDD data = qual$1.parallelize((Seq)x$2, x$3, ClassTag$.MODULE$.apply(Vector.class));
                double Ew = 1.0;
                Vector Emu = Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0}));
                Matrix Esigma = Matrices$.MODULE$.dense(2, 2, new double[]{0.6666666666666666, -0.6666666666666666, -0.6666666666666666, 0.6666666666666666});
                int[] seeds = new int[]{314589, 29032897, 50181, 494821, 4660};
                Predef$.MODULE$.intArrayOps(seeds).foreach((Function1)new Serializable(this, data, Ew, Emu, Esigma){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final RDD data$1;
                    private final double Ew$1;
                    private final Vector Emu$1;
                    private final Matrix Esigma$1;

                    public final void apply(int seed) {
                        this.apply$mcVI$sp(seed);
                    }

                    public void apply$mcVI$sp(int seed) {
                        GaussianMixtureModel gmm = new GaussianMixture().setK(1).setSeed((long)seed).run(this.data$1);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gmm.weights()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.Ew$1).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(gmm.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew).absTol(1.0E-5))");
                        this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gmm.gaussians()[0].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.Emu$1).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(gmm.gaussians.apply(0).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu).absTol(1.0E-5))");
                        this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(gmm.gaussians()[0].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(this.Esigma$1).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(gmm.gaussians.apply(0).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma).absTol(1.0E-5))");
                        this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.data$1 = data$1;
                        this.Ew$1 = Ew$1;
                        this.Emu$1 = Emu$1;
                        this.Esigma$1 = Esigma$1;
                    }
                });
            }

            public /* synthetic */ GaussianMixtureSuite org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("two clusters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$4 = Predef$.MODULE$.wrapRefArray((Object[])this.$outer.GaussianTestData().data());
                int x$5 = qual$2.parallelize$default$2();
                RDD data = qual$2.parallelize((Seq)x$4, x$5, ClassTag$.MODULE$.apply(Vector.class));
                GaussianMixtureModel initialGmm = new GaussianMixtureModel(new double[]{0.5, 0.5}, (MultivariateGaussian[])((Object[])new MultivariateGaussian[]{new MultivariateGaussian(Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Matrices$.MODULE$.dense(1, 1, new double[]{1.0})), new MultivariateGaussian(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Matrices$.MODULE$.dense(1, 1, new double[]{1.0}))}));
                double[] Ew = new double[]{0.3333333333333333, 0.6666666666666666};
                Vector[] Emu = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-4.3673, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(5.1604, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))});
                Matrix[] Esigma = (Matrix[])((Object[])new Matrix[]{Matrices$.MODULE$.dense(1, 1, new double[]{1.1098}), Matrices$.MODULE$.dense(1, 1, new double[]{0.86644})});
                GaussianMixtureModel gmm = new GaussianMixture().setK(2).setInitialModel(initialGmm).run(data);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gmm.weights()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(gmm.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew.apply(0)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gmm.weights()[1]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(gmm.weights.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew.apply(1)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gmm.gaussians()[0].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(gmm.gaussians.apply(0).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu.apply(0)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gmm.gaussians()[1].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(gmm.gaussians.apply(1).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu.apply(1)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(gmm.gaussians()[0].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(gmm.gaussians.apply(0).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma.apply(0)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(gmm.gaussians()[1].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(gmm.gaussians.apply(1).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma.apply(1)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("two clusters with distributed decompositions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD data = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.GaussianTestData().data2()), 2, ClassTag$.MODULE$.apply(Vector.class));
                int k = 5;
                int d = ((Vector)data.first()).size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(GaussianMixture$.MODULE$.shouldDistributeGaussians(k, d), "GaussianMixture.shouldDistributeGaussians(k, d)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                GaussianMixtureModel gmm = new GaussianMixture().setK(k).run(data);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gmm.k()));
                int $org_scalatest_assert_macro_right = k;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single cluster with sparse data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$6 = Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{4.0, 2.0}), Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{2.0, 4.0}), Vectors$.MODULE$.sparse(3, new int[]{1}, new double[]{6.0})});
                int x$7 = qual$3.parallelize$default$2();
                RDD data = qual$3.parallelize((Seq)x$6, x$7, ClassTag$.MODULE$.apply(Vector.class));
                double Ew = 1.0;
                Vector Emu = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 2.0}));
                Matrix Esigma = Matrices$.MODULE$.dense(3, 3, new double[]{2.6666666666666665, -4.0, 1.3333333333333333, -4.0, 8.0, -4.0, 1.3333333333333333, -4.0, 2.6666666666666665});
                int[] seeds = new int[]{42, 1994, 27, 11, 0};
                Predef$.MODULE$.intArrayOps(seeds).foreach((Function1)new Serializable(this, data, Ew, Emu, Esigma){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final RDD data$2;
                    private final double Ew$2;
                    private final Vector Emu$2;
                    private final Matrix Esigma$2;

                    public final void apply(int seed) {
                        this.apply$mcVI$sp(seed);
                    }

                    public void apply$mcVI$sp(int seed) {
                        GaussianMixtureModel gmm = new GaussianMixture().setK(1).setSeed((long)seed).run(this.data$2);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gmm.weights()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.Ew$2).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(gmm.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew).absTol(1.0E-5))");
                        this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gmm.gaussians()[0].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.Emu$2).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(gmm.gaussians.apply(0).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu).absTol(1.0E-5))");
                        this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(gmm.gaussians()[0].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(this.Esigma$2).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(gmm.gaussians.apply(0).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma).absTol(1.0E-5))");
                        this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.data$2 = data$2;
                        this.Ew$2 = Ew$2;
                        this.Emu$2 = Emu$2;
                        this.Esigma$2 = Esigma$2;
                    }
                });
            }

            public /* synthetic */ GaussianMixtureSuite org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("two clusters with sparse data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$8 = Predef$.MODULE$.wrapRefArray((Object[])this.$outer.GaussianTestData().data());
                int x$9 = qual$4.parallelize$default$2();
                RDD data = qual$4.parallelize((Seq)x$8, x$9, ClassTag$.MODULE$.apply(Vector.class));
                RDD sparseData = data.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Vector point) {
                        return Vectors$.MODULE$.sparse(1, new int[]{0}, point.toArray());
                    }
                }, ClassTag$.MODULE$.apply(Vector.class));
                GaussianMixtureModel initialGmm = new GaussianMixtureModel(new double[]{0.5, 0.5}, (MultivariateGaussian[])((Object[])new MultivariateGaussian[]{new MultivariateGaussian(Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Matrices$.MODULE$.dense(1, 1, new double[]{1.0})), new MultivariateGaussian(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Matrices$.MODULE$.dense(1, 1, new double[]{1.0}))}));
                double[] Ew = new double[]{0.3333333333333333, 0.6666666666666666};
                Vector[] Emu = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-4.3673, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(5.1604, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))});
                Matrix[] Esigma = (Matrix[])((Object[])new Matrix[]{Matrices$.MODULE$.dense(1, 1, new double[]{1.1098}), Matrices$.MODULE$.dense(1, 1, new double[]{0.86644})});
                GaussianMixtureModel sparseGMM = new GaussianMixture().setK(2).setInitialModel(initialGmm).run(sparseData);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(sparseGMM.weights()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(sparseGMM.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew.apply(0)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(sparseGMM.weights()[1]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(sparseGMM.weights.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew.apply(1)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(sparseGMM.gaussians()[0].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(sparseGMM.gaussians.apply(0).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu.apply(0)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(sparseGMM.gaussians()[1].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(sparseGMM.gaussians.apply(1).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu.apply(1)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(sparseGMM.gaussians()[0].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(sparseGMM.gaussians.apply(0).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma.apply(0)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(sparseGMM.gaussians()[1].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(sparseGMM.gaussians.apply(1).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma.apply(1)).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save / load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$5 = this.$outer.sc();
                WrappedArray x$10 = Predef$.MODULE$.wrapRefArray((Object[])this.$outer.GaussianTestData().data());
                int x$11 = qual$5.parallelize$default$2();
                RDD data = qual$5.parallelize((Seq)x$10, x$11, ClassTag$.MODULE$.apply(Vector.class));
                GaussianMixtureModel gmm = new GaussianMixture().setK(2).setSeed(0L).run(data);
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    gmm.save(this.$outer.sc(), path);
                    GaussianMixtureModel sameModel = GaussianMixtureModel$.MODULE$.load(this.$outer.sc(), path);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sameModel.k()));
                    int $org_scalatest_assert_macro_right = gmm.k();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sameModel.k()).foreach$mVc$sp((Function1)new Serializable(this, gmm, sameModel){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$6 $outer;
                        private final GaussianMixtureModel gmm$1;
                        private final GaussianMixtureModel sameModel$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().convertToEqualizer(this.sameModel$1.gaussians()[i].mu());
                            Vector $org_scalatest_assert_macro_right = this.gmm$1.gaussians()[i].mu();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().convertToEqualizer(this.sameModel$1.gaussians()[i].sigma());
                            Matrix $org_scalatest_assert_macro_right2 = this.gmm$1.gaussians()[i].sigma();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.gmm$1 = gmm$1;
                            this.sameModel$1 = sameModel$1;
                        }
                    });
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }

            public /* synthetic */ GaussianMixtureSuite org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model prediction, parallel and local", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$6 = this.$outer.sc();
                WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.$outer.GaussianTestData().data());
                int x$13 = qual$6.parallelize$default$2();
                RDD data = qual$6.parallelize((Seq)x$12, x$13, ClassTag$.MODULE$.apply(Vector.class));
                GaussianMixtureModel gmm = new GaussianMixture().setK(2).setSeed(0L).run(data);
                RDD batchPredictions = gmm.predict(data);
                Predef$.MODULE$.refArrayOps((Object[])batchPredictions.zip(data, ClassTag$.MODULE$.apply(Vector.class)).collect()).foreach((Function1)new Serializable(this, gmm){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final GaussianMixtureModel gmm$2;

                    public final void apply(Tuple2<Object, Vector> x0$1) {
                        Tuple2<Object, Vector> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int batchPred = tuple2._1$mcI$sp();
                            Vector datum = (Vector)tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)batchPred));
                            int $org_scalatest_assert_macro_right = this.gmm$2.predict(datum);
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.gmm$2 = gmm$2;
                    }
                });
            }

            public /* synthetic */ GaussianMixtureSuite org$apache$spark$mllib$clustering$GaussianMixtureSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

