/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.rdd.RDD;
import org.junit.Assert;
import org.junit.Test;

public class JavaKMeansSuite
extends SharedSparkSession {
    @Test
    public void runKMeansUsingStaticMethods() {
        List<Vector> points = Arrays.asList(Vectors.dense((double)1.0, (double[])new double[]{2.0, 6.0}), Vectors.dense((double)1.0, (double[])new double[]{3.0, 0.0}), Vectors.dense((double)1.0, (double[])new double[]{4.0, 6.0}));
        Vector expectedCenter = Vectors.dense((double)1.0, (double[])new double[]{3.0, 4.0});
        JavaRDD data = this.jsc.parallelize(points, 2);
        KMeansModel model = KMeans.train((RDD)data.rdd(), (int)1, (int)1, (int)1, (String)KMeans.K_MEANS_PARALLEL());
        Assert.assertEquals((long)1L, (long)model.clusterCenters().length);
        Assert.assertEquals((Object)expectedCenter, (Object)model.clusterCenters()[0]);
        model = KMeans.train((RDD)data.rdd(), (int)1, (int)1, (int)1, (String)KMeans.RANDOM());
        Assert.assertEquals((Object)expectedCenter, (Object)model.clusterCenters()[0]);
    }

    @Test
    public void runKMeansUsingConstructor() {
        List<Vector> points = Arrays.asList(Vectors.dense((double)1.0, (double[])new double[]{2.0, 6.0}), Vectors.dense((double)1.0, (double[])new double[]{3.0, 0.0}), Vectors.dense((double)1.0, (double[])new double[]{4.0, 6.0}));
        Vector expectedCenter = Vectors.dense((double)1.0, (double[])new double[]{3.0, 4.0});
        JavaRDD data = this.jsc.parallelize(points, 2);
        KMeansModel model = new KMeans().setK(1).setMaxIterations(5).run(data.rdd());
        Assert.assertEquals((long)1L, (long)model.clusterCenters().length);
        Assert.assertEquals((Object)expectedCenter, (Object)model.clusterCenters()[0]);
        model = new KMeans().setK(1).setMaxIterations(1).setInitializationMode(KMeans.RANDOM()).run(data.rdd());
        Assert.assertEquals((Object)expectedCenter, (Object)model.clusterCenters()[0]);
    }

    @Test
    public void testPredictJavaRDD() {
        List<Vector> points = Arrays.asList(Vectors.dense((double)1.0, (double[])new double[]{2.0, 6.0}), Vectors.dense((double)1.0, (double[])new double[]{3.0, 0.0}), Vectors.dense((double)1.0, (double[])new double[]{4.0, 6.0}));
        JavaRDD data = this.jsc.parallelize(points, 2);
        KMeansModel model = new KMeans().setK(1).setMaxIterations(5).run(data.rdd());
        JavaRDD predictions = model.predict(data);
        predictions.first();
    }
}

