/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.KMeansModel$;
import org.apache.spark.mllib.clustering.KMeansSuite$;
import org.apache.spark.mllib.clustering.KMeansSuite$$anonfun$4$;
import org.apache.spark.mllib.clustering.KMeansSuite$$anonfun$7$VectorWithCompare$4$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001b\tY1*T3b]N\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dI\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqRDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\b\u000by\u0011\u0001\u0012A\u0010\u0002\u0017-kU-\u00198t'VLG/\u001a\t\u00039\u00012Q!\u0001\u0002\t\u0002\u0005\u001a\"\u0001\t\b\t\u000be\u0001C\u0011A\u0012\u0015\u0003}AQ!\n\u0011\u0005\u0002\u0019\n1b\u0019:fCR,Wj\u001c3fYR!qE\u000b\u001a5!\ta\u0002&\u0003\u0002*\u0005\tY1*T3b]Nlu\u000eZ3m\u0011\u0015YC\u00051\u0001-\u0003\r!\u0017.\u001c\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0004\u0013:$\b\"B\u001a%\u0001\u0004a\u0013!A6\t\u000bU\"\u0003\u0019\u0001\u001c\u0002\u0011%\u001c8\u000b]1sg\u0016\u0004\"!L\u001c\n\u0005ar#a\u0002\"p_2,\u0017M\u001c\u0005\u0006u\u0001\"\taO\u0001\u000bG\",7m[#rk\u0006dGc\u0001\u001f@\u0003B\u0011Q&P\u0005\u0003}9\u0012A!\u00168ji\")\u0001)\u000fa\u0001O\u0005\t\u0011\rC\u0003Cs\u0001\u0007q%A\u0001c\u0011\u001d!\u0005%!A\u0005\n\u0015\u000b1B]3bIJ+7o\u001c7wKR\ta\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A.\u00198h\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\r=\u0013'.Z2u\u0001")
public class KMeansSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void checkEqual(KMeansModel kMeansModel, KMeansModel kMeansModel2) {
        KMeansSuite$.MODULE$.checkEqual(kMeansModel, kMeansModel2);
    }

    public static KMeansModel createModel(int n, int n2, boolean bl) {
        return KMeansSuite$.MODULE$.createModel(n, n2, bl);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public KMeansSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("single cluster", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$8 = Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0}))});
                int x$9 = qual$1.parallelize$default$2();
                RDD data = qual$1.parallelize((Seq)x$8, x$9, ClassTag$.MODULE$.apply(Vector.class));
                Vector center = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
                KMeansModel model = KMeans$.MODULE$.train(data, 1, 1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 2);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 5);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 5);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 5);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 1, KMeans$.MODULE$.RANDOM());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 1, KMeans$.MODULE$.K_MEANS_PARALLEL());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("no distinct points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD data = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0}))}), 2, ClassTag$.MODULE$.apply(Vector.class));
                Vector center = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0}));
                KMeansModel model = KMeans$.MODULE$.train(data, 2, 1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).size()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("more clusters than points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD data = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}))}), 2, ClassTag$.MODULE$.apply(Vector.class));
                KMeansModel model = KMeans$.MODULE$.train(data, 3, 1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("deterministic initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List points = (List)List$.MODULE$.tabulate(1000, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(int n) {
                        return Vectors$.MODULE$.dense((double)n, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{n}));
                    }
                });
                RDD rdd = this.$outer.sc().parallelize((Seq)points, 3, ClassTag$.MODULE$.apply(Vector.class));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KMeans$.MODULE$.RANDOM(), KMeans$.MODULE$.K_MEANS_PARALLEL()}))).foreach((Function1)new Serializable(this, rdd){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final RDD rdd$1;

                    public final void apply(String initMode) {
                        KMeansModel model1 = KMeans$.MODULE$.train(this.rdd$1, 10, 2, 1, initMode, 42L);
                        Vector[] centers1 = model1.clusterCenters();
                        KMeansModel model2 = KMeans$.MODULE$.train(this.rdd$1, 10, 2, 1, initMode, 42L);
                        Vector[] centers2 = model2.clusterCenters();
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])centers1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])centers2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$1 $outer;

                            public final void apply(Tuple2<Vector, Vector> x0$1) {
                                Tuple2<Vector, Vector> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    Vector c1 = (Vector)tuple2._1();
                                    Vector c2 = (Vector)tuple2._2();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(c1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(c2).absTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c2).absTol(1.0E-14))");
                                    this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$4 org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rdd$1 = rdd$1;
                    }
                });
            }

            public /* synthetic */ KMeansSuite org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single cluster with big dataset", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector[] smallData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0}))});
                RDD data = this.$outer.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).flatMap((Function1)new Serializable(this, smallData){
                    public static final long serialVersionUID = 0L;
                    private final Vector[] smallData$1;

                    public final ArrayOps<Vector> apply(int x$1) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.smallData$1);
                    }
                    {
                        this.smallData$1 = smallData$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), 4, ClassTag$.MODULE$.apply(Vector.class));
                Vector center = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
                KMeansModel model = KMeans$.MODULE$.train(data, 1, 1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 2);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 5);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 5);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 5);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 1, KMeans$.MODULE$.RANDOM());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 1, KMeans$.MODULE$.K_MEANS_PARALLEL());
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single cluster with sparse data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 10000;
                RDD data = this.$outer.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).flatMap((Function1)new Serializable(this, n){
                    public static final long serialVersionUID = 0L;
                    private final int n$1;

                    public final ArrayOps<Vector> apply(int i) {
                        double x = (double)i / 1000.0;
                        return Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(this.n$1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0 + x), new Tuple2.mcID.sp(1, 2.0), new Tuple2.mcID.sp(2, 6.0)}))), Vectors$.MODULE$.sparse(this.n$1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0 - x), new Tuple2.mcID.sp(1, 2.0), new Tuple2.mcID.sp(2, 6.0)}))), Vectors$.MODULE$.sparse(this.n$1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 3.0 + x)}))), Vectors$.MODULE$.sparse(this.n$1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 3.0 - x)}))), Vectors$.MODULE$.sparse(this.n$1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 4.0), new Tuple2.mcID.sp(2, 6.0 + x)}))), Vectors$.MODULE$.sparse(this.n$1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 4.0), new Tuple2.mcID.sp(2, 6.0 - x)})))});
                    }
                    {
                        this.n$1 = n$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), 4, ClassTag$.MODULE$.apply(Vector.class));
                data.persist();
                Vector center = Vectors$.MODULE$.sparse(n, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(1, 3.0), new Tuple2.mcID.sp(2, 4.0)})));
                KMeansModel model = KMeans$.MODULE$.train(data, 1, 1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 2);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 5);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 5);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 5);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 1, KMeans$.MODULE$.RANDOM());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                model = KMeans$.MODULE$.train(data, 1, 1, 1, KMeans$.MODULE$.K_MEANS_PARALLEL());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                data.unpersist(data.unpersist$default$1());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("k-means|| initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private KMeansSuite$$anonfun$7$VectorWithCompare$4$ org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2$lzycompute(VolatileObjectRef x$1) {
                $anonfun$7 var2_2 = this;
                synchronized (var2_2) {
                    if (x$1.elem != null) return (KMeansSuite$$anonfun$7$VectorWithCompare$4$)((Object)x$1.elem);
                    x$1.elem = new KMeansSuite$$anonfun$7$VectorWithCompare$4$(this, x$1);
                    return (KMeansSuite$$anonfun$7$VectorWithCompare$4$)((Object)x$1.elem);
                }
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VolatileObjectRef VectorWithCompare$module = new VolatileObjectRef(null);
                Seq points = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))}));
                SparkContext qual$2 = this.$outer.sc();
                Seq x$10 = points;
                int x$11 = qual$2.parallelize$default$2();
                RDD rdd = qual$2.parallelize(x$10, x$11, ClassTag$.MODULE$.apply(Vector.class));
                KMeansModel model = KMeans$.MODULE$.train(rdd, 5, 1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).sortBy((Function1)new Serializable(this, VectorWithCompare$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final VolatileObjectRef VectorWithCompare$module$1;

                    public final $anonfun$7$VectorWithCompare$3 apply(Vector x$2) {
                        return this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2(this.VectorWithCompare$module$1).apply(x$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.VectorWithCompare$module$1 = VectorWithCompare$module$1;
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()))).zip((GenIterable)points.sortBy((Function1)new Serializable(this, VectorWithCompare$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final VolatileObjectRef VectorWithCompare$module$1;

                    public final $anonfun$7$VectorWithCompare$3 apply(Vector x$3) {
                        return this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2(this.VectorWithCompare$module$1).apply(x$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.VectorWithCompare$module$1 = VectorWithCompare$module$1;
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Vector, Vector> x) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._1()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._2()).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.refArrayOps[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).sortBy[VectorWithCompare](((x$2: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$2)))(math.this.Ordering.ordered[VectorWithCompare](scala.this.Predef.conforms[VectorWithCompare]))).zip[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, Array[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]](points.sortBy[VectorWithCompare](((x$3: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$3)))(math.this.Ordering.ordered[VectorWithCompare](scala.this.Predef.conforms[VectorWithCompare])))(scala.this.Array.canBuildFrom[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](ClassTag.apply[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](classOf[scala.Tuple2])))).forall(((x: (org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                model = KMeans$.MODULE$.train(rdd, 5, 10);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).sortBy((Function1)new Serializable(this, VectorWithCompare$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final VolatileObjectRef VectorWithCompare$module$1;

                    public final $anonfun$7$VectorWithCompare$3 apply(Vector x$4) {
                        return this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2(this.VectorWithCompare$module$1).apply(x$4);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.VectorWithCompare$module$1 = VectorWithCompare$module$1;
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()))).zip((GenIterable)points.sortBy((Function1)new Serializable(this, VectorWithCompare$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final VolatileObjectRef VectorWithCompare$module$1;

                    public final $anonfun$7$VectorWithCompare$3 apply(Vector x$5) {
                        return this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2(this.VectorWithCompare$module$1).apply(x$5);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.VectorWithCompare$module$1 = VectorWithCompare$module$1;
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Vector, Vector> x) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._1()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._2()).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.refArrayOps[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).sortBy[VectorWithCompare](((x$4: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$4)))(math.this.Ordering.ordered[VectorWithCompare](scala.this.Predef.conforms[VectorWithCompare]))).zip[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, Array[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]](points.sortBy[VectorWithCompare](((x$5: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$5)))(math.this.Ordering.ordered[VectorWithCompare](scala.this.Predef.conforms[VectorWithCompare])))(scala.this.Array.canBuildFrom[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](ClassTag.apply[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](classOf[scala.Tuple2])))).forall(((x: (org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                model = KMeans$.MODULE$.train(rdd, 5, 10, 5);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).sortBy((Function1)new Serializable(this, VectorWithCompare$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final VolatileObjectRef VectorWithCompare$module$1;

                    public final $anonfun$7$VectorWithCompare$3 apply(Vector x$6) {
                        return this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2(this.VectorWithCompare$module$1).apply(x$6);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.VectorWithCompare$module$1 = VectorWithCompare$module$1;
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()))).zip((GenIterable)points.sortBy((Function1)new Serializable(this, VectorWithCompare$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final VolatileObjectRef VectorWithCompare$module$1;

                    public final $anonfun$7$VectorWithCompare$3 apply(Vector x$7) {
                        return this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2(this.VectorWithCompare$module$1).apply(x$7);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.VectorWithCompare$module$1 = VectorWithCompare$module$1;
                    }
                }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Vector, Vector> x) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._1()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._2()).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.refArrayOps[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).sortBy[VectorWithCompare](((x$6: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$6)))(math.this.Ordering.ordered[VectorWithCompare](scala.this.Predef.conforms[VectorWithCompare]))).zip[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, Array[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]](points.sortBy[VectorWithCompare](((x$7: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$7)))(math.this.Ordering.ordered[VectorWithCompare](scala.this.Predef.conforms[VectorWithCompare])))(scala.this.Array.canBuildFrom[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](ClassTag.apply[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](classOf[scala.Tuple2])))).forall(((x: (org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public final KMeansSuite$$anonfun$7$VectorWithCompare$4$ org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2(VolatileObjectRef VectorWithCompare$module$1) {
                return VectorWithCompare$module$1.elem == null ? this.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$VectorWithCompare$2$lzycompute(VectorWithCompare$module$1) : (KMeansSuite$$anonfun$7$VectorWithCompare$4$)((Object)VectorWithCompare$module$1.elem);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("two clusters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq points = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1})), Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2})), Vectors$.MODULE$.dense(9.2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))}));
                RDD rdd = this.$outer.sc().parallelize(points, 3, ClassTag$.MODULE$.apply(Vector.class));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KMeans$.MODULE$.RANDOM(), KMeans$.MODULE$.K_MEANS_PARALLEL()}))).foreach((Function1)new Serializable(this, rdd){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final RDD rdd$2;

                    public final void apply(String initMode) {
                        KMeansModel model = KMeans$.MODULE$.train(this.rdd$2, 2, 2, 1, initMode);
                        int[] predicts = (int[])model.predict(this.rdd$2).collect();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)predicts[0]));
                        int $org_scalatest_assert_macro_right = predicts[1];
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)predicts[0]));
                        int $org_scalatest_assert_macro_right2 = predicts[2];
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)predicts[3]));
                        int $org_scalatest_assert_macro_right3 = predicts[4];
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)predicts[3]));
                        int $org_scalatest_assert_macro_right4 = predicts[5];
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        int $org_scalatest_assert_macro_left5 = predicts[0];
                        int $org_scalatest_assert_macro_right5 = predicts[3];
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 != $org_scalatest_assert_macro_right5);
                        this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rdd$2 = rdd$2;
                    }
                });
            }

            public /* synthetic */ KMeansSuite org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                Predef$.MODULE$.booleanArrayOps(new boolean[]{true, false}).foreach((Function1)new Serializable(this, tempDir, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final File tempDir$1;
                    private final String path$1;

                    public final void apply(boolean x0$2) {
                        boolean bl = x0$2;
                        KMeansModel model = KMeansSuite$.MODULE$.createModel(10, 3, bl);
                        try {
                            model.save(this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().sc(), this.path$1);
                            KMeansModel sameModel = KMeansModel$.MODULE$.load(this.$outer.org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer().sc(), this.path$1);
                            KMeansSuite$.MODULE$.checkEqual(model, sameModel);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        finally {
                            Utils$.MODULE$.deleteRecursively(this.tempDir$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.path$1 = path$1;
                    }
                });
            }

            public /* synthetic */ KMeansSuite org$apache$spark$mllib$clustering$KMeansSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Initialize using given cluster centers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq points = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))}));
                RDD rdd = this.$outer.sc().parallelize(points, 3, ClassTag$.MODULE$.apply(Vector.class));
                KMeansModel initialModel = new KMeansModel((Vector[])((Object[])new Vector[]{(Vector)points.apply(0), (Vector)points.apply(2)}));
                KMeansModel returnModel = new KMeans().setK(2).setMaxIterations(0).setInitialModel(initialModel).run(rdd);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(returnModel.clusterCenters()[0]);
                Vector $org_scalatest_assert_macro_right = initialModel.clusterCenters()[0];
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(returnModel.clusterCenters()[1]);
                Vector $org_scalatest_assert_macro_right2 = initialModel.clusterCenters()[1];
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

