/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClustering$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringSuite$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringSuite$$anonfun$1$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringSuite$$anonfun$2$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u001b\ti\u0002k\\<fe&#XM]1uS>t7\t\\;ti\u0016\u0014\u0018N\\4Tk&$XM\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!Q\u000f^5m\u0013\t9BCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0013y\u0012!C4f]\u000eK'o\u00197f)\r\u0001CF\f\t\u0004C\u00112S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005:\u0013&K\u0005\u0003Q\t\u0012a\u0001V;qY\u0016\u0014\u0004CA\u0011+\u0013\tY#E\u0001\u0004E_V\u0014G.\u001a\u0005\u0006[u\u0001\r!K\u0001\u0002e\")q&\ba\u0001a\u0005\ta\u000e\u0005\u0002\"c%\u0011!G\t\u0002\u0004\u0013:$\b\"\u0002\u001b\u0001\t\u0013)\u0014aA:j[R\u0019\u0011F\u000e\u001d\t\u000b]\u001a\u0004\u0019\u0001\u0014\u0002\u0003aDQ!O\u001aA\u0002\u0019\n\u0011!_\u0004\u0006w\tA\t\u0001P\u0001\u001e!><XM]%uKJ\fG/[8o\u00072,8\u000f^3sS:<7+^5uKB\u0011A$\u0010\u0004\u0006\u0003\tA\tAP\n\u0003{9AQ!G\u001f\u0005\u0002\u0001#\u0012\u0001\u0010\u0005\u0006\u0005v\"\taQ\u0001\fGJ,\u0017\r^3N_\u0012,G\u000e\u0006\u0003E\u000f2s\u0005C\u0001\u000fF\u0013\t1%AA\u000fQ_^,'/\u0013;fe\u0006$\u0018n\u001c8DYV\u001cH/\u001a:j]\u001elu\u000eZ3m\u0011\u0015A\u0015\t1\u0001J\u0003\t\u00198\r\u0005\u0002\u0010\u0015&\u00111J\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006\u001b\u0006\u0003\r\u0001M\u0001\u0002W\")q*\u0011a\u0001a\u00059a\u000eU8j]R\u001c\b\"B)>\t\u0003\u0011\u0016AC2iK\u000e\\W)];bYR\u00191K\u0016-\u0011\u0005\u0005\"\u0016BA+#\u0005\u0011)f.\u001b;\t\u000b]\u0003\u0006\u0019\u0001#\u0002\u0003\u0005DQ!\u0017)A\u0002\u0011\u000b\u0011A\u0019\u0005\b7v\n\t\u0011\"\u0003]\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\t1\fgn\u001a\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0004PE*,7\r\u001e")
public class PowerIterationClusteringSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void checkEqual(PowerIterationClusteringModel powerIterationClusteringModel, PowerIterationClusteringModel powerIterationClusteringModel2) {
        PowerIterationClusteringSuite$.MODULE$.checkEqual(powerIterationClusteringModel, powerIterationClusteringModel2);
    }

    public static PowerIterationClusteringModel createModel(SparkContext sparkContext, int n, int n2) {
        return PowerIterationClusteringSuite$.MODULE$.createModel(sparkContext, n, n2);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Tuple2<Object, Object>[] org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$genCircle(double r, int n) {
        return (Tuple2[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this, r, n){
            public static final long serialVersionUID = 0L;
            private final double r$1;
            private final int n$1;

            public final Tuple2<Object, Object> apply(int i) {
                double theta = 2.0 * package$.MODULE$.Pi() * (double)i / (double)this.n$1;
                return new Tuple2.mcDD.sp(this.r$1 * package$.MODULE$.cos(theta), this.r$1 * package$.MODULE$.sin(theta));
            }
            {
                this.r$1 = r$1;
                this.n$1 = n$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$sim(Tuple2<Object, Object> x, Tuple2<Object, Object> y) {
        double dist2 = (x._1$mcD$sp() - y._1$mcD$sp()) * (x._1$mcD$sp() - y._1$mcD$sp()) + (x._2$mcD$sp() - y._2$mcD$sp()) * (x._2$mcD$sp() - y._2$mcD$sp());
        return package$.MODULE$.exp(-dist2 / 2.0);
    }

    public PowerIterationClusteringSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("power iteration clustering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PowerIterationClusteringSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double r1 = 1.0;
                int n1 = 10;
                double r2 = 4.0;
                int n2 = 40;
                int n = n1 + n2;
                Tuple2[] points = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$genCircle(r1, n1)).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$genCircle(r2, n2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                IndexedSeq similarities = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), n).flatMap((Function1)new Serializable(this, points){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final Tuple2[] points$1;

                    public final IndexedSeq<Tuple3<Object, Object, Object>> apply(int i) {
                        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i).map((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$6 $outer;
                            private final int i$1;

                            public final Tuple3<Object, Object, Object> apply(int j) {
                                return new Tuple3((Object)BoxesRunTime.boxToLong((long)this.i$1), (Object)BoxesRunTime.boxToLong((long)j), (Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer().org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$sim((Tuple2<Object, Object>)this.$outer.points$1[this.i$1], (Tuple2<Object, Object>)this.$outer.points$1[j])));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.points$1 = points$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                PowerIterationClusteringModel model = new PowerIterationClustering().setK(2).setMaxIterations(40).run(this.$outer.sc().parallelize((Seq)similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
                Set[] predictions = (Set[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Object> apply() {
                        return Set$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(Set.class));
                Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect()).foreach((Function1)new Serializable(this, predictions){
                    public static final long serialVersionUID = 0L;
                    private final Set[] predictions$1;

                    public final Set<Object> apply(PowerIterationClustering.Assignment a) {
                        return (Set)this.predictions$1[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id()));
                    }
                    {
                        this.predictions$1 = predictions$1;
                    }
                });
                scala.collection.immutable.Set $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])predictions).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n1).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n1), n).toSet()}));
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                PowerIterationClusteringModel model2 = new PowerIterationClustering().setK(2).setMaxIterations(10).setInitializationMode("degree").run(this.$outer.sc().parallelize((Seq)similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
                Set[] predictions2 = (Set[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Object> apply() {
                        return Set$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(Set.class));
                Predef$.MODULE$.refArrayOps((Object[])model2.assignments().collect()).foreach((Function1)new Serializable(this, predictions2){
                    public static final long serialVersionUID = 0L;
                    private final Set[] predictions2$1;

                    public final Set<Object> apply(PowerIterationClustering.Assignment a) {
                        return (Set)this.predictions2$1[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id()));
                    }
                    {
                        this.predictions2$1 = predictions2$1;
                    }
                });
                scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])predictions2).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n1).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n1), n).toSet()}));
                scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ PowerIterationClusteringSuite org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("power iteration clustering on graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PowerIterationClusteringSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double r1 = 1.0;
                int n1 = 10;
                double r2 = 4.0;
                int n2 = 40;
                int n = n1 + n2;
                Tuple2[] points = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$genCircle(r1, n1)).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$genCircle(r2, n2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                IndexedSeq similarities = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), n).flatMap((Function1)new Serializable(this, points){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    public final Tuple2[] points$2;

                    public final IndexedSeq<Tuple3<Object, Object, Object>> apply(int i) {
                        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i).map((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$9 $outer;
                            private final int i$2;

                            public final Tuple3<Object, Object, Object> apply(int j) {
                                return new Tuple3((Object)BoxesRunTime.boxToLong((long)this.i$2), (Object)BoxesRunTime.boxToLong((long)j), (Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer().org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$sim((Tuple2<Object, Object>)this.$outer.points$2[this.i$2], (Tuple2<Object, Object>)this.$outer.points$2[j])));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$2 = i$2;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.points$2 = points$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq edges = (IndexedSeq)similarities.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Edge<Object>> apply(Tuple3<Object, Object, Object> x0$1) {
                        Tuple3<Object, Object, Object> tuple3 = x0$1;
                        if (tuple3 != null) {
                            long i = BoxesRunTime.unboxToLong((Object)tuple3._1());
                            long j = BoxesRunTime.unboxToLong((Object)tuple3._2());
                            double s = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            Iterable iterable = i != j ? (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge.mcD.sp(i, j, s), new Edge.mcD.sp(j, i, s)})) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            return iterable;
                        }
                        throw new MatchError(tuple3);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Graph graph = Graph$.MODULE$.fromEdges(this.$outer.sc().parallelize((Seq)edges, 2, ClassTag$.MODULE$.apply(Edge.class)), (Object)BoxesRunTime.boxToDouble((double)0.0), Graph$.MODULE$.fromEdges$default$3(), Graph$.MODULE$.fromEdges$default$4(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
                PowerIterationClusteringModel model = new PowerIterationClustering().setK(2).setMaxIterations(40).run(graph);
                Set[] predictions = (Set[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Object> apply() {
                        return Set$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(Set.class));
                Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect()).foreach((Function1)new Serializable(this, predictions){
                    public static final long serialVersionUID = 0L;
                    private final Set[] predictions$2;

                    public final Set<Object> apply(PowerIterationClustering.Assignment a) {
                        return (Set)this.predictions$2[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id()));
                    }
                    {
                        this.predictions$2 = predictions$2;
                    }
                });
                scala.collection.immutable.Set $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])predictions).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n1).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n1), n).toSet()}));
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                PowerIterationClusteringModel model2 = new PowerIterationClustering().setK(2).setMaxIterations(10).setInitializationMode("degree").run(this.$outer.sc().parallelize((Seq)similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
                Set[] predictions2 = (Set[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Object> apply() {
                        return Set$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(Set.class));
                Predef$.MODULE$.refArrayOps((Object[])model2.assignments().collect()).foreach((Function1)new Serializable(this, predictions2){
                    public static final long serialVersionUID = 0L;
                    private final Set[] predictions2$2;

                    public final Set<Object> apply(PowerIterationClustering.Assignment a) {
                        return (Set)this.predictions2$2[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id()));
                    }
                    {
                        this.predictions2$2 = predictions2$2;
                    }
                });
                scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])predictions2).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n1).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(n1), n).toSet()}));
                scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ PowerIterationClusteringSuite org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("normalize and powerIter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PowerIterationClusteringSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq similarities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0))}));
                double[][] expected = (double[][])((Object[])new double[][]{{0.0, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333}, {0.5, 0.0, 0.5, 0.0}, {0.3333333333333333, 0.3333333333333333, 0.0, 0.3333333333333333}, {0.5, 0.0, 0.5, 0.0}});
                Graph w = PowerIterationClustering$.MODULE$.normalize(this.$outer.sc().parallelize(similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
                Predef$.MODULE$.refArrayOps((Object[])w.edges().collect()).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final double[][] expected$1;

                    public final void apply(Edge<Object> x0$2) {
                        Edge<Object> edge = x0$2;
                        if (edge != null) {
                            long i = edge.srcId();
                            long j = edge.dstId();
                            double x = edge.attr$mcD$sp();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.expected$1[(int)i][(int)j]).absTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(expected.apply(i.toInt).apply(j.toInt)).absTol(1.0E-14))");
                            this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(edge);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$1 = expected$1;
                    }
                });
                RDD v0 = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJD.sp(0L, 0.1), new Tuple2.mcJD.sp(1L, 0.2), new Tuple2.mcJD.sp(2L, 0.3), new Tuple2.mcJD.sp(3L, 0.4)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                Graph w0 = Graph$.MODULE$.apply(v0, (RDD)w.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
                Tuple2[] v1 = (Tuple2[])PowerIterationClustering$.MODULE$.powerIter(w0, 1).collect();
                double[] u = new double[]{0.3, 0.2, 0.2333333333333333, 0.2};
                double norm = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(u).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double[] u1 = (double[])Predef$.MODULE$.doubleArrayOps(u).map((Function1)new Serializable(this, norm){
                    public static final long serialVersionUID = 0L;
                    private final double norm$1;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x / this.norm$1;
                    }
                    {
                        this.norm$1 = norm$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Predef$.MODULE$.refArrayOps((Object[])v1).foreach((Function1)new Serializable(this, u1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final double[] u1$1;

                    public final void apply(Tuple2<Object, Object> x0$3) {
                        Tuple2<Object, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            long i = tuple2._1$mcJ$sp();
                            double x = tuple2._2$mcD$sp();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.u1$1[(int)i]).absTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(u1.apply(i.toInt)).absTol(1.0E-14))");
                            this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.u1$1 = u1$1;
                    }
                });
            }

            public /* synthetic */ PowerIterationClusteringSuite org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PowerIterationClusteringSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                PowerIterationClusteringModel model = PowerIterationClusteringSuite$.MODULE$.createModel(this.$outer.sc(), 3, 10);
                try {
                    model.save(this.$outer.sc(), path);
                    PowerIterationClusteringModel sameModel = PowerIterationClusteringModel$.MODULE$.load(this.$outer.sc(), path);
                    PowerIterationClusteringSuite$.MODULE$.checkEqual(model, sameModel);
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

