/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u001b\t\u0019\u0012I]3b+:$WM]\"veZ,7+^5uK*\u00111\u0001B\u0001\u000bKZ\fG.^1uS>t'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005kRLG.\u0003\u0002\u0018)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0001")
public class AreaUnderCurveSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public AreaUnderCurveSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("auc computation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AreaUnderCurveSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq curve = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(2.0, 3.0), new Tuple2.mcDD.sp(3.0, 0.0)}));
                double auc = 4.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of((Iterable)curve)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(auc).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(curve)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(auc).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD rddCurve = this.$outer.sc().parallelize(curve, 2, ClassTag$.MODULE$.apply(Tuple2.class));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of(rddCurve)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(auc).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(rddCurve)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(auc).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("auc of an empty curve", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AreaUnderCurveSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq curve = (Seq)Seq$.MODULE$.empty();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of((Iterable)curve)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(curve)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD rddCurve = this.$outer.sc().parallelize(curve, 2, ClassTag$.MODULE$.apply(Tuple2.class));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of(rddCurve)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(rddCurve)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("auc of a curve with a single point", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AreaUnderCurveSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq curve = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of((Iterable)curve)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(curve)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD rddCurve = this.$outer.sc().parallelize(curve, 2, ClassTag$.MODULE$.apply(Tuple2.class));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of(rddCurve)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(rddCurve)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

