/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u001b\t1\"+Z4sKN\u001c\u0018n\u001c8NKR\u0014\u0018nY:Tk&$XM\u0003\u0002\u0004\t\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!Q\u000f^5m\u0013\t9BCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0004_\n\u001cX#\u0001\u0011\u0011\u0007\u0005B#&D\u0001#\u0015\t\u0019C%A\u0005j[6,H/\u00192mK*\u0011QEJ\u0001\u000bG>dG.Z2uS>t'\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%\u0012#\u0001\u0002'jgR\u0004\"a\u000b\u0017\u000e\u0003\u0019J!!\f\u0014\u0003\r\u0011{WO\u00197f\u0011\u0019y\u0003\u0001)A\u0005A\u0005!qNY:!\u0011\u001d\t\u0004A1A\u0005\u0002I\n1!\u001a9t+\u0005Q\u0003B\u0002\u001b\u0001A\u0003%!&\u0001\u0003faN\u0004\u0003")
public class RegressionMetricsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final List<Object> obs;
    private final double eps;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public List<Object> obs() {
        return this.obs;
    }

    public double eps() {
        return this.eps;
    }

    public RegressionMetricsSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.obs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{77.0, 85.0, 62.0, 55.0, 63.0, 88.0, 57.0, 81.0, 51.0}));
        this.eps = 1.0E-5;
        this.test("regression metrics for unbiased (includes intercept term) predictor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RegressionMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List preds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{72.08, 91.88, 65.48, 52.28, 62.18, 81.98, 58.88, 78.68, 55.58}));
                RDD predictionAndObservations = this.$outer.sc().parallelize((Seq)preds.zip(this.$outer.obs(), List$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(157.3).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(157.3).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(3.7355556).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(3.7355556).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(17.539511).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(17.539511).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(4.18802).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(4.18802).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.89968225).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.89968225).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("regression metrics for biased (no intercept term) predictor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RegressionMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List preds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{72.12, 99.17, 63.11, 45.08, 58.6, 85.65, 54.09, 81.14, 49.58}));
                RDD predictionAndObservations = this.$outer.sc().parallelize((Seq)preds.zip(this.$outer.obs(), List$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations, true);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(294.88167).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(294.88167).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(4.5888889).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(4.5888889).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(39.958711).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(39.958711).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(6.3212903).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(6.3212903).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.99185395).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.99185395).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("regression metrics with complete fitting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RegressionMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List<Object> preds = this.$outer.obs();
                RDD predictionAndObservations = this.$outer.sc().parallelize((Seq)preds.zip(this.$outer.obs(), List$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(174.83951).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(174.83951).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(this.$outer.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(RegressionMetricsSuite.this.eps))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

