/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.feature.ChiSqSelector;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.feature.ChiSqSelectorModel$;
import org.apache.spark.mllib.feature.ChiSqSelectorSuite$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u001b\t\u00112\t[5TcN+G.Z2u_J\u001cV/\u001b;f\u0015\t\u0019A!A\u0004gK\u0006$XO]3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!Q\u000f^5m\u0013\t9BCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011q!\u0002\u0010\u0003\u0011\u0003y\u0012AE\"iSN\u000b8+\u001a7fGR|'oU;ji\u0016\u0004\"\u0001\b\u0011\u0007\u000b\u0005\u0011\u0001\u0012A\u0011\u0014\u0005\u0001r\u0001\"B\r!\t\u0003\u0019C#A\u0010\t\u000b\u0015\u0002C\u0011\u0001\u0014\u0002\u0017\r\u0014X-\u0019;f\u001b>$W\r\u001c\u000b\u0002OA\u0011A\u0004K\u0005\u0003S\t\u0011!c\u00115j'F\u001cV\r\\3di>\u0014Xj\u001c3fY\")1\u0006\tC\u0001Y\u0005Q1\r[3dW\u0016\u000bX/\u00197\u0015\u00075\u001aT\u0007\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0003V]&$\b\"\u0002\u001b+\u0001\u00049\u0013!A1\t\u000bYR\u0003\u0019A\u0014\u0002\u0003\tDq\u0001\u000f\u0011\u0002\u0002\u0013%\u0011(A\u0006sK\u0006$'+Z:pYZ,G#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001\u00027b]\u001eT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t1qJ\u00196fGR\u0004")
public class ChiSqSelectorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void checkEqual(ChiSqSelectorModel chiSqSelectorModel, ChiSqSelectorModel chiSqSelectorModel2) {
        ChiSqSelectorSuite$.MODULE$.checkEqual(chiSqSelectorModel, chiSqSelectorModel2);
    }

    public static ChiSqSelectorModel createModel() {
        return ChiSqSelectorSuite$.MODULE$.createModel();
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public ChiSqSelectorSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("ChiSqSelector transform test (sparse & dense vector)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChiSqSelectorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set filteredData;
                RDD labeledDiscreteData = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 8.0), new Tuple2.mcID.sp(1, 7.0)}))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 9.0), new Tuple2.mcID.sp(2, 6.0)}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 8.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 5.0}))})), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Set preFilteredData = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(new double[]{0.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{6.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{8.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{5.0}))}));
                ChiSqSelectorModel model = new ChiSqSelector(1).fit(labeledDiscreteData);
                Set $org_scalatest_assert_macro_left = filteredData = Predef$.MODULE$.refArrayOps((Object[])labeledDiscreteData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final ChiSqSelectorModel model$1;

                    public final LabeledPoint apply(LabeledPoint lp) {
                        return new LabeledPoint(lp.label(), this.model$1.transform(lp.features()));
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)).collect()).toSet();
                Set $org_scalatest_assert_macro_right = preFilteredData;
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model load / save", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChiSqSelectorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ChiSqSelectorModel model = ChiSqSelectorSuite$.MODULE$.createModel();
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    ChiSqSelectorModel sameModel = ChiSqSelectorModel$.MODULE$.load(this.$outer.sc(), path);
                    ChiSqSelectorSuite$.MODULE$.checkEqual(model, sameModel);
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

