/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.feature.PCA;
import org.apache.spark.mllib.feature.PCAModel;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u001b\tA\u0001kQ!Tk&$XM\u0003\u0002\u0004\t\u00059a-Z1ukJ,'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005kRLG.\u0003\u0002\u0018)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\n}\tA\u0001Z1uCV\t\u0001\u0005E\u0002\"I\u0019j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\u0011\ta\u0001\\5oC2<\u0017BA\u0016)\u0005\u00191Vm\u0019;pe\"1Q\u0006\u0001Q\u0001\n\u0001\nQ\u0001Z1uC\u0002B\u0001b\f\u0001\t\u0006\u0004%I\u0001M\u0001\bI\u0006$\u0018M\u0015#E+\u0005\t\u0004c\u0001\u001a6M5\t1G\u0003\u00025\r\u0005\u0019!\u000f\u001a3\n\u0005Y\u001a$a\u0001*E\t\"A\u0001\b\u0001E\u0001B\u0003&\u0011'\u0001\u0005eCR\f'\u000b\u0012#!\u0001")
public class PCASuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final Vector[] data;
    private RDD<Vector> org$apache$spark$mllib$feature$PCASuite$$dataRDD;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RDD org$apache$spark$mllib$feature$PCASuite$$dataRDD$lzycompute() {
        PCASuite pCASuite = this;
        synchronized (pCASuite) {
            if (!this.bitmap$0) {
                this.org$apache$spark$mllib$feature$PCASuite$$dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.data()), 2, ClassTag$.MODULE$.apply(Vector.class));
                this.bitmap$0 = true;
            }
        }
        this.data = null;
        return this.org$apache$spark$mllib$feature$PCASuite$$dataRDD;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    private Vector[] data() {
        return this.data;
    }

    public RDD<Vector> org$apache$spark$mllib$feature$PCASuite$$dataRDD() {
        return this.bitmap$0 ? this.org$apache$spark$mllib$feature$PCASuite$$dataRDD : this.org$apache$spark$mllib$feature$PCASuite$$dataRDD$lzycompute();
    }

    public PCASuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.data = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(3, 7.0)}))), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 3.0, 4.0, 5.0})), Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 6.0, 7.0}))});
        this.test("Correct computing use a PCA wrapper", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PCASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = (int)this.$outer.org$apache$spark$mllib$feature$PCASuite$$dataRDD().count();
                PCAModel pca = new PCA(k).fit(this.$outer.org$apache$spark$mllib$feature$PCASuite$$dataRDD());
                RowMatrix mat = new RowMatrix(this.$outer.org$apache$spark$mllib$feature$PCASuite$$dataRDD());
                Tuple2 tuple2 = mat.computePrincipalComponentsAndExplainedVariance(k);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Matrix pc = (Matrix)tuple2._1();
                    Vector explainedVariance = (Vector)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)pc, (Object)explainedVariance);
                    Matrix pc2 = (Matrix)tuple23._1();
                    Vector explainedVariance2 = (Vector)tuple23._2();
                    Vector[] pca_transform = (Vector[])pca.transform(this.$outer.org$apache$spark$mllib$feature$PCASuite$$dataRDD()).collect();
                    Vector[] mat_multiply = (Vector[])mat.multiply(pc2).rows().collect();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])pca_transform).toSet());
                    Set $org_scalatest_assert_macro_right = Predef$.MODULE$.refArrayOps((Object[])mat_multiply).toSet();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(pca.explainedVariance());
                    Vector $org_scalatest_assert_macro_right2 = explainedVariance2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

