/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.feature.StandardScalerSuite$;
import org.apache.spark.mllib.feature.StandardScalerSuite$$anonfun$3$;
import org.apache.spark.mllib.feature.StandardScalerSuite$$anonfun$3$$anonfun$apply$mcV$sp$1$;
import org.apache.spark.mllib.feature.StandardScalerSuite$$anonfun$3$$anonfun$apply$mcV$sp$2$;
import org.apache.spark.mllib.feature.StandardScalerSuite$$anonfun$4$;
import org.apache.spark.mllib.feature.StandardScalerSuite$$anonfun$4$$anonfun$apply$mcV$sp$3$;
import org.apache.spark.mllib.feature.StandardScalerSuite$$anonfun$4$$anonfun$apply$mcV$sp$4$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.Tuple3Zipped;
import scala.runtime.Tuple3Zipped$;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u001b\t\u00192\u000b^1oI\u0006\u0014HmU2bY\u0016\u00148+^5uK*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\tA!\u001e;jY&\u0011q\u0003\u0006\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\u0019\r|gn\u001d;b]R$\u0015\r^1\u0016\u0003\u0001\u00022!\t\u0013'\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#!B!se\u0006L\bCA\u0014+\u001b\u0005A#BA\u0015\u0005\u0003\u0019a\u0017N\\1mO&\u00111\u0006\u000b\u0002\u0007-\u0016\u001cGo\u001c:\t\r5\u0002\u0001\u0015!\u0003!\u00035\u0019wN\\:uC:$H)\u0019;bA!9q\u0006\u0001b\u0001\n\u0003y\u0012AC:qCJ\u001cX\rR1uC\"1\u0011\u0007\u0001Q\u0001\n\u0001\n1b\u001d9beN,G)\u0019;bA!91\u0007\u0001b\u0001\n\u0003y\u0012!\u00033f]N,G)\u0019;b\u0011\u0019)\u0004\u0001)A\u0005A\u0005QA-\u001a8tK\u0012\u000bG/\u0019\u0011\t\u000b]\u0002A\u0011\u0002\u001d\u0002\u001d\r|W\u000e];uKN+X.\\1ssR\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0011\tAa\u001d;bi&\u0011ah\u000f\u0002\u001f\u001bVdG/\u001b<be&\fG/Z*uCRL7\u000f^5dC2\u001cV/\\7befDQ\u0001\u0011\u001cA\u0002\u0005\u000bA\u0001Z1uCB\u0019!)\u0012\u0014\u000e\u0003\rS!\u0001\u0012\u0004\u0002\u0007I$G-\u0003\u0002G\u0007\n\u0019!\u000b\u0012#")
public class StandardScalerSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final Vector[] constantData;
    private final Vector[] sparseData;
    private final Vector[] denseData;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Vector[] constantData() {
        return this.constantData;
    }

    public Vector[] sparseData() {
        return this.sparseData;
    }

    public Vector[] denseData() {
        return this.denseData;
    }

    public MultivariateStatisticalSummary org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary(RDD<Vector> data) {
        MultivariateOnlineSummarizer x$13 = new MultivariateOnlineSummarizer();
        Serializable x$14 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator, Vector data) {
                return aggregator.add(data);
            }
        };
        Serializable x$15 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator1, MultivariateOnlineSummarizer aggregator2) {
                return aggregator1.merge(aggregator2);
            }
        };
        int x$16 = data.treeAggregate$default$4((Object)x$13);
        return (MultivariateStatisticalSummary)data.treeAggregate((Object)x$13, (Function2)x$14, (Function2)x$15, x$16, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
    }

    public StandardScalerSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.constantData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))});
        this.sparseData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, -2.0), new Tuple2.mcID.sp(1, 2.3)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, -1.0), new Tuple2.mcID.sp(2, -3.0)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, -5.1)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 3.8), new Tuple2.mcID.sp(2, 1.9)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.7), new Tuple2.mcID.sp(1, -0.6)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.9)})))});
        this.denseData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.3, 0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.0, -3.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-5.1, 0.0})), Vectors$.MODULE$.dense(3.8, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.9})), Vectors$.MODULE$.dense(1.7, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.6, 0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.9, 0.0}))});
        this.test("Standardization with dense input when means and stds are provided", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StandardScalerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD dataRDD = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.denseData()), 3, ClassTag$.MODULE$.apply(Vector.class));
                StandardScaler standardizer1 = new StandardScaler(true, true);
                StandardScaler standardizer2 = new StandardScaler();
                StandardScaler standardizer3 = new StandardScaler(true, false);
                StandardScalerModel model1 = standardizer1.fit(dataRDD);
                StandardScalerModel model2 = standardizer2.fit(dataRDD);
                StandardScalerModel model3 = standardizer3.fit(dataRDD);
                StandardScalerModel equivalentModel1 = new StandardScalerModel(model1.std(), model1.mean());
                StandardScalerModel equivalentModel2 = new StandardScalerModel(model2.std(), model2.mean(), true, false);
                StandardScalerModel equivalentModel3 = new StandardScalerModel(model3.std(), model3.mean(), false, true);
                Vector[] data1 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.denseData()).map((Function1)new Serializable(this, equivalentModel1){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel equivalentModel1$1;

                    public final Vector apply(Vector vector) {
                        return this.equivalentModel1$1.transform(vector);
                    }
                    {
                        this.equivalentModel1$1 = equivalentModel1$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Vector[] data2 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.denseData()).map((Function1)new Serializable(this, equivalentModel2){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel equivalentModel2$1;

                    public final Vector apply(Vector vector) {
                        return this.equivalentModel2$1.transform(vector);
                    }
                    {
                        this.equivalentModel2$1 = equivalentModel2$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Vector[] data3 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.denseData()).map((Function1)new Serializable(this, equivalentModel3){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel equivalentModel3$1;

                    public final Vector apply(Vector vector) {
                        return this.equivalentModel3$1.transform(vector);
                    }
                    {
                        this.equivalentModel3$1 = equivalentModel3$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                RDD data1RDD = equivalentModel1.transform(dataRDD);
                RDD data2RDD = equivalentModel2.transform(dataRDD);
                RDD data3RDD = equivalentModel3.transform(dataRDD);
                MultivariateStatisticalSummary summary = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)dataRDD);
                MultivariateStatisticalSummary summary1 = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)data1RDD);
                MultivariateStatisticalSummary summary2 = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)data2RDD);
                MultivariateStatisticalSummary summary3 = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)data3RDD);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.denseData(), (Object)data1, data1RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$1, Vector x1$1, Vector x2$1) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$1, (Object)x1$1, (Object)x2$1);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$1: org.apache.spark.mllib.linalg.Vector, x1$1: org.apache.spark.mllib.linalg.Vector, x2$1: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$1, x1$1, x2$1) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after standardization.");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.denseData(), (Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$2, Vector x1$2, Vector x2$2) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$2, (Object)x1$2, (Object)x2$2);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$2: org.apache.spark.mllib.linalg.Vector, x1$2: org.apache.spark.mllib.linalg.Vector, x2$2: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$2, x1$2, x2$2) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The vector type should be preserved after standardization.");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.denseData(), (Object)data3, data3RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$3, Vector x1$3, Vector x2$3) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$3, (Object)x1$3, (Object)x2$3);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$3: org.apache.spark.mllib.linalg.Vector, x1$3: org.apache.spark.mllib.linalg.Vector, x2$3: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$3, x1$3, x2$3) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The vector type should be preserved after standardization.");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data1, data1RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data3, data3RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.mean()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.mean).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary.variance()).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary.variance).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-1.31527964, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.023470449, 0.11637768424}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-1.31527964, 1.023470449, 0.11637768424)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.637735298, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.156973995, 1.32247368462}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.637735298, 0.156973995, 1.32247368462)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.865538862, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.22604255, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.865538862, -0.22604255, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.71580142, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.71580142, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.58333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.58333333, -2.8166666666}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.58333333, -0.58333333, -2.8166666666)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.58333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.316666666, 0.18333333333}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.58333333, 2.316666666, 0.18333333333)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Standardization with dense input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StandardScalerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD dataRDD = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.denseData()), 3, ClassTag$.MODULE$.apply(Vector.class));
                StandardScaler standardizer1 = new StandardScaler(true, true);
                StandardScaler standardizer2 = new StandardScaler();
                StandardScaler standardizer3 = new StandardScaler(true, false);
                StandardScalerModel model1 = standardizer1.fit(dataRDD);
                StandardScalerModel model2 = standardizer2.fit(dataRDD);
                StandardScalerModel model3 = standardizer3.fit(dataRDD);
                Vector[] data1 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.denseData()).map((Function1)new Serializable(this, model1){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel model1$1;

                    public final Vector apply(Vector vector) {
                        return this.model1$1.transform(vector);
                    }
                    {
                        this.model1$1 = model1$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Vector[] data2 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.denseData()).map((Function1)new Serializable(this, model2){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel model2$1;

                    public final Vector apply(Vector vector) {
                        return this.model2$1.transform(vector);
                    }
                    {
                        this.model2$1 = model2$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Vector[] data3 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.denseData()).map((Function1)new Serializable(this, model3){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel model3$1;

                    public final Vector apply(Vector vector) {
                        return this.model3$1.transform(vector);
                    }
                    {
                        this.model3$1 = model3$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                RDD data1RDD = model1.transform(dataRDD);
                RDD data2RDD = model2.transform(dataRDD);
                RDD data3RDD = model3.transform(dataRDD);
                MultivariateStatisticalSummary summary = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)dataRDD);
                MultivariateStatisticalSummary summary1 = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)data1RDD);
                MultivariateStatisticalSummary summary2 = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)data2RDD);
                MultivariateStatisticalSummary summary3 = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)data3RDD);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.denseData(), (Object)data1, data1RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$4, Vector x1$4, Vector x2$4) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$4, (Object)x1$4, (Object)x2$4);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$4: org.apache.spark.mllib.linalg.Vector, x1$4: org.apache.spark.mllib.linalg.Vector, x2$4: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$4, x1$4, x2$4) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after standardization.");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.denseData(), (Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$5, Vector x1$5, Vector x2$5) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$5, (Object)x1$5, (Object)x2$5);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$5: org.apache.spark.mllib.linalg.Vector, x1$5: org.apache.spark.mllib.linalg.Vector, x2$5: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$5, x1$5, x2$5) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The vector type should be preserved after standardization.");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.denseData(), (Object)data3, data3RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$6, Vector x1$6, Vector x2$6) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$6, (Object)x1$6, (Object)x2$6);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$6: org.apache.spark.mllib.linalg.Vector, x1$6: org.apache.spark.mllib.linalg.Vector, x2$6: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$6, x1$6, x2$6) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The vector type should be preserved after standardization.");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data1, data1RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data3, data3RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.mean()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.mean).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary.variance()).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary.variance).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-1.31527964, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.023470449, 0.11637768424}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-1.31527964, 1.023470449, 0.11637768424)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.637735298, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.156973995, 1.32247368462}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.637735298, 0.156973995, 1.32247368462)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.865538862, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.22604255, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.865538862, -0.22604255, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.71580142, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.71580142, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.58333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.58333333, -2.8166666666}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.58333333, -0.58333333, -2.8166666666)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.58333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.316666666, 0.18333333333}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.58333333, 2.316666666, 0.18333333333)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Standardization with sparse input when means and stds are provided", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StandardScalerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD dataRDD = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.sparseData()), 3, ClassTag$.MODULE$.apply(Vector.class));
                StandardScaler standardizer1 = new StandardScaler(true, true);
                StandardScaler standardizer2 = new StandardScaler();
                StandardScaler standardizer3 = new StandardScaler(true, false);
                StandardScalerModel model1 = standardizer1.fit(dataRDD);
                StandardScalerModel model2 = standardizer2.fit(dataRDD);
                StandardScalerModel model3 = standardizer3.fit(dataRDD);
                StandardScalerModel equivalentModel1 = new StandardScalerModel(model1.std(), model1.mean());
                StandardScalerModel equivalentModel2 = new StandardScalerModel(model2.std(), model2.mean(), true, false);
                StandardScalerModel equivalentModel3 = new StandardScalerModel(model3.std(), model3.mean(), false, true);
                Vector[] data2 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.sparseData()).map((Function1)new Serializable(this, equivalentModel2){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel equivalentModel2$2;

                    public final Vector apply(Vector vector) {
                        return this.equivalentModel2$2.transform(vector);
                    }
                    {
                        this.equivalentModel2$2 = equivalentModel2$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                this.$outer.withClue("Standardization with mean can not be applied on sparse input.", (Function0)new Serializable(this, equivalentModel1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    public final StandardScalerModel equivalentModel1$2;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$1 $outer;

                            public final Object apply() {
                                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().sparseData()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$1$$anonfun$apply$9 $outer;

                                    public final Vector apply(Vector vector) {
                                        return this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$anonfun$$$outer().equivalentModel1$2.transform(vector);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                            }

                            public /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$1 org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.equivalentModel1$2 = equivalentModel1$2;
                    }
                });
                this.$outer.withClue("Standardization with mean can not be applied on sparse input.", (Function0)new Serializable(this, equivalentModel3){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    public final StandardScalerModel equivalentModel3$2;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$2 $outer;

                            public final Object apply() {
                                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().sparseData()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$2$$anonfun$apply$11 $outer;

                                    public final Vector apply(Vector vector) {
                                        return this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$anonfun$$$outer().equivalentModel3$2.transform(vector);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                            }

                            public /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$2 org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.equivalentModel3$2 = equivalentModel3$2;
                    }
                });
                RDD data2RDD = equivalentModel2.transform(dataRDD);
                MultivariateStatisticalSummary summary = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)data2RDD);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.sparseData(), (Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$7, Vector x1$7, Vector x2$7) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$7, (Object)x1$7, (Object)x2$7);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.sparseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$7: org.apache.spark.mllib.linalg.Vector, x1$7: org.apache.spark.mllib.linalg.Vector, x2$7: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$7, x1$7, x2$7) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after standardization.");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary.mean()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary.mean).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.865538862), new Tuple2.mcID.sp(1, -0.22604255)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, 0.865538862), scala.Tuple2.apply[Int, Double](1, -0.22604255)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.71580142)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.71580142)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }

            public /* synthetic */ StandardScalerSuite org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Standardization with sparse input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StandardScalerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD dataRDD = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.sparseData()), 3, ClassTag$.MODULE$.apply(Vector.class));
                StandardScaler standardizer1 = new StandardScaler(true, true);
                StandardScaler standardizer2 = new StandardScaler();
                StandardScaler standardizer3 = new StandardScaler(true, false);
                StandardScalerModel model1 = standardizer1.fit(dataRDD);
                StandardScalerModel model2 = standardizer2.fit(dataRDD);
                StandardScalerModel model3 = standardizer3.fit(dataRDD);
                Vector[] data2 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.sparseData()).map((Function1)new Serializable(this, model2){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel model2$2;

                    public final Vector apply(Vector vector) {
                        return this.model2$2.transform(vector);
                    }
                    {
                        this.model2$2 = model2$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                this.$outer.withClue("Standardization with mean can not be applied on sparse input.", (Function0)new Serializable(this, model1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    public final StandardScalerModel model1$2;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$3 $outer;

                            public final Object apply() {
                                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().sparseData()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$3$$anonfun$apply$13 $outer;

                                    public final Vector apply(Vector vector) {
                                        return this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$anonfun$$$outer().model1$2.transform(vector);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                            }

                            public /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$3 org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }

                    public /* synthetic */ $anonfun$4 org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model1$2 = model1$2;
                    }
                });
                this.$outer.withClue("Standardization with mean can not be applied on sparse input.", (Function0)new Serializable(this, model3){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    public final StandardScalerModel model3$2;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4 $outer;

                            public final Object apply() {
                                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().sparseData()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4$$anonfun$apply$15 $outer;

                                    public final Vector apply(Vector vector) {
                                        return this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$anonfun$$$outer().model3$2.transform(vector);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                            }

                            public /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4 org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }

                    public /* synthetic */ $anonfun$4 org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model3$2 = model3$2;
                    }
                });
                RDD data2RDD = model2.transform(dataRDD);
                MultivariateStatisticalSummary summary = this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$computeSummary((RDD<Vector>)data2RDD);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.sparseData(), (Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$8, Vector x1$8, Vector x2$8) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$8, (Object)x1$8, (Object)x2$8);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.sparseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$8: org.apache.spark.mllib.linalg.Vector, x1$8: org.apache.spark.mllib.linalg.Vector, x2$8: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$8, x1$8, x2$8) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after standardization.");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary.mean()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary.mean).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.865538862), new Tuple2.mcID.sp(1, -0.22604255)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, 0.865538862), scala.Tuple2.apply[Int, Double](1, -0.22604255)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.71580142)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.71580142)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }

            public /* synthetic */ StandardScalerSuite org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Standardization with constant input when means and stds are provided", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StandardScalerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD dataRDD = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.constantData()), 2, ClassTag$.MODULE$.apply(Vector.class));
                StandardScaler standardizer1 = new StandardScaler(true, true);
                StandardScaler standardizer2 = new StandardScaler(true, false);
                StandardScaler standardizer3 = new StandardScaler(false, true);
                StandardScalerModel model1 = standardizer1.fit(dataRDD);
                StandardScalerModel model2 = standardizer2.fit(dataRDD);
                StandardScalerModel model3 = standardizer3.fit(dataRDD);
                StandardScalerModel equivalentModel1 = new StandardScalerModel(model1.std(), model1.mean());
                StandardScalerModel equivalentModel2 = new StandardScalerModel(model2.std(), model2.mean(), true, false);
                StandardScalerModel equivalentModel3 = new StandardScalerModel(model3.std(), model3.mean(), false, true);
                Vector[] data1 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.constantData()).map((Function1)new Serializable(this, equivalentModel1){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel equivalentModel1$3;

                    public final Vector apply(Vector vector) {
                        return this.equivalentModel1$3.transform(vector);
                    }
                    {
                        this.equivalentModel1$3 = equivalentModel1$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Vector[] data2 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.constantData()).map((Function1)new Serializable(this, equivalentModel2){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel equivalentModel2$3;

                    public final Vector apply(Vector vector) {
                        return this.equivalentModel2$3.transform(vector);
                    }
                    {
                        this.equivalentModel2$3 = equivalentModel2$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Vector[] data3 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.constantData()).map((Function1)new Serializable(this, equivalentModel3){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel equivalentModel3$3;

                    public final Vector apply(Vector vector) {
                        return this.equivalentModel3$3.transform(vector);
                    }
                    {
                        this.equivalentModel3$3 = equivalentModel3$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])data1).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector x$1) {
                        return Predef$.MODULE$.doubleArrayOps(x$1.toArray()).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(double x$2) {
                                return this.apply$mcZD$sp(x$2);
                            }

                            public boolean apply$mcZD$sp(double x$2) {
                                return x$2 == 0.0;
                            }
                        });
                    }
                }), "scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data1).forall(((x$1: org.apache.spark.mllib.linalg.Vector) => scala.this.Predef.doubleArrayOps(x$1.toArray).forall(((x$2: Double) => x$2.==(0.0)))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The variance is zero, so the transformed result should be 0.0");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])data2).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector x$3) {
                        return Predef$.MODULE$.doubleArrayOps(x$3.toArray()).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(double x$4) {
                                return this.apply$mcZD$sp(x$4);
                            }

                            public boolean apply$mcZD$sp(double x$4) {
                                return x$4 == 0.0;
                            }
                        });
                    }
                }), "scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data2).forall(((x$3: org.apache.spark.mllib.linalg.Vector) => scala.this.Predef.doubleArrayOps(x$3.toArray).forall(((x$4: Double) => x$4.==(0.0)))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The variance is zero, so the transformed result should be 0.0");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])data3).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector x$5) {
                        return Predef$.MODULE$.doubleArrayOps(x$5.toArray()).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(double x$6) {
                                return this.apply$mcZD$sp(x$6);
                            }

                            public boolean apply$mcZD$sp(double x$6) {
                                return x$6 == 0.0;
                            }
                        });
                    }
                }), "scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data3).forall(((x$5: org.apache.spark.mllib.linalg.Vector) => scala.this.Predef.doubleArrayOps(x$5.toArray).forall(((x$6: Double) => x$6.==(0.0)))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The variance is zero, so the transformed result should be 0.0");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Standardization with constant input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StandardScalerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD dataRDD = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.constantData()), 2, ClassTag$.MODULE$.apply(Vector.class));
                StandardScaler standardizer1 = new StandardScaler(true, true);
                StandardScaler standardizer2 = new StandardScaler(true, false);
                StandardScaler standardizer3 = new StandardScaler(false, true);
                StandardScalerModel model1 = standardizer1.fit(dataRDD);
                StandardScalerModel model2 = standardizer2.fit(dataRDD);
                StandardScalerModel model3 = standardizer3.fit(dataRDD);
                Vector[] data1 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.constantData()).map((Function1)new Serializable(this, model1){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel model1$3;

                    public final Vector apply(Vector vector) {
                        return this.model1$3.transform(vector);
                    }
                    {
                        this.model1$3 = model1$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Vector[] data2 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.constantData()).map((Function1)new Serializable(this, model2){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel model2$3;

                    public final Vector apply(Vector vector) {
                        return this.model2$3.transform(vector);
                    }
                    {
                        this.model2$3 = model2$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Vector[] data3 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.constantData()).map((Function1)new Serializable(this, model3){
                    public static final long serialVersionUID = 0L;
                    private final StandardScalerModel model3$3;

                    public final Vector apply(Vector vector) {
                        return this.model3$3.transform(vector);
                    }
                    {
                        this.model3$3 = model3$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])data1).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector x$7) {
                        return Predef$.MODULE$.doubleArrayOps(x$7.toArray()).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(double x$8) {
                                return this.apply$mcZD$sp(x$8);
                            }

                            public boolean apply$mcZD$sp(double x$8) {
                                return x$8 == 0.0;
                            }
                        });
                    }
                }), "scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data1).forall(((x$7: org.apache.spark.mllib.linalg.Vector) => scala.this.Predef.doubleArrayOps(x$7.toArray).forall(((x$8: Double) => x$8.==(0.0)))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The variance is zero, so the transformed result should be 0.0");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])data2).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector x$9) {
                        return Predef$.MODULE$.doubleArrayOps(x$9.toArray()).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(double x$10) {
                                return this.apply$mcZD$sp(x$10);
                            }

                            public boolean apply$mcZD$sp(double x$10) {
                                return x$10 == 0.0;
                            }
                        });
                    }
                }), "scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data2).forall(((x$9: org.apache.spark.mllib.linalg.Vector) => scala.this.Predef.doubleArrayOps(x$9.toArray).forall(((x$10: Double) => x$10.==(0.0)))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The variance is zero, so the transformed result should be 0.0");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])data3).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector x$11) {
                        return Predef$.MODULE$.doubleArrayOps(x$11.toArray()).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(double x$12) {
                                return this.apply$mcZD$sp(x$12);
                            }

                            public boolean apply$mcZD$sp(double x$12) {
                                return x$12 == 0.0;
                            }
                        });
                    }
                }), "scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data3).forall(((x$11: org.apache.spark.mllib.linalg.Vector) => scala.this.Predef.doubleArrayOps(x$11.toArray).forall(((x$12: Double) => x$12.==(0.0)))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The variance is zero, so the transformed result should be 0.0");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("StandardScalerModel argument nulls are properly handled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StandardScalerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withClue("model needs at least one of std or mean vectors", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                StandardScalerModel standardScalerModel = new StandardScalerModel(null, null);
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.withClue("model needs std to set withStd to true", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final StandardScalerModel apply() {
                                StandardScalerModel model = new StandardScalerModel(null, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
                                return model.setWithStd(true);
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.withClue("model needs mean to set withMean to true", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final StandardScalerModel apply() {
                                StandardScalerModel model = new StandardScalerModel(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), null);
                                return model.setWithMean(true);
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.withClue("model needs std and mean vectors to be equal size when both are provided", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                StandardScalerModel standardScalerModel = new StandardScalerModel(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})));
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ StandardScalerSuite org$apache$spark$mllib$feature$StandardScalerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

