/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.feature.Word2Vec;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecSuite$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u001b\tiqk\u001c:eeY+7mU;ji\u0016T!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f%A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011\u0001B;uS2L!a\u0006\u000b\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001")
public class Word2VecSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public Word2VecSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Word2Vec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2[] syms;
                String sentence = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("a b ")).$times(100)).append((Object)new StringOps(Predef$.MODULE$.augmentString("a c ")).$times(10)).toString();
                Seq localDoc = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
                SparkContext qual$1 = this.$outer.sc();
                Seq x$10 = localDoc;
                int x$11 = qual$1.parallelize$default$2();
                RDD doc = qual$1.parallelize(x$10, x$11, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(String line) {
                        return Predef$.MODULE$.refArrayOps((Object[])line.split(" ")).toSeq();
                    }
                }, ClassTag$.MODULE$.apply(Seq.class));
                Word2VecModel model = new Word2Vec().setVectorSize(10).setSeed(42L).fit(doc);
                Tuple2[] $org_scalatest_assert_macro_left = syms = model.findSynonyms("a", 2);
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = (String)syms[0]._1();
                String $org_scalatest_assert_macro_right2 = "b";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = (String)syms[1]._1();
                String $org_scalatest_assert_macro_right3 = "c";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Map word2VecMap = model.getVectors();
                Word2VecModel newModel = new Word2VecModel(word2VecMap);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(newModel.getVectors().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(float[] x$1) {
                        return Predef$.MODULE$.floatArrayOps(x$1).toSeq();
                    }
                }));
                Map $org_scalatest_assert_macro_right4 = word2VecMap.mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(float[] x$2) {
                        return Predef$.MODULE$.floatArrayOps(x$2).toSeq();
                    }
                });
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Word2Vec throws exception when vocabulary is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Word2VecModel apply() {
                        String sentence = "a b c";
                        Seq localDoc = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
                        SparkContext qual$2 = this.$outer.org$apache$spark$mllib$feature$Word2VecSuite$$anonfun$$$outer().sc();
                        Seq x$12 = localDoc;
                        int x$13 = qual$2.parallelize$default$2();
                        RDD doc = qual$2.parallelize(x$12, x$13, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String line) {
                                return Predef$.MODULE$.refArrayOps((Object[])line.split(" ")).toSeq();
                            }
                        }, ClassTag$.MODULE$.apply(Seq.class));
                        return new Word2Vec().setMinCount(10).fit(doc);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ Word2VecSuite org$apache$spark$mllib$feature$Word2VecSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Word2VecModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2[] syms;
                int num = 2;
                Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
                Word2VecModel model = new Word2VecModel(word2VecMap);
                Tuple2[] $org_scalatest_assert_macro_left = syms = model.findSynonyms("china", num);
                int $org_scalatest_assert_macro_right = num;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = (String)syms[0]._1();
                String $org_scalatest_assert_macro_right2 = "taiwan";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = (String)syms[1]._1();
                String $org_scalatest_assert_macro_right3 = "japan";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("findSynonyms doesn't reject similar word vectors when called with a vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2[] syms;
                int num = 2;
                Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
                Word2VecModel model = new Word2VecModel(word2VecMap);
                Tuple2[] $org_scalatest_assert_macro_left = syms = model.findSynonyms(Vectors$.MODULE$.dense(new double[]{0.52, 0.5, 0.5, 0.5}), num);
                int $org_scalatest_assert_macro_right = num;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = (String)syms[0]._1();
                String $org_scalatest_assert_macro_right2 = "china";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = (String)syms[1]._1();
                String $org_scalatest_assert_macro_right3 = "taiwan";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model load / save", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
                Word2VecModel model = new Word2VecModel(word2VecMap);
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    Word2VecModel sameModel = Word2VecModel$.MODULE$.load(this.$outer.sc(), path);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(sameModel.getVectors().mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Object> apply(float[] x$3) {
                            return Predef$.MODULE$.floatArrayOps(x$3).toSeq();
                        }
                    }));
                    Map $org_scalatest_assert_macro_right = model.getVectors().mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Object> apply(float[] x$4) {
                            return Predef$.MODULE$.floatArrayOps(x$4).toSeq();
                        }
                    });
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("big model load / save", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String oldBufferConfValue = this.$outer.spark().conf().get("spark.kryoserializer.buffer.max", "64m");
                String oldBufferMaxConfValue = this.$outer.spark().conf().get("spark.kryoserializer.buffer", "64k");
                this.$outer.spark().conf().set("spark.kryoserializer.buffer", "50b");
                this.$outer.spark().conf().set("spark.kryoserializer.buffer.max", "50b");
                Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, float[]> apply(int i) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))), Array$.MODULE$.fill(10, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final float apply() {
                                return this.apply$mcF$sp();
                            }

                            public float apply$mcF$sp() {
                                return 0.1f;
                            }
                        }, ClassTag$.MODULE$.Float()));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()));
                Word2VecModel model = new Word2VecModel(word2VecMap);
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    Word2VecModel sameModel = Word2VecModel$.MODULE$.load(this.$outer.sc(), path);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(sameModel.getVectors().mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Object> apply(float[] x$5) {
                            return Predef$.MODULE$.floatArrayOps(x$5).toSeq();
                        }
                    }));
                    Map $org_scalatest_assert_macro_right = model.getVectors().mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Object> apply(float[] x$6) {
                            return Predef$.MODULE$.floatArrayOps(x$6).toSeq();
                        }
                    });
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                }
                catch (Throwable throwable) {
                    try {
                        throw this.$outer.fail("exception thrown persisting a model that spans over multiple partitions", throwable);
                    }
                    catch (Throwable throwable2) {
                        Utils$.MODULE$.deleteRecursively(tempDir);
                        this.$outer.spark().conf().set("spark.kryoserializer.buffer", oldBufferConfValue);
                        this.$outer.spark().conf().set("spark.kryoserializer.buffer.max", oldBufferMaxConfValue);
                        throw throwable2;
                    }
                }
                Utils$.MODULE$.deleteRecursively(tempDir);
                this.$outer.spark().conf().set("spark.kryoserializer.buffer", oldBufferConfValue);
                this.$outer.spark().conf().set("spark.kryoserializer.buffer.max", oldBufferMaxConfValue);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("test similarity for word vectors with large values is not Infinity or NaN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                float[] vecA = (float[])Predef$.MODULE$.doubleArrayOps(new double[]{-4.331467827487745E21, -5.26707742075006E21, 5.63551690626524E21, 2.833692188614257E21, (double)-1.968816E21f, -4.933950659913092E21, -2.7401535502536787E21, -1.418671793782632E20}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final float apply(double x$7) {
                        return this.apply$mcFD$sp(x$7);
                    }

                    public float apply$mcFD$sp(double x$7) {
                        return (float)x$7;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                float[] vecB = (float[])Predef$.MODULE$.doubleArrayOps(new double[]{-3.985017545110323E16, -3.4829783883841536E16, 9.421469251534848E15, 4.406968446667981E16, 7.20936298872832E15, -4.288330283037491E16, (double)-3.60558E16f, -2.8151294422155264E16}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final float apply(double x$8) {
                        return this.apply$mcFD$sp(x$8);
                    }

                    public float apply$mcFD$sp(double x$8) {
                        return (float)x$8;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                float[] vecC = (float[])Predef$.MODULE$.doubleArrayOps(new double[]{(double)-1.922738E16f, -3.907009342603264E16, 2.110207626838016E15, -4.877006661065114E16, -1.973496455574323E16, -3.2206001247617024E16, 2.772535822044365E16, 3.1618718156980224E16}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final float apply(double x$9) {
                        return this.apply$mcFD$sp(x$9);
                    }

                    public float apply$mcFD$sp(double x$9) {
                        return (float)x$9;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                Map wordMapIn = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"A", (Object)vecA), new Tuple2((Object)"B", (Object)vecB), new Tuple2((Object)"C", (Object)vecC)}));
                Word2VecModel model = new Word2VecModel(wordMapIn);
                Predef$.MODULE$.refArrayOps((Object[])model.findSynonyms("A", 5)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(Tuple2<String, Object> pair) {
                        Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(pair._2$mcD$sp()).isInfinite(), "scala.this.Predef.double2Double(pair._2).isInfinite()");
                        Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "") : Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(pair._2$mcD$sp()).isNaN(), "scala.this.Predef.double2Double(pair._2).isNaN()");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0)new Serializable(this, $org_scalatest_assert_macro_right){
                            public static final long serialVersionUID = 0L;
                            private final Bool $org_scalatest_assert_macro_right$1;

                            public final Bool apply() {
                                return this.$org_scalatest_assert_macro_right$1;
                            }
                            {
                                this.$org_scalatest_assert_macro_right$1 = $org_scalatest_assert_macro_right$1;
                            }
                        })));
                        this.$outer.org$apache$spark$mllib$feature$Word2VecSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ Word2VecSuite org$apache$spark$mllib$feature$Word2VecSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

