/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.util.Utils;
import org.junit.Assert;
import org.junit.Test;

public class JavaFPGrowthSuite
extends SharedSparkSession {
    @Test
    public void runFPGrowth() {
        JavaRDD rdd = this.jsc.parallelize(Arrays.asList(Arrays.asList("r z h k p".split(" ")), Arrays.asList("z y x w v u t s".split(" ")), Arrays.asList("s x o n r".split(" ")), Arrays.asList("x z y m t s q e".split(" ")), Arrays.asList("z".split(" ")), Arrays.asList("x z y r q t p".split(" "))), 2);
        FPGrowthModel model = new FPGrowth().setMinSupport(0.5).setNumPartitions(2).run(rdd);
        List freqItemsets = model.freqItemsets().toJavaRDD().collect();
        Assert.assertEquals((long)18L, (long)freqItemsets.size());
        for (FPGrowth.FreqItemset itemset : freqItemsets) {
            List items = itemset.javaItems();
            long freq = itemset.freq();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runFPGrowthSaveLoad() {
        JavaRDD rdd = this.jsc.parallelize(Arrays.asList(Arrays.asList("r z h k p".split(" ")), Arrays.asList("z y x w v u t s".split(" ")), Arrays.asList("s x o n r".split(" ")), Arrays.asList("x z y m t s q e".split(" ")), Arrays.asList("z".split(" ")), Arrays.asList("x z y r q t p".split(" "))), 2);
        FPGrowthModel model = new FPGrowth().setMinSupport(0.5).setNumPartitions(2).run(rdd);
        File tempDir = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"JavaFPGrowthSuite");
        String outputPath = tempDir.getPath();
        try {
            model.save(this.spark.sparkContext(), outputPath);
            FPGrowthModel newModel = FPGrowthModel.load((SparkContext)this.spark.sparkContext(), (String)outputPath);
            List freqItemsets = newModel.freqItemsets().toJavaRDD().collect();
            Assert.assertEquals((long)18L, (long)freqItemsets.size());
            for (FPGrowth.FreqItemset itemset : freqItemsets) {
                List items = itemset.javaItems();
                long freq = itemset.freq();
            }
        }
        finally {
            Utils.deleteRecursively((File)tempDir);
        }
    }
}

