/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.fpm.PrefixSpan;
import org.apache.spark.mllib.fpm.PrefixSpanModel;
import org.apache.spark.util.Utils;
import org.junit.Assert;
import org.junit.Test;

public class JavaPrefixSpanSuite
extends SharedSparkSession {
    @Test
    public void runPrefixSpan() {
        JavaRDD sequences = this.jsc.parallelize(Arrays.asList(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3)), Arrays.asList(Arrays.asList(1), Arrays.asList(3, 2), Arrays.asList(1, 2)), Arrays.asList(Arrays.asList(1, 2), Arrays.asList(5)), Arrays.asList(Arrays.asList(6))), 2);
        PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(0.5).setMaxPatternLength(5);
        PrefixSpanModel model = prefixSpan.run(sequences);
        JavaRDD freqSeqs = model.freqSequences().toJavaRDD();
        List localFreqSeqs = freqSeqs.collect();
        Assert.assertEquals((long)5L, (long)localFreqSeqs.size());
        for (PrefixSpan.FreqSequence freqSeq : localFreqSeqs) {
            List seq = freqSeq.javaSequence();
            long freq = freqSeq.freq();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runPrefixSpanSaveLoad() {
        JavaRDD sequences = this.jsc.parallelize(Arrays.asList(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3)), Arrays.asList(Arrays.asList(1), Arrays.asList(3, 2), Arrays.asList(1, 2)), Arrays.asList(Arrays.asList(1, 2), Arrays.asList(5)), Arrays.asList(Arrays.asList(6))), 2);
        PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(0.5).setMaxPatternLength(5);
        PrefixSpanModel model = prefixSpan.run(sequences);
        File tempDir = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"JavaPrefixSpanSuite");
        String outputPath = tempDir.getPath();
        try {
            model.save(this.spark.sparkContext(), outputPath);
            PrefixSpanModel newModel = PrefixSpanModel.load((SparkContext)this.spark.sparkContext(), (String)outputPath);
            JavaRDD freqSeqs = newModel.freqSequences().toJavaRDD();
            List localFreqSeqs = freqSeqs.collect();
            Assert.assertEquals((long)5L, (long)localFreqSeqs.size());
            for (PrefixSpan.FreqSequence freqSeq : localFreqSeqs) {
                List seq = freqSeq.javaSequence();
                long freq = freqSeq.freq();
            }
        }
        finally {
            Utils.deleteRecursively((File)tempDir);
        }
    }
}

