/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseVector;
import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001b\tY\"I]3fu\u00164Vm\u0019;pe\u000e{gN^3sg&|gnU;ji\u0016T!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001b\u0001\n\u0003I\u0012aA1seV\t!\u0004E\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00037\u0005J!A\t\u000f\u0003\r\u0011{WO\u00197f\u0011\u0019!\u0003\u0001)A\u00055\u0005!\u0011M\u001d:!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\n\u0011A\\\u000b\u0002QA\u00111$K\u0005\u0003Uq\u00111!\u00138u\u0011\u0019a\u0003\u0001)A\u0005Q\u0005\u0011a\u000e\t\u0005\b]\u0001\u0011\r\u0011\"\u00010\u0003\u001dIg\u000eZ5dKN,\u0012\u0001\r\t\u00047yA\u0003B\u0002\u001a\u0001A\u0003%\u0001'\u0001\u0005j]\u0012L7-Z:!\u0011\u001d!\u0004A1A\u0005\u0002e\taA^1mk\u0016\u001c\bB\u0002\u001c\u0001A\u0003%!$A\u0004wC2,Xm\u001d\u0011")
public class BreezeVectorConversionSuite
extends SparkFunSuite {
    private final double[] arr = new double[]{0.1, 0.2, 0.3, 0.4};
    private final int n;
    private final int[] indices = new int[]{0, 3, 5, 10, 13};
    private final double[] values = new double[]{0.1, 0.5, 0.3, -0.8, -1.0};

    public double[] arr() {
        return this.arr;
    }

    public int n() {
        return this.n;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public BreezeVectorConversionSuite() {
        this.n = 20;
        this.test("dense to breeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector vec = Vectors$.MODULE$.dense(this.$outer.arr());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(vec.asBreeze());
                DenseVector.mcD.sp $org_scalatest_assert_macro_right = new DenseVector.mcD.sp(this.$outer.arr());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse to breeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector vec = Vectors$.MODULE$.sparse(this.$outer.n(), this.$outer.indices(), this.$outer.values());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(vec.asBreeze());
                SparseVector.mcD.sp $org_scalatest_assert_macro_right = new SparseVector.mcD.sp(this.$outer.indices(), this.$outer.values(), this.$outer.n(), (Zero)Zero.DoubleZero$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("dense breeze to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector.mcD.sp breeze = new DenseVector.mcD.sp(this.$outer.arr());
                DenseVector vec = (DenseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.arr().length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double[] $org_scalatest_assert_macro_left2 = vec.values();
                double[] $org_scalatest_assert_macro_right2 = this.$outer.arr();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should not copy data");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse breeze to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector.mcD.sp breeze = new SparseVector.mcD.sp(this.$outer.indices(), this.$outer.values(), this.$outer.n(), (Zero)Zero.DoubleZero$.MODULE$);
                SparseVector vec = (SparseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int[] $org_scalatest_assert_macro_left2 = vec.indices();
                int[] $org_scalatest_assert_macro_right2 = this.$outer.indices();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should not copy data");
                double[] $org_scalatest_assert_macro_left3 = vec.values();
                double[] $org_scalatest_assert_macro_right3 = this.$outer.values();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse breeze with partially-used arrays to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BreezeVectorConversionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int activeSize = 3;
                SparseVector.mcD.sp breeze = new SparseVector.mcD.sp(this.$outer.indices(), this.$outer.values(), activeSize, this.$outer.n(), (Zero)Zero.DoubleZero$.MODULE$);
                SparseVector vec = (SparseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(vec.indices());
                int[] $org_scalatest_assert_macro_right2 = (int[])Predef$.MODULE$.intArrayOps(this.$outer.indices()).slice(0, activeSize);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(vec.values());
                double[] $org_scalatest_assert_macro_right3 = (double[])Predef$.MODULE$.doubleArrayOps(this.$outer.values()).slice(0, activeSize);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

