/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.GradientDescent$;
import org.apache.spark.mllib.optimization.GradientDescentSuite$;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Entry;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Tag;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.TraitSetter;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u00015<Q!\u0001\u0002\t\u00025\tAc\u0012:bI&,g\u000e\u001e#fg\u000e,g\u000e^*vSR,'BA\u0002\u0005\u00031y\u0007\u000f^5nSj\fG/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011Ac\u0012:bI&,g\u000e\u001e#fg\u000e,g\u000e^*vSR,7cA\b\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"aE\r\n\u0005i!\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u000f\u0010\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u0015yr\u0002\"\u0001!\u0003m9WM\\3sCR,Gj\\4jgRL7-\u00138qkR\f5\u000fT5tiR)\u0011e\f\u001b7wA\u0019!eJ\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3E\u0001\u0003MSN$\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0005\u0003)\u0011Xm\u001a:fgNLwN\\\u0005\u0003]-\u0012A\u0002T1cK2,G\rU8j]RDQ\u0001\r\u0010A\u0002E\naa\u001c4gg\u0016$\bCA\n3\u0013\t\u0019DC\u0001\u0004E_V\u0014G.\u001a\u0005\u0006ky\u0001\r!M\u0001\u0006g\u000e\fG.\u001a\u0005\u0006oy\u0001\r\u0001O\u0001\b]B{\u0017N\u001c;t!\t\u0019\u0012(\u0003\u0002;)\t\u0019\u0011J\u001c;\t\u000bqr\u0002\u0019\u0001\u001d\u0002\tM,W\r\u001a\u0005\u0006}=!\taP\u0001\u0010O\u0016tWM]1uK\u001e#\u0015J\u001c9viR)\u0001\tT'O\u001fB\u0019\u0011)S\u0015\u000f\u0005\t;eBA\"G\u001b\u0005!%BA#\r\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002I)\u00059\u0001/Y2lC\u001e,\u0017B\u0001&L\u0005\r\u0019V-\u001d\u0006\u0003\u0011RAQ\u0001M\u001fA\u0002EBQ!N\u001fA\u0002EBQaN\u001fA\u0002aBQ\u0001P\u001fA\u0002aBq!U\b\u0002\u0002\u0013%!+A\u0006sK\u0006$'+Z:pYZ,G#A*\u0011\u0005Q;V\"A+\u000b\u0005Y+\u0013\u0001\u00027b]\u001eL!\u0001W+\u0003\r=\u0013'.Z2u\r\u0011\u0001\"\u0001\u0001.\u0014\te[v\f\u001a\t\u00039vk\u0011AB\u0005\u0003=\u001a\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u00011c\u001b\u0005\t'B\u0001\u0013\u0005\u0013\t\u0019\u0017MA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dT\u0011!C:dC2\fG/Z:u\u0013\tIgM\u0001\u0005NCR\u001c\u0007.\u001a:t\u0011\u0015a\u0012\f\"\u0001l)\u0005a\u0007C\u0001\bZ\u0001")
public class GradientDescentSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
Matchers {
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final NoExceptionWord noException;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$module;
    private volatile Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$module;
    private volatile Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$module;
    private volatile Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$module;
    private volatile Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$module;

    public static Seq<LabeledPoint> generateGDInput(double d, double d2, int n, int n2) {
        return GradientDescentSuite$.MODULE$.generateGDInput(d, d2, n, n2);
    }

    public static List<LabeledPoint> generateLogisticInputAsList(double d, double d2, int n, int n2) {
        return GradientDescentSuite$.MODULE$.generateLogisticInputAsList(d, d2, n, n2);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$lzycompute() {
        GradientDescentSuite gradientDescentSuite = this;
        synchronized (gradientDescentSuite) {
            if (this.org$scalatest$Matchers$$AllCollected$module != null) return this.org$scalatest$Matchers$$AllCollected$module;
            this.org$scalatest$Matchers$$AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AllCollected$module;
        }
    }

    public final Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        return this.org$scalatest$Matchers$$AllCollected$module == null ? this.org$scalatest$Matchers$$AllCollected$lzycompute() : this.org$scalatest$Matchers$$AllCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$lzycompute() {
        GradientDescentSuite gradientDescentSuite = this;
        synchronized (gradientDescentSuite) {
            if (this.org$scalatest$Matchers$$EveryCollected$module != null) return this.org$scalatest$Matchers$$EveryCollected$module;
            this.org$scalatest$Matchers$$EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$EveryCollected$module;
        }
    }

    public final Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        return this.org$scalatest$Matchers$$EveryCollected$module == null ? this.org$scalatest$Matchers$$EveryCollected$lzycompute() : this.org$scalatest$Matchers$$EveryCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$lzycompute() {
        GradientDescentSuite gradientDescentSuite = this;
        synchronized (gradientDescentSuite) {
            if (this.org$scalatest$Matchers$$BetweenCollected$module != null) return this.org$scalatest$Matchers$$BetweenCollected$module;
            this.org$scalatest$Matchers$$BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$BetweenCollected$module;
        }
    }

    public final Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        return this.org$scalatest$Matchers$$BetweenCollected$module == null ? this.org$scalatest$Matchers$$BetweenCollected$lzycompute() : this.org$scalatest$Matchers$$BetweenCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$lzycompute() {
        GradientDescentSuite gradientDescentSuite = this;
        synchronized (gradientDescentSuite) {
            if (this.org$scalatest$Matchers$$AtLeastCollected$module != null) return this.org$scalatest$Matchers$$AtLeastCollected$module;
            this.org$scalatest$Matchers$$AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtLeastCollected$module;
        }
    }

    public final Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        return this.org$scalatest$Matchers$$AtLeastCollected$module == null ? this.org$scalatest$Matchers$$AtLeastCollected$lzycompute() : this.org$scalatest$Matchers$$AtLeastCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$lzycompute() {
        GradientDescentSuite gradientDescentSuite = this;
        synchronized (gradientDescentSuite) {
            if (this.org$scalatest$Matchers$$AtMostCollected$module != null) return this.org$scalatest$Matchers$$AtMostCollected$module;
            this.org$scalatest$Matchers$$AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtMostCollected$module;
        }
    }

    public final Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        return this.org$scalatest$Matchers$$AtMostCollected$module == null ? this.org$scalatest$Matchers$$AtMostCollected$lzycompute() : this.org$scalatest$Matchers$$AtMostCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$lzycompute() {
        GradientDescentSuite gradientDescentSuite = this;
        synchronized (gradientDescentSuite) {
            if (this.org$scalatest$Matchers$$NoCollected$module != null) return this.org$scalatest$Matchers$$NoCollected$module;
            this.org$scalatest$Matchers$$NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$NoCollected$module;
        }
    }

    public final Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        return this.org$scalatest$Matchers$$NoCollected$module == null ? this.org$scalatest$Matchers$$NoCollected$lzycompute() : this.org$scalatest$Matchers$$NoCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$lzycompute() {
        GradientDescentSuite gradientDescentSuite = this;
        synchronized (gradientDescentSuite) {
            if (this.org$scalatest$Matchers$$ExactlyCollected$module != null) return this.org$scalatest$Matchers$$ExactlyCollected$module;
            this.org$scalatest$Matchers$$ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$ExactlyCollected$module;
        }
    }

    public final Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        return this.org$scalatest$Matchers$$ExactlyCollected$module == null ? this.org$scalatest$Matchers$$ExactlyCollected$lzycompute() : this.org$scalatest$Matchers$$ExactlyCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() {
        GradientDescentSuite gradientDescentSuite = this;
        synchronized (gradientDescentSuite) {
            if (this.org$scalatest$Matchers$$ShouldMethodHelper$module != null) return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
            this.org$scalatest$Matchers$$ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
        }
    }

    public final Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        return this.org$scalatest$Matchers$$ShouldMethodHelper$module == null ? this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() : this.org$scalatest$Matchers$$ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol) {
        return Matchers.class.convertSymbolToHavePropertyMatcherGenerator((Matchers)this, (Symbol)symbol);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.class.equal((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.class.equal((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.class.$less((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.class.$greater((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.class.$less$eq((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.class.$greater$eq((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.class.definedAt((Matchers)this, right);
    }

    public Matchers.ResultOfEvaluatingApplication evaluating(Function0<Object> fun) {
        return Matchers.class.evaluating((Matchers)this, fun);
    }

    public <T> Matchers.ResultOfProduceInvocation<T> produce(Manifest<T> evidence$5) {
        return Matchers.class.produce((Matchers)this, evidence$5);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.oneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atLeastOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.noneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsAs((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsInOrderAs((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs) {
        return Matchers.class.only((Matchers)this, xs);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrderOnly((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.allOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrder((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atMostOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.class.thrownBy((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.class.message((Matchers)this, (String)expectedMessage);
    }

    public <T> void doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, String methodName, int stackDepth, Function1<T, BoxedUnit> fun) {
        Matchers.class.doCollected((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (String)methodName, (int)stackDepth, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.all((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.every((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.no((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <T> ResultOfATypeInvocation<T> a(Manifest<T> evidence$6) {
        return Matchers.class.a((Matchers)this, evidence$6);
    }

    public <T> ResultOfAnTypeInvocation<T> an(Manifest<T> evidence$7) {
        return Matchers.class.an((Matchers)this, evidence$7);
    }

    public <T> ResultOfTheTypeInvocation<T> the(Manifest<T> evidence$8) {
        return Matchers.class.the((Matchers)this, evidence$8);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o) {
        return Matchers.class.convertToAnyShouldWrapper((Matchers)this, o);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o) {
        return Matchers.class.convertToStringShouldWrapper((Matchers)this, (String)o);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.class.convertToRegexWrapper((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(Manifest<T> ev) {
        return Matchers.class.of((Matchers)this, ev);
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public NoExceptionWord noException() {
        return this.noException;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$noException_$eq(NoExceptionWord x$1) {
        this.noException = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.class.equal((MatcherWords)this, (Object)right);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.class.convertNumericToPlusOrMinusWrapper((Tolerance)this, pivot, evidence$2);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public GradientDescentSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        Tolerance.class.$init$((Tolerance)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        MatcherWords.class.$init$((MatcherWords)this);
        Explicitly.class.$init$((Explicitly)this);
        Matchers.class.$init$((Matchers)this);
        this.test("Assert the loss is decreasing.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientDescentSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector initialWeightsWithIntercept;
                int nPoints = 10000;
                double A = 2.0;
                double B = -1.5;
                double initialB = -1.0;
                double[] initialWeights = new double[]{initialB};
                LogisticGradient gradient = new LogisticGradient();
                SimpleUpdater updater = new SimpleUpdater();
                double stepSize = 1.0;
                int numIterations = 10;
                boolean regParam = false;
                double miniBatchFrac = 1.0;
                Seq<LabeledPoint> testData = GradientDescentSuite$.MODULE$.generateGDInput(A, B, nPoints, 42);
                Seq data = (Seq)testData.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Vector> apply(LabeledPoint x0$1) {
                        LabeledPoint labeledPoint = x0$1;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector features = labeledPoint.features();
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)label)), (Object)MLUtils$.MODULE$.appendBias(features));
                            return tuple2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD dataRDD = this.$outer.sc().parallelize(data, 2, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
                Tuple2 tuple2 = GradientDescent$.MODULE$.runMiniBatchSGD(dataRDD, (Gradient)gradient, (Updater)updater, stepSize, numIterations, (double)regParam, miniBatchFrac, initialWeightsWithIntercept = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(initialWeights).toArray(ClassTag$.MODULE$.Double())).$colon$plus((Object)BoxesRunTime.boxToDouble((double)1.0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                if (tuple2 != null) {
                    double[] loss;
                    double[] dArray;
                    double[] loss2 = dArray = (loss = (double[])tuple2._2());
                    double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(loss2).last()) - BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(loss2).head());
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (double)$org_scalatest_assert_macro_right);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"loss isn't decreasing.");
                    double[] lossDiff = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(loss2).init()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray((double[])Predef$.MODULE$.doubleArrayOps(loss2).tail()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple2<Object, Object> x0$2) {
                            Tuple2<Object, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                double lhs = tuple2._1$mcD$sp();
                                double rhs = tuple2._2$mcD$sp();
                                double d = lhs - rhs;
                                return d;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    double $org_scalatest_assert_macro_left2 = (double)Predef$.MODULE$.doubleArrayOps(lossDiff).count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(double x$1) {
                            return this.apply$mcZD$sp(x$1);
                        }

                        public boolean apply$mcZD$sp(double x$1) {
                            return x$1 > 0.0;
                        }
                    }) / (double)Predef$.MODULE$.doubleArrayOps(lossDiff).size();
                    double $org_scalatest_assert_macro_right2 = 0.8;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Test the loss and gradient of first iteration with regularization.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientDescentSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector initialWeightsWithIntercept;
                boolean regParam0;
                LogisticGradient gradient = new LogisticGradient();
                SquaredL2Updater updater = new SquaredL2Updater();
                Seq<LabeledPoint> testData = GradientDescentSuite$.MODULE$.generateGDInput(2.0, -1.5, 10000, 42);
                Seq data = (Seq)testData.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Vector> apply(LabeledPoint x0$3) {
                        LabeledPoint labeledPoint = x0$3;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector features = labeledPoint.features();
                            double d = 1.0;
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)label)), (Object)Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(features.toArray()).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                            return tuple2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD dataRDD = this.$outer.sc().parallelize(data, 2, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
                Tuple2 tuple2 = GradientDescent$.MODULE$.runMiniBatchSGD(dataRDD, (Gradient)gradient, (Updater)updater, 1.0, 1, (double)(regParam0 = false), 1.0, initialWeightsWithIntercept = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})));
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Vector newWeights0 = (Vector)tuple2._1();
                    double[] loss0 = (double[])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)newWeights0, (Object)loss0);
                    Vector newWeights02 = (Vector)tuple23._1();
                    double[] loss02 = (double[])tuple23._2();
                    boolean regParam1 = true;
                    Tuple2 tuple24 = GradientDescent$.MODULE$.runMiniBatchSGD(dataRDD, (Gradient)gradient, (Updater)updater, 1.0, 1, (double)regParam1, 1.0, initialWeightsWithIntercept);
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        Vector newWeights1 = (Vector)tuple24._1();
                        double[] loss1 = (double[])tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)newWeights1, (Object)loss1);
                        Vector newWeights12 = (Vector)tuple26._1();
                        double[] loss12 = (double[])tuple26._2();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss12[0]).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss02[0] + (package$.MODULE$.pow(initialWeightsWithIntercept.apply(0), 2.0) + package$.MODULE$.pow(initialWeightsWithIntercept.apply(1), 2.0)) / (double)2).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(loss1.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(loss0.apply(0).+(scala.math.`package`.pow(initialWeightsWithIntercept.apply(0), 2.0).+(scala.math.`package`.pow(initialWeightsWithIntercept.apply(1), 2.0))./(2))).absTol(1.0E-5))");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"For non-zero weights, the regVal should be \\frac{1}{2}\\sum_i w_i^2.");
                        Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(newWeights12.apply(0)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(newWeights02.apply(0) - initialWeightsWithIntercept.apply(0)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(newWeights1.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(newWeights0.apply(0).-(initialWeightsWithIntercept.apply(0))).absTol(1.0E-5))");
                        Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(newWeights12.apply(1)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(newWeights02.apply(1) - initialWeightsWithIntercept.apply(1)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(newWeights1.apply(1)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(newWeights0.apply(1).-(initialWeightsWithIntercept.apply(1))).absTol(1.0E-5))") : Bool$.MODULE$.simpleMacroBool(false, "");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The different between newWeights with/without regularization should be initialWeightsWithIntercept.");
                        return;
                    }
                    throw new MatchError((Object)tuple24);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("iteration should end with convergence tolerance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientDescentSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector initialWeightsWithIntercept;
                int nPoints = 10000;
                double A = 2.0;
                double B = -1.5;
                double initialB = -1.0;
                double[] initialWeights = new double[]{initialB};
                LogisticGradient gradient = new LogisticGradient();
                SimpleUpdater updater = new SimpleUpdater();
                double stepSize = 1.0;
                int numIterations = 10;
                boolean regParam = false;
                double miniBatchFrac = 1.0;
                double convergenceTolerance = 0.5;
                Seq<LabeledPoint> testData = GradientDescentSuite$.MODULE$.generateGDInput(A, B, nPoints, 42);
                Seq data = (Seq)testData.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Vector> apply(LabeledPoint x0$4) {
                        LabeledPoint labeledPoint = x0$4;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector features = labeledPoint.features();
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)label)), (Object)MLUtils$.MODULE$.appendBias(features));
                            return tuple2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD dataRDD = this.$outer.sc().parallelize(data, 2, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
                Tuple2 tuple2 = GradientDescent$.MODULE$.runMiniBatchSGD(dataRDD, (Gradient)gradient, (Updater)updater, stepSize, numIterations, (double)regParam, miniBatchFrac, initialWeightsWithIntercept = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(initialWeights).toArray(ClassTag$.MODULE$.Double())).$colon$plus((Object)BoxesRunTime.boxToDouble((double)1.0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), convergenceTolerance);
                if (tuple2 != null) {
                    double[] loss;
                    double[] dArray;
                    double[] loss2 = dArray = (loss = (double[])tuple2._2());
                    int $org_scalatest_assert_macro_left = loss2.length;
                    int $org_scalatest_assert_macro_right = numIterations;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"convergenceTolerance failed to stop optimization early");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

