/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import java.io.File;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.GradientDescent$;
import org.apache.spark.mllib.optimization.GradientDescentSuite$;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.LBFGS$;
import org.apache.spark.mllib.optimization.LBFGSSuite$;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Entry;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Tag;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.TraitSetter;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u00015\u0011!\u0002\u0014\"G\u000fN\u001bV/\u001b;f\u0015\t\u0019A!\u0001\u0007paRLW.\u001b>bi&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001q!\u0003\u0007\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0011)H/\u001b7\n\u0005]!\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\t\u00033qi\u0011A\u0007\u0006\u00037)\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005uQ\"\u0001C'bi\u000eDWM]:\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\u0005\t\u0003C\u0001\u0012\u0001\u001b\u0005\u0011\u0001b\u0002\u0013\u0001\u0005\u0004%\t!J\u0001\b]B{\u0017N\u001c;t+\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\"1Q\u0006\u0001Q\u0001\n\u0019\n\u0001B\u001c)pS:$8\u000f\t\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0003\u0005\tU#A\u0019\u0011\u0005\u001d\u0012\u0014BA\u001a)\u0005\u0019!u.\u001e2mK\"1Q\u0007\u0001Q\u0001\nE\n!!\u0011\u0011\t\u000f]\u0002!\u0019!C\u0001a\u0005\t!\t\u0003\u0004:\u0001\u0001\u0006I!M\u0001\u0003\u0005\u0002Bqa\u000f\u0001C\u0002\u0013\u0005\u0001'\u0001\u0005j]&$\u0018.\u00197C\u0011\u0019i\u0004\u0001)A\u0005c\u0005I\u0011N\\5uS\u0006d'\t\t\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001A\u00039Ig.\u001b;jC2<V-[4iiN,\u0012!\u0011\t\u0004O\t\u000b\u0014BA\")\u0005\u0015\t%O]1z\u0011\u0019)\u0005\u0001)A\u0005\u0003\u0006y\u0011N\\5uS\u0006dw+Z5hQR\u001c\b\u0005C\u0004H\u0001\t\u0007I\u0011\u0001%\u0002\u0011\u001d\u0014\u0018\rZ5f]R,\u0012!\u0013\t\u0003E)K!a\u0013\u0002\u0003!1{w-[:uS\u000e<%/\u00193jK:$\bBB'\u0001A\u0003%\u0011*A\u0005he\u0006$\u0017.\u001a8uA!9q\n\u0001b\u0001\n\u0003)\u0013A\u00048v[\u000e{'O]3di&|gn\u001d\u0005\u0007#\u0002\u0001\u000b\u0011\u0002\u0014\u0002\u001f9,XnQ8se\u0016\u001cG/[8og\u0002Bqa\u0015\u0001C\u0002\u0013\u0005\u0001'A\u0007nS:L')\u0019;dQ\u001a\u0013\u0018m\u0019\u0005\u0007+\u0002\u0001\u000b\u0011B\u0019\u0002\u001d5Lg.\u001b\"bi\u000eDgI]1dA!9q\u000b\u0001b\u0001\n\u0003A\u0016!D:j[BdW-\u00169eCR,'/F\u0001Z!\t\u0011#,\u0003\u0002\\\u0005\ti1+[7qY\u0016,\u0006\u000fZ1uKJDa!\u0018\u0001!\u0002\u0013I\u0016AD:j[BdW-\u00169eCR,'\u000f\t\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0003A\u0019\u0018/^1sK\u0012d%'\u00169eCR,'/F\u0001b!\t\u0011#-\u0003\u0002d\u0005\t\u00012+];be\u0016$GJM+qI\u0006$XM\u001d\u0005\u0007K\u0002\u0001\u000b\u0011B1\u0002#M\fX/\u0019:fI2\u0013T\u000b\u001d3bi\u0016\u0014\b\u0005C\u0004h\u0001\t\u0007I\u0011\u00015\u0002\u0011Q,7\u000f\u001e#bi\u0006,\u0012!\u001b\t\u0004UJ,hBA6q\u001d\taw.D\u0001n\u0015\tqG\"\u0001\u0004=e>|GOP\u0005\u0002S%\u0011\u0011\u000fK\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019HOA\u0002TKFT!!\u001d\u0015\u0011\u0005YLX\"A<\u000b\u0005a$\u0011A\u0003:fOJ,7o]5p]&\u0011!p\u001e\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u0007y\u0002\u0001\u000b\u0011B5\u0002\u0013Q,7\u000f\u001e#bi\u0006\u0004\u0003b\u0002@\u0001\u0005\u0004%\ta`\u0001\u0005I\u0006$\u0018-\u0006\u0002\u0002\u0002A1\u00111AA\u0005\u0003\u0017i!!!\u0002\u000b\u0007\u0005\u001d\u0001&\u0001\u0006d_2dWm\u0019;j_:L1a]A\u0003!\u00199\u0013QB\u0019\u0002\u0012%\u0019\u0011q\u0002\u0015\u0003\rQ+\b\u000f\\33!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\t\u00051A.\u001b8bY\u001eLA!a\u0007\u0002\u0016\t1a+Z2u_JD\u0001\"a\b\u0001A\u0003%\u0011\u0011A\u0001\u0006I\u0006$\u0018\r\t\u0005\u000b\u0003G\u0001\u0001R1A\u0005\u0002\u0005\u0015\u0012a\u00023bi\u0006\u0014F\tR\u000b\u0003\u0003O\u0001b!!\u000b\u00020\u0005-QBAA\u0016\u0015\r\tiCB\u0001\u0004e\u0012$\u0017\u0002BA\u0019\u0003W\u00111A\u0015#E\u0011)\t)\u0004\u0001E\u0001B\u0003&\u0011qE\u0001\tI\u0006$\u0018M\u0015#EA\u0001")
public class LBFGSSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
Matchers {
    private final int nPoints;
    private final double A;
    private final double B;
    private final double initialB;
    private final double[] initialWeights;
    private final LogisticGradient gradient;
    private final int numCorrections;
    private final double miniBatchFrac;
    private final SimpleUpdater simpleUpdater;
    private final SquaredL2Updater squaredL2Updater;
    private final Seq<LabeledPoint> testData;
    private final Seq<Tuple2<Object, Vector>> data;
    private RDD<Tuple2<Object, Vector>> dataRDD;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final NoExceptionWord noException;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;
    private volatile Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$module;
    private volatile Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$module;
    private volatile Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$module;
    private volatile Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$module;
    private volatile Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$module;

    private RDD dataRDD$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (!this.bitmap$0) {
                this.dataRDD = this.sc().parallelize(this.data(), 2, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
                this.bitmap$0 = true;
            }
            return this.dataRDD;
        }
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.org$scalatest$Matchers$$AllCollected$module != null) return this.org$scalatest$Matchers$$AllCollected$module;
            this.org$scalatest$Matchers$$AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AllCollected$module;
        }
    }

    public final Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        return this.org$scalatest$Matchers$$AllCollected$module == null ? this.org$scalatest$Matchers$$AllCollected$lzycompute() : this.org$scalatest$Matchers$$AllCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.org$scalatest$Matchers$$EveryCollected$module != null) return this.org$scalatest$Matchers$$EveryCollected$module;
            this.org$scalatest$Matchers$$EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$EveryCollected$module;
        }
    }

    public final Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        return this.org$scalatest$Matchers$$EveryCollected$module == null ? this.org$scalatest$Matchers$$EveryCollected$lzycompute() : this.org$scalatest$Matchers$$EveryCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.org$scalatest$Matchers$$BetweenCollected$module != null) return this.org$scalatest$Matchers$$BetweenCollected$module;
            this.org$scalatest$Matchers$$BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$BetweenCollected$module;
        }
    }

    public final Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        return this.org$scalatest$Matchers$$BetweenCollected$module == null ? this.org$scalatest$Matchers$$BetweenCollected$lzycompute() : this.org$scalatest$Matchers$$BetweenCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.org$scalatest$Matchers$$AtLeastCollected$module != null) return this.org$scalatest$Matchers$$AtLeastCollected$module;
            this.org$scalatest$Matchers$$AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtLeastCollected$module;
        }
    }

    public final Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        return this.org$scalatest$Matchers$$AtLeastCollected$module == null ? this.org$scalatest$Matchers$$AtLeastCollected$lzycompute() : this.org$scalatest$Matchers$$AtLeastCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.org$scalatest$Matchers$$AtMostCollected$module != null) return this.org$scalatest$Matchers$$AtMostCollected$module;
            this.org$scalatest$Matchers$$AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtMostCollected$module;
        }
    }

    public final Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        return this.org$scalatest$Matchers$$AtMostCollected$module == null ? this.org$scalatest$Matchers$$AtMostCollected$lzycompute() : this.org$scalatest$Matchers$$AtMostCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.org$scalatest$Matchers$$NoCollected$module != null) return this.org$scalatest$Matchers$$NoCollected$module;
            this.org$scalatest$Matchers$$NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$NoCollected$module;
        }
    }

    public final Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        return this.org$scalatest$Matchers$$NoCollected$module == null ? this.org$scalatest$Matchers$$NoCollected$lzycompute() : this.org$scalatest$Matchers$$NoCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.org$scalatest$Matchers$$ExactlyCollected$module != null) return this.org$scalatest$Matchers$$ExactlyCollected$module;
            this.org$scalatest$Matchers$$ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$ExactlyCollected$module;
        }
    }

    public final Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        return this.org$scalatest$Matchers$$ExactlyCollected$module == null ? this.org$scalatest$Matchers$$ExactlyCollected$lzycompute() : this.org$scalatest$Matchers$$ExactlyCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.org$scalatest$Matchers$$ShouldMethodHelper$module != null) return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
            this.org$scalatest$Matchers$$ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
        }
    }

    public final Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        return this.org$scalatest$Matchers$$ShouldMethodHelper$module == null ? this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() : this.org$scalatest$Matchers$$ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol) {
        return Matchers.class.convertSymbolToHavePropertyMatcherGenerator((Matchers)this, (Symbol)symbol);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.class.equal((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.class.equal((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.class.$less((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.class.$greater((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.class.$less$eq((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.class.$greater$eq((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.class.definedAt((Matchers)this, right);
    }

    public Matchers.ResultOfEvaluatingApplication evaluating(Function0<Object> fun) {
        return Matchers.class.evaluating((Matchers)this, fun);
    }

    public <T> Matchers.ResultOfProduceInvocation<T> produce(Manifest<T> evidence$5) {
        return Matchers.class.produce((Matchers)this, evidence$5);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.oneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atLeastOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.noneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsAs((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsInOrderAs((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs) {
        return Matchers.class.only((Matchers)this, xs);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrderOnly((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.allOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrder((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atMostOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.class.thrownBy((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.class.message((Matchers)this, (String)expectedMessage);
    }

    public <T> void doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, String methodName, int stackDepth, Function1<T, BoxedUnit> fun) {
        Matchers.class.doCollected((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (String)methodName, (int)stackDepth, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.all((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.every((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.no((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <T> ResultOfATypeInvocation<T> a(Manifest<T> evidence$6) {
        return Matchers.class.a((Matchers)this, evidence$6);
    }

    public <T> ResultOfAnTypeInvocation<T> an(Manifest<T> evidence$7) {
        return Matchers.class.an((Matchers)this, evidence$7);
    }

    public <T> ResultOfTheTypeInvocation<T> the(Manifest<T> evidence$8) {
        return Matchers.class.the((Matchers)this, evidence$8);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o) {
        return Matchers.class.convertToAnyShouldWrapper((Matchers)this, o);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o) {
        return Matchers.class.convertToStringShouldWrapper((Matchers)this, (String)o);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.class.convertToRegexWrapper((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(Manifest<T> ev) {
        return Matchers.class.of((Matchers)this, ev);
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public NoExceptionWord noException() {
        return this.noException;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$noException_$eq(NoExceptionWord x$1) {
        this.noException = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.class.equal((MatcherWords)this, (Object)right);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.class.convertNumericToPlusOrMinusWrapper((Tolerance)this, pivot, evidence$2);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public int nPoints() {
        return this.nPoints;
    }

    public double A() {
        return this.A;
    }

    public double B() {
        return this.B;
    }

    public double initialB() {
        return this.initialB;
    }

    public double[] initialWeights() {
        return this.initialWeights;
    }

    public LogisticGradient gradient() {
        return this.gradient;
    }

    public int numCorrections() {
        return this.numCorrections;
    }

    public double miniBatchFrac() {
        return this.miniBatchFrac;
    }

    public SimpleUpdater simpleUpdater() {
        return this.simpleUpdater;
    }

    public SquaredL2Updater squaredL2Updater() {
        return this.squaredL2Updater;
    }

    public Seq<LabeledPoint> testData() {
        return this.testData;
    }

    public Seq<Tuple2<Object, Vector>> data() {
        return this.data;
    }

    public RDD<Tuple2<Object, Vector>> dataRDD() {
        return this.bitmap$0 ? this.dataRDD : this.dataRDD$lzycompute();
    }

    public LBFGSSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        Tolerance.class.$init$((Tolerance)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        MatcherWords.class.$init$((MatcherWords)this);
        Explicitly.class.$init$((Explicitly)this);
        Matchers.class.$init$((Matchers)this);
        this.nPoints = 10000;
        this.A = 2.0;
        this.B = -1.5;
        this.initialB = -1.0;
        this.initialWeights = new double[]{this.initialB()};
        this.gradient = new LogisticGradient();
        this.numCorrections = 10;
        this.miniBatchFrac = 1.0;
        this.simpleUpdater = new SimpleUpdater();
        this.squaredL2Updater = new SquaredL2Updater();
        this.testData = GradientDescentSuite$.MODULE$.generateGDInput(this.A(), this.B(), this.nPoints(), 42);
        this.data = (Seq)this.testData().map((Function1)new $anonfun$8(this), Seq$.MODULE$.canBuildFrom());
        this.test("LBFGS loss should be decreasing and match the result of Gradient Descent.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LBFGSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                boolean regParam = false;
                double d = 1.0;
                Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(this.$outer.initialWeights()).toArray(ClassTag$.MODULE$.Double())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                double convergenceTol = 1.0E-12;
                int numIterations = 10;
                Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.$outer.dataRDD(), (Gradient)this.$outer.gradient(), (Updater)this.$outer.simpleUpdater(), this.$outer.numCorrections(), convergenceTol, numIterations, (double)regParam, initialWeightsWithIntercept);
                if (tuple2 != null) {
                    double[] loss;
                    double[] dArray;
                    double[] loss2 = dArray = (loss = (double[])tuple2._2());
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)loss2, Predef$.MODULE$.doubleArrayOps(loss2).tail())), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ArrayOps<Object> apply(double[] xs) {
                            return Predef$.MODULE$.doubleArrayOps(xs);
                        }
                    }, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ArrayOps<Object> apply(double[] xs) {
                            return Predef$.MODULE$.doubleArrayOps(xs);
                        }
                    }), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(double x$3, double x$4) {
                            return this.apply$mcZDD$sp(x$3, x$4);
                        }

                        public boolean apply$mcZDD$sp(double x$3, double x$4) {
                            return x$3 > x$4;
                        }
                    }), "scala.this.Predef.tuple2ToZippedOps[Array[Double], Array[Double]](scala.Tuple2.apply[Array[Double], Array[Double]](loss, scala.this.Predef.doubleArrayOps(loss).tail)).zipped[Double, Array[Double], Double, Array[Double]]({\n  ((xs: Array[Double]) => scala.this.Predef.doubleArrayOps(xs))\n}, {\n  ((xs: Array[Double]) => scala.this.Predef.doubleArrayOps(xs))\n}).forall(((x$3: Double, x$4: Double) => x$3.>(x$4)))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"loss should be monotonically decreasing.");
                    double stepSize = 1.0;
                    int numGDIterations = 50;
                    Tuple2 tuple22 = GradientDescent$.MODULE$.runMiniBatchSGD(this.$outer.dataRDD(), (Gradient)this.$outer.gradient(), (Updater)this.$outer.simpleUpdater(), stepSize, numGDIterations, (double)regParam, this.$outer.miniBatchFrac(), initialWeightsWithIntercept);
                    if (tuple22 != null) {
                        double[] lossGD;
                        double[] dArray2;
                        double[] lossGD2 = dArray2 = (lossGD = (double[])tuple22._2());
                        double $org_scalatest_assert_macro_left = package$.MODULE$.abs((BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(lossGD2).last()) - BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(loss2).last())) / BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(loss2).last()));
                        double $org_scalatest_assert_macro_right = 0.02;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"LBFGS should match GD result within 2% difference.");
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("LBFGS and Gradient Descent with L2 regularization should get the same result.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LBFGSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double regParam = 0.2;
                Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.3, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12}));
                double convergenceTol = 1.0E-12;
                int numIterations = 10;
                Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.$outer.dataRDD(), (Gradient)this.$outer.gradient(), (Updater)this.$outer.squaredL2Updater(), this.$outer.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Vector weightLBFGS = (Vector)tuple2._1();
                    double[] lossLBFGS = (double[])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)weightLBFGS, (Object)lossLBFGS);
                    Vector weightLBFGS2 = (Vector)tuple23._1();
                    double[] lossLBFGS2 = (double[])tuple23._2();
                    int numGDIterations = 50;
                    double stepSize = 1.0;
                    Tuple2 tuple24 = GradientDescent$.MODULE$.runMiniBatchSGD(this.$outer.dataRDD(), (Gradient)this.$outer.gradient(), (Updater)this.$outer.squaredL2Updater(), stepSize, numGDIterations, regParam, this.$outer.miniBatchFrac(), initialWeightsWithIntercept, convergenceTol);
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        Vector weightGD = (Vector)tuple24._1();
                        double[] lossGD = (double[])tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)weightGD, (Object)lossGD);
                        Vector weightGD2 = (Vector)tuple26._1();
                        double[] lossGD2 = (double[])tuple26._2();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(lossGD2[0]).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(lossLBFGS2[0]).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(lossGD.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(lossLBFGS.apply(0)).absTol(1.0E-5))");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The first losses of LBFGS and GD should be the same.");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(lossGD2).last())).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(lossLBFGS2).last())).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(lossGD).last).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(lossLBFGS).last).relTol(0.02))");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The last losses of LBFGS and GD should be within 2% difference.");
                        Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS2.apply(0)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(0)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(0)).relTol(0.02))");
                        Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS2.apply(1)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(1)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(1)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(1)).relTol(0.02))") : Bool$.MODULE$.simpleMacroBool(false, "");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The weight differences between LBFGS and GD should be within 2%.");
                        return;
                    }
                    throw new MatchError((Object)tuple24);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("The convergence criteria should work as we expect.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LBFGSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double regParam = 0.0;
                Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
                int numIterations = 8;
                double convergenceTol = 0.0;
                Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.$outer.dataRDD(), (Gradient)this.$outer.gradient(), (Updater)this.$outer.squaredL2Updater(), this.$outer.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
                if (tuple2 != null) {
                    double[] lossLBFGS1;
                    double[] dArray;
                    double[] lossLBFGS12;
                    double[] $org_scalatest_assert_macro_left = lossLBFGS12 = (dArray = (lossLBFGS1 = (double[])tuple2._2()));
                    int $org_scalatest_assert_macro_right = 9;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    convergenceTol = 0.1;
                    Tuple2 tuple22 = LBFGS$.MODULE$.runLBFGS(this.$outer.dataRDD(), (Gradient)this.$outer.gradient(), (Updater)this.$outer.squaredL2Updater(), this.$outer.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
                    if (tuple22 != null) {
                        double[] lossLBFGS2;
                        double[] dArray2;
                        double[] lossLBFGS22;
                        double[] $org_scalatest_assert_macro_left2 = lossLBFGS22 = (dArray2 = (lossLBFGS2 = (double[])tuple22._2()));
                        int $org_scalatest_assert_macro_right2 = 4;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double $org_scalatest_assert_macro_left3 = (lossLBFGS22[2] - lossLBFGS22[3]) / lossLBFGS22[2];
                        double $org_scalatest_assert_macro_right3 = convergenceTol;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        convergenceTol = 0.01;
                        Tuple2 tuple23 = LBFGS$.MODULE$.runLBFGS(this.$outer.dataRDD(), (Gradient)this.$outer.gradient(), (Updater)this.$outer.squaredL2Updater(), this.$outer.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
                        if (tuple23 != null) {
                            double[] lossLBFGS3;
                            double[] dArray3;
                            double[] lossLBFGS32 = dArray3 = (lossLBFGS3 = (double[])tuple23._2());
                            int $org_scalatest_assert_macro_left4 = lossLBFGS32.length;
                            int $org_scalatest_assert_macro_right4 = lossLBFGS22.length;
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4);
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            double[] $org_scalatest_assert_macro_left5 = lossLBFGS32;
                            int $org_scalatest_assert_macro_right5 = 6;
                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                            double $org_scalatest_assert_macro_left6 = (lossLBFGS32[4] - lossLBFGS32[5]) / lossLBFGS32[4];
                            double $org_scalatest_assert_macro_right6 = convergenceTol;
                            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6);
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                            return;
                        }
                        throw new MatchError((Object)tuple23);
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Optimize via class LBFGS.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LBFGSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double regParam = 0.2;
                Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.3, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12}));
                double convergenceTol = 1.0E-12;
                int numIterations = 10;
                LBFGS lbfgsOptimizer = new LBFGS((Gradient)this.$outer.gradient(), (Updater)this.$outer.squaredL2Updater()).setNumCorrections(this.$outer.numCorrections()).setConvergenceTol(convergenceTol).setNumIterations(numIterations).setRegParam(regParam);
                Vector weightLBFGS = lbfgsOptimizer.optimize(this.$outer.dataRDD(), initialWeightsWithIntercept);
                int numGDIterations = 50;
                double stepSize = 1.0;
                Tuple2 tuple2 = GradientDescent$.MODULE$.runMiniBatchSGD(this.$outer.dataRDD(), (Gradient)this.$outer.gradient(), (Updater)this.$outer.squaredL2Updater(), stepSize, numGDIterations, regParam, this.$outer.miniBatchFrac(), initialWeightsWithIntercept, convergenceTol);
                if (tuple2 != null) {
                    Vector weightGD;
                    Vector vector;
                    Vector weightGD2 = vector = (weightGD = (Vector)tuple2._1());
                    Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS.apply(0)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(0)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(0)).relTol(0.02))");
                    Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS.apply(1)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(1)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(1)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(1)).relTol(0.02))") : Bool$.MODULE$.simpleMacroBool(false, "");
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The weight differences between LBFGS and GD should be within 2%.");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

