/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.norm$;
import breeze.math.Field;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.optimization.NNLS;
import org.apache.spark.mllib.optimization.NNLS$;
import org.apache.spark.mllib.optimization.NNLSSuite$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichDouble;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001\u001b\tIaJ\u0014'T'VLG/\u001a\u0006\u0003\u0007\u0011\tAb\u001c9uS6L'0\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012aC4f]>sWm\u001d#bi\u0006$2A\u0007\u00184!\u0011Yb\u0004I\u0016\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a\u0001V;qY\u0016\u0014\u0004cA\u0011'Q5\t!E\u0003\u0002$I\u00051A.\u001b8bY\u001eT\u0011!J\u0001\u0007EJ,WM_3\n\u0005\u001d\u0012#a\u0003#f]N,W*\u0019;sSb\u0004\"aG\u0015\n\u0005)b\"A\u0002#pk\ndW\rE\u0002\"Y!J!!\f\u0012\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\u0005\u0006_]\u0001\r\u0001M\u0001\u0002]B\u00111$M\u0005\u0003eq\u00111!\u00138u\u0011\u0015!t\u00031\u00016\u0003\u0011\u0011\u0018M\u001c3\u0011\u0005YJT\"A\u001c\u000b\u0005ab\u0012\u0001B;uS2L!AO\u001c\u0003\rI\u000bg\u000eZ8n\u0011\u0015a\u0004\u0001\"\u0001>\u0003U\u0019w.\u001c9vi\u0016|%M[3di&4XMV1mk\u0016$B\u0001\u000b A\u0005\")qh\u000fa\u0001A\u0005\u0019\u0011\r^1\t\u000b\u0005[\u0004\u0019A\u0016\u0002\u0007\u0005$(\rC\u0003Dw\u0001\u00071&A\u0001y\u0001")
public class NNLSSuite
extends SparkFunSuite {
    public Tuple2<DenseMatrix<Object>, DenseVector<Object>> genOnesData(int n, Random rand) {
        DenseMatrix.mcD.sp A = new DenseMatrix.mcD.sp(n, n, (double[])Array$.MODULE$.fill(n * n, (Function0)new Serializable(this, rand){
            public static final long serialVersionUID = 0L;
            private final Random rand$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.rand$1.nextDouble();
            }
            {
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.Double()));
        DenseVector b = (DenseVector)A.$times((Object)new DenseVector.mcD.sp((double[])Array$.MODULE$.fill(n, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }, ClassTag$.MODULE$.Double())), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD());
        return new Tuple2(((ImmutableNumericOps)A.t(DenseMatrix$.MODULE$.canTranspose())).$times((Object)A, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), ((ImmutableNumericOps)A.t(DenseMatrix$.MODULE$.canTranspose())).$times((Object)b, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()));
    }

    public double computeObjectiveValue(DenseMatrix<Object> ata, DenseVector<Object> atb, DenseVector<Object> x) {
        return BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)((ImmutableNumericOps)x.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms()))).$times(ata, DenseMatrix$.MODULE$.implOpMulMatrix_DVTt_DMT_eq_DMT((UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()))).$times(x, Transpose$.MODULE$.transTimesNormalFromDot(DenseVector$.MODULE$.canDotD()))) / 2.0 - BoxesRunTime.unboxToDouble((Object)atb.dot(x, DenseVector$.MODULE$.canDotD()));
    }

    public NNLSSuite() {
        this.test("NNLS: exact solution cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NNLSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 20;
                Random rand = new Random(12346);
                NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
                IntRef numSolved = new IntRef(0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, n, rand, ws, numSolved){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final int n$1;
                    private final Random rand$2;
                    private final NNLS.Workspace ws$1;
                    private final IntRef numSolved$1;

                    public final void apply(int k) {
                        this.apply$mcVI$sp(k);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void apply$mcVI$sp(int k) {
                        Tuple2 tuple2;
                        Tuple2<DenseMatrix<Object>, DenseVector<Object>> tuple22 = this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().genOnesData(this.n$1, this.rand$2);
                        if (tuple22 == null) throw new MatchError(tuple22);
                        DenseMatrix ata = (DenseMatrix)tuple22._1();
                        DenseVector atb = (DenseVector)tuple22._2();
                        Tuple2 tuple23 = tuple2 = new Tuple2((Object)ata, (Object)atb);
                        DenseMatrix ata2 = (DenseMatrix)tuple23._1();
                        DenseVector atb2 = (DenseVector)tuple23._2();
                        DenseVector.mcD.sp x = new DenseVector.mcD.sp(NNLS$.MODULE$.solve(ata2.data$mcD$sp(), atb2.data$mcD$sp(), this.ws$1));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)x.length()));
                        int $org_scalatest_assert_macro_right = this.n$1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        DenseVector.mcD.sp answer = new DenseVector.mcD.sp((double[])Array$.MODULE$.fill(this.n$1, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 1.0;
                            }
                        }, ClassTag$.MODULE$.Double()));
                        if (!(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(x.$minus((Object)answer, DenseVector$.MODULE$.canSubD()), DenseVector$.MODULE$.canNorm((Field)Field.fieldDouble$.MODULE$))) < 0.01)) return;
                        Serializable serializable = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x$2) {
                                return this.apply$mcDD$sp(x$2);
                            }

                            public double apply$mcDD$sp(double x$2) {
                                return BoxesRunTime.unboxToDouble((Object)new RichDouble(Predef$.MODULE$.doubleWrapper(x$2)).abs());
                            }
                        };
                        if (!(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(((DenseVector)x.$minus((Object)answer, DenseVector$.MODULE$.canSubD())).toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)serializable, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$)) < 0.001)) return;
                        boolean bl = true;
                        boolean solved = bl;
                        if (!solved) return;
                        ++this.numSolved$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.n$1 = n$1;
                        this.rand$2 = rand$2;
                        this.ws$1 = ws$1;
                        this.numSolved$1 = numSolved$1;
                    }
                });
                int $org_scalatest_assert_macro_left = numSolved.elem;
                int $org_scalatest_assert_macro_right = 50;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ NNLSSuite org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("NNLS: nonnegativity constraint active", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NNLSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 5;
                double[] ata = new double[]{4.377, -3.531, -1.306, -0.139, 3.418, -3.531, 4.344, 0.934, 0.305, -2.14, -1.306, 0.934, 2.644, -0.203, -0.17, -0.139, 0.305, -0.203, 5.883, 1.428, 3.418, -2.14, -0.17, 1.428, 4.684};
                double[] atb = new double[]{-1.632, 2.115, 1.094, -1.025, -0.636};
                double[] goodx = new double[]{0.13025, 0.54506, 0.2874, 0.0, 0.028628};
                NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
                double[] x = NNLS$.MODULE$.solve(ata, atb, ws);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)new Serializable(this, goodx, x){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final double[] goodx$1;
                    private final double[] x$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.x$3[i]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.goodx$1[i]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x.apply(i)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(goodx.apply(i)).absTol(0.001))");
                        this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        double $org_scalatest_assert_macro_left = this.x$3[i];
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (double)$org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.goodx$1 = goodx$1;
                        this.x$3 = x$3;
                    }
                });
            }

            public /* synthetic */ NNLSSuite org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("NNLS: objective value test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NNLSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double obj;
                int n = 5;
                DenseMatrix.mcD.sp ata = new DenseMatrix.mcD.sp(5, 5, new double[]{517399.13534, 242529.67289, -153644.98976, 130802.84503, -798452.29283, 242529.67289, 126017.69765, -75944.21743, 81785.36128, -405290.60884, -153644.98976, -75944.21743, 46986.44577, -45401.12659, 247059.51049, 130802.84503, 81785.36128, -45401.12659, 67457.3131, -253747.03819, -798452.29283, -405290.60884, 247059.51049, -253747.03819, 1310939.40814});
                DenseVector.mcD.sp atb = new DenseVector.mcD.sp(new double[]{-31755.0571, 13047.14813, -20191.24443, 25993.7758, 11963.55017});
                DenseVector.mcD.sp refx = new DenseVector.mcD.sp(new double[]{34.90751, 103.96254, 0.0, 27.82094, 58.79627});
                double refObj = this.$outer.computeObjectiveValue((DenseMatrix<Object>)ata, (DenseVector<Object>)atb, (DenseVector<Object>)refx);
                NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
                DenseVector.mcD.sp x = new DenseVector.mcD.sp(NNLS$.MODULE$.solve(ata.data$mcD$sp(), atb.data$mcD$sp(), ws));
                double $org_scalatest_assert_macro_left = obj = this.$outer.computeObjectiveValue((DenseMatrix<Object>)ata, (DenseVector<Object>)atb, (DenseVector<Object>)x);
                double $org_scalatest_assert_macro_right = refObj + 1.0E-5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

