/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.pmml.export;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport;
import org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport;
import org.apache.spark.mllib.pmml.export.KMeansPMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExportFactory$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e1A!\u0001\u0002\u0001\u001f\tY\u0002+T'M\u001b>$W\r\\#ya>\u0014HOR1di>\u0014\u0018pU;ji\u0016T!a\u0001\u0003\u0002\r\u0015D\bo\u001c:u\u0015\t)a!\u0001\u0003q[6d'BA\u0004\t\u0003\u0015iG\u000e\\5c\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001")
public class PMMLModelExportFactorySuite
extends SparkFunSuite {
    public PMMLModelExportFactorySuite() {
        this.test("PMMLModelExportFactory create KMeansPMMLModelExport when passing a KMeansModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PMMLModelExportFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PMMLModelExport modelExport;
                Vector[] clusterCenters = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0}))});
                KMeansModel kmeansModel = new KMeansModel(clusterCenters);
                PMMLModelExport $org_scalatest_assert_macro_left = modelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)kmeansModel);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.mllib.pmml.export.KMeansPMMLModelExport", $org_scalatest_assert_macro_left instanceof KMeansPMMLModelExport);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PMMLModelExportFactory create GeneralizedLinearPMMLModelExport when passing a LinearRegressionModel, RidgeRegressionModel or LassoModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PMMLModelExportFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PMMLModelExport lassoModelExport;
                PMMLModelExport ridgeModelExport;
                PMMLModelExport linearModelExport;
                Seq linearInput = LinearDataGenerator$.MODULE$.generateLinearInput(3.0, new double[]{10.0, 10.0}, 1, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                LinearRegressionModel linearRegressionModel = new LinearRegressionModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
                PMMLModelExport $org_scalatest_assert_macro_left = linearModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)linearRegressionModel);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport", $org_scalatest_assert_macro_left instanceof GeneralizedLinearPMMLModelExport);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RidgeRegressionModel ridgeRegressionModel = new RidgeRegressionModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
                PMMLModelExport $org_scalatest_assert_macro_left2 = ridgeModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)ridgeRegressionModel);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport", $org_scalatest_assert_macro_left2 instanceof GeneralizedLinearPMMLModelExport);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                LassoModel lassoModel = new LassoModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
                PMMLModelExport $org_scalatest_assert_macro_left3 = lassoModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)lassoModel);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport", $org_scalatest_assert_macro_left3 instanceof GeneralizedLinearPMMLModelExport);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PMMLModelExportFactory create BinaryClassificationPMMLModelExport when passing a LogisticRegressionModel or SVMModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PMMLModelExportFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PMMLModelExport svmModelExport;
                PMMLModelExport logisticRegressionModelExport;
                Seq linearInput = LinearDataGenerator$.MODULE$.generateLinearInput(3.0, new double[]{10.0, 10.0}, 1, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                LogisticRegressionModel logisticRegressionModel = new LogisticRegressionModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
                PMMLModelExport $org_scalatest_assert_macro_left = logisticRegressionModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)logisticRegressionModel);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport", $org_scalatest_assert_macro_left instanceof BinaryClassificationPMMLModelExport);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SVMModel svmModel = new SVMModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
                PMMLModelExport $org_scalatest_assert_macro_left2 = svmModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)svmModel);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport", $org_scalatest_assert_macro_left2 instanceof BinaryClassificationPMMLModelExport);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PMMLModelExportFactory throw IllegalArgumentException when passing a Multinomial Logistic Regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PMMLModelExportFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegressionModel multiclassLogisticRegressionModel = new LogisticRegressionModel(Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.3, 0.4})), 1.0, 2, 3);
                this.$outer.intercept((Function0)new Serializable(this, multiclassLogisticRegressionModel){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegressionModel multiclassLogisticRegressionModel$1;

                    public final PMMLModelExport apply() {
                        return PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)this.multiclassLogisticRegressionModel$1);
                    }
                    {
                        this.multiclassLogisticRegressionModel$1 = multiclassLogisticRegressionModel$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PMMLModelExportFactory throw IllegalArgumentException when passing an unsupported model", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PMMLModelExportFactorySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object invalidModel = new Object();
                this.$outer.intercept((Function0)new Serializable(this, invalidModel){
                    public static final long serialVersionUID = 0L;
                    private final Object invalidModel$1;

                    public final PMMLModelExport apply() {
                        return PMMLModelExportFactory$.MODULE$.createPMMLModelExport(this.invalidModel$1);
                    }
                    {
                        this.invalidModel$1 = invalidModel$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

