/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.random;

import org.apache.commons.math3.special.Gamma;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.random.ExponentialGenerator;
import org.apache.spark.mllib.random.GammaGenerator;
import org.apache.spark.mllib.random.LogNormalGenerator;
import org.apache.spark.mllib.random.PoissonGenerator;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.RandomDataGeneratorSuite$;
import org.apache.spark.mllib.random.StandardNormalGenerator;
import org.apache.spark.mllib.random.UniformGenerator;
import org.apache.spark.mllib.random.WeibullGenerator;
import org.apache.spark.util.StatCounter;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u001b\tA\"+\u00198e_6$\u0015\r^1HK:,'/\u0019;peN+\u0018\u000e^3\u000b\u0005\r!\u0011A\u0002:b]\u0012|WN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t!G\u0001\nCBL7\t[3dWN$\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006C]\u0001\rAI\u0001\u0004O\u0016t\u0007c\u0001\f$K%\u0011AE\u0001\u0002\u0014%\u0006tGm\\7ECR\fw)\u001a8fe\u0006$xN\u001d\t\u00037\u0019J!a\n\u000f\u0003\r\u0011{WO\u00197f\u0011\u0015I\u0003\u0001\"\u0001+\u0003I!\u0017n\u001d;sS\n,H/[8o\u0007\",7m[:\u0015\u000biYCF\f\u0019\t\u000b\u0005B\u0003\u0019\u0001\u0012\t\u000f5B\u0003\u0013!a\u0001K\u0005!Q.Z1o\u0011\u001dy\u0003\u0006%AA\u0002\u0015\naa\u001d;eI\u00164\bbB\u0019)!\u0003\u0005\r!J\u0001\bKB\u001c\u0018\u000e\\8o\u0011\u001d\u0019\u0004!%A\u0005\u0002Q\nA\u0004Z5tiJL'-\u001e;j_:\u001c\u0005.Z2lg\u0012\"WMZ1vYR$#'F\u00016U\t)cgK\u00018!\tAT(D\u0001:\u0015\tQ4(A\u0005v]\u000eDWmY6fI*\u0011A\bH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001 :\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b\u0001\u0002\t\n\u0011\"\u00015\u0003q!\u0017n\u001d;sS\n,H/[8o\u0007\",7m[:%I\u00164\u0017-\u001e7uIMBqA\u0011\u0001\u0012\u0002\u0013\u0005A'\u0001\u000feSN$(/\u001b2vi&|gn\u00115fG.\u001cH\u0005Z3gCVdG\u000f\n\u001b")
public class RandomDataGeneratorSuite
extends SparkFunSuite {
    public void apiChecks(RandomDataGenerator<Object> gen) {
        gen.setSeed(42L);
        IndexedSeq array1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, gen){
            public static final long serialVersionUID = 0L;
            private final RandomDataGenerator gen$1;

            public final double apply(int x$1) {
                return this.apply$mcDI$sp(x$1);
            }

            public double apply$mcDI$sp(int x$1) {
                return BoxesRunTime.unboxToDouble((Object)this.gen$1.nextValue());
            }
            {
                this.gen$1 = gen$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        gen.setSeed(42L);
        IndexedSeq array2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, gen){
            public static final long serialVersionUID = 0L;
            private final RandomDataGenerator gen$1;

            public final double apply(int x$2) {
                return this.apply$mcDI$sp(x$2);
            }

            public double apply$mcDI$sp(int x$2) {
                return BoxesRunTime.unboxToDouble((Object)this.gen$1.nextValue());
            }
            {
                this.gen$1 = gen$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(array1.equals((Object)array2), "array1.equals(array2)");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        RandomDataGenerator gen2 = gen.copy();
        gen.setSeed(0L);
        IndexedSeq array3 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, gen){
            public static final long serialVersionUID = 0L;
            private final RandomDataGenerator gen$1;

            public final double apply(int x$3) {
                return this.apply$mcDI$sp(x$3);
            }

            public double apply$mcDI$sp(int x$3) {
                return BoxesRunTime.unboxToDouble((Object)this.gen$1.nextValue());
            }
            {
                this.gen$1 = gen$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        gen2.setSeed(1L);
        IndexedSeq array4 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, gen2){
            public static final long serialVersionUID = 0L;
            private final RandomDataGenerator gen2$1;

            public final double apply(int x$4) {
                return this.apply$mcDI$sp(x$4);
            }

            public double apply$mcDI$sp(int x$4) {
                return BoxesRunTime.unboxToDouble((Object)this.gen2$1.nextValue());
            }
            {
                this.gen2$1 = gen2$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(array3.equals((Object)array4), "array3.equals(array4)"));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        gen.setSeed(0L);
        IndexedSeq array5 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, gen){
            public static final long serialVersionUID = 0L;
            private final RandomDataGenerator gen$1;

            public final double apply(int x$5) {
                return this.apply$mcDI$sp(x$5);
            }

            public double apply$mcDI$sp(int x$5) {
                return BoxesRunTime.unboxToDouble((Object)this.gen$1.nextValue());
            }
            {
                this.gen$1 = gen$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        gen2.setSeed(0L);
        IndexedSeq array6 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, gen2){
            public static final long serialVersionUID = 0L;
            private final RandomDataGenerator gen2$1;

            public final double apply(int x$6) {
                return this.apply$mcDI$sp(x$6);
            }

            public double apply$mcDI$sp(int x$6) {
                return BoxesRunTime.unboxToDouble((Object)this.gen2$1.nextValue());
            }
            {
                this.gen2$1 = gen2$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(array5.equals((Object)array6), "array5.equals(array6)");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
    }

    public void distributionChecks(RandomDataGenerator<Object> gen, double mean, double stddev, double epsilon) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, gen, mean, stddev, epsilon){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomDataGeneratorSuite $outer;
            public final RandomDataGenerator gen$2;
            private final double mean$1;
            private final double stddev$1;
            private final double epsilon$1;

            public final void apply(int seed) {
                this.apply$mcVI$sp(seed);
            }

            public void apply$mcVI$sp(int seed) {
                this.gen$2.setSeed((long)seed);
                IndexedSeq sample = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$distributionChecks$1 $outer;

                    public final double apply(int x$7) {
                        return this.apply$mcDI$sp(x$7);
                    }

                    public double apply$mcDI$sp(int x$7) {
                        return BoxesRunTime.unboxToDouble((Object)this.$outer.gen$2.nextValue());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                StatCounter stats = new StatCounter((TraversableOnce)sample);
                double $org_scalatest_assert_macro_left = package$.MODULE$.abs(stats.mean() - this.mean$1);
                double $org_scalatest_assert_macro_right = this.epsilon$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left2 = package$.MODULE$.abs(stats.stdev() - this.stddev$1);
                double $org_scalatest_assert_macro_right2 = this.epsilon$1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.gen$2 = gen$2;
                this.mean$1 = mean$1;
                this.stddev$1 = stddev$1;
                this.epsilon$1 = epsilon$1;
            }
        });
    }

    public double distributionChecks$default$2() {
        return 0.0;
    }

    public double distributionChecks$default$3() {
        return 1.0;
    }

    public double distributionChecks$default$4() {
        return 0.01;
    }

    public RandomDataGeneratorSuite() {
        this.test("UniformGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomDataGeneratorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                UniformGenerator uniform = new UniformGenerator();
                this.$outer.apiChecks((RandomDataGenerator<Object>)uniform);
                this.$outer.distributionChecks((RandomDataGenerator<Object>)uniform, 0.5, 1.0 / package$.MODULE$.sqrt(12.0), this.$outer.distributionChecks$default$4());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("StandardNormalGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomDataGeneratorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StandardNormalGenerator normal = new StandardNormalGenerator();
                this.$outer.apiChecks((RandomDataGenerator<Object>)normal);
                this.$outer.distributionChecks((RandomDataGenerator<Object>)normal, 0.0, 1.0, this.$outer.distributionChecks$default$4());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("LogNormalGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomDataGeneratorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0), new Tuple2.mcDD.sp(0.0, 2.0), new Tuple2.mcDD.sp(2.0, 1.0), new Tuple2.mcDD.sp(2.0, 2.0)})).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            double mean = tuple2._1$mcD$sp();
                            double vari = tuple2._2$mcD$sp();
                            double d = mean;
                            double d2 = vari;
                            LogNormalGenerator normal = new LogNormalGenerator(d, package$.MODULE$.sqrt(d2));
                            this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().apiChecks((RandomDataGenerator<Object>)normal);
                            double expectedMean = package$.MODULE$.exp(d + 0.5 * d2);
                            double expectedStd = package$.MODULE$.sqrt((package$.MODULE$.exp(d2) - 1.0) * package$.MODULE$.exp(2.0 * d + d2));
                            double epsilon = 0.05 * expectedStd * expectedStd;
                            this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().distributionChecks((RandomDataGenerator<Object>)normal, expectedMean, expectedStd, epsilon);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ RandomDataGeneratorSuite org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("PoissonGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomDataGeneratorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 5.0, 100.0})).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final void apply(double mean) {
                        this.apply$mcVD$sp(mean);
                    }

                    public void apply$mcVD$sp(double mean) {
                        PoissonGenerator poisson = new PoissonGenerator(mean);
                        this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().apiChecks((RandomDataGenerator<Object>)poisson);
                        this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().distributionChecks((RandomDataGenerator<Object>)poisson, mean, package$.MODULE$.sqrt(mean), 0.1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RandomDataGeneratorSuite org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ExponentialGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomDataGeneratorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 5.0, 10.0, 50.0, 100.0})).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final void apply(double mean) {
                        this.apply$mcVD$sp(mean);
                    }

                    public void apply$mcVD$sp(double mean) {
                        ExponentialGenerator exponential = new ExponentialGenerator(mean);
                        this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().apiChecks((RandomDataGenerator<Object>)exponential);
                        double epsilon = 0.05 * mean * mean;
                        this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().distributionChecks((RandomDataGenerator<Object>)exponential, mean, mean, epsilon);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RandomDataGeneratorSuite org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("GammaGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomDataGeneratorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 2.0), new Tuple2.mcDD.sp(2.0, 2.0), new Tuple2.mcDD.sp(3.0, 2.0), new Tuple2.mcDD.sp(5.0, 1.0), new Tuple2.mcDD.sp(9.0, 0.5)})).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final void apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            double shape = tuple2._1$mcD$sp();
                            double scale = tuple2._2$mcD$sp();
                            double d = shape;
                            double d2 = scale;
                            GammaGenerator gamma = new GammaGenerator(d, d2);
                            this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().apiChecks((RandomDataGenerator<Object>)gamma);
                            double expectedMean = d * d2;
                            double expectedStd = package$.MODULE$.sqrt(d * d2 * d2);
                            this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().distributionChecks((RandomDataGenerator<Object>)gamma, expectedMean, expectedStd, 0.1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ RandomDataGeneratorSuite org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("WeibullGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomDataGeneratorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 2.0), new Tuple2.mcDD.sp(2.0, 3.0), new Tuple2.mcDD.sp(2.5, 3.5), new Tuple2.mcDD.sp(10.4, 2.222)})).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$14 $outer;

                    public final void apply(Tuple2<Object, Object> x0$3) {
                        Tuple2<Object, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            double alpha = tuple2._1$mcD$sp();
                            double beta = tuple2._2$mcD$sp();
                            double d = alpha;
                            double d2 = beta;
                            WeibullGenerator weibull = new WeibullGenerator(d, d2);
                            this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().apiChecks((RandomDataGenerator<Object>)weibull);
                            double expectedMean = package$.MODULE$.exp(Gamma.logGamma((double)(1.0 + 1.0 / d))) * d2;
                            double expectedVariance = package$.MODULE$.exp(Gamma.logGamma((double)(1.0 + (double)2 / d))) * d2 * d2 - expectedMean * expectedMean;
                            double expectedStd = package$.MODULE$.sqrt(expectedVariance);
                            this.$outer.org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer().distributionChecks((RandomDataGenerator<Object>)weibull, expectedMean, expectedStd, 0.1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ RandomDataGeneratorSuite org$apache$spark$mllib$random$RandomDataGeneratorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

