/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.ALSSuite$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005%t!B\u0001\u0003\u0011\u0003i\u0011\u0001C!M'N+\u0018\u000e^3\u000b\u0005\r!\u0011A\u0004:fG>lW.\u001a8eCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005!\tEjU*vSR,7cA\b\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"aE\r\n\u0005i!\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u000f\u0010\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u0015yr\u0002\"\u0001!\u0003U9WM\\3sCR,'+\u0019;j]\u001e\u001c\u0018i\u001d&bm\u0006$r!I\u001b;yy\u0002U\tE\u0003\u0014E\u0011zs&\u0003\u0002$)\t1A+\u001e9mKN\u00022!\n\u0016-\u001b\u00051#BA\u0014)\u0003\u0011)H/\u001b7\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002\u000f[%\u0011aF\u0001\u0002\u0007%\u0006$\u0018N\\4\u0011\u0007M\u0001$'\u0003\u00022)\t)\u0011I\u001d:bsB\u00111cM\u0005\u0003iQ\u0011a\u0001R8vE2,\u0007\"\u0002\u001c\u001f\u0001\u00049\u0014!B;tKJ\u001c\bCA\n9\u0013\tIDCA\u0002J]RDQa\u000f\u0010A\u0002]\n\u0001\u0002\u001d:pIV\u001cGo\u001d\u0005\u0006{y\u0001\raN\u0001\tM\u0016\fG/\u001e:fg\")qH\ba\u0001e\u0005a1/Y7qY&twMU1uK\")\u0011I\ba\u0001\u0005\u0006i\u0011.\u001c9mS\u000eLG\u000f\u0015:fMN\u0004\"aE\"\n\u0005\u0011#\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\rz\u0001\rAQ\u0001\u0010]\u0016<\u0017\r^5wK^+\u0017n\u001a5ug\")\u0001j\u0004C\u0001\u0013\u0006yq-\u001a8fe\u0006$XMU1uS:<7\u000f\u0006\u0005K?\u0002\f'm\u00193f!\u0015\u0019\"eS,X!\raE\u000b\f\b\u0003\u001bJs!AT)\u000e\u0003=S!\u0001\u0015\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012BA*\u0015\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\u0007M+\u0017O\u0003\u0002T)A\u0019\u0001,\u0018\u001a\u000e\u0003eS!AW.\u0002\r1Lg.\u00197h\u0015\u0005a\u0016A\u00022sK\u0016TX-\u0003\u0002_3\nYA)\u001a8tK6\u000bGO]5y\u0011\u00151t\t1\u00018\u0011\u0015Yt\t1\u00018\u0011\u0015it\t1\u00018\u0011\u0015yt\t1\u00013\u0011\u001d\tu\t%AA\u0002\tCqAR$\u0011\u0002\u0003\u0007!\tC\u0004g\u000fB\u0005\t\u0019\u0001\"\u0002\u001f9,w-\u0019;jm\u00164\u0015m\u0019;peNDq\u0001[\b\u0012\u0002\u0013\u0005\u0011.A\rhK:,'/\u0019;f%\u0006$\u0018N\\4tI\u0011,g-Y;mi\u0012*T#\u00016+\u0005\t[7&\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018!C;oG\",7m[3e\u0015\t\tH#\u0001\u0006b]:|G/\u0019;j_:L!a\u001d8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004v\u001fE\u0005I\u0011A5\u00023\u001d,g.\u001a:bi\u0016\u0014\u0016\r^5oON$C-\u001a4bk2$HE\u000e\u0005\bo>\t\n\u0011\"\u0001j\u0003e9WM\\3sCR,'+\u0019;j]\u001e\u001cH\u0005Z3gCVdG\u000fJ\u001c\t\u000fe|\u0011\u0011!C\u0005u\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@)\u0003\u0011a\u0017M\\4\n\u0007\u0005\u0005QP\u0001\u0004PE*,7\r\u001e\u0004\u0006!\t\u0001\u0011QA\n\u0007\u0003\u0007\t9!a\u0004\u0011\t\u0005%\u00111B\u0007\u0002\r%\u0019\u0011Q\u0002\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\u0011\t\t\"!\u0006\u000e\u0005\u0005M!BA\u0014\u0005\u0013\u0011\t9\"a\u0005\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\"9A$a\u0001\u0005\u0002\u0005mACAA\u000f!\rq\u00111\u0001\u0005\t\u0003C\t\u0019\u0001\"\u0001\u0002$\u00059A/Z:u\u00032\u001bFCGA\u0013\u0003W\ti#a\f\u00022\u0005U\u0012qGA\u001e\u0003{\t\t%a\u0011\u0002H\u0005-\u0003cA\n\u0002(%\u0019\u0011\u0011\u0006\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0007m\u0005}\u0001\u0019A\u001c\t\rm\ny\u00021\u00018\u0011\u0019i\u0014q\u0004a\u0001o!9\u00111GA\u0010\u0001\u00049\u0014AC5uKJ\fG/[8og\"1q(a\bA\u0002IBq!!\u000f\u0002 \u0001\u0007!'\u0001\bnCR\u001c\u0007\u000e\u00165sKNDw\u000e\u001c3\t\u0011\u0005\u000by\u0002%AA\u0002\tC\u0011\"a\u0010\u0002 A\u0005\t\u0019\u0001\"\u0002\u0017\t,Hn\u001b)sK\u0012L7\r\u001e\u0005\t\r\u0006}\u0001\u0013!a\u0001\u0005\"I\u0011QIA\u0010!\u0003\u0005\raN\u0001\u000e]VlWk]3s\u00052|7m[:\t\u0013\u0005%\u0013q\u0004I\u0001\u0002\u00049\u0014\u0001\u00058v[B\u0013x\u000eZ;di\ncwnY6t\u0011!1\u0017q\u0004I\u0001\u0002\u0004\u0011\u0005\"CA(\u0003\u0007\t\n\u0011\"\u0001j\u0003E!Xm\u001d;B\u0019N#C-\u001a4bk2$He\u000e\u0005\n\u0003'\n\u0019!%A\u0005\u0002%\f\u0011\u0003^3ti\u0006c5\u000b\n3fM\u0006,H\u000e\u001e\u00139\u0011%\t9&a\u0001\u0012\u0002\u0013\u0005\u0011.A\tuKN$\u0018\tT*%I\u00164\u0017-\u001e7uIeB!\"a\u0017\u0002\u0004E\u0005I\u0011AA/\u0003I!Xm\u001d;B\u0019N#C-\u001a4bk2$H%\r\u0019\u0016\u0005\u0005}#FA\u001cl\u0011)\t\u0019'a\u0001\u0012\u0002\u0013\u0005\u0011QL\u0001\u0013i\u0016\u001cH/\u0011'TI\u0011,g-Y;mi\u0012\n\u0014\u0007C\u0005\u0002h\u0005\r\u0011\u0013!C\u0001S\u0006\u0011B/Z:u\u00032\u001bF\u0005Z3gCVdG\u000fJ\u00193\u0001")
public class ALSSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static boolean generateRatings$default$7() {
        return ALSSuite$.MODULE$.generateRatings$default$7();
    }

    public static boolean generateRatings$default$6() {
        return ALSSuite$.MODULE$.generateRatings$default$6();
    }

    public static boolean generateRatings$default$5() {
        return ALSSuite$.MODULE$.generateRatings$default$5();
    }

    public static Tuple3<Seq<Rating>, DenseMatrix<Object>, DenseMatrix<Object>> generateRatings(int n, int n2, int n3, double d, boolean bl, boolean bl2, boolean bl3) {
        return ALSSuite$.MODULE$.generateRatings(n, n2, n3, d, bl, bl2, bl3);
    }

    public static Tuple3<java.util.List<Rating>, double[], double[]> generateRatingsAsJava(int n, int n2, int n3, double d, boolean bl, boolean bl2) {
        return ALSSuite$.MODULE$.generateRatingsAsJava(n, n2, n3, d, bl, bl2);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public void testALS(int users, int products, int features, int iterations, double samplingRate, double matchThreshold, boolean implicitPrefs, boolean bulkPredict, boolean negativeWeights, int numUserBlocks, int numProductBlocks, boolean negativeFactors) {
        Tuple3<Seq<Rating>, DenseMatrix<Object>, DenseMatrix<Object>> tuple3 = ALSSuite$.MODULE$.generateRatings(users, products, features, samplingRate, implicitPrefs, negativeWeights, negativeFactors);
        if (tuple3 != null) {
            DenseMatrix predictedRatings;
            DenseMatrix denseMatrix;
            Tuple3 tuple32;
            Seq sampledRatings = (Seq)tuple3._1();
            DenseMatrix trueRatings = (DenseMatrix)tuple3._2();
            DenseMatrix truePrefs = (DenseMatrix)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)sampledRatings, (Object)trueRatings, (Object)truePrefs);
            Seq sampledRatings2 = (Seq)tuple33._1();
            DenseMatrix trueRatings2 = (DenseMatrix)tuple33._2();
            DenseMatrix truePrefs2 = (DenseMatrix)tuple33._3();
            SparkContext qual$3 = this.sc();
            Seq x$25 = sampledRatings2;
            int x$26 = qual$3.parallelize$default$2();
            MatrixFactorizationModel model = new ALS().setUserBlocks(numUserBlocks).setProductBlocks(numProductBlocks).setRank(features).setIterations(iterations).setAlpha(1.0).setImplicitPrefs(implicitPrefs).setLambda(0.01).setSeed(0L).setNonnegative(!negativeFactors).run(qual$3.parallelize(x$25, x$26, ClassTag$.MODULE$.apply(Rating.class)));
            DenseMatrix.mcD.sp predictedU = new DenseMatrix.mcD.sp(users, features, ClassTag$.MODULE$.Double());
            Predef$.MODULE$.refArrayOps((Object[])model.userFeatures().collect()).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, double[]> check$ifrefutable$1) {
                    Tuple2<Object, double[]> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, features, (DenseMatrix)predictedU){
                public static final long serialVersionUID = 0L;
                private final int features$1;
                public final DenseMatrix predictedU$1;

                public final void apply(Tuple2<Object, double[]> x$7) {
                    Tuple2<Object, double[]> tuple2 = x$7;
                    if (tuple2 != null) {
                        int u = tuple2._1$mcI$sp();
                        double[] vec = (double[])tuple2._2();
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.features$1).foreach$mVc$sp((Function1)new Serializable(this, u, vec){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testALS$4 $outer;
                            private final int u$2;
                            private final double[] vec$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.$outer.predictedU$1.update$mcD$sp(this.u$2, i, this.vec$1[i]);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.u$2 = u$2;
                                this.vec$1 = vec$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.features$1 = features$1;
                    this.predictedU$1 = predictedU$1;
                }
            });
            DenseMatrix.mcD.sp predictedP = new DenseMatrix.mcD.sp(products, features, ClassTag$.MODULE$.Double());
            Predef$.MODULE$.refArrayOps((Object[])model.productFeatures().collect()).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, double[]> check$ifrefutable$2) {
                    Tuple2<Object, double[]> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, features, (DenseMatrix)predictedP){
                public static final long serialVersionUID = 0L;
                private final int features$1;
                public final DenseMatrix predictedP$1;

                public final void apply(Tuple2<Object, double[]> x$8) {
                    Tuple2<Object, double[]> tuple2 = x$8;
                    if (tuple2 != null) {
                        int p = tuple2._1$mcI$sp();
                        double[] vec = (double[])tuple2._2();
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.features$1).foreach$mVc$sp((Function1)new Serializable(this, p, vec){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testALS$6 $outer;
                            private final int p$1;
                            private final double[] vec$2;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.$outer.predictedP$1.update$mcD$sp(this.p$1, i, this.vec$2[i]);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.p$1 = p$1;
                                this.vec$2 = vec$2;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.features$1 = features$1;
                    this.predictedP$1 = predictedP$1;
                }
            });
            if (bulkPredict) {
                DenseMatrix.mcD.sp allRatings = new DenseMatrix.mcD.sp(users, products, ClassTag$.MODULE$.Double());
                IndexedSeq usersProducts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).flatMap((Function1)new Serializable(this, products){
                    public static final long serialVersionUID = 0L;
                    private final int products$2;

                    public final IndexedSeq<Tuple2<Object, Object>> apply(int u) {
                        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.products$2).map((Function1)new Serializable(this, u){
                            public static final long serialVersionUID = 0L;
                            private final int u$3;

                            public final Tuple2<Object, Object> apply(int p) {
                                return new Tuple2.mcII.sp(this.u$3, p);
                            }
                            {
                                this.u$3 = u$3;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                    }
                    {
                        this.products$2 = products$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                SparkContext qual$4 = this.sc();
                IndexedSeq x$27 = usersProducts;
                int x$28 = qual$4.parallelize$default$2();
                RDD userProductsRDD = qual$4.parallelize((Seq)x$27, x$28, ClassTag$.MODULE$.apply(Tuple2.class));
                Predef$.MODULE$.refArrayOps((Object[])model.predict(userProductsRDD).collect()).foreach((Function1)new Serializable(this, (DenseMatrix)allRatings){
                    public static final long serialVersionUID = 0L;
                    private final DenseMatrix allRatings$1;

                    public final void apply(Rating elem) {
                        this.allRatings$1.update$mcD$sp(elem.user(), elem.product(), elem.rating());
                    }
                    {
                        this.allRatings$1 = allRatings$1;
                    }
                });
                denseMatrix = allRatings;
            } else {
                denseMatrix = predictedRatings = (DenseMatrix)predictedU.$times(predictedP.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD());
            }
            if (implicitPrefs) {
                DoubleRef sqErr = new DoubleRef(0.0);
                DoubleRef denom = new DoubleRef(0.0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).foreach$mVc$sp((Function1)new Serializable(this, products, trueRatings2, truePrefs2, predictedRatings, sqErr, denom){
                    public static final long serialVersionUID = 0L;
                    private final int products$2;
                    public final DenseMatrix trueRatings$2;
                    public final DenseMatrix truePrefs$1;
                    public final DenseMatrix predictedRatings$1;
                    public final DoubleRef sqErr$1;
                    public final DoubleRef denom$1;

                    public final void apply(int u) {
                        this.apply$mcVI$sp(u);
                    }

                    public void apply$mcVI$sp(int u) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.products$2).foreach$mVc$sp((Function1)new Serializable(this, u){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testALS$2 $outer;
                            private final int u$5;

                            public final void apply(int p) {
                                this.apply$mcVI$sp(p);
                            }

                            public void apply$mcVI$sp(int p) {
                                double prediction = this.$outer.predictedRatings$1.apply$mcD$sp(this.u$5, p);
                                double truePref = this.$outer.truePrefs$1.apply$mcD$sp(this.u$5, p);
                                double confidence = 1.0 + package$.MODULE$.abs(this.$outer.trueRatings$2.apply$mcD$sp(this.u$5, p));
                                double err = confidence * (truePref - prediction) * (truePref - prediction);
                                this.$outer.sqErr$1.elem += err;
                                this.$outer.denom$1.elem += confidence;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.u$5 = u$5;
                            }
                        });
                    }
                    {
                        this.products$2 = products$2;
                        this.trueRatings$2 = trueRatings$2;
                        this.truePrefs$1 = truePrefs$1;
                        this.predictedRatings$1 = predictedRatings$1;
                        this.sqErr$1 = sqErr$1;
                        this.denom$1 = denom$1;
                    }
                });
                double rmse = package$.MODULE$.sqrt(sqErr.elem / denom.elem);
                if (rmse > matchThreshold) {
                    throw this.fail(new StringOps(Predef$.MODULE$.augmentString("Model failed to predict RMSE: %f\ncorr: %s\npred: %s\nU: %s\n P: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rmse), truePrefs2, predictedRatings, predictedU, predictedP})));
                }
            } else {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).foreach$mVc$sp((Function1)new Serializable(this, products, matchThreshold, trueRatings2, (DenseMatrix)predictedU, (DenseMatrix)predictedP, predictedRatings){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ALSSuite $outer;
                    private final int products$2;
                    public final double matchThreshold$1;
                    public final DenseMatrix trueRatings$2;
                    public final DenseMatrix predictedU$1;
                    public final DenseMatrix predictedP$1;
                    public final DenseMatrix predictedRatings$1;

                    public final void apply(int u) {
                        this.apply$mcVI$sp(u);
                    }

                    public void apply$mcVI$sp(int u) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.products$2).foreach$mVc$sp((Function1)new Serializable(this, u){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testALS$1 $outer;
                            private final int u$4;

                            public final void apply(int p) {
                                this.apply$mcVI$sp(p);
                            }

                            public void apply$mcVI$sp(int p) {
                                double correct;
                                double prediction = this.$outer.predictedRatings$1.apply$mcD$sp(this.u$4, p);
                                if (package$.MODULE$.abs(prediction - (correct = this.$outer.trueRatings$2.apply$mcD$sp(this.u$4, p))) > this.$outer.matchThreshold$1) {
                                    throw this.$outer.org$apache$spark$mllib$recommendation$ALSSuite$$anonfun$$$outer().fail(new StringOps(Predef$.MODULE$.augmentString("Model failed to predict (%d, %d): %f vs %f\ncorr: %s\npred: %s\nU: %s\n P: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.u$4), BoxesRunTime.boxToInteger((int)p), BoxesRunTime.boxToDouble((double)correct), BoxesRunTime.boxToDouble((double)prediction), this.$outer.trueRatings$2, this.$outer.predictedRatings$1, this.$outer.predictedU$1, this.$outer.predictedP$1})));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.u$4 = u$4;
                            }
                        });
                    }

                    public /* synthetic */ ALSSuite org$apache$spark$mllib$recommendation$ALSSuite$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.products$2 = products$2;
                        this.matchThreshold$1 = matchThreshold$1;
                        this.trueRatings$2 = trueRatings$2;
                        this.predictedU$1 = predictedU$1;
                        this.predictedP$1 = predictedP$1;
                        this.predictedRatings$1 = predictedRatings$1;
                    }
                });
            }
            return;
        }
        throw new MatchError(tuple3);
    }

    public boolean testALS$default$7() {
        return false;
    }

    public boolean testALS$default$8() {
        return false;
    }

    public boolean testALS$default$9() {
        return false;
    }

    public int testALS$default$10() {
        return -1;
    }

    public int testALS$default$11() {
        return -1;
    }

    public boolean testALS$default$12() {
        return true;
    }

    public ALSSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("rank-1 matrices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(50, 100, 1, 15, 0.7, 0.3, this.$outer.testALS$default$7(), this.$outer.testALS$default$8(), this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-1 matrices bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(50, 100, 1, 15, 0.7, 0.3, false, true, this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.3, this.$outer.testALS$default$7(), this.$outer.testALS$default$8(), this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.3, false, true, this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-1 matrices implicit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(80, 160, 1, 15, 0.7, 0.4, true, this.$outer.testALS$default$8(), this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-1 matrices implicit bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(80, 160, 1, 15, 0.7, 0.4, true, true, this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices implicit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.4, true, this.$outer.testALS$default$8(), this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices implicit bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.4, true, true, this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices implicit negative", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.4, true, false, true, this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices with different user and product blocks", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$9 = 100;
                int x$10 = 200;
                int x$11 = 2;
                int x$12 = 15;
                double x$13 = 0.7;
                double x$14 = 0.4;
                int x$15 = 4;
                int x$16 = 2;
                boolean x$17 = this.$outer.testALS$default$7();
                boolean x$18 = this.$outer.testALS$default$8();
                boolean x$19 = this.$outer.testALS$default$9();
                boolean x$20 = this.$outer.testALS$default$12();
                this.$outer.testALS(x$9, x$10, x$11, x$12, x$13, x$14, x$17, x$18, x$19, x$15, x$16, x$20);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("pseudorandomness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD ratings = this.$outer.sc().parallelize((Seq)ALSSuite$.MODULE$.generateRatings(10, 20, 5, 0.5, false, false, ALSSuite$.MODULE$.generateRatings$default$7())._1(), 2, ClassTag$.MODULE$.apply(Rating.class));
                MatrixFactorizationModel model11 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 1L);
                MatrixFactorizationModel model12 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 1L);
                List u11 = Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model11.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Object> apply(double[] x$3) {
                        return Predef$.MODULE$.doubleArrayOps(x$3).toList();
                    }
                }, ClassTag$.MODULE$.Double()).collect()).toList();
                List u12 = Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model12.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Object> apply(double[] x$4) {
                        return Predef$.MODULE$.doubleArrayOps(x$4).toList();
                    }
                }, ClassTag$.MODULE$.Double()).collect()).toList();
                MatrixFactorizationModel model2 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 2L);
                List u2 = Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model2.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Object> apply(double[] x$5) {
                        return Predef$.MODULE$.doubleArrayOps(x$5).toList();
                    }
                }, ClassTag$.MODULE$.Double()).collect()).toList();
                List $org_scalatest_assert_macro_left = u11;
                List $org_scalatest_assert_macro_right = u12;
                List list = $org_scalatest_assert_macro_left;
                List list2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(list != null ? !list.equals(list2) : list2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                List $org_scalatest_assert_macro_left2 = u11;
                List $org_scalatest_assert_macro_right2 = u2;
                List list3 = $org_scalatest_assert_macro_left2;
                List list4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, list3 != null ? !list3.equals(list4) : list4 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Storage Level for RDDs in model", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD ratings = this.$outer.sc().parallelize((Seq)ALSSuite$.MODULE$.generateRatings(10, 20, 5, 0.5, false, false, ALSSuite$.MODULE$.generateRatings$default$7())._1(), 2, ClassTag$.MODULE$.apply(Rating.class));
                StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_ONLY();
                MatrixFactorizationModel model = new ALS().setRank(5).setIterations(1).setLambda(1.0).setBlocks(2).setSeed(1L).setFinalRDDStorageLevel(storageLevel).run(ratings);
                StorageLevel $org_scalatest_assert_macro_left = model.productFeatures().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right = storageLevel;
                StorageLevel storageLevel2 = $org_scalatest_assert_macro_left;
                StorageLevel storageLevel3 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                StorageLevel $org_scalatest_assert_macro_left2 = model.userFeatures().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right2 = storageLevel;
                StorageLevel storageLevel4 = $org_scalatest_assert_macro_left2;
                StorageLevel storageLevel5 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(storageLevel4 != null ? !storageLevel4.equals(storageLevel5) : storageLevel5 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                storageLevel = StorageLevel$.MODULE$.DISK_ONLY();
                model = new ALS().setRank(5).setIterations(1).setLambda(1.0).setBlocks(2).setSeed(1L).setFinalRDDStorageLevel(storageLevel).run(ratings);
                StorageLevel $org_scalatest_assert_macro_left3 = model.productFeatures().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right3 = storageLevel;
                StorageLevel storageLevel6 = $org_scalatest_assert_macro_left3;
                StorageLevel storageLevel7 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(storageLevel6 != null ? !storageLevel6.equals(storageLevel7) : storageLevel7 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                StorageLevel $org_scalatest_assert_macro_left4 = model.userFeatures().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right4 = storageLevel;
                StorageLevel storageLevel8 = $org_scalatest_assert_macro_left4;
                StorageLevel storageLevel9 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(storageLevel8 != null ? !storageLevel8.equals(storageLevel9) : storageLevel9 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("negative ids", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple3<Seq<Rating>, DenseMatrix<Object>, DenseMatrix<Object>> data = ALSSuite$.MODULE$.generateRatings(50, 50, 2, 0.7, false, false, ALSSuite$.MODULE$.generateRatings$default$7());
                SparkContext qual$1 = this.$outer.sc();
                Seq x$21 = (Seq)((TraversableLike)data._1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Rating apply(Rating x0$1) {
                        Rating rating = x0$1;
                        if (rating != null) {
                            int u = rating.user();
                            int p = rating.product();
                            double r = rating.rating();
                            Rating rating2 = new Rating(u - 25, p - 25, r);
                            return rating2;
                        }
                        throw new MatchError((Object)rating);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                int x$22 = qual$1.parallelize$default$2();
                RDD ratings = qual$1.parallelize(x$21, x$22, ClassTag$.MODULE$.apply(Rating.class));
                DenseMatrix correct = (DenseMatrix)data._2();
                MatrixFactorizationModel model = ALS$.MODULE$.train(ratings, 5, 15);
                Tuple2[] pairs = (Tuple2[])Predef$.MODULE$.refArrayOps(Array$.MODULE$.tabulate(50, 50, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int u, int p) {
                        return new Tuple2.mcII.sp(u - 25, p - 25);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class))).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<Tuple2<Object, Object>> apply(Tuple2<Object, Object>[] xs) {
                        return Predef$.MODULE$.wrapRefArray((Object[])xs);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$23 = Predef$.MODULE$.wrapRefArray((Object[])pairs);
                int x$24 = qual$2.parallelize$default$2();
                Rating[] ans = (Rating[])model.predict(qual$2.parallelize((Seq)x$23, x$24, ClassTag$.MODULE$.apply(Tuple2.class))).collect();
                Predef$.MODULE$.refArrayOps((Object[])ans).foreach((Function1)new Serializable(this, correct){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    private final DenseMatrix correct$1;

                    public final void apply(Rating r) {
                        int u = r.user() + 25;
                        int p = r.product() + 25;
                        double v = r.rating();
                        double error = v - this.correct$1.apply$mcD$sp(u, p);
                        double $org_scalatest_assert_macro_left = package$.MODULE$.abs(error);
                        double $org_scalatest_assert_macro_right = 0.4;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.correct$1 = correct$1;
                    }
                });
            }

            public /* synthetic */ ALSSuite org$apache$spark$mllib$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("NNALS, rank 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.4, false, false, false, -1, -1, false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

