/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModelSuite$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u001b\tiR*\u0019;sSb4\u0015m\u0019;pe&T\u0018\r^5p]6{G-\u001a7Tk&$XM\u0003\u0002\u0004\t\u0005q!/Z2p[6,g\u000eZ1uS>t'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005kRLG.\u0003\u0002\u0018)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\tAA]1oWV\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0002J]RDaa\n\u0001!\u0002\u0013\u0001\u0013!\u0002:b].\u0004\u0003\"C\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0001+\u00031)8/\u001a:GK\u0006$XO]3t+\u0005Y\u0003c\u0001\u00170c5\tQF\u0003\u0002/\r\u0005\u0019!\u000f\u001a3\n\u0005Aj#a\u0001*E\tB!\u0011E\r\u00115\u0013\t\u0019$E\u0001\u0004UkBdWM\r\t\u0004CU:\u0014B\u0001\u001c#\u0005\u0015\t%O]1z!\t\t\u0003(\u0003\u0002:E\t1Ai\\;cY\u0016D\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001f\u0002!U\u001cXM\u001d$fCR,(/Z:`I\u0015\fHCA\u001fA!\t\tc(\u0003\u0002@E\t!QK\\5u\u0011\u001d\t%(!AA\u0002-\n1\u0001\u001f\u00132\u0011\u0019\u0019\u0005\u0001)Q\u0005W\u0005iQo]3s\r\u0016\fG/\u001e:fg\u0002B\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001\u0016\u0002\u0019A\u0014x\u000e\u001a$fCR,(/Z:\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003A\u0015\u0001\u00059s_\u00124U-\u0019;ve\u0016\u001cx\fJ3r)\ti\u0014\nC\u0004B\r\u0006\u0005\t\u0019A\u0016\t\r-\u0003\u0001\u0015)\u0003,\u00035\u0001(o\u001c3GK\u0006$XO]3tA!)Q\n\u0001C!\u001d\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002{\u0001")
public class MatrixFactorizationModelSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int rank;
    private RDD<Tuple2<Object, double[]>> userFeatures;
    private RDD<Tuple2<Object, double[]>> prodFeatures;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public void userFeatures_$eq(RDD<Tuple2<Object, double[]>> x$1) {
        this.userFeatures = x$1;
    }

    public RDD<Tuple2<Object, double[]>> prodFeatures() {
        return this.prodFeatures;
    }

    public void prodFeatures_$eq(RDD<Tuple2<Object, double[]>> x$1) {
        this.prodFeatures = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        Seq x$2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new double[]{1.0, 2.0}), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new double[]{3.0, 4.0})}));
        int x$3 = qual$1.parallelize$default$2();
        this.userFeatures_$eq((RDD<Tuple2<Object, double[]>>)qual$1.parallelize(x$2, x$3, ClassTag$.MODULE$.apply(Tuple2.class)));
        SparkContext qual$2 = this.sc();
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new double[]{5.0, 6.0})}));
        int x$5 = qual$2.parallelize$default$2();
        this.prodFeatures_$eq((RDD<Tuple2<Object, double[]>>)qual$2.parallelize(x$4, x$5, ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public MatrixFactorizationModelSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.rank = 2;
        this.test("constructor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModelSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatrixFactorizationModel model = new MatrixFactorizationModel(this.$outer.rank(), this.$outer.userFeatures(), this.$outer.prodFeatures());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.predict(0, 2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(17.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(0, 2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(17.0).relTol(1.0E-14))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final MatrixFactorizationModel apply() {
                        return new MatrixFactorizationModel(1, this.$outer.org$apache$spark$mllib$recommendation$MatrixFactorizationModelSuite$$anonfun$$$outer().userFeatures(), this.$outer.org$apache$spark$mllib$recommendation$MatrixFactorizationModelSuite$$anonfun$$$outer().prodFeatures());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                SparkContext qual$3 = this.$outer.sc();
                Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new double[]{1.0}), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new double[]{3.0})}));
                int x$7 = qual$3.parallelize$default$2();
                RDD userFeatures1 = qual$3.parallelize(x$6, x$7, ClassTag$.MODULE$.apply(Tuple2.class));
                this.$outer.intercept((Function0)new Serializable(this, userFeatures1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final RDD userFeatures1$1;

                    public final MatrixFactorizationModel apply() {
                        return new MatrixFactorizationModel(this.$outer.org$apache$spark$mllib$recommendation$MatrixFactorizationModelSuite$$anonfun$$$outer().rank(), this.userFeatures1$1, this.$outer.org$apache$spark$mllib$recommendation$MatrixFactorizationModelSuite$$anonfun$$$outer().prodFeatures());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.userFeatures1$1 = userFeatures1$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                SparkContext qual$4 = this.$outer.sc();
                Seq x$8 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new double[]{5.0})}));
                int x$9 = qual$4.parallelize$default$2();
                RDD prodFeatures1 = qual$4.parallelize(x$8, x$9, ClassTag$.MODULE$.apply(Tuple2.class));
                this.$outer.intercept((Function0)new Serializable(this, prodFeatures1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final RDD prodFeatures1$1;

                    public final MatrixFactorizationModel apply() {
                        return new MatrixFactorizationModel(this.$outer.org$apache$spark$mllib$recommendation$MatrixFactorizationModelSuite$$anonfun$$$outer().rank(), this.$outer.org$apache$spark$mllib$recommendation$MatrixFactorizationModelSuite$$anonfun$$$outer().userFeatures(), this.prodFeatures1$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.prodFeatures1$1 = prodFeatures1$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ MatrixFactorizationModelSuite org$apache$spark$mllib$recommendation$MatrixFactorizationModelSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModelSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatrixFactorizationModel model = new MatrixFactorizationModel(this.$outer.rank(), this.$outer.userFeatures(), this.$outer.prodFeatures());
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    MatrixFactorizationModel newModel = MatrixFactorizationModel$.MODULE$.load(this.$outer.sc(), path);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.rank()));
                    int $org_scalatest_assert_macro_right = this.$outer.rank();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.collect$1(newModel.userFeatures()));
                    Set $org_scalatest_assert_macro_right2 = this.collect$1(this.$outer.userFeatures());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.collect$1(newModel.productFeatures()));
                    Set $org_scalatest_assert_macro_right3 = this.collect$1(this.$outer.prodFeatures());
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }

            private final Set collect$1(RDD features) {
                return Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(features, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(double[] x$1) {
                        return Predef$.MODULE$.doubleArrayOps(x$1).toSeq();
                    }
                }).collect()).toSet();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("batch predict API recommendProductsForUsers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModelSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatrixFactorizationModel model = new MatrixFactorizationModel(this.$outer.rank(), this.$outer.userFeatures(), this.$outer.prodFeatures());
                int topK = 10;
                Map recommendations = RDD$.MODULE$.rddToPairRDDFunctions(model.recommendProductsForUsers(topK), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Rating.class)), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)0)))[0].rating()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(17.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recommendations.apply(0).apply(0).rating).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(17.0).relTol(1.0E-14))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)1)))[0].rating()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(39.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recommendations.apply(1).apply(0).rating).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(39.0).relTol(1.0E-14))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("batch predict API recommendUsersForProducts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModelSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatrixFactorizationModel model = new MatrixFactorizationModel(this.$outer.rank(), this.$outer.userFeatures(), this.$outer.prodFeatures());
                int topK = 10;
                Map recommendations = RDD$.MODULE$.rddToPairRDDFunctions(model.recommendUsersForProducts(topK), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Rating.class)), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
                int $org_scalatest_assert_macro_left = ((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)2)))[0].user();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)2)))[0].rating()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(39.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recommendations.apply(2).apply(0).rating).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(39.0).relTol(1.0E-14))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                int $org_scalatest_assert_macro_left2 = ((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)2)))[1].user();
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)2)))[1].rating()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(17.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recommendations.apply(2).apply(1).rating).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(17.0).relTol(1.0E-14))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

