/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoModel$;
import org.apache.spark.mllib.regression.LassoSuite$;
import org.apache.spark.mllib.regression.LassoWithSGD;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001u;Q!\u0001\u0002\t\n5\t!\u0002T1tg>\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!%\u0011C\u0001\u0006MCN\u001cxnU;ji\u0016\u001c2a\u0004\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u00111#G\u0005\u00035Q\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001H\b\u0005\u0002u\ta\u0001P5oSRtD#A\u0007\t\u000f}y!\u0019!C\u0001A\u0005)Qn\u001c3fYV\t\u0011\u0005\u0005\u0002\u000fE%\u00111E\u0001\u0002\u000b\u0019\u0006\u001c8o\\'pI\u0016d\u0007BB\u0013\u0010A\u0003%\u0011%\u0001\u0004n_\u0012,G\u000e\t\u0005\bO=\t\t\u0011\"\u0003)\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\t1\fgn\u001a\u0006\u0002]\u0005!!.\u0019<b\u0013\t\u00014F\u0001\u0004PE*,7\r\u001e\u0004\u0005!\t\u0001!gE\u00022g]\u0002\"\u0001N\u001b\u000e\u0003\u0019I!A\u000e\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tA4(D\u0001:\u0015\tQD!\u0001\u0003vi&d\u0017B\u0001\u001f:\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqRDQ\u0001H\u0019\u0005\u0002y\"\u0012a\u0010\t\u0003\u001dEBQ!Q\u0019\u0005\u0002\t\u000b!C^1mS\u0012\fG/\u001a)sK\u0012L7\r^5p]R\u00191IR,\u0011\u0005M!\u0015BA#\u0015\u0005\u0011)f.\u001b;\t\u000b\u001d\u0003\u0005\u0019\u0001%\u0002\u0017A\u0014X\rZ5di&|gn\u001d\t\u0004\u0013F#fB\u0001&P\u001d\tYe*D\u0001M\u0015\tiE\"\u0001\u0004=e>|GOP\u0005\u0002+%\u0011\u0001\u000bF\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116KA\u0002TKFT!\u0001\u0015\u000b\u0011\u0005M)\u0016B\u0001,\u0015\u0005\u0019!u.\u001e2mK\")\u0001\f\u0011a\u00013\u0006)\u0011N\u001c9viB\u0019\u0011*\u0015.\u0011\u00059Y\u0016B\u0001/\u0003\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u\u0001")
public class LassoSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static LassoModel model() {
        return LassoSuite$.MODULE$.model();
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOffPredictions;
        int $org_scalatest_assert_macro_left = numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, LabeledPoint> x0$1) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$1;
                if (tuple2 != null) {
                    LabeledPoint expected;
                    double prediction = tuple2._1$mcD$sp();
                    boolean bl = package$.MODULE$.abs(prediction - (expected = (LabeledPoint)tuple2._2()).label()) > 0.5;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public LassoSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Lasso local random SGD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LassoSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Bool bool2;
                Bool bool3;
                int nPoints = 1000;
                double A = 2.0;
                double B = -1.5;
                double C = 0.01;
                Seq testData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x0$2) {
                        LabeledPoint labeledPoint = x0$2;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector features = labeledPoint.features();
                            double d = 1.0;
                            LabeledPoint labeledPoint2 = new LabeledPoint(label, Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(features.toArray()).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                            return labeledPoint2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
                LassoWithSGD ls = new LassoWithSGD();
                ls.optimizer().setStepSize(1.0).setRegParam(0.01).setNumIterations(40);
                LassoModel model = (LassoModel)ls.run(testRDD);
                double weight0 = model.weights().apply(0);
                double weight1 = model.weights().apply(1);
                double weight2 = model.weights().apply(2);
                double $org_scalatest_assert_macro_left = weight0;
                double $org_scalatest_assert_macro_right = 1.9;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right);
                if ($org_scalatest_assert_macro_left2.value()) {
                    double $org_scalatest_assert_macro_left3 = weight0;
                    double $org_scalatest_assert_macro_right2 = 2.1;
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right2);
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append(weight0).append((Object)" not in [1.9, 2.1]").toString());
                double $org_scalatest_assert_macro_left4 = weight1;
                double $org_scalatest_assert_macro_right4 = -1.6;
                Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 >= $org_scalatest_assert_macro_right4);
                if ($org_scalatest_assert_macro_left5.value()) {
                    double $org_scalatest_assert_macro_left6 = weight1;
                    double $org_scalatest_assert_macro_right5 = -1.4;
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 <= $org_scalatest_assert_macro_right5);
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right6 = bool2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp($org_scalatest_assert_macro_right6));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder().append(weight1).append((Object)" not in [-1.6, -1.4]").toString());
                double $org_scalatest_assert_macro_left7 = weight2;
                double $org_scalatest_assert_macro_right7 = -0.001;
                Bool $org_scalatest_assert_macro_left8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 >= $org_scalatest_assert_macro_right7);
                if ($org_scalatest_assert_macro_left8.value()) {
                    double $org_scalatest_assert_macro_left9 = weight2;
                    double $org_scalatest_assert_macro_right8 = 0.001;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9 <= $org_scalatest_assert_macro_right8);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right9 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "&&", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left8.$amp$amp($org_scalatest_assert_macro_right9));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder().append(weight2).append((Object)" not in [-0.001, 0.001]").toString());
                Seq validationData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x0$3) {
                        LabeledPoint labeledPoint = x0$3;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector features = labeledPoint.features();
                            double d = 1.0;
                            LabeledPoint labeledPoint2 = new LabeledPoint(label, Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(features.toArray()).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                            return labeledPoint2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$3) {
                        return x$3.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LassoModel model$1;

                    public final double apply(LabeledPoint row) {
                        return this.model$1.predict(row.features());
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Lasso local random SGD with initial weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LassoSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Bool bool2;
                Bool bool3;
                int nPoints = 1000;
                double A = 2.0;
                double B = -1.5;
                double C = 0.01;
                Seq testData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x0$4) {
                        LabeledPoint labeledPoint = x0$4;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector features = labeledPoint.features();
                            double d = 1.0;
                            LabeledPoint labeledPoint2 = new LabeledPoint(label, Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(features.toArray()).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                            return labeledPoint2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                double initialA = -1.0;
                double initialB = -1.0;
                double initialC = -1.0;
                Vector initialWeights = Vectors$.MODULE$.dense(initialA, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{initialB, initialC}));
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
                LassoWithSGD ls = new LassoWithSGD();
                ls.optimizer().setStepSize(1.0).setRegParam(0.01).setNumIterations(40).setConvergenceTol(5.0E-4);
                LassoModel model = (LassoModel)ls.run(testRDD, initialWeights);
                double weight0 = model.weights().apply(0);
                double weight1 = model.weights().apply(1);
                double weight2 = model.weights().apply(2);
                double $org_scalatest_assert_macro_left = weight0;
                double $org_scalatest_assert_macro_right = 1.9;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right);
                if ($org_scalatest_assert_macro_left2.value()) {
                    double $org_scalatest_assert_macro_left3 = weight0;
                    double $org_scalatest_assert_macro_right2 = 2.1;
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right2);
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append(weight0).append((Object)" not in [1.9, 2.1]").toString());
                double $org_scalatest_assert_macro_left4 = weight1;
                double $org_scalatest_assert_macro_right4 = -1.6;
                Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 >= $org_scalatest_assert_macro_right4);
                if ($org_scalatest_assert_macro_left5.value()) {
                    double $org_scalatest_assert_macro_left6 = weight1;
                    double $org_scalatest_assert_macro_right5 = -1.4;
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 <= $org_scalatest_assert_macro_right5);
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right6 = bool2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp($org_scalatest_assert_macro_right6));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder().append(weight1).append((Object)" not in [-1.6, -1.4]").toString());
                double $org_scalatest_assert_macro_left7 = weight2;
                double $org_scalatest_assert_macro_right7 = -0.001;
                Bool $org_scalatest_assert_macro_left8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 >= $org_scalatest_assert_macro_right7);
                if ($org_scalatest_assert_macro_left8.value()) {
                    double $org_scalatest_assert_macro_left9 = weight2;
                    double $org_scalatest_assert_macro_right8 = 0.001;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9 <= $org_scalatest_assert_macro_right8);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right9 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "&&", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left8.$amp$amp($org_scalatest_assert_macro_right9));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder().append(weight2).append((Object)" not in [-0.001, 0.001]").toString());
                Seq validationData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x0$5) {
                        LabeledPoint labeledPoint = x0$5;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector features = labeledPoint.features();
                            double d = 1.0;
                            LabeledPoint labeledPoint2 = new LabeledPoint(label, Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(features.toArray()).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                            return labeledPoint2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$6) {
                        return x$6.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LassoModel model$2;

                    public final double apply(LabeledPoint row) {
                        return this.model$2.predict(row.features());
                    }
                    {
                        this.model$2 = model$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LassoSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LassoModel model = LassoSuite$.MODULE$.model();
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    LassoModel sameModel = LassoModel$.MODULE$.load(this.$outer.sc(), path);
                    Vector $org_scalatest_assert_macro_left = model.weights();
                    Vector $org_scalatest_assert_macro_right = sameModel.weights();
                    Vector vector = $org_scalatest_assert_macro_left;
                    Vector vector2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(vector != null ? !vector.equals(vector2) : vector2 != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    double $org_scalatest_assert_macro_left2 = model.intercept();
                    double $org_scalatest_assert_macro_right2 = sameModel.intercept();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

