/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionModel$;
import org.apache.spark.mllib.regression.LinearRegressionSuite$;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001u;Q!\u0001\u0002\t\n5\tQ\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk&$XM\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0005#\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\*vSR,7cA\b\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"aE\r\n\u0005i!\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u000f\u0010\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u001dyrB1A\u0005\u0002\u0001\nQ!\\8eK2,\u0012!\t\t\u0003\u001d\tJ!a\t\u0002\u0003+1Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fY\"1Qe\u0004Q\u0001\n\u0005\na!\\8eK2\u0004\u0003bB\u0014\u0010\u0003\u0003%I\u0001K\u0001\fe\u0016\fGMU3t_24X\rF\u0001*!\tQs&D\u0001,\u0015\taS&\u0001\u0003mC:<'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a-\u0012aa\u00142kK\u000e$h\u0001\u0002\t\u0003\u0001I\u001a2!M\u001a8!\t!T'D\u0001\u0007\u0013\t1dAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0011\tA!\u001e;jY&\u0011A(\u000f\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015a\u0012\u0007\"\u0001?)\u0005y\u0004C\u0001\b2\u0011\u0015\t\u0015\u0007\"\u0001C\u0003I1\u0018\r\\5eCR,\u0007K]3eS\u000e$\u0018n\u001c8\u0015\u0007\r3u\u000b\u0005\u0002\u0014\t&\u0011Q\t\u0006\u0002\u0005+:LG\u000fC\u0003H\u0001\u0002\u0007\u0001*A\u0006qe\u0016$\u0017n\u0019;j_:\u001c\bcA%R):\u0011!j\u0014\b\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b2\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005A#\u0012a\u00029bG.\fw-Z\u0005\u0003%N\u00131aU3r\u0015\t\u0001F\u0003\u0005\u0002\u0014+&\u0011a\u000b\u0006\u0002\u0007\t>,(\r\\3\t\u000ba\u0003\u0005\u0019A-\u0002\u000b%t\u0007/\u001e;\u0011\u0007%\u000b&\f\u0005\u0002\u000f7&\u0011AL\u0001\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e")
public class LinearRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static LinearRegressionModel model() {
        return LinearRegressionSuite$.MODULE$.model();
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOffPredictions;
        int $org_scalatest_assert_macro_left = numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, LabeledPoint> x0$1) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$1;
                if (tuple2 != null) {
                    LabeledPoint expected;
                    double prediction = tuple2._1$mcD$sp();
                    boolean bl = package$.MODULE$.abs(prediction - (expected = (LabeledPoint)tuple2._2()).label()) > 0.5;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public LinearRegressionSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("linear regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Bool bool2;
                Bool bool3;
                RDD testRDD = this.$outer.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(3.0, new double[]{10.0, 10.0}, 100, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
                LinearRegressionWithSGD linReg = (LinearRegressionWithSGD)new LinearRegressionWithSGD().setIntercept(true);
                linReg.optimizer().setNumIterations(1000).setStepSize(1.0);
                LinearRegressionModel model = (LinearRegressionModel)linReg.run(testRDD);
                double $org_scalatest_assert_macro_left = model.intercept();
                double $org_scalatest_assert_macro_right = 2.5;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right);
                if ($org_scalatest_assert_macro_left2.value()) {
                    double $org_scalatest_assert_macro_left3 = model.intercept();
                    double $org_scalatest_assert_macro_right2 = 3.5;
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right2);
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Vector weights = model.weights();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)weights.size()));
                int $org_scalatest_assert_macro_right4 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double $org_scalatest_assert_macro_left5 = weights.apply(0);
                double $org_scalatest_assert_macro_right5 = 9.0;
                Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 >= $org_scalatest_assert_macro_right5);
                if ($org_scalatest_assert_macro_left6.value()) {
                    double $org_scalatest_assert_macro_left7 = weights.apply(0);
                    double $org_scalatest_assert_macro_right6 = 11.0;
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7 <= $org_scalatest_assert_macro_right6);
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right7 = bool2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left6.$amp$amp($org_scalatest_assert_macro_right7));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                double $org_scalatest_assert_macro_left8 = weights.apply(1);
                double $org_scalatest_assert_macro_right8 = 9.0;
                Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 >= $org_scalatest_assert_macro_right8);
                if ($org_scalatest_assert_macro_left9.value()) {
                    double $org_scalatest_assert_macro_left10 = weights.apply(1);
                    double $org_scalatest_assert_macro_right9 = 11.0;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left10), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10 <= $org_scalatest_assert_macro_right9);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right10 = bool;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left9.$amp$amp($org_scalatest_assert_macro_right10));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Seq validationData = LinearDataGenerator$.MODULE$.generateLinearInput(3.0, new double[]{10.0, 10.0}, 100, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$1) {
                        return x$1.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LinearRegressionModel model$1;

                    public final double apply(LabeledPoint row) {
                        return this.model$1.predict(row.features());
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Bool bool2;
                RDD testRDD = this.$outer.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
                LinearRegressionWithSGD linReg = (LinearRegressionWithSGD)new LinearRegressionWithSGD().setIntercept(false);
                linReg.optimizer().setNumIterations(1000).setStepSize(1.0);
                LinearRegressionModel model = (LinearRegressionModel)linReg.run(testRDD);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = 0.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Vector weights = model.weights();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)weights.size()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double $org_scalatest_assert_macro_left3 = weights.apply(0);
                double $org_scalatest_assert_macro_right3 = 9.0;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 >= $org_scalatest_assert_macro_right3);
                if ($org_scalatest_assert_macro_left4.value()) {
                    double $org_scalatest_assert_macro_left5 = weights.apply(0);
                    double $org_scalatest_assert_macro_right4 = 11.0;
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 <= $org_scalatest_assert_macro_right4);
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right5 = bool2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp($org_scalatest_assert_macro_right5));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                double $org_scalatest_assert_macro_left6 = weights.apply(1);
                double $org_scalatest_assert_macro_right6 = 9.0;
                Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 >= $org_scalatest_assert_macro_right6);
                if ($org_scalatest_assert_macro_left7.value()) {
                    double $org_scalatest_assert_macro_left8 = weights.apply(1);
                    double $org_scalatest_assert_macro_right7 = 11.0;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 <= $org_scalatest_assert_macro_right7);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right8 = bool;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left7.$amp$amp($org_scalatest_assert_macro_right8));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Seq validationData = LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$2) {
                        return x$2.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LinearRegressionModel model$2;

                    public final double apply(LabeledPoint row) {
                        return this.model$2.predict(row.features());
                    }
                    {
                        this.model$2 = model$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse linear regression without intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Bool bool2;
                RDD denseRDD = this.$outer.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD sparseRDD = denseRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x0$2) {
                        LabeledPoint labeledPoint = x0$2;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector v = labeledPoint.features();
                            Vector sv = Vectors$.MODULE$.sparse(10000, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, v.apply(0)), new Tuple2.mcID.sp(9999, v.apply(1))})));
                            LabeledPoint labeledPoint2 = new LabeledPoint(label, sv);
                            return labeledPoint2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
                LinearRegressionWithSGD linReg = (LinearRegressionWithSGD)new LinearRegressionWithSGD().setIntercept(false);
                linReg.optimizer().setNumIterations(1000).setStepSize(1.0);
                LinearRegressionModel model = (LinearRegressionModel)linReg.run(sparseRDD);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = 0.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Vector weights = model.weights();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)weights.size()));
                int $org_scalatest_assert_macro_right2 = 10000;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double $org_scalatest_assert_macro_left3 = weights.apply(0);
                double $org_scalatest_assert_macro_right3 = 9.0;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 >= $org_scalatest_assert_macro_right3);
                if ($org_scalatest_assert_macro_left4.value()) {
                    double $org_scalatest_assert_macro_left5 = weights.apply(0);
                    double $org_scalatest_assert_macro_right4 = 11.0;
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 <= $org_scalatest_assert_macro_right4);
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right5 = bool2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp($org_scalatest_assert_macro_right5));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                double $org_scalatest_assert_macro_left6 = weights.apply(9999);
                double $org_scalatest_assert_macro_right6 = 9.0;
                Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 >= $org_scalatest_assert_macro_right6);
                if ($org_scalatest_assert_macro_left7.value()) {
                    double $org_scalatest_assert_macro_left8 = weights.apply(9999);
                    double $org_scalatest_assert_macro_right7 = 11.0;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 <= $org_scalatest_assert_macro_right7);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right8 = bool;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left7.$amp$amp($org_scalatest_assert_macro_right8));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Seq validationData = LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                Seq sparseValidationData = (Seq)validationData.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x0$3) {
                        LabeledPoint labeledPoint = x0$3;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector v = labeledPoint.features();
                            Vector sv = Vectors$.MODULE$.sparse(10000, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, v.apply(0)), new Tuple2.mcID.sp(9999, v.apply(1))})));
                            LabeledPoint labeledPoint2 = new LabeledPoint(label, sv);
                            return labeledPoint2;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RDD sparseValidationRDD = this.$outer.sc().parallelize(sparseValidationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(sparseValidationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$3) {
                        return x$3.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)sparseValidationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)sparseValidationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LinearRegressionModel model$3;

                    public final double apply(LabeledPoint row) {
                        return this.model$3.predict(row.features());
                    }
                    {
                        this.model$3 = model$3;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)sparseValidationData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegressionModel model = LinearRegressionSuite$.MODULE$.model();
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    LinearRegressionModel sameModel = LinearRegressionModel$.MODULE$.load(this.$outer.sc(), path);
                    Vector $org_scalatest_assert_macro_left = model.weights();
                    Vector $org_scalatest_assert_macro_right = sameModel.weights();
                    Vector vector = $org_scalatest_assert_macro_left;
                    Vector vector2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(vector != null ? !vector.equals(vector2) : vector2 != null));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    double $org_scalatest_assert_macro_left2 = model.intercept();
                    double $org_scalatest_assert_macro_right2 = sameModel.intercept();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

