/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Matrix;
import breeze.linalg.support.LiteralRow$;
import breeze.storage.Zero;
import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.stat.CorrelationSuite$;
import org.apache.spark.mllib.stat.CorrelationSuite$$anonfun$matrixApproxEqual$1$;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.correlation.Correlation;
import org.apache.spark.mllib.stat.correlation.Correlations$;
import org.apache.spark.mllib.stat.correlation.PearsonCorrelation$;
import org.apache.spark.mllib.stat.correlation.SpearmanCorrelation$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001b\t\u00012i\u001c:sK2\fG/[8o'VLG/\u001a\u0006\u0003\u0007\u0011\tAa\u001d;bi*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%a\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!!\b\u000e\u0003\u000f1{wmZ5oO\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\u0012!\t\t\u0003E\u0001i\u0011A\u0001\u0005\bI\u0001\u0011\r\u0011\"\u0001&\u0003\u0015AH)\u0019;b+\u00051\u0003cA\u0014+Y5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0003BeJ\f\u0017\u0010\u0005\u0002([%\u0011a\u0006\u000b\u0002\u0007\t>,(\r\\3\t\rA\u0002\u0001\u0015!\u0003'\u0003\u0019AH)\u0019;bA!9!\u0007\u0001b\u0001\n\u0003)\u0013!B=ECR\f\u0007B\u0002\u001b\u0001A\u0003%a%\u0001\u0004z\t\u0006$\u0018\r\t\u0005\bm\u0001\u0011\r\u0011\"\u0001&\u0003\u0015QXM]8t\u0011\u0019A\u0004\u0001)A\u0005M\u00051!0\u001a:pg\u0002BqA\u000f\u0001C\u0002\u0013\u00051(\u0001\u0003eCR\fW#\u0001\u001f\u0011\u0007u\u0002%)D\u0001?\u0015\ty\u0004&\u0001\u0006d_2dWm\u0019;j_:L!!\u0011 \u0003\u0007M+\u0017\u000f\u0005\u0002D\r6\tAI\u0003\u0002F\t\u00051A.\u001b8bY\u001eL!a\u0012#\u0003\rY+7\r^8s\u0011\u0019I\u0005\u0001)A\u0005y\u0005)A-\u0019;bA!)1\n\u0001C\u0001\u0019\u0006Y\u0011\r\u001d9s_b,\u0015/^1m)\u0011i\u0005K\u0015+\u0011\u0005\u001dr\u0015BA()\u0005\u001d\u0011un\u001c7fC:DQ!\u0015&A\u00021\n!A^\u0019\t\u000bMS\u0005\u0019\u0001\u0017\u0002\u0005Y\u0014\u0004bB+K!\u0003\u0005\r\u0001L\u0001\ni\"\u0014Xm\u001d5pY\u0012DQa\u0016\u0001\u0005\u0002a\u000b\u0011#\\1ue&D\u0018\t\u001d9s_b,\u0015/^1m)\u0011i\u0015L\u00193\t\u000bi3\u0006\u0019A.\u0002\u0003\u0005\u00032\u0001\u00181-\u001b\u0005i&BA#_\u0015\u0005y\u0016A\u00022sK\u0016TX-\u0003\u0002b;\n1Q*\u0019;sSbDQa\u0019,A\u0002m\u000b\u0011A\u0011\u0005\b+Z\u0003\n\u00111\u0001-\u0011\u001d1\u0007!%A\u0005\u0002\u001d\fQ#\u00199qe>DX)];bY\u0012\"WMZ1vYR$3'F\u0001iU\ta\u0013nK\u0001k!\tY\u0007/D\u0001m\u0015\tig.A\u0005v]\u000eDWmY6fI*\u0011q\u000eK\u0001\u000bC:tw\u000e^1uS>t\u0017BA9m\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bg\u0002\t\n\u0011\"\u0001h\u0003mi\u0017\r\u001e:jq\u0006\u0003\bO]8y\u000bF,\u0018\r\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class CorrelationSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final double[] xData;
    private final double[] yData;
    private final double[] zeros;
    private final Seq<Vector> data;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public double[] xData() {
        return this.xData;
    }

    public double[] yData() {
        return this.yData;
    }

    public double[] zeros() {
        return this.zeros;
    }

    public Seq<Vector> data() {
        return this.data;
    }

    public boolean approxEqual(double v1, double v2, double threshold) {
        return Predef$.MODULE$.double2Double(v1).isNaN() ? Predef$.MODULE$.double2Double(v2).isNaN() : package$.MODULE$.abs(v1 - v2) <= threshold;
    }

    public double approxEqual$default$3() {
        return 1.0E-6;
    }

    public boolean matrixApproxEqual(Matrix<Object> A, Matrix<Object> B, double threshold) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.rows()).foreach$mVc$sp((Function1)new Serializable(this, A, B, threshold, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CorrelationSuite $outer;
                    public final Matrix A$1;
                    public final Matrix B$1;
                    public final double threshold$1;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.A$1.cols()).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$matrixApproxEqual$1 $outer;
                            public final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                if (this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual(this.$outer.A$1.apply$mcD$sp(this.i$1, j), this.$outer.B$1.apply$mcD$sp(this.i$1, j), this.$outer.threshold$1)) {
                                    return;
                                }
                                this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, j){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$matrixApproxEqual$1$$anonfun$apply$mcVI$sp$1 $outer;
                                    private final int j$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"i, j = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.i$1)).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)this.j$1)).append((Object)" actual: ").append((Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$anonfun$$$outer().A$1.apply$mcD$sp(this.$outer.i$1, this.j$1))).append((Object)" expected:").append((Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$anonfun$$$outer().B$1.apply$mcD$sp(this.$outer.i$1, this.j$1))).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.j$1 = j$1;
                                    }
                                });
                                throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, false);
                            }

                            public /* synthetic */ $anonfun$matrixApproxEqual$1 org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        });
                    }

                    public /* synthetic */ CorrelationSuite org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.A$1 = A$1;
                        this.B$1 = B$1;
                        this.threshold$1 = threshold$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public double matrixApproxEqual$default$3() {
        return 1.0E-6;
    }

    public CorrelationSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.xData = new double[]{1.0, 0.0, -2.0};
        this.yData = new double[]{4.0, 5.0, 3.0};
        this.zeros = new double[3];
        this.data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, -2.0})), Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0, 0.0, 3.0})), Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0, 0.0, 8.0})), Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 1.0}))}));
        this.test("corr(x, y) pearson, 1 value in data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$3 = Predef$.MODULE$.wrapDoubleArray(new double[]{1.0});
                int x$4 = qual$1.parallelize$default$2();
                RDD x = qual$1.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.Double());
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$5 = Predef$.MODULE$.wrapDoubleArray(new double[]{4.0});
                int x$6 = qual$2.parallelize$default$2();
                RDD y = qual$2.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.Double());
                this.$outer.intercept((Function0)new Serializable(this, x, y){
                    public static final long serialVersionUID = 0L;
                    private final RDD x$23;
                    private final RDD y$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Statistics$.MODULE$.corr(this.x$23, this.y$1, "pearson");
                    }
                    {
                        this.x$23 = x$23;
                        this.y$1 = y$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, x, y){
                    public static final long serialVersionUID = 0L;
                    private final RDD x$23;
                    private final RDD y$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Statistics$.MODULE$.corr(this.x$23, this.y$1, "spearman");
                    }
                    {
                        this.x$23 = x$23;
                        this.y$1 = y$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("corr(x, y) default, pearson", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$7 = Predef$.MODULE$.wrapDoubleArray(this.$outer.xData());
                int x$8 = qual$3.parallelize$default$2();
                RDD x = qual$3.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.Double());
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$9 = Predef$.MODULE$.wrapDoubleArray(this.$outer.yData());
                int x$10 = qual$4.parallelize$default$2();
                RDD y = qual$4.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.Double());
                double expected = 0.6546537;
                double d = Statistics$.MODULE$.corr(x, y);
                double p1 = Statistics$.MODULE$.corr(x, y, "pearson");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.approxEqual(expected, d, this.$outer.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, default, CorrelationSuite.this.approxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.approxEqual(expected, p1, this.$outer.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, p1, CorrelationSuite.this.approxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Predef$.MODULE$.doubleArrayOps(this.$outer.xData()).size(), Predef$.MODULE$.doubleArrayOps(this.$outer.xData()).size() * 2})).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final double expected$1;

                    public final void apply(int numParts) {
                        this.apply$mcVI$sp(numParts);
                    }

                    public void apply$mcVI$sp(int numParts) {
                        RDD x1 = this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().xData()), numParts, ClassTag$.MODULE$.Double());
                        RDD y1 = this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().yData()), numParts, ClassTag$.MODULE$.Double());
                        double p2 = Statistics$.MODULE$.corr(x1, y1);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual(this.expected$1, p2, this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, p2, CorrelationSuite.this.approxEqual$default$3)");
                        this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$1 = expected$1;
                    }
                });
                SparkContext qual$5 = this.$outer.sc();
                WrappedArray x$11 = Predef$.MODULE$.wrapDoubleArray(this.$outer.zeros());
                int x$12 = qual$5.parallelize$default$2();
                RDD z = qual$5.parallelize((Seq)x$11, x$12, ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(Statistics$.MODULE$.corr(x, z)).isNaN(), "scala.this.Predef.double2Double(Statistics.corr(x, z)).isNaN()");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ CorrelationSuite org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("corr(x, y) spearman", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$6 = this.$outer.sc();
                WrappedArray x$13 = Predef$.MODULE$.wrapDoubleArray(this.$outer.xData());
                int x$14 = qual$6.parallelize$default$2();
                RDD x = qual$6.parallelize((Seq)x$13, x$14, ClassTag$.MODULE$.Double());
                SparkContext qual$7 = this.$outer.sc();
                WrappedArray x$15 = Predef$.MODULE$.wrapDoubleArray(this.$outer.yData());
                int x$16 = qual$7.parallelize$default$2();
                RDD y = qual$7.parallelize((Seq)x$15, x$16, ClassTag$.MODULE$.Double());
                double expected = 0.5;
                double s1 = Statistics$.MODULE$.corr(x, y, "spearman");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.approxEqual(expected, s1, this.$outer.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, s1, CorrelationSuite.this.approxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Predef$.MODULE$.doubleArrayOps(this.$outer.xData()).size(), Predef$.MODULE$.doubleArrayOps(this.$outer.xData()).size() * 2})).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final double expected$2;

                    public final void apply(int numParts) {
                        this.apply$mcVI$sp(numParts);
                    }

                    public void apply$mcVI$sp(int numParts) {
                        RDD x1 = this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().xData()), numParts, ClassTag$.MODULE$.Double());
                        RDD y1 = this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().yData()), numParts, ClassTag$.MODULE$.Double());
                        double s2 = Statistics$.MODULE$.corr(x1, y1, "spearman");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual(this.expected$2, s2, this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, s2, CorrelationSuite.this.approxEqual$default$3)");
                        this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$2 = expected$2;
                    }
                });
                SparkContext qual$8 = this.$outer.sc();
                WrappedArray x$17 = Predef$.MODULE$.wrapDoubleArray(this.$outer.zeros());
                int x$18 = qual$8.parallelize$default$2();
                RDD z = qual$8.parallelize((Seq)x$17, x$18, ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(Statistics$.MODULE$.corr(x, z, "spearman")).isNaN(), "scala.this.Predef.double2Double(Statistics.corr(x, z, \"spearman\")).isNaN()");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ CorrelationSuite org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("corr(X) default, pearson", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$9 = this.$outer.sc();
                Seq<Vector> x$19 = this.$outer.data();
                int x$20 = qual$9.parallelize$default$2();
                RDD X = qual$9.parallelize(x$19, x$20, ClassTag$.MODULE$.apply(Vector.class));
                org.apache.spark.mllib.linalg.Matrix defaultMat = Statistics$.MODULE$.corr(X);
                org.apache.spark.mllib.linalg.Matrix pearsonMat = Statistics$.MODULE$.corr(X, "pearson");
                DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.05564149), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.4004714)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.05564149), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.9135959)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.40047142), (Object)BoxesRunTime.boxToDouble((double)0.91359586), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.matrixApproxEqual((Matrix<Object>)defaultMat.asBreeze(), (Matrix<Object>)expected, this.$outer.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(defaultMat.asBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.matrixApproxEqual((Matrix<Object>)pearsonMat.asBreeze(), (Matrix<Object>)expected, this.$outer.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(pearsonMat.asBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("corr(X) spearman", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$10 = this.$outer.sc();
                Seq<Vector> x$21 = this.$outer.data();
                int x$22 = qual$10.parallelize$default$2();
                RDD X = qual$10.parallelize(x$21, x$22, ClassTag$.MODULE$.apply(Vector.class));
                org.apache.spark.mllib.linalg.Matrix spearmanMat = Statistics$.MODULE$.corr(X, "spearman");
                DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.1054093), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.4)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.1054093), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.9486833)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.4), (Object)BoxesRunTime.boxToDouble((double)0.9486833), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.matrixApproxEqual((Matrix<Object>)spearmanMat.asBreeze(), (Matrix<Object>)expected, this.$outer.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(spearmanMat.asBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("method identification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PearsonCorrelation$ pearson = PearsonCorrelation$.MODULE$;
                SpearmanCorrelation$ spearman = SpearmanCorrelation$.MODULE$;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Correlations$.MODULE$.getCorrelationFromName("pearson"));
                PearsonCorrelation$ $org_scalatest_assert_macro_right = pearson;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Correlations$.MODULE$.getCorrelationFromName("spearman"));
                SpearmanCorrelation$ $org_scalatest_assert_macro_right2 = spearman;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Correlation apply() {
                        return Correlations$.MODULE$.getCorrelationFromName("kendall");
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.ignore("Pearson correlation of very large uncorrelated values (SPARK-14533)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD a = RandomRDDs$.MODULE$.normalRDD(this.$outer.sc(), 100000L, 10, RandomRDDs$.MODULE$.normalRDD$default$4()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$1) {
                        return this.apply$mcDD$sp(x$1);
                    }

                    public double apply$mcDD$sp(double x$1) {
                        return x$1 + 1.0E9;
                    }
                }, ClassTag$.MODULE$.Double());
                RDD b = RandomRDDs$.MODULE$.normalRDD(this.$outer.sc(), 100000L, 10, RandomRDDs$.MODULE$.normalRDD$default$4()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$2) {
                        return this.apply$mcDD$sp(x$2);
                    }

                    public double apply$mcDD$sp(double x$2) {
                        return x$2 + 1.0E9;
                    }
                }, ClassTag$.MODULE$.Double());
                double p = Statistics$.MODULE$.corr(a, b, "pearson");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.approxEqual(p, 0.0, 0.01), "CorrelationSuite.this.approxEqual(p, 0.0, 0.01)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

