/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DecisionTreeModel$;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u00015\u0011\u0011\u0003R3dSNLwN\u001c+sK\u0016\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003ue\u0016,'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005kRLG.\u0003\u0002\u0018)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u000f\u0015q\"\u0001#\u0001 \u0003E!UmY5tS>tGK]3f'VLG/\u001a\t\u00039\u00012Q!\u0001\u0002\t\u0002\u0005\u001a\"\u0001\t\b\t\u000be\u0001C\u0011A\u0012\u0015\u0003}AQ!\n\u0011\u0005\u0002\u0019\n!C^1mS\u0012\fG/Z\"mCN\u001c\u0018NZ5feR!q%\f\u001bI!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0011)f.\u001b;\t\u000b9\"\u0003\u0019A\u0018\u0002\u000b5|G-\u001a7\u0011\u0005A\u0012T\"A\u0019\u000b\u00059\u0012\u0011BA\u001a2\u0005E!UmY5tS>tGK]3f\u001b>$W\r\u001c\u0005\u0006k\u0011\u0002\rAN\u0001\u0006S:\u0004X\u000f\u001e\t\u0004o}\u0012eB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYD\"\u0001\u0004=e>|GOP\u0005\u0002U%\u0011a(K\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0015IA\u0002TKFT!AP\u0015\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0011A\u0003:fOJ,7o]5p]&\u0011q\t\u0012\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u0006\u0013\u0012\u0002\rAS\u0001\u0011e\u0016\fX/\u001b:fI\u0006\u001b7-\u001e:bGf\u0004\"\u0001K&\n\u00051K#A\u0002#pk\ndW\rC\u0003OA\u0011\u0005q*A\twC2LG-\u0019;f%\u0016<'/Z:t_J$Ba\n)R%\")a&\u0014a\u0001_!)Q'\u0014a\u0001m!)1+\u0014a\u0001\u0015\u0006Y!/Z9vSJ,G-T*F\u0011\u0015)\u0006\u0005\"\u0001W\u0003\u0019:WM\\3sCR,wJ\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN<\u0016\u000e\u001e5MC\n,G\u000e\r\u000b\u0002/B\u0019\u0001\u0006\u0017\"\n\u0005eK#!B!se\u0006L\b\"B.!\t\u00031\u0016AJ4f]\u0016\u0014\u0018\r^3Pe\u0012,'/\u001a3MC\n,G.\u001a3Q_&tGo],ji\"d\u0015MY3mc!)Q\f\tC\u0001-\u0006ar-\u001a8fe\u0006$Xm\u0014:eKJ,G\rT1cK2,G\rU8j]R\u001c\b\"B0!\t\u00031\u0016!H4f]\u0016\u0014\u0018\r^3DCR,wm\u001c:jG\u0006dG)\u0019;b!>Lg\u000e^:\t\u000b\u0005\u0004C\u0011\u00012\u0002O\u001d,g.\u001a:bi\u0016\u001c\u0015\r^3h_JL7-\u00197ECR\f\u0007k\\5oiN\f5OS1wC2K7\u000f\u001e\u000b\u0002GB\u0019A\r\u001b\"\u000e\u0003\u0015T!!\u00064\u000b\u0003\u001d\fAA[1wC&\u0011\u0011.\u001a\u0002\u0005\u0019&\u001cH\u000fC\u0003lA\u0011\u0005a+\u0001\u0016hK:,'/\u0019;f\u0007\u0006$XmZ8sS\u000e\fG\u000eR1uCB{\u0017N\u001c;t\r>\u0014X*\u001e7uS\u000ed\u0017m]:\t\u000b5\u0004C\u0011\u0001,\u0002S\u001d,g.\u001a:bi\u0016\u001cuN\u001c;j]V|Wo\u001d#bi\u0006\u0004v.\u001b8ug\u001a{'/T;mi&\u001cG.Y:t\u0011\u0015y\u0007\u0005\"\u0001W\u0003q:WM\\3sCR,7)\u0019;fO>\u0014\u0018nY1m\t\u0006$\u0018\rU8j]R\u001chi\u001c:Nk2$\u0018n\u00197bgN4uN](sI\u0016\u0014X\r\u001a$fCR,(/Z:\t\u000bE\u0004C\u0011\u0002:\u0002\u001d\r\u0014X-\u0019;f\u0019\u0016\fgMT8eKR\u00111O\u001e\t\u0003aQL!!^\u0019\u0003\t9{G-\u001a\u0005\u0006oB\u0004\r\u0001_\u0001\u0003S\u0012\u0004\"\u0001K=\n\u0005iL#aA%oi\")A\u0010\tC\u0005{\u0006\u00112M]3bi\u0016Le\u000e^3s]\u0006dgj\u001c3f)\r\u0019hp \u0005\u0006on\u0004\r\u0001\u001f\u0005\b\u0003\u0003Y\b\u0019AA\u0002\u0003-1W-\u0019;ve\u0016$\u0016\u0010]3\u0011\t\u0005\u0015\u0011q\u0005\b\u0005\u0003\u000f\t\tC\u0004\u0003\u0002\n\u0005ua\u0002BA\u0006\u00037qA!!\u0004\u0002\u001a9!\u0011qBA\f\u001d\u0011\t\t\"!\u0006\u000f\u0007e\n\u0019\"C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I1!a\b\u0003\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u00111EA\u0013\u0003-1U-\u0019;ve\u0016$\u0016\u0010]3\u000b\u0007\u0005}!!\u0003\u0003\u0002*\u0005-\"a\u0003$fCR,(/\u001a+za\u0016TA!a\t\u0002&!A\u0011q\u0006\u0011\u0005\u0002\u0019\t\t$A\u0006de\u0016\fG/Z'pI\u0016dGcA\u0018\u00024!A\u0011QGA\u0017\u0001\u0004\t9$\u0001\u0003bY\u001e|\u0007\u0003BA\u001d\u0003\u007fqA!a\u0002\u0002<%!\u0011QHA\u0013\u0003\u0011\tEnZ8\n\t\u0005\u0005\u00131\t\u0002\u0005\u00032<wN\u0003\u0003\u0002>\u0005\u0015\u0002\"CA$A\t\u0007I\u0011BA%\u0003M\u0019'/Z1uK\u0012lu\u000eZ3m\u001d>$W-\u00133t+\t\tY\u0005E\u0002)1bD\u0001\"a\u0014!A\u0003%\u00111J\u0001\u0015GJ,\u0017\r^3e\u001b>$W\r\u001c(pI\u0016LEm\u001d\u0011\t\u0011\u0005M\u0003\u0005\"\u0001\u0005\u0003+\n!b\u00195fG.,\u0015/^1m)\u00159\u0013qKA.\u0011\u001d\tI&!\u0015A\u0002=\n\u0011!\u0019\u0005\b\u0003;\n\t\u00061\u00010\u0003\u0005\u0011\u0007bBA*A\u0011%\u0011\u0011\r\u000b\u0006O\u0005\r\u0014Q\r\u0005\b\u00033\ny\u00061\u0001t\u0011\u001d\ti&a\u0018A\u0002MD\u0011\"!\u001b!\u0003\u0003%I!a\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003g2\u0017\u0001\u00027b]\u001eLA!a\u001e\u0002r\t1qJ\u00196fGR\u0004")
public class DecisionTreeSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateCategoricalDataPointsForMulticlassForOrderedFeatures() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateContinuousDataPointsForMulticlass() {
        return DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateCategoricalDataPointsForMulticlass() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
    }

    public static java.util.List<org.apache.spark.mllib.regression.LabeledPoint> generateCategoricalDataPointsAsJavaList() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsAsJavaList();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateCategoricalDataPoints() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateOrderedLabeledPoints() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPoints();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateOrderedLabeledPointsWithLabel1() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateOrderedLabeledPointsWithLabel0() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
    }

    public static void validateRegressor(DecisionTreeModel decisionTreeModel, Seq<org.apache.spark.mllib.regression.LabeledPoint> seq, double d) {
        DecisionTreeSuite$.MODULE$.validateRegressor(decisionTreeModel, seq, d);
    }

    public static void validateClassifier(DecisionTreeModel decisionTreeModel, Seq<org.apache.spark.mllib.regression.LabeledPoint> seq, double d) {
        DecisionTreeSuite$.MODULE$.validateClassifier(decisionTreeModel, seq, d);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public DecisionTreeSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Binary classification stump with ordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$14 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$15 = qual$1.parallelize$default$2();
                RDD rdd = qual$1.parallelize((Seq)x$14, x$15, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$16 = Algo$.MODULE$.Classification();
                Gini$ x$17 = Gini$.MODULE$;
                int x$18 = 2;
                int x$19 = 2;
                int x$20 = 100;
                Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$22 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$23 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$24 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$25 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$26 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$27 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$28 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$16, (Impurity)x$17, x$19, x$18, x$20, x$22, x$21, x$23, x$24, x$25, x$26, x$27, x$28);
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(split.categories());
                List $org_scalatest_assert_macro_right2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right3 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
                double $org_scalatest_assert_macro_left4 = stats.gain();
                int $org_scalatest_assert_macro_right4 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > (double)$org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                double $org_scalatest_assert_macro_left6 = stats.impurity();
                double $org_scalatest_assert_macro_right6 = 0.2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right6);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression stump with 3-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$29 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$30 = qual$2.parallelize$default$2();
                RDD rdd = qual$2.parallelize((Seq)x$29, x$30, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$31 = Algo$.MODULE$.Regression();
                Variance$ x$32 = Variance$.MODULE$;
                int x$33 = 2;
                int x$34 = 100;
                Map x$35 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$36 = Strategy$.MODULE$.$lessinit$greater$default$4();
                Enumeration.Value x$37 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$38 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$39 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$40 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$41 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$42 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$43 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$31, (Impurity)x$32, x$33, x$36, x$34, x$37, x$35, x$38, x$39, x$40, x$41, x$42, x$43);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$1) {
                        return x$1.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                List $org_scalatest_assert_macro_left3 = split.categories();
                double $org_scalatest_assert_macro_right3 = 1.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
                double $org_scalatest_assert_macro_left5 = stats.gain();
                int $org_scalatest_assert_macro_right5 = 0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 > (double)$org_scalatest_assert_macro_right5);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                double $org_scalatest_assert_macro_right6 = 0.6;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                double $org_scalatest_assert_macro_left7 = stats.impurity();
                double $org_scalatest_assert_macro_right7 = 0.2;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 > $org_scalatest_assert_macro_right7);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression stump with binary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$44 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$45 = qual$3.parallelize$default$2();
                RDD rdd = qual$3.parallelize((Seq)x$44, x$45, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$46 = Algo$.MODULE$.Regression();
                Variance$ x$47 = Variance$.MODULE$;
                int x$48 = 2;
                int x$49 = 100;
                Map x$50 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                int x$51 = Strategy$.MODULE$.$lessinit$greater$default$4();
                Enumeration.Value x$52 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$53 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$54 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$55 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$56 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$57 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$58 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$46, (Impurity)x$47, x$48, x$51, x$49, x$52, x$50, x$53, x$54, x$55, x$56, x$57, x$58);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$2) {
                        return x$2.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateRegressor(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed label 0 for Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$59 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$60 = qual$4.parallelize$default$2();
                RDD rdd = qual$4.parallelize((Seq)x$59, x$60, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$3) {
                        return x$3.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Option $org_scalatest_assert_macro_left3 = rootNode.stats();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed label 1 for Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$5 = this.$outer.sc();
                WrappedArray x$61 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$62 = qual$5.parallelize$default$2();
                RDD rdd = qual$5.parallelize((Seq)x$61, x$62, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$4) {
                        return x$4.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Option $org_scalatest_assert_macro_left3 = rootNode.stats();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed label 0 for Entropy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$6 = this.$outer.sc();
                WrappedArray x$63 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$64 = qual$6.parallelize$default$2();
                RDD rdd = qual$6.parallelize((Seq)x$63, x$64, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$5) {
                        return x$5.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Option $org_scalatest_assert_macro_left3 = rootNode.stats();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed label 1 for Entropy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$7 = this.$outer.sc();
                WrappedArray x$65 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$66 = qual$7.parallelize$default$2();
                RDD rdd = qual$7.parallelize((Seq)x$65, x$66, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$6) {
                        return x$6.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Option $org_scalatest_assert_macro_left3 = rootNode.stats();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with 3-ary (unordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
                SparkContext qual$8 = this.$outer.sc();
                WrappedArray x$67 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$68 = qual$8.parallelize$default$2();
                RDD rdd = qual$8.parallelize((Seq)x$67, x$68, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$69 = Algo$.MODULE$.Classification();
                Gini$ x$70 = Gini$.MODULE$;
                int x$71 = 4;
                int x$72 = 3;
                Map x$73 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$74 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$75 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$76 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$77 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$78 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$79 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$80 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$81 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$69, (Impurity)x$70, x$71, x$72, x$74, x$75, x$73, x$76, x$77, x$78, x$79, x$80, x$81);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$7) {
                        return x$7.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                List $org_scalatest_assert_macro_left3 = split.categories();
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with 1 continuous feature, to check off-by-1 error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
                SparkContext qual$9 = this.$outer.sc();
                WrappedArray x$82 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$83 = qual$9.parallelize$default$2();
                RDD rdd = qual$9.parallelize((Seq)x$82, x$83, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with 2 continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 2.0)}))))});
                SparkContext qual$10 = this.$outer.sc();
                WrappedArray x$84 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$85 = qual$10.parallelize$default$2();
                RDD rdd = qual$10.parallelize((Seq)x$84, x$85, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Split)model.topNode().split().get()).feature()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with unordered categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int maxBins = 2 * ((int)package$.MODULE$.pow(2.0, 2.0) - 1);
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
                SparkContext qual$11 = this.$outer.sc();
                WrappedArray x$86 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$87 = qual$11.parallelize$default$2();
                RDD rdd = qual$11.parallelize((Seq)x$86, x$87, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$88 = Algo$.MODULE$.Classification();
                Gini$ x$89 = Gini$.MODULE$;
                int x$90 = 4;
                int x$91 = 3;
                int x$92 = maxBins;
                Map x$93 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$94 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$95 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$96 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$97 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$98 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$99 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$100 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$88, (Impurity)x$89, x$90, x$91, x$92, x$94, x$93, x$95, x$96, x$97, x$98, x$99, x$100);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$8) {
                        return x$8.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Node rootNode = model.topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                List $org_scalatest_assert_macro_left5 = split.categories();
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right6 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                InformationGainStats gain = (InformationGainStats)rootNode.stats().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)gain.leftImpurity()));
                int $org_scalatest_assert_macro_right7 = 0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)gain.rightImpurity()));
                int $org_scalatest_assert_macro_right8 = 0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
                SparkContext qual$12 = this.$outer.sc();
                WrappedArray x$101 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$102 = qual$12.parallelize$default$2();
                RDD rdd = qual$12.parallelize((Seq)x$101, x$102, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 3, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
                Node rootNode = model.topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right2 = FeatureType$.MODULE$.Continuous();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                double $org_scalatest_assert_macro_left3 = split.threshold();
                int $org_scalatest_assert_macro_right3 = 1980;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                double $org_scalatest_assert_macro_left4 = split.threshold();
                int $org_scalatest_assert_macro_right4 = 2020;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < (double)$org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with continuous + unordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
                SparkContext qual$13 = this.$outer.sc();
                WrappedArray x$103 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$104 = qual$13.parallelize$default$2();
                RDD rdd = qual$13.parallelize((Seq)x$103, x$104, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$105 = Algo$.MODULE$.Classification();
                Gini$ x$106 = Gini$.MODULE$;
                int x$107 = 4;
                int x$108 = 3;
                int x$109 = 100;
                Map x$110 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$111 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$112 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$113 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$114 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$115 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$116 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$117 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$105, (Impurity)x$106, x$107, x$108, x$109, x$111, x$110, x$112, x$113, x$114, x$115, x$116, x$117);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$9) {
                        return x$9.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
                Node rootNode = model.topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right2 = FeatureType$.MODULE$.Continuous();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                double $org_scalatest_assert_macro_left3 = split.threshold();
                int $org_scalatest_assert_macro_right3 = 1980;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                double $org_scalatest_assert_macro_left4 = split.threshold();
                int $org_scalatest_assert_macro_right4 = 2020;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < (double)$org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with 10-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
                SparkContext qual$14 = this.$outer.sc();
                WrappedArray x$118 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$119 = qual$14.parallelize$default$2();
                RDD rdd = qual$14.parallelize((Seq)x$118, x$119, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$120 = Algo$.MODULE$.Classification();
                Gini$ x$121 = Gini$.MODULE$;
                int x$122 = 4;
                int x$123 = 3;
                int x$124 = 100;
                Map x$125 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
                Enumeration.Value x$126 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$127 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$128 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$129 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$130 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$131 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$132 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$120, (Impurity)x$121, x$122, x$123, x$124, x$126, x$125, x$127, x$128, x$129, x$130, x$131, x$132);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(org.apache.spark.mllib.regression.LabeledPoint x$10) {
                        return x$10.asML();
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                List $org_scalatest_assert_macro_left3 = split.categories();
                double $org_scalatest_assert_macro_right3 = 1.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification tree with 10-ary (ordered) categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
                SparkContext qual$15 = this.$outer.sc();
                WrappedArray x$133 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$134 = qual$15.parallelize$default$2();
                RDD rdd = qual$15.parallelize((Seq)x$133, x$134, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$135 = Algo$.MODULE$.Classification();
                Gini$ x$136 = Gini$.MODULE$;
                int x$137 = 4;
                int x$138 = 3;
                int x$139 = 10;
                Map x$140 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
                Enumeration.Value x$141 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$142 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$143 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$144 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$145 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$146 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$147 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$135, (Impurity)x$136, x$137, x$138, x$139, x$141, x$140, x$142, x$143, x$144, x$145, x$146, x$147);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.6);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("split must satisfy min instances per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
                SparkContext qual$16 = this.$outer.sc();
                WrappedArray x$148 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$149 = qual$16.parallelize$default$2();
                RDD rdd = qual$16.parallelize((Seq)x$148, x$149, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$150 = Algo$.MODULE$.Classification();
                Gini$ x$151 = Gini$.MODULE$;
                int x$152 = 2;
                int x$153 = 2;
                int x$154 = 2;
                int x$155 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$156 = Strategy$.MODULE$.$lessinit$greater$default$6();
                Map x$157 = Strategy$.MODULE$.$lessinit$greater$default$7();
                double x$158 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$159 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$160 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$161 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$162 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$150, (Impurity)x$151, x$152, x$153, x$155, x$156, x$157, x$154, x$158, x$159, x$160, x$161, x$162);
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.topNode().isLeaf(), "model.topNode.isLeaf");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left = model.topNode().predict().predict();
                double $org_scalatest_assert_macro_right = 0.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double[] predicts = (double[])rdd.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTreeModel model$3;

                    public final double apply(org.apache.spark.mllib.regression.LabeledPoint p) {
                        return this.model$3.predict(p.features());
                    }
                    {
                        this.model$3 = model$3;
                    }
                }, ClassTag$.MODULE$.Double()).collect();
                Predef$.MODULE$.doubleArrayOps(predicts).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final void apply(double predict) {
                        this.apply$mcVD$sp(predict);
                    }

                    public void apply$mcVD$sp(double predict) {
                        double $org_scalatest_assert_macro_left = predict;
                        double $org_scalatest_assert_macro_right = 0.0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Node rootNode = model.topNode();
                Option $org_scalatest_assert_macro_left2 = rootNode.stats();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ DecisionTreeSuite org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("do not choose split that does not satisfy min instance per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})))});
                SparkContext qual$17 = this.$outer.sc();
                WrappedArray x$163 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$164 = qual$17.parallelize$default$2();
                RDD rdd = qual$17.parallelize((Seq)x$163, x$164, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$165 = Algo$.MODULE$.Classification();
                Gini$ x$166 = Gini$.MODULE$;
                int x$167 = 2;
                int x$168 = 2;
                Map x$169 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                int x$170 = 2;
                int x$171 = 2;
                Enumeration.Value x$172 = Strategy$.MODULE$.$lessinit$greater$default$6();
                double x$173 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$174 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$175 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$176 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$177 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$165, (Impurity)x$166, x$168, x$170, x$167, x$172, x$169, x$171, x$173, x$174, x$175, x$176, x$177);
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                InformationGainStats gainStats = (InformationGainStats)rootNode.stats().get();
                int $org_scalatest_assert_macro_left = split.feature();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left2 = gainStats.gain();
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 >= (double)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double $org_scalatest_assert_macro_left3 = gainStats.impurity();
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 >= (double)$org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("split must satisfy min info gain requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
                SparkContext qual$18 = this.$outer.sc();
                WrappedArray x$178 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$179 = qual$18.parallelize$default$2();
                RDD input = qual$18.parallelize((Seq)x$178, x$179, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
                Enumeration.Value x$180 = Algo$.MODULE$.Classification();
                Gini$ x$181 = Gini$.MODULE$;
                int x$182 = 2;
                int x$183 = 2;
                double x$184 = 1.0;
                int x$185 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$186 = Strategy$.MODULE$.$lessinit$greater$default$6();
                Map x$187 = Strategy$.MODULE$.$lessinit$greater$default$7();
                int x$188 = Strategy$.MODULE$.$lessinit$greater$default$8();
                int x$189 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$190 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$191 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$192 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$180, (Impurity)x$181, x$182, x$183, x$185, x$186, x$187, x$188, x$184, x$189, x$190, x$191, x$192);
                DecisionTreeModel model = DecisionTree$.MODULE$.train(input, strategy);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.topNode().isLeaf(), "model.topNode.isLeaf");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left = model.topNode().predict().predict();
                double $org_scalatest_assert_macro_right = 0.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double[] predicts = (double[])input.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTreeModel model$4;

                    public final double apply(org.apache.spark.mllib.regression.LabeledPoint p) {
                        return this.model$4.predict(p.features());
                    }
                    {
                        this.model$4 = model$4;
                    }
                }, ClassTag$.MODULE$.Double()).collect();
                Predef$.MODULE$.doubleArrayOps(predicts).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;

                    public final void apply(double predict) {
                        this.apply$mcVD$sp(predict);
                    }

                    public void apply$mcVD$sp(double predict) {
                        double $org_scalatest_assert_macro_left = predict;
                        double $org_scalatest_assert_macro_right = 0.0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Option $org_scalatest_assert_macro_left2 = model.topNode().stats();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ DecisionTreeSuite org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Node.subtreeIterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeModel model = DecisionTreeSuite$.MODULE$.createModel(Algo$.MODULE$.Classification());
                int[] nodeIds = (int[])Predef$.MODULE$.intArrayOps((int[])model.topNode().subtreeIterator().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$11) {
                        return x$11.id();
                    }
                }).toArray(ClassTag$.MODULE$.Int())).sorted((Ordering)Ordering.Int$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(nodeIds);
                int[] $org_scalatest_assert_macro_right = DecisionTreeSuite$.MODULE$.org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()}).foreach((Function1)new Serializable(this, tempDir, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;
                    private final File tempDir$1;
                    private final String path$1;

                    public final void apply(Enumeration.Value algo) {
                        DecisionTreeModel model = DecisionTreeSuite$.MODULE$.createModel(algo);
                        try {
                            model.save(this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().sc(), this.path$1);
                            DecisionTreeModel sameModel = DecisionTreeModel$.MODULE$.load(this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().sc(), this.path$1);
                            DecisionTreeSuite$.MODULE$.checkEqual(model, sameModel);
                            return;
                        }
                        finally {
                            Utils$.MODULE$.deleteRecursively(this.tempDir$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.path$1 = path$1;
                    }
                });
            }

            public /* synthetic */ DecisionTreeSuite org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

