/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.util.StatCounter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class EnsembleTestHelper$ {
    public static final EnsembleTestHelper$ MODULE$;

    static {
        new EnsembleTestHelper$();
    }

    public void testRandomArrays(double[][] data, int numCols, double expectedMean, double expectedStddev, double epsilon) {
        ArrayBuffer values = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])data).foreach((Function1)new Serializable(numCols, values){
            public static final long serialVersionUID = 0L;
            private final int numCols$1;
            private final ArrayBuffer values$1;

            public final ArrayBuffer<Object> apply(double[] row) {
                Predef$.MODULE$.assert(Predef$.MODULE$.doubleArrayOps(row).size() == this.numCols$1);
                return this.values$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps(row));
            }
            {
                this.numCols$1 = numCols$1;
                this.values$1 = values$1;
            }
        });
        StatCounter stats = new StatCounter((TraversableOnce)values);
        Predef$.MODULE$.assert(package$.MODULE$.abs(stats.mean() - expectedMean) < epsilon);
        Predef$.MODULE$.assert(package$.MODULE$.abs(stats.stdev() - expectedStddev) < epsilon);
    }

    public void validateClassifier(TreeEnsembleModel model, Seq<LabeledPoint> input, double requiredAccuracy) {
        Seq predictions = (Seq)input.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final TreeEnsembleModel model$1;

            public final double apply(LabeledPoint x) {
                return this.model$1.predict(x.features());
            }
            {
                this.model$1 = model$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, LabeledPoint> x0$1) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$1;
                if (tuple2 != null) {
                    LabeledPoint expected;
                    double prediction = tuple2._1$mcD$sp();
                    boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        double accuracy = (double)(input.length() - numOffPredictions) / (double)input.length();
        Predef$.MODULE$.assert(accuracy >= requiredAccuracy, (Function0)new Serializable(requiredAccuracy, accuracy){
            public static final long serialVersionUID = 0L;
            private final double requiredAccuracy$1;
            private final double accuracy$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateClassifier calculated accuracy ", " but required ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.accuracy$1), BoxesRunTime.boxToDouble((double)this.requiredAccuracy$1)}));
            }
            {
                this.requiredAccuracy$1 = requiredAccuracy$1;
                this.accuracy$1 = accuracy$1;
            }
        });
    }

    public void validateRegressor(TreeEnsembleModel model, Seq<LabeledPoint> input, double required, String metricName) {
        String string;
        block4: {
            double d;
            block3: {
                Seq errors;
                block2: {
                    Seq predictions = (Seq)input.map((Function1)new Serializable(model){
                        public static final long serialVersionUID = 0L;
                        private final TreeEnsembleModel model$2;

                        public final double apply(LabeledPoint x) {
                            return this.model$2.predict(x.features());
                        }
                        {
                            this.model$2 = model$2;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    errors = (Seq)((TraversableLike)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple2<Object, LabeledPoint> x0$2) {
                            Tuple2<Object, LabeledPoint> tuple2 = x0$2;
                            if (tuple2 != null) {
                                double prediction = tuple2._1$mcD$sp();
                                LabeledPoint point = (LabeledPoint)tuple2._2();
                                double d = point.label() - prediction;
                                return d;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    String string2 = string = metricName;
                    if ("mse" != null ? !"mse".equals(string2) : string2 != null) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)errors.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(double err) {
                            return this.apply$mcDD$sp(err);
                        }

                        public double apply$mcDD$sp(double err) {
                            return err * err;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)errors.size();
                    break block3;
                }
                String string3 = string;
                if ("mae" != null ? !"mae".equals(string3) : string3 != null) break block4;
                d = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)errors.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.abs(x);
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)errors.size();
            }
            double metric = d;
            Predef$.MODULE$.assert(metric <= required, (Function0)new Serializable(required, metricName, metric){
                public static final long serialVersionUID = 0L;
                private final double required$1;
                private final String metricName$1;
                private final double metric$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateRegressor calculated ", " ", " but required ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1, BoxesRunTime.boxToDouble((double)this.metric$1), BoxesRunTime.boxToDouble((double)this.required$1)}));
                }
                {
                    this.required$1 = required$1;
                    this.metricName$1 = metricName$1;
                    this.metric$1 = metric$1;
                }
            });
            return;
        }
        throw new MatchError((Object)string);
    }

    public String validateRegressor$default$4() {
        return "mse";
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateOrderedLabeledPoints(int numFeatures, int numInstances) {
        void var3_3;
        LabeledPoint[] arr = new LabeledPoint[numInstances];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInstances).foreach$mVc$sp((Function1)new Serializable(numFeatures, numInstances, arr){
            public static final long serialVersionUID = 0L;
            private final int numFeatures$1;
            private final int numInstances$1;
            private final LabeledPoint[] arr$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double label = i < this.numInstances$1 / 10 ? 0.0 : (i < this.numInstances$1 / 2 ? 1.0 : ((double)i < (double)this.numInstances$1 * 0.9 ? 0.0 : 1.0));
                double[] features = (double[])Array$.MODULE$.fill(this.numFeatures$1, (Function0)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.i$1;
                    }
                    {
                        this.i$1 = i$1;
                    }
                }, ClassTag$.MODULE$.Double());
                this.arr$1[i] = new LabeledPoint(label, Vectors$.MODULE$.dense(features));
            }
            {
                this.numFeatures$1 = numFeatures$1;
                this.numInstances$1 = numInstances$1;
                this.arr$1 = arr$1;
            }
        });
        return var3_3;
    }

    private EnsembleTestHelper$() {
        MODULE$ = this;
    }
}

