/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.GradientBoostedTreesSuite$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.loss.AbsoluteError$;
import org.apache.spark.mllib.tree.loss.LogLoss$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.loss.SquaredError$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001b\tIrI]1eS\u0016tGOQ8pgR,G\r\u0016:fKN\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003ue\u0016,'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019\u0011\u0002\u0004\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003/Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001e5\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u000f\u0019!#\u0001#\u0001\u0007K\u0005IrI]1eS\u0016tGOQ8pgR,G\r\u0016:fKN\u001cV/\u001b;f!\t\u0011cE\u0002\u0004\u0002\u0005!\u0005aaJ\n\u0004M!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u0002*_%\u0011\u0001G\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006?\u0019\"\tA\r\u000b\u0002K!9AG\nb\u0001\n\u0003)\u0014\u0001\u0005;fgR\u001cu.\u001c2j]\u0006$\u0018n\u001c8t+\u00051\u0004cA\u00158s%\u0011\u0001H\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0006SibthP\u0005\u0003w)\u0012a\u0001V;qY\u0016\u001c\u0004CA\u0015>\u0013\tq$FA\u0002J]R\u0004\"!\u000b!\n\u0005\u0005S#A\u0002#pk\ndW\r\u0003\u0004DM\u0001\u0006IAN\u0001\u0012i\u0016\u001cHoQ8nE&t\u0017\r^5p]N\u0004\u0003bB#'\u0005\u0004%\tAR\u0001\u0005I\u0006$\u0018-F\u0001H!\rIs\u0007\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\u0012\t!B]3he\u0016\u001c8/[8o\u0013\ti%J\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0003\u0004PM\u0001\u0006IaR\u0001\u0006I\u0006$\u0018\r\t\u0005\b#\u001a\u0012\r\u0011\"\u0001G\u0003%!(/Y5o\t\u0006$\u0018\r\u0003\u0004TM\u0001\u0006IaR\u0001\u000biJ\f\u0017N\u001c#bi\u0006\u0004\u0003bB+'\u0005\u0004%\tAR\u0001\rm\u0006d\u0017\u000eZ1uK\u0012\u000bG/\u0019\u0005\u0007/\u001a\u0002\u000b\u0011B$\u0002\u001bY\fG.\u001b3bi\u0016$\u0015\r^1!\u0011\u001dIf%!A\u0005\ni\u000b1B]3bIJ+7o\u001c7wKR\t1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006!A.\u00198h\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\r=\u0013'.Z2u\u0001")
public class GradientBoostedTreesSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static LabeledPoint[] validateData() {
        return GradientBoostedTreesSuite$.MODULE$.validateData();
    }

    public static LabeledPoint[] trainData() {
        return GradientBoostedTreesSuite$.MODULE$.trainData();
    }

    public static LabeledPoint[] data() {
        return GradientBoostedTreesSuite$.MODULE$.data();
    }

    public static Tuple3<Object, Object, Object>[] testCombinations() {
        return GradientBoostedTreesSuite$.MODULE$.testCombinations();
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public GradientBoostedTreesSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Regression with continuous features: SquaredError", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple3<Object, Object, Object> x0$1) {
                        Tuple3<Object, Object, Object> tuple3 = x0$1;
                        if (tuple3 == null) throw new MatchError(tuple3);
                        int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        RDD rdd = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        Enumeration.Value x$2 = Algo$.MODULE$.Regression();
                        Variance$ x$3 = Variance$.MODULE$;
                        int x$4 = 2;
                        Map x$5 = Predef$.MODULE$.Map().empty();
                        double x$6 = subsamplingRate;
                        int x$7 = Strategy$.MODULE$.$lessinit$greater$default$4();
                        int x$8 = Strategy$.MODULE$.$lessinit$greater$default$5();
                        Enumeration.Value x$9 = Strategy$.MODULE$.$lessinit$greater$default$6();
                        int x$10 = Strategy$.MODULE$.$lessinit$greater$default$8();
                        double x$11 = Strategy$.MODULE$.$lessinit$greater$default$9();
                        int x$12 = Strategy$.MODULE$.$lessinit$greater$default$10();
                        boolean x$13 = Strategy$.MODULE$.$lessinit$greater$default$12();
                        int x$14 = Strategy$.MODULE$.$lessinit$greater$default$13();
                        Strategy treeStrategy = new Strategy(x$2, (Impurity)x$3, x$4, x$7, x$8, x$9, x$5, x$10, x$11, x$12, x$6, x$13, x$14);
                        BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)SquaredError$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                        GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).size()));
                        int $org_scalatest_assert_macro_right = numIterations;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        try {
                            EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.06, EnsembleTestHelper$.MODULE$.validateRegressor$default$4());
                        }
                        catch (AssertionError assertionError) {
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().logError((Function0)new Serializable(this, numIterations, learningRate, subsamplingRate){
                                public static final long serialVersionUID = 0L;
                                private final int numIterations$1;
                                private final double learningRate$1;
                                private final double subsamplingRate$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED for numIterations=", ", learningRate=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIterations$1), BoxesRunTime.boxToDouble((double)this.learningRate$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" subsamplingRate=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.subsamplingRate$1)}))).toString();
                                }
                                {
                                    this.numIterations$1 = numIterations$1;
                                    this.learningRate$1 = learningRate$1;
                                    this.subsamplingRate$1 = subsamplingRate$1;
                                }
                            });
                            throw assertionError;
                        }
                        RDD remappedInput = rdd.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LabeledPoint apply(LabeledPoint x) {
                                return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                            }
                        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, treeStrategy);
                        String $org_scalatest_assert_macro_left2 = ((DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).head()).toString();
                        String $org_scalatest_assert_macro_right2 = dt.toString();
                        String string = $org_scalatest_assert_macro_left2;
                        String string2 = $org_scalatest_assert_macro_right2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression with continuous features: Absolute Error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple3<Object, Object, Object> x0$2) {
                        Tuple3<Object, Object, Object> tuple3 = x0$2;
                        if (tuple3 == null) throw new MatchError(tuple3);
                        int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        RDD rdd = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        Enumeration.Value x$15 = Algo$.MODULE$.Regression();
                        Variance$ x$16 = Variance$.MODULE$;
                        int x$17 = 2;
                        Map x$18 = Predef$.MODULE$.Map().empty();
                        double x$19 = subsamplingRate;
                        int x$20 = Strategy$.MODULE$.$lessinit$greater$default$4();
                        int x$21 = Strategy$.MODULE$.$lessinit$greater$default$5();
                        Enumeration.Value x$22 = Strategy$.MODULE$.$lessinit$greater$default$6();
                        int x$23 = Strategy$.MODULE$.$lessinit$greater$default$8();
                        double x$24 = Strategy$.MODULE$.$lessinit$greater$default$9();
                        int x$25 = Strategy$.MODULE$.$lessinit$greater$default$10();
                        boolean x$26 = Strategy$.MODULE$.$lessinit$greater$default$12();
                        int x$27 = Strategy$.MODULE$.$lessinit$greater$default$13();
                        Strategy treeStrategy = new Strategy(x$15, (Impurity)x$16, x$17, x$20, x$21, x$22, x$18, x$23, x$24, x$25, x$19, x$26, x$27);
                        BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)AbsoluteError$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                        GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).size()));
                        int $org_scalatest_assert_macro_right = numIterations;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        try {
                            EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.85, "mae");
                        }
                        catch (AssertionError assertionError) {
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().logError((Function0)new Serializable(this, numIterations, learningRate, subsamplingRate){
                                public static final long serialVersionUID = 0L;
                                private final int numIterations$2;
                                private final double learningRate$2;
                                private final double subsamplingRate$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED for numIterations=", ", learningRate=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIterations$2), BoxesRunTime.boxToDouble((double)this.learningRate$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" subsamplingRate=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.subsamplingRate$2)}))).toString();
                                }
                                {
                                    this.numIterations$2 = numIterations$2;
                                    this.learningRate$2 = learningRate$2;
                                    this.subsamplingRate$2 = subsamplingRate$2;
                                }
                            });
                            throw assertionError;
                        }
                        RDD remappedInput = rdd.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LabeledPoint apply(LabeledPoint x) {
                                return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                            }
                        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, treeStrategy);
                        String $org_scalatest_assert_macro_left2 = ((DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).head()).toString();
                        String $org_scalatest_assert_macro_right2 = dt.toString();
                        String string = $org_scalatest_assert_macro_left2;
                        String string2 = $org_scalatest_assert_macro_right2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features: Log Loss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple3<Object, Object, Object> x0$3) {
                        Tuple3<Object, Object, Object> tuple3 = x0$3;
                        if (tuple3 == null) throw new MatchError(tuple3);
                        int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        RDD rdd = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        Enumeration.Value x$28 = Algo$.MODULE$.Classification();
                        Variance$ x$29 = Variance$.MODULE$;
                        int x$30 = 2;
                        int x$31 = 2;
                        Map x$32 = Predef$.MODULE$.Map().empty();
                        double x$33 = subsamplingRate;
                        int x$34 = Strategy$.MODULE$.$lessinit$greater$default$5();
                        Enumeration.Value x$35 = Strategy$.MODULE$.$lessinit$greater$default$6();
                        int x$36 = Strategy$.MODULE$.$lessinit$greater$default$8();
                        double x$37 = Strategy$.MODULE$.$lessinit$greater$default$9();
                        int x$38 = Strategy$.MODULE$.$lessinit$greater$default$10();
                        boolean x$39 = Strategy$.MODULE$.$lessinit$greater$default$12();
                        int x$40 = Strategy$.MODULE$.$lessinit$greater$default$13();
                        Strategy treeStrategy = new Strategy(x$28, (Impurity)x$29, x$30, x$31, x$34, x$35, x$32, x$36, x$37, x$38, x$33, x$39, x$40);
                        BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)LogLoss$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                        GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).size()));
                        int $org_scalatest_assert_macro_right = numIterations;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        try {
                            EnsembleTestHelper$.MODULE$.validateClassifier((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.9);
                        }
                        catch (AssertionError assertionError) {
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().logError((Function0)new Serializable(this, numIterations, learningRate, subsamplingRate){
                                public static final long serialVersionUID = 0L;
                                private final int numIterations$3;
                                private final double learningRate$3;
                                private final double subsamplingRate$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED for numIterations=", ", learningRate=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIterations$3), BoxesRunTime.boxToDouble((double)this.learningRate$3)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" subsamplingRate=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.subsamplingRate$3)}))).toString();
                                }
                                {
                                    this.numIterations$3 = numIterations$3;
                                    this.learningRate$3 = learningRate$3;
                                    this.subsamplingRate$3 = subsamplingRate$3;
                                }
                            });
                            throw assertionError;
                        }
                        RDD remappedInput = rdd.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LabeledPoint apply(LabeledPoint x) {
                                return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                            }
                        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        Strategy ensembleStrategy = treeStrategy.copy();
                        ensembleStrategy.algo_$eq(Algo$.MODULE$.Regression());
                        ensembleStrategy.impurity_$eq((Impurity)Variance$.MODULE$);
                        DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, ensembleStrategy);
                        String $org_scalatest_assert_macro_left2 = ((DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).head()).toString();
                        String $org_scalatest_assert_macro_right2 = dt.toString();
                        String string = $org_scalatest_assert_macro_left2;
                        String string2 = $org_scalatest_assert_macro_right2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-5496: BoostingStrategy.defaultParams should recognize Classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"classification", "Classification", "regression", "Regression"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BoostingStrategy apply(String algo) {
                        return BoostingStrategy$.MODULE$.defaultParams(algo);
                    }
                });
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                DecisionTreeModel[] trees = (DecisionTreeModel[])((TraversableOnce)package$.MODULE$.Range().apply(0, 3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DecisionTreeModel apply(int x$1) {
                        return DecisionTreeSuite$.MODULE$.createModel(Algo$.MODULE$.Regression());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DecisionTreeModel.class));
                double[] treeWeights = new double[]{0.1, 0.3, 1.1};
                Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()}).foreach((Function1)new Serializable(this, tempDir, path, trees, treeWeights){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final File tempDir$1;
                    private final String path$1;
                    private final DecisionTreeModel[] trees$1;
                    private final double[] treeWeights$1;

                    public final void apply(Enumeration.Value algo) {
                        GradientBoostedTreesModel model = new GradientBoostedTreesModel(algo, this.trees$1, this.treeWeights$1);
                        try {
                            model.save(this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc(), this.path$1);
                            GradientBoostedTreesModel sameModel = GradientBoostedTreesModel$.MODULE$.load(this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc(), this.path$1);
                            Enumeration.Value $org_scalatest_assert_macro_left = model.algo();
                            Enumeration.Value $org_scalatest_assert_macro_right = sameModel.algo();
                            Enumeration.Value value = $org_scalatest_assert_macro_left;
                            Enumeration.Value value2 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(value != null ? !value.equals(value2) : value2 != null));
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.trees()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sameModel.trees()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<DecisionTreeModel, DecisionTreeModel> x0$4) {
                                    Tuple2<DecisionTreeModel, DecisionTreeModel> tuple2 = x0$4;
                                    if (tuple2 != null) {
                                        DecisionTreeModel treeA = (DecisionTreeModel)tuple2._1();
                                        DecisionTreeModel treeB = (DecisionTreeModel)tuple2._2();
                                        DecisionTreeSuite$.MODULE$.checkEqual(treeA, treeB);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            });
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(model.treeWeights());
                            double[] $org_scalatest_assert_macro_right2 = sameModel.treeWeights();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            return;
                        }
                        finally {
                            Utils$.MODULE$.deleteRecursively(this.tempDir$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.path$1 = path$1;
                        this.trees$1 = trees$1;
                        this.treeWeights$1 = treeWeights$1;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                this.$outer.sc().setCheckpointDir(path);
                RDD rdd = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$41 = Algo$.MODULE$.Regression();
                Variance$ x$42 = Variance$.MODULE$;
                int x$43 = 2;
                Map x$44 = Predef$.MODULE$.Map().empty();
                int x$45 = 2;
                int x$46 = Strategy$.MODULE$.$lessinit$greater$default$4();
                int x$47 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$48 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$49 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$50 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$51 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$52 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$53 = Strategy$.MODULE$.$lessinit$greater$default$12();
                Strategy treeStrategy = new Strategy(x$41, (Impurity)x$42, x$43, x$46, x$47, x$48, x$44, x$49, x$50, x$51, x$52, x$53, x$45);
                BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)SquaredError$.MODULE$, 5, 0.1, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                this.$outer.sc().checkpointDir_$eq((Option)None$.MODULE$);
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

