/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.RandomForestSuite$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.tree.model.RandomForestModel$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001I2A!\u0001\u0002\u0001\u001b\t\t\"+\u00198e_64uN]3tiN+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001\u0002;sK\u0016T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dI\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqRDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000by\u0001A\u0011A\u0010\u0002]\tLg.\u0019:z\u00072\f7o]5gS\u000e\fG/[8o)\u0016\u001cHoV5uQ\u000e{g\u000e^5ok>,8OR3biV\u0014Xm\u001d\u000b\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\")q%\ba\u0001Q\u0005A1\u000f\u001e:bi\u0016<\u0017\u0010\u0005\u0002*Y5\t!F\u0003\u0002,\u0005\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\f\u0016\u0003\u0011M#(/\u0019;fOfDQa\f\u0001\u0005\u0002A\nAE]3he\u0016\u001c8/[8o)\u0016\u001cHoV5uQ\u000e{g\u000e^5ok>,8OR3biV\u0014Xm\u001d\u000b\u0003AEBQa\n\u0018A\u0002!\u0002")
public class RandomForestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    public void binaryClassificationTestWithContinuousFeatures(Strategy strategy) {
        LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000);
        SparkContext qual$1 = this.sc();
        WrappedArray x$2 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$3 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize((Seq)x$2, x$3, ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numTrees = 1;
        RandomForestModel rf = RandomForest$.MODULE$.trainClassifier(rdd, strategy, numTrees, "auto", 123);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rf.trees().length));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        DecisionTreeModel rfTree = rf.trees()[0];
        DecisionTreeModel dt = DecisionTree$.MODULE$.train(rdd, strategy);
        EnsembleTestHelper$.MODULE$.validateClassifier((TreeEnsembleModel)rf, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
        DecisionTreeSuite$.MODULE$.validateClassifier(dt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
        String $org_scalatest_assert_macro_left2 = rfTree.toString();
        String $org_scalatest_assert_macro_right2 = dt.toString();
        String string = $org_scalatest_assert_macro_left2;
        String string2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    public void regressionTestWithContinuousFeatures(Strategy strategy) {
        LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000);
        SparkContext qual$2 = this.sc();
        WrappedArray x$30 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$31 = qual$2.parallelize$default$2();
        RDD rdd = qual$2.parallelize((Seq)x$30, x$31, ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numTrees = 1;
        RandomForestModel rf = RandomForest$.MODULE$.trainRegressor(rdd, strategy, numTrees, "auto", 123);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rf.trees().length));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        DecisionTreeModel rfTree = rf.trees()[0];
        DecisionTreeModel dt = DecisionTree$.MODULE$.train(rdd, strategy);
        EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)rf, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.01, EnsembleTestHelper$.MODULE$.validateRegressor$default$4());
        DecisionTreeSuite$.MODULE$.validateRegressor(dt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.01);
        String $org_scalatest_assert_macro_left2 = rfTree.toString();
        String $org_scalatest_assert_macro_right2 = dt.toString();
        String string = $org_scalatest_assert_macro_left2;
        String string2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    public RandomForestSuite() {
        TempDirectory$class.$init$(this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Binary classification with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$4 = Algo$.MODULE$.Classification();
                Gini$ x$5 = Gini$.MODULE$;
                int x$6 = 2;
                int x$7 = 2;
                Map x$8 = categoricalFeaturesInfo;
                int x$9 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$10 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$11 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$12 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$13 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$14 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$15 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$16 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$4, (Impurity)x$5, x$6, x$7, x$9, x$10, x$8, x$11, x$12, x$13, x$14, x$15, x$16);
                this.$outer.binaryClassificationTestWithContinuousFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features and node Id cache : comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$17 = Algo$.MODULE$.Classification();
                Gini$ x$18 = Gini$.MODULE$;
                int x$19 = 2;
                int x$20 = 2;
                Map x$21 = categoricalFeaturesInfo;
                boolean x$22 = true;
                int x$23 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$24 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$25 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$26 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$27 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$28 = Strategy$.MODULE$.$lessinit$greater$default$11();
                int x$29 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$17, (Impurity)x$18, x$19, x$20, x$23, x$24, x$21, x$25, x$26, x$27, x$28, x$22, x$29);
                this.$outer.binaryClassificationTestWithContinuousFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$32 = Algo$.MODULE$.Regression();
                Variance$ x$33 = Variance$.MODULE$;
                int x$34 = 2;
                int x$35 = 10;
                int x$36 = 2;
                Map x$37 = categoricalFeaturesInfo;
                Enumeration.Value x$38 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$39 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$40 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$41 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$42 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$43 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$44 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$32, (Impurity)x$33, x$34, x$36, x$35, x$38, x$37, x$39, x$40, x$41, x$42, x$43, x$44);
                this.$outer.regressionTestWithContinuousFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression with continuous features and node Id cache : comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$45 = Algo$.MODULE$.Regression();
                Variance$ x$46 = Variance$.MODULE$;
                int x$47 = 2;
                int x$48 = 10;
                int x$49 = 2;
                Map x$50 = categoricalFeaturesInfo;
                boolean x$51 = true;
                Enumeration.Value x$52 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$53 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$54 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$55 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$56 = Strategy$.MODULE$.$lessinit$greater$default$11();
                int x$57 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$45, (Impurity)x$46, x$47, x$49, x$48, x$52, x$50, x$53, x$54, x$55, x$56, x$51, x$57);
                this.$outer.regressionTestWithContinuousFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alternating categorical and continuous features with multiclass labels to test indexing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 3.0, 1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0, 1.0, 2.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 6.0, 3.0}))), new LabeledPoint(2.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0, 3.0, 2.0})))};
                Map categoricalFeaturesInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4))}));
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$58 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$59 = qual$3.parallelize$default$2();
                RDD input = qual$3.parallelize((Seq)x$58, x$59, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$60 = Algo$.MODULE$.Classification();
                Gini$ x$61 = Gini$.MODULE$;
                int x$62 = 5;
                int x$63 = 3;
                Map x$64 = categoricalFeaturesInfo;
                int x$65 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$66 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$67 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$68 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$69 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$70 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$71 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$72 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$60, (Impurity)x$61, x$62, x$63, x$65, x$66, x$64, x$67, x$68, x$69, x$70, x$71, x$72);
                RandomForestModel model = RandomForest$.MODULE$.trainClassifier(input, strategy, 2, "sqrt", 12345);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("subsampling rate in RandomForest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(5, 20);
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$73 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$74 = qual$4.parallelize$default$2();
                RDD rdd = qual$4.parallelize((Seq)x$73, x$74, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$75 = Algo$.MODULE$.Classification();
                Gini$ x$76 = Gini$.MODULE$;
                int x$77 = 2;
                int x$78 = 2;
                Map x$79 = Predef$.MODULE$.Map().empty();
                boolean x$80 = true;
                int x$81 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$82 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$83 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$84 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$85 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$86 = Strategy$.MODULE$.$lessinit$greater$default$11();
                int x$87 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$75, (Impurity)x$76, x$77, x$78, x$81, x$82, x$79, x$83, x$84, x$85, x$86, x$80, x$87);
                RandomForestModel rf1 = RandomForest$.MODULE$.trainClassifier(rdd, strategy, 3, "auto", 123);
                strategy.subsamplingRate_$eq(0.5);
                RandomForestModel rf2 = RandomForest$.MODULE$.trainClassifier(rdd, strategy, 3, "auto", 123);
                String $org_scalatest_assert_macro_left = rf1.toDebugString();
                String $org_scalatest_assert_macro_right = rf2.toDebugString();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string != null ? !string.equals(string2) : string2 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()}).foreach((Function1)new Serializable(this, tempDir, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final File tempDir$1;
                    private final String path$1;

                    public final void apply(Enumeration.Value algo) {
                        DecisionTreeModel[] trees = (DecisionTreeModel[])((TraversableOnce)package$.MODULE$.Range().apply(0, 3).map((Function1)new Serializable(this, algo){
                            public static final long serialVersionUID = 0L;
                            private final Enumeration.Value algo$1;

                            public final DecisionTreeModel apply(int x$1) {
                                return DecisionTreeSuite$.MODULE$.createModel(this.algo$1);
                            }
                            {
                                this.algo$1 = algo$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DecisionTreeModel.class));
                        RandomForestModel model = new RandomForestModel(algo, trees);
                        try {
                            model.save(this.$outer.org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer().sc(), this.path$1);
                            RandomForestModel sameModel = RandomForestModel$.MODULE$.load(this.$outer.org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer().sc(), this.path$1);
                            Enumeration.Value $org_scalatest_assert_macro_left = model.algo();
                            Enumeration.Value $org_scalatest_assert_macro_right = sameModel.algo();
                            Enumeration.Value value = $org_scalatest_assert_macro_left;
                            Enumeration.Value value2 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(value != null ? !value.equals(value2) : value2 != null));
                            this.$outer.org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.trees()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sameModel.trees()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<DecisionTreeModel, DecisionTreeModel> x0$1) {
                                    Tuple2<DecisionTreeModel, DecisionTreeModel> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        DecisionTreeModel treeA = (DecisionTreeModel)tuple2._1();
                                        DecisionTreeModel treeB = (DecisionTreeModel)tuple2._2();
                                        DecisionTreeSuite$.MODULE$.checkEqual(treeA, treeB);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            });
                            return;
                        }
                        finally {
                            Utils$.MODULE$.deleteRecursively(this.tempDir$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.path$1 = path$1;
                    }
                });
            }

            public /* synthetic */ RandomForestSuite org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

