/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.ChunkReceivedCallback;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.SystemPropertyConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChunkFetchIntegrationSuite {
    static final long STREAM_ID = 1L;
    static final int BUFFER_CHUNK_INDEX = 0;
    static final int FILE_CHUNK_INDEX = 1;
    static TransportServer server;
    static TransportClientFactory clientFactory;
    static StreamManager streamManager;
    static File testFile;
    static ManagedBuffer bufferChunk;
    static ManagedBuffer fileChunk;
    private TransportConf transportConf;

    @BeforeClass
    public static void setUp() throws Exception {
        int bufSize = 100000;
        final ByteBuffer buf = ByteBuffer.allocate(bufSize);
        for (int i = 0; i < bufSize; ++i) {
            buf.put((byte)i);
        }
        buf.flip();
        bufferChunk = new NioManagedBuffer(buf);
        testFile = File.createTempFile("shuffle-test-file", "txt");
        testFile.deleteOnExit();
        RandomAccessFile fp = new RandomAccessFile(testFile, "rw");
        byte[] fileContent = new byte[1024];
        new Random().nextBytes(fileContent);
        fp.write(fileContent);
        fp.close();
        final TransportConf conf = new TransportConf((ConfigProvider)new SystemPropertyConfigProvider());
        fileChunk = new FileSegmentManagedBuffer(conf, testFile, 10L, testFile.length() - 25L);
        streamManager = new StreamManager(){

            public ManagedBuffer getChunk(long streamId, int chunkIndex) {
                Assert.assertEquals((long)1L, (long)streamId);
                if (chunkIndex == 0) {
                    return new NioManagedBuffer(buf);
                }
                if (chunkIndex == 1) {
                    return new FileSegmentManagedBuffer(conf, testFile, 10L, testFile.length() - 25L);
                }
                throw new IllegalArgumentException("Invalid chunk index: " + chunkIndex);
            }
        };
        RpcHandler handler = new RpcHandler(){

            public void receive(TransportClient client, byte[] message, RpcResponseCallback callback) {
                throw new UnsupportedOperationException();
            }

            public StreamManager getStreamManager() {
                return streamManager;
            }
        };
        TransportContext context = new TransportContext(conf, handler);
        server = context.createServer();
        clientFactory = context.createClientFactory();
    }

    @AfterClass
    public static void tearDown() {
        server.close();
        clientFactory.close();
        testFile.delete();
    }

    private FetchResult fetchChunks(List<Integer> chunkIndices) throws Exception {
        TransportClient client = clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
        final Semaphore sem = new Semaphore(0);
        final FetchResult res = new FetchResult();
        res.successChunks = Collections.synchronizedSet(new HashSet());
        res.failedChunks = Collections.synchronizedSet(new HashSet());
        res.buffers = Collections.synchronizedList(new LinkedList());
        ChunkReceivedCallback callback = new ChunkReceivedCallback(){

            public void onSuccess(int chunkIndex, ManagedBuffer buffer) {
                buffer.retain();
                res.successChunks.add(chunkIndex);
                res.buffers.add(buffer);
                sem.release();
            }

            public void onFailure(int chunkIndex, Throwable e) {
                res.failedChunks.add(chunkIndex);
                sem.release();
            }
        };
        for (int chunkIndex : chunkIndices) {
            client.fetchChunk(1L, chunkIndex, callback);
        }
        if (!sem.tryAcquire(chunkIndices.size(), 5L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Timeout getting response from the server");
        }
        client.close();
        return res;
    }

    @Test
    public void fetchBufferChunk() throws Exception {
        FetchResult res = this.fetchChunks(Lists.newArrayList((Object[])new Integer[]{0}));
        Assert.assertEquals(res.successChunks, (Object)Sets.newHashSet((Object[])new Integer[]{0}));
        Assert.assertTrue((boolean)res.failedChunks.isEmpty());
        this.assertBufferListsEqual(res.buffers, Lists.newArrayList((Object[])new ManagedBuffer[]{bufferChunk}));
        res.releaseBuffers();
    }

    @Test
    public void fetchFileChunk() throws Exception {
        FetchResult res = this.fetchChunks(Lists.newArrayList((Object[])new Integer[]{1}));
        Assert.assertEquals(res.successChunks, (Object)Sets.newHashSet((Object[])new Integer[]{1}));
        Assert.assertTrue((boolean)res.failedChunks.isEmpty());
        this.assertBufferListsEqual(res.buffers, Lists.newArrayList((Object[])new ManagedBuffer[]{fileChunk}));
        res.releaseBuffers();
    }

    @Test
    public void fetchNonExistentChunk() throws Exception {
        FetchResult res = this.fetchChunks(Lists.newArrayList((Object[])new Integer[]{12345}));
        Assert.assertTrue((boolean)res.successChunks.isEmpty());
        Assert.assertEquals(res.failedChunks, (Object)Sets.newHashSet((Object[])new Integer[]{12345}));
        Assert.assertTrue((boolean)res.buffers.isEmpty());
    }

    @Test
    public void fetchBothChunks() throws Exception {
        FetchResult res = this.fetchChunks(Lists.newArrayList((Object[])new Integer[]{0, 1}));
        Assert.assertEquals(res.successChunks, (Object)Sets.newHashSet((Object[])new Integer[]{0, 1}));
        Assert.assertTrue((boolean)res.failedChunks.isEmpty());
        this.assertBufferListsEqual(res.buffers, Lists.newArrayList((Object[])new ManagedBuffer[]{bufferChunk, fileChunk}));
        res.releaseBuffers();
    }

    @Test
    public void fetchChunkAndNonExistent() throws Exception {
        FetchResult res = this.fetchChunks(Lists.newArrayList((Object[])new Integer[]{0, 12345}));
        Assert.assertEquals(res.successChunks, (Object)Sets.newHashSet((Object[])new Integer[]{0}));
        Assert.assertEquals(res.failedChunks, (Object)Sets.newHashSet((Object[])new Integer[]{12345}));
        this.assertBufferListsEqual(res.buffers, Lists.newArrayList((Object[])new ManagedBuffer[]{bufferChunk}));
        res.releaseBuffers();
    }

    private void assertBufferListsEqual(List<ManagedBuffer> list0, List<ManagedBuffer> list1) throws Exception {
        Assert.assertEquals((long)list0.size(), (long)list1.size());
        for (int i = 0; i < list0.size(); ++i) {
            this.assertBuffersEqual(list0.get(i), list1.get(i));
        }
    }

    private void assertBuffersEqual(ManagedBuffer buffer0, ManagedBuffer buffer1) throws Exception {
        ByteBuffer nio0 = buffer0.nioByteBuffer();
        ByteBuffer nio1 = buffer1.nioByteBuffer();
        int len = nio0.remaining();
        Assert.assertEquals((long)nio0.remaining(), (long)nio1.remaining());
        for (int i = 0; i < len; ++i) {
            Assert.assertEquals((long)nio0.get(), (long)nio1.get());
        }
    }

    class FetchResult {
        public Set<Integer> successChunks;
        public Set<Integer> failedChunks;
        public List<ManagedBuffer> buffers;

        FetchResult() {
        }

        public void releaseBuffers() {
            for (ManagedBuffer buffer : this.buffers) {
                buffer.release();
            }
        }
    }
}

